/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SingleSampleSeekMap;
import androidx.media3.extractor.TrackOutput;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class SingleSampleExtractor
implements Extractor {
    private final int fileSignature;
    private final int fileSignatureLength;
    private final String sampleMimeType;
    private static final int STATE_READING = 1;
    private static final int STATE_ENDED = 2;
    public static final int IMAGE_TRACK_ID = 1024;
    private static final int FIXED_READ_LENGTH = 1024;
    private int size;
    private int state;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput trackOutput;

    public SingleSampleExtractor(int fileSignature, int fileSignatureLength, String sampleMimeType) {
        this.fileSignature = fileSignature;
        this.fileSignatureLength = fileSignatureLength;
        this.sampleMimeType = sampleMimeType;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        Assertions.checkState((this.fileSignature != -1 && this.fileSignatureLength != -1 ? 1 : 0) != 0);
        ParsableByteArray scratch = new ParsableByteArray(this.fileSignatureLength);
        input.peekFully(scratch.getData(), 0, this.fileSignatureLength);
        return scratch.readUnsignedShort() == this.fileSignature;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.outputImageTrackAndSeekMap(this.sampleMimeType);
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        switch (this.state) {
            case 1: {
                this.readSegment(input);
                return 0;
            }
            case 2: {
                return -1;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void seek(long position, long timeUs) {
        if (position == 0L || this.state == 1) {
            this.state = 1;
            this.size = 0;
        }
    }

    @Override
    public void release() {
    }

    private void readSegment(ExtractorInput input) throws IOException {
        int result = ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleData(input, 1024, true);
        if (result == -1) {
            this.state = 2;
            int flags = 1;
            this.trackOutput.sampleMetadata(0L, flags, this.size, 0, null);
            this.size = 0;
        } else {
            this.size += result;
        }
    }

    @RequiresNonNull(value={"this.extractorOutput"})
    private void outputImageTrackAndSeekMap(String sampleMimeType) {
        this.trackOutput = this.extractorOutput.track(1024, 4);
        this.trackOutput.format(new Format.Builder().setSampleMimeType(sampleMimeType).build());
        this.extractorOutput.endTracks();
        this.extractorOutput.seekMap(new SingleSampleSeekMap(-9223372036854775807L));
        this.state = 1;
    }
}

