/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.webvtt;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.SubtitleParser;
import androidx.media3.extractor.text.webvtt.WebvttCueParser;
import java.util.ArrayList;
import java.util.Collections;

@UnstableApi
public final class Mp4WebvttParser
implements SubtitleParser {
    public static final int CUE_REPLACEMENT_BEHAVIOR = 2;
    private static final int BOX_HEADER_SIZE = 8;
    private static final int TYPE_payl = 1885436268;
    private static final int TYPE_sttg = 1937011815;
    private static final int TYPE_vttc = 1987343459;
    private final ParsableByteArray parsableByteArray = new ParsableByteArray();

    @Override
    public int getCueReplacementBehavior() {
        return 2;
    }

    @Override
    public void parse(byte[] data, int offset, int length, SubtitleParser.OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        this.parsableByteArray.reset(data, offset + length);
        this.parsableByteArray.setPosition(offset);
        ArrayList<Cue> cues = new ArrayList<Cue>();
        while (this.parsableByteArray.bytesLeft() > 0) {
            Assertions.checkArgument((this.parsableByteArray.bytesLeft() >= 8 ? 1 : 0) != 0, (Object)"Incomplete Mp4Webvtt Top Level box header found.");
            int boxSize = this.parsableByteArray.readInt();
            int boxType = this.parsableByteArray.readInt();
            if (boxType == 1987343459) {
                cues.add(Mp4WebvttParser.parseVttCueBox(this.parsableByteArray, boxSize - 8));
                continue;
            }
            this.parsableByteArray.skipBytes(boxSize - 8);
        }
        output.accept((Object)new CuesWithTiming(cues, -9223372036854775807L, -9223372036854775807L));
    }

    private static Cue parseVttCueBox(ParsableByteArray sampleData, int remainingCueBoxBytes) {
        Cue.Builder cueBuilder = null;
        String cueText = null;
        while (remainingCueBoxBytes > 0) {
            Assertions.checkArgument((remainingCueBoxBytes >= 8 ? 1 : 0) != 0, (Object)"Incomplete vtt cue box header found.");
            int boxSize = sampleData.readInt();
            int boxType = sampleData.readInt();
            remainingCueBoxBytes -= 8;
            int payloadLength = boxSize - 8;
            String boxPayload = Util.fromUtf8Bytes((byte[])sampleData.getData(), (int)sampleData.getPosition(), (int)payloadLength);
            sampleData.skipBytes(payloadLength);
            remainingCueBoxBytes -= payloadLength;
            if (boxType == 1937011815) {
                cueBuilder = WebvttCueParser.parseCueSettingsList(boxPayload);
                continue;
            }
            if (boxType != 1885436268) continue;
            cueText = WebvttCueParser.parseCueText(null, boxPayload.trim(), Collections.emptyList());
        }
        if (cueText == null) {
            cueText = "";
        }
        return cueBuilder != null ? cueBuilder.setText((CharSequence)cueText).build() : WebvttCueParser.newCueForText(cueText);
    }
}

