/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.DtsUtil;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import com.google.common.primitives.Ints;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class DtsReader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_CORE_HEADER = 1;
    private static final int STATE_FINDING_EXTSS_HEADER_SIZE = 2;
    private static final int STATE_READING_EXTSS_HEADER = 3;
    private static final int STATE_FINDING_UHD_HEADER_SIZE = 4;
    private static final int STATE_READING_UHD_HEADER = 5;
    private static final int STATE_READING_SAMPLE = 6;
    private static final int CORE_HEADER_SIZE = 18;
    static final int EXTSS_HEADER_SIZE_MAX = 4096;
    static final int FTOC_MAX_HEADER_SIZE = 5408;
    private final ParsableByteArray headerScratchBytes;
    private final AtomicInteger uhdAudioChunkId;
    @Nullable
    private final String language;
    private final int roleFlags;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private int state;
    private int bytesRead;
    private int syncBytes;
    private long sampleDurationUs;
    private @MonotonicNonNull Format format;
    private int sampleSize;
    private int frameType;
    private int extensionSubstreamHeaderSize;
    private int uhdHeaderSize;
    private long timeUs;

    public DtsReader(@Nullable String language, int roleFlags, int maxHeaderSize) {
        this.headerScratchBytes = new ParsableByteArray(new byte[maxHeaderSize]);
        this.state = 0;
        this.timeUs = -9223372036854775807L;
        this.uhdAudioChunkId = new AtomicInteger();
        this.extensionSubstreamHeaderSize = -1;
        this.uhdHeaderSize = -1;
        this.language = language;
        this.roleFlags = roleFlags;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.syncBytes = 0;
        this.timeUs = -9223372036854775807L;
        this.uhdAudioChunkId.set(0);
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 1);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.timeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) throws ParserException {
        Assertions.checkStateNotNull((Object)this.output);
        block9: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSyncWord(data)) continue block9;
                    if (this.frameType == 3 || this.frameType == 4) {
                        this.state = 4;
                        continue block9;
                    }
                    if (this.frameType == 1) {
                        this.state = 1;
                        continue block9;
                    }
                    this.state = 2;
                    continue block9;
                }
                case 1: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), 18)) continue block9;
                    this.parseCoreHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, 18);
                    this.state = 6;
                    continue block9;
                }
                case 2: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), 7)) continue block9;
                    this.extensionSubstreamHeaderSize = DtsUtil.parseDtsHdHeaderSize(this.headerScratchBytes.getData());
                    this.state = 3;
                    continue block9;
                }
                case 3: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), this.extensionSubstreamHeaderSize)) continue block9;
                    this.parseExtensionSubstreamHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, this.extensionSubstreamHeaderSize);
                    this.state = 6;
                    continue block9;
                }
                case 4: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), 6)) continue block9;
                    this.uhdHeaderSize = DtsUtil.parseDtsUhdHeaderSize(this.headerScratchBytes.getData());
                    if (this.bytesRead > this.uhdHeaderSize) {
                        int extraBytes = this.bytesRead - this.uhdHeaderSize;
                        this.bytesRead -= extraBytes;
                        data.setPosition(data.getPosition() - extraBytes);
                    }
                    this.state = 5;
                    continue block9;
                }
                case 5: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), this.uhdHeaderSize)) continue block9;
                    this.parseUhdHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, this.uhdHeaderSize);
                    this.state = 6;
                    continue block9;
                }
                case 6: {
                    int bytesToRead = Math.min(data.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(data, bytesToRead);
                    this.bytesRead += bytesToRead;
                    if (this.bytesRead != this.sampleSize) continue block9;
                    Assertions.checkState((this.timeUs != -9223372036854775807L ? 1 : 0) != 0);
                    this.output.sampleMetadata(this.timeUs, this.frameType == 4 ? 0 : 1, this.sampleSize, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                    continue block9;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void packetFinished(boolean isEndOfInput) {
    }

    private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
        int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
        source.readBytes(target, this.bytesRead, bytesToRead);
        this.bytesRead += bytesToRead;
        return this.bytesRead == targetLength;
    }

    private boolean skipToNextSyncWord(ParsableByteArray pesBuffer) {
        while (pesBuffer.bytesLeft() > 0) {
            this.syncBytes <<= 8;
            this.syncBytes |= pesBuffer.readUnsignedByte();
            this.frameType = DtsUtil.getFrameType(this.syncBytes);
            if (this.frameType == 0) continue;
            byte[] headerData = this.headerScratchBytes.getData();
            headerData[0] = (byte)(this.syncBytes >> 24 & 0xFF);
            headerData[1] = (byte)(this.syncBytes >> 16 & 0xFF);
            headerData[2] = (byte)(this.syncBytes >> 8 & 0xFF);
            headerData[3] = (byte)(this.syncBytes & 0xFF);
            this.bytesRead = 4;
            this.syncBytes = 0;
            return true;
        }
        return false;
    }

    @RequiresNonNull(value={"output"})
    private void parseCoreHeader() {
        byte[] frameData = this.headerScratchBytes.getData();
        if (this.format == null) {
            this.format = DtsUtil.parseDtsFormat(frameData, this.formatId, this.language, this.roleFlags, null);
            this.output.format(this.format);
        }
        this.sampleSize = DtsUtil.getDtsFrameSize(frameData);
        this.sampleDurationUs = Ints.checkedCast((long)Util.sampleCountToDurationUs((long)DtsUtil.parseDtsAudioSampleCount(frameData), (int)this.format.sampleRate));
    }

    @RequiresNonNull(value={"output"})
    private void parseExtensionSubstreamHeader() throws ParserException {
        DtsUtil.DtsHeader dtsHeader = DtsUtil.parseDtsHdHeader(this.headerScratchBytes.getData());
        this.updateFormatWithDtsHeaderInfo(dtsHeader);
        this.sampleSize = dtsHeader.frameSize;
        this.sampleDurationUs = dtsHeader.frameDurationUs == -9223372036854775807L ? 0L : dtsHeader.frameDurationUs;
    }

    @RequiresNonNull(value={"output"})
    private void parseUhdHeader() throws ParserException {
        DtsUtil.DtsHeader dtsHeader = DtsUtil.parseDtsUhdHeader(this.headerScratchBytes.getData(), this.uhdAudioChunkId);
        if (this.frameType == 3) {
            this.updateFormatWithDtsHeaderInfo(dtsHeader);
        }
        this.sampleSize = dtsHeader.frameSize;
        this.sampleDurationUs = dtsHeader.frameDurationUs == -9223372036854775807L ? 0L : dtsHeader.frameDurationUs;
    }

    @RequiresNonNull(value={"output"})
    private void updateFormatWithDtsHeaderInfo(DtsUtil.DtsHeader dtsHeader) {
        if (dtsHeader.sampleRate == -2147483647 || dtsHeader.channelCount == -1) {
            return;
        }
        if (this.format == null || dtsHeader.channelCount != this.format.channelCount || dtsHeader.sampleRate != this.format.sampleRate || !Util.areEqual((Object)dtsHeader.mimeType, (Object)this.format.sampleMimeType)) {
            Format.Builder formatBuilder = this.format == null ? new Format.Builder() : this.format.buildUpon();
            this.format = formatBuilder.setId(this.formatId).setSampleMimeType(dtsHeader.mimeType).setChannelCount(dtsHeader.channelCount).setSampleRate(dtsHeader.sampleRate).setLanguage(this.language).setRoleFlags(this.roleFlags).build();
            this.output.format(this.format);
        }
    }
}

