/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp3;

import androidx.annotation.Nullable;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.extractor.MpegAudioUtil;

final class XingFrame {
    private static final String TAG = "XingHeader";
    public final MpegAudioUtil.Header header;
    public final long frameCount;
    public final long dataSize;
    public final int encoderDelay;
    public final int encoderPadding;
    @Nullable
    public final long[] tableOfContents;

    private XingFrame(MpegAudioUtil.Header header, long frameCount, long dataSize, @Nullable long[] tableOfContents, int encoderDelay, int encoderPadding) {
        this.header = header;
        this.frameCount = frameCount;
        this.dataSize = dataSize;
        this.tableOfContents = tableOfContents;
        this.encoderDelay = encoderDelay;
        this.encoderPadding = encoderPadding;
    }

    public static XingFrame parse(MpegAudioUtil.Header mpegAudioHeader, ParsableByteArray frame) {
        int encoderPadding;
        int encoderDelay;
        long[] tableOfContents;
        long dataSize;
        int samplesPerFrame = mpegAudioHeader.samplesPerFrame;
        int sampleRate = mpegAudioHeader.sampleRate;
        int flags = frame.readInt();
        int frameCount = (flags & 1) != 0 ? frame.readUnsignedIntToInt() : -1;
        long l = dataSize = (flags & 2) != 0 ? frame.readUnsignedInt() : -1L;
        if ((flags & 4) == 4) {
            tableOfContents = new long[100];
            for (int i = 0; i < 100; ++i) {
                tableOfContents[i] = frame.readUnsignedByte();
            }
        } else {
            tableOfContents = null;
        }
        if ((flags & 8) != 0) {
            frame.skipBytes(4);
        }
        int bytesToSkipBeforeEncoderDelayAndPadding = 21;
        if (frame.bytesLeft() >= bytesToSkipBeforeEncoderDelayAndPadding + 3) {
            frame.skipBytes(bytesToSkipBeforeEncoderDelayAndPadding);
            int encoderDelayAndPadding = frame.readUnsignedInt24();
            encoderDelay = (encoderDelayAndPadding & 0xFFF000) >> 12;
            encoderPadding = encoderDelayAndPadding & 0xFFF;
        } else {
            encoderDelay = -1;
            encoderPadding = -1;
        }
        return new XingFrame(mpegAudioHeader, frameCount, dataSize, tableOfContents, encoderDelay, encoderPadding);
    }
}

