/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.Subtitle;
import androidx.media3.extractor.text.SubtitleParser;
import java.util.List;

@UnstableApi
public class LegacySubtitleUtil {
    private LegacySubtitleUtil() {
    }

    public static void toCuesWithTiming(Subtitle subtitle, SubtitleParser.OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        int startIndex = LegacySubtitleUtil.getStartIndex(subtitle, outputOptions);
        boolean startedInMiddleOfCue = false;
        if (outputOptions.startTimeUs != -9223372036854775807L) {
            List<Cue> cuesAtStartTime = subtitle.getCues(outputOptions.startTimeUs);
            long firstEventTimeUs = subtitle.getEventTime(startIndex);
            if (!cuesAtStartTime.isEmpty() && startIndex < subtitle.getEventTimeCount() && outputOptions.startTimeUs < firstEventTimeUs) {
                output.accept((Object)new CuesWithTiming(cuesAtStartTime, outputOptions.startTimeUs, firstEventTimeUs - outputOptions.startTimeUs));
                startedInMiddleOfCue = true;
            }
        }
        for (int i = startIndex; i < subtitle.getEventTimeCount(); ++i) {
            LegacySubtitleUtil.outputSubtitleEvent(subtitle, i, output);
        }
        if (outputOptions.outputAllCues) {
            int endIndex = startedInMiddleOfCue ? startIndex - 1 : startIndex;
            for (int i = 0; i < endIndex; ++i) {
                LegacySubtitleUtil.outputSubtitleEvent(subtitle, i, output);
            }
            if (startedInMiddleOfCue) {
                output.accept((Object)new CuesWithTiming(subtitle.getCues(outputOptions.startTimeUs), subtitle.getEventTime(endIndex), outputOptions.startTimeUs - subtitle.getEventTime(endIndex)));
            }
        }
    }

    private static int getStartIndex(Subtitle subtitle, SubtitleParser.OutputOptions outputOptions) {
        if (outputOptions.startTimeUs == -9223372036854775807L) {
            return 0;
        }
        int nextEventTimeIndex = subtitle.getNextEventTimeIndex(outputOptions.startTimeUs);
        if (nextEventTimeIndex == -1) {
            return subtitle.getEventTimeCount();
        }
        if (nextEventTimeIndex > 0 && subtitle.getEventTime(nextEventTimeIndex - 1) == outputOptions.startTimeUs) {
            --nextEventTimeIndex;
        }
        return nextEventTimeIndex;
    }

    private static void outputSubtitleEvent(Subtitle subtitle, int eventIndex, Consumer<CuesWithTiming> output) {
        long startTimeUs = subtitle.getEventTime(eventIndex);
        List<Cue> cuesForThisStartTime = subtitle.getCues(startTimeUs);
        if (cuesForThisStartTime.isEmpty()) {
            return;
        }
        if (eventIndex == subtitle.getEventTimeCount() - 1) {
            throw new IllegalStateException();
        }
        long durationUs = subtitle.getEventTime(eventIndex + 1) - subtitle.getEventTime(eventIndex);
        if (durationUs > 0L) {
            output.accept((Object)new CuesWithTiming(cuesForThisStartTime, startTimeUs, durationUs));
        }
    }
}

