/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.dvb;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class DvbParser
implements SubtitleParser {
    public static final int CUE_REPLACEMENT_BEHAVIOR = 2;
    private static final String TAG = "DvbParser";
    private static final int SEGMENT_TYPE_PAGE_COMPOSITION = 16;
    private static final int SEGMENT_TYPE_REGION_COMPOSITION = 17;
    private static final int SEGMENT_TYPE_CLUT_DEFINITION = 18;
    private static final int SEGMENT_TYPE_OBJECT_DATA = 19;
    private static final int SEGMENT_TYPE_DISPLAY_DEFINITION = 20;
    private static final int PAGE_STATE_NORMAL = 0;
    private static final int REGION_DEPTH_4_BIT = 2;
    private static final int REGION_DEPTH_8_BIT = 3;
    private static final int OBJECT_CODING_PIXELS = 0;
    private static final int OBJECT_CODING_STRING = 1;
    private static final int DATA_TYPE_2BP_CODE_STRING = 16;
    private static final int DATA_TYPE_4BP_CODE_STRING = 17;
    private static final int DATA_TYPE_8BP_CODE_STRING = 18;
    private static final int DATA_TYPE_24_TABLE_DATA = 32;
    private static final int DATA_TYPE_28_TABLE_DATA = 33;
    private static final int DATA_TYPE_48_TABLE_DATA = 34;
    private static final int DATA_TYPE_END_LINE = 240;
    private static final byte[] defaultMap2To4 = new byte[]{0, 7, 8, 15};
    private static final byte[] defaultMap2To8 = new byte[]{0, 119, -120, -1};
    private static final byte[] defaultMap4To8 = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
    private final Paint defaultPaint;
    private final Paint fillRegionPaint;
    private final Canvas canvas;
    private final DisplayDefinition defaultDisplayDefinition;
    private final ClutDefinition defaultClutDefinition;
    private final SubtitleService subtitleService;
    private @MonotonicNonNull Bitmap bitmap;

    public DvbParser(List<byte[]> initializationData) {
        ParsableByteArray data = new ParsableByteArray(initializationData.get(0));
        int subtitleCompositionPage = data.readUnsignedShort();
        int subtitleAncillaryPage = data.readUnsignedShort();
        this.defaultPaint = new Paint();
        this.defaultPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.defaultPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        this.defaultPaint.setPathEffect(null);
        this.fillRegionPaint = new Paint();
        this.fillRegionPaint.setStyle(Paint.Style.FILL);
        this.fillRegionPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OVER));
        this.fillRegionPaint.setPathEffect(null);
        this.canvas = new Canvas();
        this.defaultDisplayDefinition = new DisplayDefinition(719, 575, 0, 719, 0, 575);
        this.defaultClutDefinition = new ClutDefinition(0, DvbParser.generateDefault2BitClutEntries(), DvbParser.generateDefault4BitClutEntries(), DvbParser.generateDefault8BitClutEntries());
        this.subtitleService = new SubtitleService(subtitleCompositionPage, subtitleAncillaryPage);
    }

    @Override
    public void reset() {
        this.subtitleService.reset();
    }

    @Override
    public int getCueReplacementBehavior() {
        return 2;
    }

    @Override
    public void parse(byte[] data, int offset, int length, SubtitleParser.OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        ParsableBitArray dataBitArray = new ParsableBitArray(data, offset + length);
        dataBitArray.setPosition(offset);
        output.accept((Object)this.parse(dataBitArray));
    }

    private CuesWithTiming parse(ParsableBitArray dataBitArray) {
        DisplayDefinition displayDefinition;
        while (dataBitArray.bitsLeft() >= 48 && dataBitArray.readBits(8) == 15) {
            DvbParser.parseSubtitlingSegment(dataBitArray, this.subtitleService);
        }
        PageComposition pageComposition = this.subtitleService.pageComposition;
        if (pageComposition == null) {
            return new CuesWithTiming((List<Cue>)ImmutableList.of(), -9223372036854775807L, -9223372036854775807L);
        }
        DisplayDefinition displayDefinition2 = displayDefinition = this.subtitleService.displayDefinition != null ? this.subtitleService.displayDefinition : this.defaultDisplayDefinition;
        if (this.bitmap == null || displayDefinition.width + 1 != this.bitmap.getWidth() || displayDefinition.height + 1 != this.bitmap.getHeight()) {
            this.bitmap = Bitmap.createBitmap((int)(displayDefinition.width + 1), (int)(displayDefinition.height + 1), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas.setBitmap(this.bitmap);
        }
        ArrayList<Cue> cues = new ArrayList<Cue>();
        SparseArray<PageRegion> pageRegions = pageComposition.regions;
        for (int i = 0; i < pageRegions.size(); ++i) {
            this.canvas.save();
            PageRegion pageRegion = (PageRegion)pageRegions.valueAt(i);
            int regionId = pageRegions.keyAt(i);
            RegionComposition regionComposition = (RegionComposition)this.subtitleService.regions.get(regionId);
            int baseHorizontalAddress = pageRegion.horizontalAddress + displayDefinition.horizontalPositionMinimum;
            int baseVerticalAddress = pageRegion.verticalAddress + displayDefinition.verticalPositionMinimum;
            int clipRight = Math.min(baseHorizontalAddress + regionComposition.width, displayDefinition.horizontalPositionMaximum);
            int clipBottom = Math.min(baseVerticalAddress + regionComposition.height, displayDefinition.verticalPositionMaximum);
            this.canvas.clipRect(baseHorizontalAddress, baseVerticalAddress, clipRight, clipBottom);
            ClutDefinition clutDefinition = (ClutDefinition)this.subtitleService.cluts.get(regionComposition.clutId);
            if (clutDefinition == null && (clutDefinition = (ClutDefinition)this.subtitleService.ancillaryCluts.get(regionComposition.clutId)) == null) {
                clutDefinition = this.defaultClutDefinition;
            }
            SparseArray<RegionObject> regionObjects = regionComposition.regionObjects;
            for (int j = 0; j < regionObjects.size(); ++j) {
                int objectId = regionObjects.keyAt(j);
                RegionObject regionObject = (RegionObject)regionObjects.valueAt(j);
                ObjectData objectData = (ObjectData)this.subtitleService.objects.get(objectId);
                if (objectData == null) {
                    objectData = (ObjectData)this.subtitleService.ancillaryObjects.get(objectId);
                }
                if (objectData == null) continue;
                Paint paint = objectData.nonModifyingColorFlag ? null : this.defaultPaint;
                DvbParser.paintPixelDataSubBlocks(objectData, clutDefinition, regionComposition.depth, baseHorizontalAddress + regionObject.horizontalPosition, baseVerticalAddress + regionObject.verticalPosition, paint, this.canvas);
            }
            if (regionComposition.fillFlag) {
                int color = regionComposition.depth == 3 ? clutDefinition.clutEntries8Bit[regionComposition.pixelCode8Bit] : (regionComposition.depth == 2 ? clutDefinition.clutEntries4Bit[regionComposition.pixelCode4Bit] : clutDefinition.clutEntries2Bit[regionComposition.pixelCode2Bit]);
                this.fillRegionPaint.setColor(color);
                this.canvas.drawRect((float)baseHorizontalAddress, (float)baseVerticalAddress, (float)(baseHorizontalAddress + regionComposition.width), (float)(baseVerticalAddress + regionComposition.height), this.fillRegionPaint);
            }
            cues.add(new Cue.Builder().setBitmap(Bitmap.createBitmap((Bitmap)this.bitmap, (int)baseHorizontalAddress, (int)baseVerticalAddress, (int)regionComposition.width, (int)regionComposition.height)).setPosition((float)baseHorizontalAddress / (float)displayDefinition.width).setPositionAnchor(0).setLine((float)baseVerticalAddress / (float)displayDefinition.height, 0).setLineAnchor(0).setSize((float)regionComposition.width / (float)displayDefinition.width).setBitmapHeight((float)regionComposition.height / (float)displayDefinition.height).build());
            this.canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.canvas.restore();
        }
        return new CuesWithTiming(cues, -9223372036854775807L, -9223372036854775807L);
    }

    private static void parseSubtitlingSegment(ParsableBitArray data, SubtitleService service) {
        int segmentType = data.readBits(8);
        int pageId = data.readBits(16);
        int dataFieldLength = data.readBits(16);
        int dataFieldLimit = data.getBytePosition() + dataFieldLength;
        if (dataFieldLength * 8 > data.bitsLeft()) {
            Log.w((String)TAG, (String)"Data field length exceeds limit");
            data.skipBits(data.bitsLeft());
            return;
        }
        switch (segmentType) {
            case 20: {
                if (pageId != service.subtitlePageId) break;
                service.displayDefinition = DvbParser.parseDisplayDefinition(data);
                break;
            }
            case 16: {
                if (pageId != service.subtitlePageId) break;
                PageComposition current = service.pageComposition;
                PageComposition pageComposition = DvbParser.parsePageComposition(data, dataFieldLength);
                if (pageComposition.state != 0) {
                    service.pageComposition = pageComposition;
                    service.regions.clear();
                    service.cluts.clear();
                    service.objects.clear();
                    break;
                }
                if (current == null || current.version == pageComposition.version) break;
                service.pageComposition = pageComposition;
                break;
            }
            case 17: {
                RegionComposition existingRegionComposition;
                PageComposition pageComposition = service.pageComposition;
                if (pageId != service.subtitlePageId || pageComposition == null) break;
                RegionComposition regionComposition = DvbParser.parseRegionComposition(data, dataFieldLength);
                if (pageComposition.state == 0 && (existingRegionComposition = (RegionComposition)service.regions.get(regionComposition.id)) != null) {
                    regionComposition.mergeFrom(existingRegionComposition);
                }
                service.regions.put(regionComposition.id, (Object)regionComposition);
                break;
            }
            case 18: {
                if (pageId == service.subtitlePageId) {
                    ClutDefinition clutDefinition = DvbParser.parseClutDefinition(data, dataFieldLength);
                    service.cluts.put(clutDefinition.id, (Object)clutDefinition);
                    break;
                }
                if (pageId != service.ancillaryPageId) break;
                ClutDefinition clutDefinition = DvbParser.parseClutDefinition(data, dataFieldLength);
                service.ancillaryCluts.put(clutDefinition.id, (Object)clutDefinition);
                break;
            }
            case 19: {
                if (pageId == service.subtitlePageId) {
                    ObjectData objectData = DvbParser.parseObjectData(data);
                    service.objects.put(objectData.id, (Object)objectData);
                    break;
                }
                if (pageId != service.ancillaryPageId) break;
                ObjectData objectData = DvbParser.parseObjectData(data);
                service.ancillaryObjects.put(objectData.id, (Object)objectData);
                break;
            }
        }
        data.skipBytes(dataFieldLimit - data.getBytePosition());
    }

    private static DisplayDefinition parseDisplayDefinition(ParsableBitArray data) {
        int verticalPositionMaximum;
        int verticalPositionMinimum;
        int horizontalPositionMaximum;
        int horizontalPositionMinimum;
        data.skipBits(4);
        boolean displayWindowFlag = data.readBit();
        data.skipBits(3);
        int width = data.readBits(16);
        int height = data.readBits(16);
        if (displayWindowFlag) {
            horizontalPositionMinimum = data.readBits(16);
            horizontalPositionMaximum = data.readBits(16);
            verticalPositionMinimum = data.readBits(16);
            verticalPositionMaximum = data.readBits(16);
        } else {
            horizontalPositionMinimum = 0;
            horizontalPositionMaximum = width;
            verticalPositionMinimum = 0;
            verticalPositionMaximum = height;
        }
        return new DisplayDefinition(width, height, horizontalPositionMinimum, horizontalPositionMaximum, verticalPositionMinimum, verticalPositionMaximum);
    }

    private static PageComposition parsePageComposition(ParsableBitArray data, int length) {
        int timeoutSecs = data.readBits(8);
        int version = data.readBits(4);
        int state = data.readBits(2);
        data.skipBits(2);
        SparseArray regions = new SparseArray();
        for (int remainingLength = length - 2; remainingLength > 0; remainingLength -= 6) {
            int regionId = data.readBits(8);
            data.skipBits(8);
            int regionHorizontalAddress = data.readBits(16);
            int regionVerticalAddress = data.readBits(16);
            regions.put(regionId, (Object)new PageRegion(regionHorizontalAddress, regionVerticalAddress));
        }
        return new PageComposition(timeoutSecs, version, state, (SparseArray<PageRegion>)regions);
    }

    private static RegionComposition parseRegionComposition(ParsableBitArray data, int length) {
        int id = data.readBits(8);
        data.skipBits(4);
        boolean fillFlag = data.readBit();
        data.skipBits(3);
        int width = data.readBits(16);
        int height = data.readBits(16);
        int levelOfCompatibility = data.readBits(3);
        int depth = data.readBits(3);
        data.skipBits(2);
        int clutId = data.readBits(8);
        int pixelCode8Bit = data.readBits(8);
        int pixelCode4Bit = data.readBits(4);
        int pixelCode2Bit = data.readBits(2);
        data.skipBits(2);
        int remainingLength = length - 10;
        SparseArray regionObjects = new SparseArray();
        while (remainingLength > 0) {
            int objectId = data.readBits(16);
            int objectType = data.readBits(2);
            int objectProvider = data.readBits(2);
            int objectHorizontalPosition = data.readBits(12);
            data.skipBits(4);
            int objectVerticalPosition = data.readBits(12);
            remainingLength -= 6;
            int foregroundPixelCode = 0;
            int backgroundPixelCode = 0;
            if (objectType == 1 || objectType == 2) {
                foregroundPixelCode = data.readBits(8);
                backgroundPixelCode = data.readBits(8);
                remainingLength -= 2;
            }
            regionObjects.put(objectId, (Object)new RegionObject(objectType, objectProvider, objectHorizontalPosition, objectVerticalPosition, foregroundPixelCode, backgroundPixelCode));
        }
        return new RegionComposition(id, fillFlag, width, height, levelOfCompatibility, depth, clutId, pixelCode8Bit, pixelCode4Bit, pixelCode2Bit, (SparseArray<RegionObject>)regionObjects);
    }

    private static ClutDefinition parseClutDefinition(ParsableBitArray data, int length) {
        int clutId = data.readBits(8);
        data.skipBits(8);
        int remainingLength = length - 2;
        int[] clutEntries2Bit = DvbParser.generateDefault2BitClutEntries();
        int[] clutEntries4Bit = DvbParser.generateDefault4BitClutEntries();
        int[] clutEntries8Bit = DvbParser.generateDefault8BitClutEntries();
        while (remainingLength > 0) {
            int t;
            int cb;
            int cr;
            int y;
            int entryId = data.readBits(8);
            int entryFlags = data.readBits(8);
            remainingLength -= 2;
            int[] clutEntries = (entryFlags & 0x80) != 0 ? clutEntries2Bit : ((entryFlags & 0x40) != 0 ? clutEntries4Bit : clutEntries8Bit);
            if ((entryFlags & 1) != 0) {
                y = data.readBits(8);
                cr = data.readBits(8);
                cb = data.readBits(8);
                t = data.readBits(8);
                remainingLength -= 4;
            } else {
                y = data.readBits(6) << 2;
                cr = data.readBits(4) << 4;
                cb = data.readBits(4) << 4;
                t = data.readBits(2) << 6;
                remainingLength -= 2;
            }
            if (y == 0) {
                cr = 0;
                cb = 0;
                t = 255;
            }
            byte a = (byte)(255 - (t & 0xFF));
            int r = (int)((double)y + 1.402 * (double)(cr - 128));
            int g = (int)((double)y - 0.34414 * (double)(cb - 128) - 0.71414 * (double)(cr - 128));
            int b = (int)((double)y + 1.772 * (double)(cb - 128));
            clutEntries[entryId] = DvbParser.getColor(a, Util.constrainValue((int)r, (int)0, (int)255), Util.constrainValue((int)g, (int)0, (int)255), Util.constrainValue((int)b, (int)0, (int)255));
        }
        return new ClutDefinition(clutId, clutEntries2Bit, clutEntries4Bit, clutEntries8Bit);
    }

    private static ObjectData parseObjectData(ParsableBitArray data) {
        int objectId = data.readBits(16);
        data.skipBits(4);
        int objectCodingMethod = data.readBits(2);
        boolean nonModifyingColorFlag = data.readBit();
        data.skipBits(1);
        byte[] topFieldData = Util.EMPTY_BYTE_ARRAY;
        byte[] bottomFieldData = Util.EMPTY_BYTE_ARRAY;
        if (objectCodingMethod == 1) {
            int numberOfCodes = data.readBits(8);
            data.skipBits(numberOfCodes * 16);
        } else if (objectCodingMethod == 0) {
            int topFieldDataLength = data.readBits(16);
            int bottomFieldDataLength = data.readBits(16);
            if (topFieldDataLength > 0) {
                topFieldData = new byte[topFieldDataLength];
                data.readBytes(topFieldData, 0, topFieldDataLength);
            }
            if (bottomFieldDataLength > 0) {
                bottomFieldData = new byte[bottomFieldDataLength];
                data.readBytes(bottomFieldData, 0, bottomFieldDataLength);
            } else {
                bottomFieldData = topFieldData;
            }
        }
        return new ObjectData(objectId, nonModifyingColorFlag, topFieldData, bottomFieldData);
    }

    private static int[] generateDefault2BitClutEntries() {
        int[] entries = new int[]{0, -1, -16777216, -8421505};
        return entries;
    }

    private static int[] generateDefault4BitClutEntries() {
        int[] entries = new int[16];
        entries[0] = 0;
        for (int i = 1; i < entries.length; ++i) {
            entries[i] = i < 8 ? DvbParser.getColor(255, (i & 1) != 0 ? 255 : 0, (i & 2) != 0 ? 255 : 0, (i & 4) != 0 ? 255 : 0) : DvbParser.getColor(255, (i & 1) != 0 ? 127 : 0, (i & 2) != 0 ? 127 : 0, (i & 4) != 0 ? 127 : 0);
        }
        return entries;
    }

    private static int[] generateDefault8BitClutEntries() {
        int[] entries = new int[256];
        entries[0] = 0;
        block6: for (int i = 0; i < entries.length; ++i) {
            if (i < 8) {
                entries[i] = DvbParser.getColor(63, (i & 1) != 0 ? 255 : 0, (i & 2) != 0 ? 255 : 0, (i & 4) != 0 ? 255 : 0);
                continue;
            }
            switch (i & 0x88) {
                case 0: {
                    entries[i] = DvbParser.getColor(255, ((i & 1) != 0 ? 85 : 0) + ((i & 0x10) != 0 ? 170 : 0), ((i & 2) != 0 ? 85 : 0) + ((i & 0x20) != 0 ? 170 : 0), ((i & 4) != 0 ? 85 : 0) + ((i & 0x40) != 0 ? 170 : 0));
                    continue block6;
                }
                case 8: {
                    entries[i] = DvbParser.getColor(127, ((i & 1) != 0 ? 85 : 0) + ((i & 0x10) != 0 ? 170 : 0), ((i & 2) != 0 ? 85 : 0) + ((i & 0x20) != 0 ? 170 : 0), ((i & 4) != 0 ? 85 : 0) + ((i & 0x40) != 0 ? 170 : 0));
                    continue block6;
                }
                case 128: {
                    entries[i] = DvbParser.getColor(255, 127 + ((i & 1) != 0 ? 43 : 0) + ((i & 0x10) != 0 ? 85 : 0), 127 + ((i & 2) != 0 ? 43 : 0) + ((i & 0x20) != 0 ? 85 : 0), 127 + ((i & 4) != 0 ? 43 : 0) + ((i & 0x40) != 0 ? 85 : 0));
                    continue block6;
                }
                case 136: {
                    entries[i] = DvbParser.getColor(255, ((i & 1) != 0 ? 43 : 0) + ((i & 0x10) != 0 ? 85 : 0), ((i & 2) != 0 ? 43 : 0) + ((i & 0x20) != 0 ? 85 : 0), ((i & 4) != 0 ? 43 : 0) + ((i & 0x40) != 0 ? 85 : 0));
                }
            }
        }
        return entries;
    }

    private static int getColor(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static void paintPixelDataSubBlocks(ObjectData objectData, ClutDefinition clutDefinition, int regionDepth, int horizontalAddress, int verticalAddress, @Nullable Paint paint, Canvas canvas) {
        int[] clutEntries = regionDepth == 3 ? clutDefinition.clutEntries8Bit : (regionDepth == 2 ? clutDefinition.clutEntries4Bit : clutDefinition.clutEntries2Bit);
        DvbParser.paintPixelDataSubBlock(objectData.topFieldData, clutEntries, regionDepth, horizontalAddress, verticalAddress, paint, canvas);
        DvbParser.paintPixelDataSubBlock(objectData.bottomFieldData, clutEntries, regionDepth, horizontalAddress, verticalAddress + 1, paint, canvas);
    }

    private static void paintPixelDataSubBlock(byte[] pixelData, int[] clutEntries, int regionDepth, int horizontalAddress, int verticalAddress, @Nullable Paint paint, Canvas canvas) {
        ParsableBitArray data = new ParsableBitArray(pixelData);
        int column = horizontalAddress;
        int line = verticalAddress;
        byte[] clutMapTable2To4 = null;
        byte[] clutMapTable2To8 = null;
        byte[] clutMapTable4To8 = null;
        while (data.bitsLeft() != 0) {
            int dataType = data.readBits(8);
            switch (dataType) {
                case 16: {
                    Object clutMapTable2ToX = regionDepth == 3 ? (clutMapTable2To8 == null ? defaultMap2To8 : clutMapTable2To8) : (Object)(regionDepth == 2 ? (clutMapTable2To4 == null ? defaultMap2To4 : clutMapTable2To4) : null);
                    column = DvbParser.paint2BitPixelCodeString(data, clutEntries, clutMapTable2ToX, column, line, paint, canvas);
                    data.byteAlign();
                    break;
                }
                case 17: {
                    byte[] clutMapTable4ToX = regionDepth == 3 ? (clutMapTable4To8 == null ? defaultMap4To8 : clutMapTable4To8) : null;
                    column = DvbParser.paint4BitPixelCodeString(data, clutEntries, clutMapTable4ToX, column, line, paint, canvas);
                    data.byteAlign();
                    break;
                }
                case 18: {
                    column = DvbParser.paint8BitPixelCodeString(data, clutEntries, null, column, line, paint, canvas);
                    break;
                }
                case 32: {
                    clutMapTable2To4 = DvbParser.buildClutMapTable(4, 4, data);
                    break;
                }
                case 33: {
                    clutMapTable2To8 = DvbParser.buildClutMapTable(4, 8, data);
                    break;
                }
                case 34: {
                    clutMapTable4To8 = DvbParser.buildClutMapTable(16, 8, data);
                    break;
                }
                case 240: {
                    column = horizontalAddress;
                    line += 2;
                    break;
                }
            }
        }
    }

    private static int paint2BitPixelCodeString(ParsableBitArray data, int[] clutEntries, @Nullable byte[] clutMapTable, int column, int line, @Nullable Paint paint, Canvas canvas) {
        boolean endOfPixelCodeString = false;
        do {
            int runLength = 0;
            int clutIndex = 0;
            int peek = data.readBits(2);
            if (peek != 0) {
                runLength = 1;
                clutIndex = peek;
            } else if (data.readBit()) {
                runLength = 3 + data.readBits(3);
                clutIndex = data.readBits(2);
            } else if (data.readBit()) {
                runLength = 1;
            } else {
                switch (data.readBits(2)) {
                    case 0: {
                        endOfPixelCodeString = true;
                        break;
                    }
                    case 1: {
                        runLength = 2;
                        break;
                    }
                    case 2: {
                        runLength = 12 + data.readBits(4);
                        clutIndex = data.readBits(2);
                        break;
                    }
                    case 3: {
                        runLength = 29 + data.readBits(8);
                        clutIndex = data.readBits(2);
                    }
                }
            }
            if (runLength != 0 && paint != null) {
                paint.setColor(clutEntries[clutMapTable != null ? clutMapTable[clutIndex] : clutIndex]);
                canvas.drawRect((float)column, (float)line, (float)(column + runLength), (float)(line + 1), paint);
            }
            column += runLength;
        } while (!endOfPixelCodeString);
        return column;
    }

    private static int paint4BitPixelCodeString(ParsableBitArray data, int[] clutEntries, @Nullable byte[] clutMapTable, int column, int line, @Nullable Paint paint, Canvas canvas) {
        boolean endOfPixelCodeString = false;
        do {
            int runLength = 0;
            int clutIndex = 0;
            int peek = data.readBits(4);
            if (peek != 0) {
                runLength = 1;
                clutIndex = peek;
            } else if (!data.readBit()) {
                peek = data.readBits(3);
                if (peek != 0) {
                    runLength = 2 + peek;
                    clutIndex = 0;
                } else {
                    endOfPixelCodeString = true;
                }
            } else if (!data.readBit()) {
                runLength = 4 + data.readBits(2);
                clutIndex = data.readBits(4);
            } else {
                switch (data.readBits(2)) {
                    case 0: {
                        runLength = 1;
                        break;
                    }
                    case 1: {
                        runLength = 2;
                        break;
                    }
                    case 2: {
                        runLength = 9 + data.readBits(4);
                        clutIndex = data.readBits(4);
                        break;
                    }
                    case 3: {
                        runLength = 25 + data.readBits(8);
                        clutIndex = data.readBits(4);
                    }
                }
            }
            if (runLength != 0 && paint != null) {
                paint.setColor(clutEntries[clutMapTable != null ? clutMapTable[clutIndex] : clutIndex]);
                canvas.drawRect((float)column, (float)line, (float)(column + runLength), (float)(line + 1), paint);
            }
            column += runLength;
        } while (!endOfPixelCodeString);
        return column;
    }

    private static int paint8BitPixelCodeString(ParsableBitArray data, int[] clutEntries, @Nullable byte[] clutMapTable, int column, int line, @Nullable Paint paint, Canvas canvas) {
        boolean endOfPixelCodeString = false;
        do {
            int runLength = 0;
            int clutIndex = 0;
            int peek = data.readBits(8);
            if (peek != 0) {
                runLength = 1;
                clutIndex = peek;
            } else if (!data.readBit()) {
                peek = data.readBits(7);
                if (peek != 0) {
                    runLength = peek;
                    clutIndex = 0;
                } else {
                    endOfPixelCodeString = true;
                }
            } else {
                runLength = data.readBits(7);
                clutIndex = data.readBits(8);
            }
            if (runLength != 0 && paint != null) {
                paint.setColor(clutEntries[clutMapTable != null ? clutMapTable[clutIndex] : clutIndex]);
                canvas.drawRect((float)column, (float)line, (float)(column + runLength), (float)(line + 1), paint);
            }
            column += runLength;
        } while (!endOfPixelCodeString);
        return column;
    }

    private static byte[] buildClutMapTable(int length, int bitsPerEntry, ParsableBitArray data) {
        byte[] clutMapTable = new byte[length];
        for (int i = 0; i < length; ++i) {
            clutMapTable[i] = (byte)data.readBits(bitsPerEntry);
        }
        return clutMapTable;
    }

    private static final class DisplayDefinition {
        public final int width;
        public final int height;
        public final int horizontalPositionMinimum;
        public final int horizontalPositionMaximum;
        public final int verticalPositionMinimum;
        public final int verticalPositionMaximum;

        public DisplayDefinition(int width, int height, int horizontalPositionMinimum, int horizontalPositionMaximum, int verticalPositionMinimum, int verticalPositionMaximum) {
            this.width = width;
            this.height = height;
            this.horizontalPositionMinimum = horizontalPositionMinimum;
            this.horizontalPositionMaximum = horizontalPositionMaximum;
            this.verticalPositionMinimum = verticalPositionMinimum;
            this.verticalPositionMaximum = verticalPositionMaximum;
        }
    }

    private static final class ClutDefinition {
        public final int id;
        public final int[] clutEntries2Bit;
        public final int[] clutEntries4Bit;
        public final int[] clutEntries8Bit;

        public ClutDefinition(int id, int[] clutEntries2Bit, int[] clutEntries4Bit, int[] clutEntries8bit) {
            this.id = id;
            this.clutEntries2Bit = clutEntries2Bit;
            this.clutEntries4Bit = clutEntries4Bit;
            this.clutEntries8Bit = clutEntries8bit;
        }
    }

    private static final class SubtitleService {
        public final int subtitlePageId;
        public final int ancillaryPageId;
        public final SparseArray<RegionComposition> regions;
        public final SparseArray<ClutDefinition> cluts;
        public final SparseArray<ObjectData> objects;
        public final SparseArray<ClutDefinition> ancillaryCluts;
        public final SparseArray<ObjectData> ancillaryObjects;
        @Nullable
        public DisplayDefinition displayDefinition;
        @Nullable
        public PageComposition pageComposition;

        public SubtitleService(int subtitlePageId, int ancillaryPageId) {
            this.subtitlePageId = subtitlePageId;
            this.ancillaryPageId = ancillaryPageId;
            this.regions = new SparseArray();
            this.cluts = new SparseArray();
            this.objects = new SparseArray();
            this.ancillaryCluts = new SparseArray();
            this.ancillaryObjects = new SparseArray();
        }

        public void reset() {
            this.regions.clear();
            this.cluts.clear();
            this.objects.clear();
            this.ancillaryCluts.clear();
            this.ancillaryObjects.clear();
            this.displayDefinition = null;
            this.pageComposition = null;
        }
    }

    private static final class PageComposition {
        public final int timeOutSecs;
        public final int version;
        public final int state;
        public final SparseArray<PageRegion> regions;

        public PageComposition(int timeoutSecs, int version, int state, SparseArray<PageRegion> regions) {
            this.timeOutSecs = timeoutSecs;
            this.version = version;
            this.state = state;
            this.regions = regions;
        }
    }

    private static final class PageRegion {
        public final int horizontalAddress;
        public final int verticalAddress;

        public PageRegion(int horizontalAddress, int verticalAddress) {
            this.horizontalAddress = horizontalAddress;
            this.verticalAddress = verticalAddress;
        }
    }

    private static final class RegionComposition {
        public final int id;
        public final boolean fillFlag;
        public final int width;
        public final int height;
        public final int levelOfCompatibility;
        public final int depth;
        public final int clutId;
        public final int pixelCode8Bit;
        public final int pixelCode4Bit;
        public final int pixelCode2Bit;
        public final SparseArray<RegionObject> regionObjects;

        public RegionComposition(int id, boolean fillFlag, int width, int height, int levelOfCompatibility, int depth, int clutId, int pixelCode8Bit, int pixelCode4Bit, int pixelCode2Bit, SparseArray<RegionObject> regionObjects) {
            this.id = id;
            this.fillFlag = fillFlag;
            this.width = width;
            this.height = height;
            this.levelOfCompatibility = levelOfCompatibility;
            this.depth = depth;
            this.clutId = clutId;
            this.pixelCode8Bit = pixelCode8Bit;
            this.pixelCode4Bit = pixelCode4Bit;
            this.pixelCode2Bit = pixelCode2Bit;
            this.regionObjects = regionObjects;
        }

        public void mergeFrom(RegionComposition otherRegionComposition) {
            SparseArray<RegionObject> otherRegionObjects = otherRegionComposition.regionObjects;
            for (int i = 0; i < otherRegionObjects.size(); ++i) {
                this.regionObjects.put(otherRegionObjects.keyAt(i), (Object)((RegionObject)otherRegionObjects.valueAt(i)));
            }
        }
    }

    private static final class RegionObject {
        public final int type;
        public final int provider;
        public final int horizontalPosition;
        public final int verticalPosition;
        public final int foregroundPixelCode;
        public final int backgroundPixelCode;

        public RegionObject(int type, int provider, int horizontalPosition, int verticalPosition, int foregroundPixelCode, int backgroundPixelCode) {
            this.type = type;
            this.provider = provider;
            this.horizontalPosition = horizontalPosition;
            this.verticalPosition = verticalPosition;
            this.foregroundPixelCode = foregroundPixelCode;
            this.backgroundPixelCode = backgroundPixelCode;
        }
    }

    private static final class ObjectData {
        public final int id;
        public final boolean nonModifyingColorFlag;
        public final byte[] topFieldData;
        public final byte[] bottomFieldData;

        public ObjectData(int id, boolean nonModifyingColorFlag, byte[] topFieldData, byte[] bottomFieldData) {
            this.id = id;
            this.nonModifyingColorFlag = nonModifyingColorFlag;
            this.topFieldData = topFieldData;
            this.bottomFieldData = bottomFieldData;
        }
    }
}

