/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.webvtt;

import android.text.TextUtils;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.LegacySubtitleUtil;
import androidx.media3.extractor.text.SubtitleParser;
import androidx.media3.extractor.text.webvtt.WebvttCssParser;
import androidx.media3.extractor.text.webvtt.WebvttCssStyle;
import androidx.media3.extractor.text.webvtt.WebvttCueInfo;
import androidx.media3.extractor.text.webvtt.WebvttCueParser;
import androidx.media3.extractor.text.webvtt.WebvttParserUtil;
import androidx.media3.extractor.text.webvtt.WebvttSubtitle;
import java.util.ArrayList;

@UnstableApi
public final class WebvttParser
implements SubtitleParser {
    public static final int CUE_REPLACEMENT_BEHAVIOR = 1;
    private static final int EVENT_NONE = -1;
    private static final int EVENT_END_OF_FILE = 0;
    private static final int EVENT_COMMENT = 1;
    private static final int EVENT_STYLE_BLOCK = 2;
    private static final int EVENT_CUE = 3;
    private static final String COMMENT_START = "NOTE";
    private static final String STYLE_START = "STYLE";
    private final ParsableByteArray parsableWebvttData = new ParsableByteArray();
    private final WebvttCssParser cssParser = new WebvttCssParser();

    @Override
    public int getCueReplacementBehavior() {
        return 1;
    }

    @Override
    public void parse(byte[] data, int offset, int length, SubtitleParser.OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        int event;
        this.parsableWebvttData.reset(data, offset + length);
        this.parsableWebvttData.setPosition(offset);
        ArrayList<WebvttCssStyle> definedStyles = new ArrayList<WebvttCssStyle>();
        try {
            WebvttParserUtil.validateWebvttHeaderLine(this.parsableWebvttData);
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(e);
        }
        while (!TextUtils.isEmpty((CharSequence)this.parsableWebvttData.readLine())) {
        }
        ArrayList<WebvttCueInfo> cueInfos = new ArrayList<WebvttCueInfo>();
        while ((event = WebvttParser.getNextEvent(this.parsableWebvttData)) != 0) {
            WebvttCueInfo cueInfo;
            if (event == 1) {
                WebvttParser.skipComment(this.parsableWebvttData);
                continue;
            }
            if (event == 2) {
                if (!cueInfos.isEmpty()) {
                    throw new IllegalArgumentException("A style block was found after the first cue.");
                }
                this.parsableWebvttData.readLine();
                definedStyles.addAll(this.cssParser.parseBlock(this.parsableWebvttData));
                continue;
            }
            if (event != 3 || (cueInfo = WebvttCueParser.parseCue(this.parsableWebvttData, definedStyles)) == null) continue;
            cueInfos.add(cueInfo);
        }
        WebvttSubtitle subtitle = new WebvttSubtitle(cueInfos);
        LegacySubtitleUtil.toCuesWithTiming(subtitle, outputOptions, output);
    }

    private static int getNextEvent(ParsableByteArray parsableWebvttData) {
        int foundEvent = -1;
        int currentInputPosition = 0;
        while (foundEvent == -1) {
            currentInputPosition = parsableWebvttData.getPosition();
            String line = parsableWebvttData.readLine();
            if (line == null) {
                foundEvent = 0;
                continue;
            }
            if (STYLE_START.equals(line)) {
                foundEvent = 2;
                continue;
            }
            if (line.startsWith(COMMENT_START)) {
                foundEvent = 1;
                continue;
            }
            foundEvent = 3;
        }
        parsableWebvttData.setPosition(currentInputPosition);
        return foundEvent;
    }

    private static void skipComment(ParsableByteArray parsableWebvttData) {
        while (!TextUtils.isEmpty((CharSequence)parsableWebvttData.readLine())) {
        }
    }
}

