/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.Ac3Util;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class Ac3Reader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int HEADER_SIZE = 128;
    private final ParsableBitArray headerScratchBits = new ParsableBitArray(new byte[128]);
    private final ParsableByteArray headerScratchBytes;
    @Nullable
    private final String language;
    private final int roleFlags;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private int state;
    private int bytesRead;
    private boolean lastByteWas0B;
    private long sampleDurationUs;
    private @MonotonicNonNull Format format;
    private int sampleSize;
    private long timeUs;

    public Ac3Reader() {
        this(null, 0);
    }

    public Ac3Reader(@Nullable String language, int roleFlags) {
        this.headerScratchBytes = new ParsableByteArray(this.headerScratchBits.data);
        this.state = 0;
        this.timeUs = -9223372036854775807L;
        this.language = language;
        this.roleFlags = roleFlags;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWas0B = false;
        this.timeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 1);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.timeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull((Object)this.output);
        block5: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSync(data)) continue block5;
                    this.state = 1;
                    this.headerScratchBytes.getData()[0] = 11;
                    this.headerScratchBytes.getData()[1] = 119;
                    this.bytesRead = 2;
                    continue block5;
                }
                case 1: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), 128)) continue block5;
                    this.parseHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, 128);
                    this.state = 2;
                    continue block5;
                }
                case 2: {
                    int bytesToRead = Math.min(data.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(data, bytesToRead);
                    this.bytesRead += bytesToRead;
                    if (this.bytesRead != this.sampleSize) continue block5;
                    Assertions.checkState((this.timeUs != -9223372036854775807L ? 1 : 0) != 0);
                    this.output.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                    continue block5;
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
        int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
        source.readBytes(target, this.bytesRead, bytesToRead);
        this.bytesRead += bytesToRead;
        return this.bytesRead == targetLength;
    }

    private boolean skipToNextSync(ParsableByteArray pesBuffer) {
        while (pesBuffer.bytesLeft() > 0) {
            if (!this.lastByteWas0B) {
                this.lastByteWas0B = pesBuffer.readUnsignedByte() == 11;
                continue;
            }
            int secondByte = pesBuffer.readUnsignedByte();
            if (secondByte == 119) {
                this.lastByteWas0B = false;
                return true;
            }
            this.lastByteWas0B = secondByte == 11;
        }
        return false;
    }

    @RequiresNonNull(value={"output"})
    private void parseHeader() {
        this.headerScratchBits.setPosition(0);
        Ac3Util.SyncFrameInfo frameInfo = Ac3Util.parseAc3SyncframeInfo(this.headerScratchBits);
        if (this.format == null || frameInfo.channelCount != this.format.channelCount || frameInfo.sampleRate != this.format.sampleRate || !Util.areEqual((Object)frameInfo.mimeType, (Object)this.format.sampleMimeType)) {
            Format.Builder formatBuilder = new Format.Builder().setId(this.formatId).setSampleMimeType(frameInfo.mimeType).setChannelCount(frameInfo.channelCount).setSampleRate(frameInfo.sampleRate).setLanguage(this.language).setRoleFlags(this.roleFlags).setPeakBitrate(frameInfo.bitrate);
            if ("audio/ac3".equals(frameInfo.mimeType)) {
                formatBuilder.setAverageBitrate(frameInfo.bitrate);
            }
            this.format = formatBuilder.build();
            this.output.format(this.format);
        }
        this.sampleSize = frameInfo.frameSize;
        this.sampleDurationUs = 1000000L * (long)frameInfo.sampleCount / (long)this.format.sampleRate;
    }
}

