/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.container.NalUnitUtil;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.NalUnitTargetBuffer;
import androidx.media3.extractor.ts.TsPayloadReader;
import androidx.media3.extractor.ts.UserDataReader;
import java.util.Arrays;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class H263Reader
implements ElementaryStreamReader {
    private static final String TAG = "H263Reader";
    private static final int START_CODE_VALUE_VISUAL_OBJECT_SEQUENCE = 176;
    private static final int START_CODE_VALUE_USER_DATA = 178;
    private static final int START_CODE_VALUE_GROUP_OF_VOP = 179;
    private static final int START_CODE_VALUE_VISUAL_OBJECT = 181;
    private static final int START_CODE_VALUE_VOP = 182;
    private static final int START_CODE_VALUE_MAX_VIDEO_OBJECT = 31;
    private static final int START_CODE_VALUE_UNSET = -1;
    private static final float[] PIXEL_WIDTH_HEIGHT_RATIO_BY_ASPECT_RATIO_INFO = new float[]{1.0f, 1.0f, 1.0909091f, 0.90909094f, 1.4545455f, 1.2121212f, 1.0f};
    private static final int VIDEO_OBJECT_LAYER_SHAPE_RECTANGULAR = 0;
    @Nullable
    private final UserDataReader userDataReader;
    @Nullable
    private final ParsableByteArray userDataParsable;
    private final boolean[] prefixFlags;
    private final CsdBuffer csdBuffer;
    @Nullable
    private final NalUnitTargetBuffer userData;
    private @MonotonicNonNull SampleReader sampleReader;
    private long totalBytesWritten;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private boolean hasOutputFormat;
    private long pesTimeUs;

    public H263Reader() {
        this(null);
    }

    H263Reader(@Nullable UserDataReader userDataReader) {
        this.userDataReader = userDataReader;
        this.prefixFlags = new boolean[4];
        this.csdBuffer = new CsdBuffer(128);
        this.pesTimeUs = -9223372036854775807L;
        if (userDataReader != null) {
            this.userData = new NalUnitTargetBuffer(178, 128);
            this.userDataParsable = new ParsableByteArray();
        } else {
            this.userData = null;
            this.userDataParsable = null;
        }
    }

    @Override
    public void seek() {
        NalUnitUtil.clearPrefixFlags((boolean[])this.prefixFlags);
        this.csdBuffer.reset();
        if (this.sampleReader != null) {
            this.sampleReader.reset();
        }
        if (this.userData != null) {
            this.userData.reset();
        }
        this.totalBytesWritten = 0L;
        this.pesTimeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 2);
        this.sampleReader = new SampleReader(this.output);
        if (this.userDataReader != null) {
            this.userDataReader.createTracks(extractorOutput, idGenerator);
        }
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.pesTimeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull((Object)this.sampleReader);
        Assertions.checkStateNotNull((Object)this.output);
        int offset = data.getPosition();
        int limit = data.limit();
        byte[] dataArray = data.getData();
        this.totalBytesWritten += (long)data.bytesLeft();
        this.output.sampleData(data, data.bytesLeft());
        while (true) {
            int bytesAlreadyPassed;
            int startCodeOffset;
            if ((startCodeOffset = NalUnitUtil.findNalUnit((byte[])dataArray, (int)offset, (int)limit, (boolean[])this.prefixFlags)) == limit) {
                if (!this.hasOutputFormat) {
                    this.csdBuffer.onData(dataArray, offset, limit);
                }
                this.sampleReader.onData(dataArray, offset, limit);
                if (this.userData != null) {
                    this.userData.appendToNalUnit(dataArray, offset, limit);
                }
                return;
            }
            int startCodeValue = data.getData()[startCodeOffset + 3] & 0xFF;
            int lengthToStartCode = startCodeOffset - offset;
            if (!this.hasOutputFormat) {
                if (lengthToStartCode > 0) {
                    this.csdBuffer.onData(dataArray, offset, startCodeOffset);
                }
                int n = bytesAlreadyPassed = lengthToStartCode < 0 ? -lengthToStartCode : 0;
                if (this.csdBuffer.onStartCode(startCodeValue, bytesAlreadyPassed)) {
                    this.output.format(H263Reader.parseCsdBuffer(this.csdBuffer, this.csdBuffer.volStartPosition, (String)Assertions.checkNotNull((Object)this.formatId)));
                    this.hasOutputFormat = true;
                }
            }
            this.sampleReader.onData(dataArray, offset, startCodeOffset);
            if (this.userData != null) {
                bytesAlreadyPassed = 0;
                if (lengthToStartCode > 0) {
                    this.userData.appendToNalUnit(dataArray, offset, startCodeOffset);
                } else {
                    bytesAlreadyPassed = -lengthToStartCode;
                }
                if (this.userData.endNalUnit(bytesAlreadyPassed)) {
                    int unescapedLength = NalUnitUtil.unescapeStream((byte[])this.userData.nalData, (int)this.userData.nalLength);
                    ((ParsableByteArray)Util.castNonNull((Object)this.userDataParsable)).reset(this.userData.nalData, unescapedLength);
                    ((UserDataReader)Util.castNonNull((Object)this.userDataReader)).consume(this.pesTimeUs, this.userDataParsable);
                }
                if (startCodeValue == 178 && data.getData()[startCodeOffset + 2] == 1) {
                    this.userData.startNalUnit(startCodeValue);
                }
            }
            int bytesWrittenPastPosition = limit - startCodeOffset;
            long absolutePosition = this.totalBytesWritten - (long)bytesWrittenPastPosition;
            this.sampleReader.onDataEnd(absolutePosition, bytesWrittenPastPosition, this.hasOutputFormat);
            this.sampleReader.onStartCode(startCodeValue, this.pesTimeUs);
            offset = startCodeOffset + 3;
        }
    }

    @Override
    public void packetFinished() {
    }

    private static Format parseCsdBuffer(CsdBuffer csdBuffer, int volStartPosition, String formatId) {
        int videoObjectLayerShape;
        float pixelWidthHeightRatio;
        int aspectRatioInfo;
        byte[] csdData = Arrays.copyOf(csdBuffer.data, csdBuffer.length);
        ParsableBitArray buffer = new ParsableBitArray(csdData);
        buffer.skipBytes(volStartPosition);
        buffer.skipBytes(4);
        buffer.skipBit();
        buffer.skipBits(8);
        if (buffer.readBit()) {
            buffer.skipBits(4);
            buffer.skipBits(3);
        }
        if ((aspectRatioInfo = buffer.readBits(4)) == 15) {
            int parWidth = buffer.readBits(8);
            int parHeight = buffer.readBits(8);
            if (parHeight == 0) {
                Log.w((String)TAG, (String)"Invalid aspect ratio");
                pixelWidthHeightRatio = 1.0f;
            } else {
                pixelWidthHeightRatio = (float)parWidth / (float)parHeight;
            }
        } else if (aspectRatioInfo < PIXEL_WIDTH_HEIGHT_RATIO_BY_ASPECT_RATIO_INFO.length) {
            pixelWidthHeightRatio = PIXEL_WIDTH_HEIGHT_RATIO_BY_ASPECT_RATIO_INFO[aspectRatioInfo];
        } else {
            Log.w((String)TAG, (String)"Invalid aspect ratio");
            pixelWidthHeightRatio = 1.0f;
        }
        if (buffer.readBit()) {
            buffer.skipBits(2);
            buffer.skipBits(1);
            if (buffer.readBit()) {
                buffer.skipBits(15);
                buffer.skipBit();
                buffer.skipBits(15);
                buffer.skipBit();
                buffer.skipBits(15);
                buffer.skipBit();
                buffer.skipBits(3);
                buffer.skipBits(11);
                buffer.skipBit();
                buffer.skipBits(15);
                buffer.skipBit();
            }
        }
        if ((videoObjectLayerShape = buffer.readBits(2)) != 0) {
            Log.w((String)TAG, (String)"Unhandled video object layer shape");
        }
        buffer.skipBit();
        int vopTimeIncrementResolution = buffer.readBits(16);
        buffer.skipBit();
        if (buffer.readBit()) {
            if (vopTimeIncrementResolution == 0) {
                Log.w((String)TAG, (String)"Invalid vop_increment_time_resolution");
            } else {
                --vopTimeIncrementResolution;
                int numBits = 0;
                while (vopTimeIncrementResolution > 0) {
                    ++numBits;
                    vopTimeIncrementResolution >>= 1;
                }
                buffer.skipBits(numBits);
            }
        }
        buffer.skipBit();
        int videoObjectLayerWidth = buffer.readBits(13);
        buffer.skipBit();
        int videoObjectLayerHeight = buffer.readBits(13);
        buffer.skipBit();
        buffer.skipBit();
        return new Format.Builder().setId(formatId).setSampleMimeType("video/mp4v-es").setWidth(videoObjectLayerWidth).setHeight(videoObjectLayerHeight).setPixelWidthHeightRatio(pixelWidthHeightRatio).setInitializationData(Collections.singletonList(csdData)).build();
    }

    private static final class CsdBuffer {
        private static final byte[] START_CODE = new byte[]{0, 0, 1};
        private static final int STATE_SKIP_TO_VISUAL_OBJECT_SEQUENCE_START = 0;
        private static final int STATE_EXPECT_VISUAL_OBJECT_START = 1;
        private static final int STATE_EXPECT_VIDEO_OBJECT_START = 2;
        private static final int STATE_EXPECT_VIDEO_OBJECT_LAYER_START = 3;
        private static final int STATE_WAIT_FOR_VOP_START = 4;
        private boolean isFilling;
        private int state;
        public int length;
        public int volStartPosition;
        public byte[] data;

        public CsdBuffer(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        public void reset() {
            this.isFilling = false;
            this.length = 0;
            this.state = 0;
        }

        public boolean onStartCode(int startCodeValue, int bytesAlreadyPassed) {
            switch (this.state) {
                case 0: {
                    if (startCodeValue != 176) break;
                    this.state = 1;
                    this.isFilling = true;
                    break;
                }
                case 1: {
                    if (startCodeValue != 181) {
                        Log.w((String)H263Reader.TAG, (String)"Unexpected start code value");
                        this.reset();
                        break;
                    }
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (startCodeValue > 31) {
                        Log.w((String)H263Reader.TAG, (String)"Unexpected start code value");
                        this.reset();
                        break;
                    }
                    this.state = 3;
                    break;
                }
                case 3: {
                    if ((startCodeValue & 0xF0) != 32) {
                        Log.w((String)H263Reader.TAG, (String)"Unexpected start code value");
                        this.reset();
                        break;
                    }
                    this.volStartPosition = this.length;
                    this.state = 4;
                    break;
                }
                case 4: {
                    if (startCodeValue != 179 && startCodeValue != 181) break;
                    this.length -= bytesAlreadyPassed;
                    this.isFilling = false;
                    return true;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.onData(START_CODE, 0, START_CODE.length);
            return false;
        }

        public void onData(byte[] newData, int offset, int limit) {
            if (!this.isFilling) {
                return;
            }
            int readLength = limit - offset;
            if (this.data.length < this.length + readLength) {
                this.data = Arrays.copyOf(this.data, (this.length + readLength) * 2);
            }
            System.arraycopy(newData, offset, this.data, this.length, readLength);
            this.length += readLength;
        }
    }

    private static final class SampleReader {
        private static final int OFFSET_VOP_CODING_TYPE = 1;
        private static final int VOP_CODING_TYPE_INTRA = 0;
        private final TrackOutput output;
        private boolean readingSample;
        private boolean lookingForVopCodingType;
        private boolean sampleIsKeyframe;
        private int startCodeValue;
        private int vopBytesRead;
        private long samplePosition;
        private long sampleTimeUs;

        public SampleReader(TrackOutput output) {
            this.output = output;
        }

        public void reset() {
            this.readingSample = false;
            this.lookingForVopCodingType = false;
            this.sampleIsKeyframe = false;
            this.startCodeValue = -1;
        }

        public void onStartCode(int startCodeValue, long pesTimeUs) {
            this.startCodeValue = startCodeValue;
            this.sampleIsKeyframe = false;
            this.readingSample = startCodeValue == 182 || startCodeValue == 179;
            this.lookingForVopCodingType = startCodeValue == 182;
            this.vopBytesRead = 0;
            this.sampleTimeUs = pesTimeUs;
        }

        public void onData(byte[] data, int offset, int limit) {
            if (this.lookingForVopCodingType) {
                int headerOffset = offset + 1 - this.vopBytesRead;
                if (headerOffset < limit) {
                    this.sampleIsKeyframe = (data[headerOffset] & 0xC0) >> 6 == 0;
                    this.lookingForVopCodingType = false;
                } else {
                    this.vopBytesRead += limit - offset;
                }
            }
        }

        public void onDataEnd(long position, int bytesWrittenPastPosition, boolean hasOutputFormat) {
            Assertions.checkState((this.sampleTimeUs != -9223372036854775807L ? 1 : 0) != 0);
            if (this.startCodeValue == 182 && hasOutputFormat && this.readingSample) {
                int size = (int)(position - this.samplePosition);
                int flags = this.sampleIsKeyframe ? 1 : 0;
                this.output.sampleMetadata(this.sampleTimeUs, flags, size, bytesWrittenPastPosition, null);
            }
            if (this.startCodeValue != 179) {
                this.samplePosition = position;
            }
        }
    }
}

