/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class Id3Reader
implements ElementaryStreamReader {
    private static final String TAG = "Id3Reader";
    private final ParsableByteArray id3Header = new ParsableByteArray(10);
    private @MonotonicNonNull TrackOutput output;
    private boolean writingSample;
    private long sampleTimeUs = -9223372036854775807L;
    private int sampleSize;
    private int sampleBytesRead;

    @Override
    public void seek() {
        this.writingSample = false;
        this.sampleTimeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 5);
        this.output.format(new Format.Builder().setId(idGenerator.getFormatId()).setSampleMimeType("application/id3").build());
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        if ((flags & 4) == 0) {
            return;
        }
        this.writingSample = true;
        this.sampleTimeUs = pesTimeUs;
        this.sampleSize = 0;
        this.sampleBytesRead = 0;
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull((Object)this.output);
        if (!this.writingSample) {
            return;
        }
        int bytesAvailable = data.bytesLeft();
        if (this.sampleBytesRead < 10) {
            int headerBytesAvailable = Math.min(bytesAvailable, 10 - this.sampleBytesRead);
            System.arraycopy(data.getData(), data.getPosition(), this.id3Header.getData(), this.sampleBytesRead, headerBytesAvailable);
            if (this.sampleBytesRead + headerBytesAvailable == 10) {
                this.id3Header.setPosition(0);
                if (73 != this.id3Header.readUnsignedByte() || 68 != this.id3Header.readUnsignedByte() || 51 != this.id3Header.readUnsignedByte()) {
                    Log.w((String)TAG, (String)"Discarding invalid ID3 tag");
                    this.writingSample = false;
                    return;
                }
                this.id3Header.skipBytes(3);
                this.sampleSize = 10 + this.id3Header.readSynchSafeInt();
            }
        }
        int bytesToWrite = Math.min(bytesAvailable, this.sampleSize - this.sampleBytesRead);
        this.output.sampleData(data, bytesToWrite);
        this.sampleBytesRead += bytesToWrite;
    }

    @Override
    public void packetFinished() {
        Assertions.checkStateNotNull((Object)this.output);
        if (!this.writingSample || this.sampleSize == 0 || this.sampleBytesRead != this.sampleSize) {
            return;
        }
        Assertions.checkState((this.sampleTimeUs != -9223372036854775807L ? 1 : 0) != 0);
        this.output.sampleMetadata(this.sampleTimeUs, 1, this.sampleSize, 0, null);
        this.writingSample = false;
    }
}

