/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.Subtitle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableApi
public final class CuesWithTimingSubtitle
implements Subtitle {
    private static final String TAG = "CuesWithTimingSubtitle";
    private final ImmutableList<ImmutableList<Cue>> eventCues;
    private final long[] eventTimesUs;
    private static final Ordering<CuesWithTiming> CUES_BY_START_TIME_ASCENDING = Ordering.natural().onResultOf(c -> Long.valueOf(CuesWithTimingSubtitle.normalizeUnsetStartTimeToZero(c.startTimeUs)));

    public CuesWithTimingSubtitle(List<CuesWithTiming> cuesWithTimingList) {
        if (cuesWithTimingList.size() == 1) {
            CuesWithTiming cuesWithTiming = (CuesWithTiming)Iterables.getOnlyElement(cuesWithTimingList);
            long startTimeUs = CuesWithTimingSubtitle.normalizeUnsetStartTimeToZero(cuesWithTiming.startTimeUs);
            if (cuesWithTiming.durationUs == -9223372036854775807L) {
                this.eventCues = ImmutableList.of(cuesWithTiming.cues);
                this.eventTimesUs = new long[]{startTimeUs};
            } else {
                this.eventCues = ImmutableList.of(cuesWithTiming.cues, (Object)ImmutableList.of());
                this.eventTimesUs = new long[]{startTimeUs, startTimeUs + cuesWithTiming.durationUs};
            }
            return;
        }
        this.eventTimesUs = new long[cuesWithTimingList.size() * 2];
        Arrays.fill(this.eventTimesUs, Long.MAX_VALUE);
        ArrayList<Object> eventCues = new ArrayList<Object>();
        ImmutableList sortedCuesWithTimingList = ImmutableList.sortedCopyOf(CUES_BY_START_TIME_ASCENDING, cuesWithTimingList);
        int eventIndex = 0;
        for (int i = 0; i < sortedCuesWithTimingList.size(); ++i) {
            CuesWithTiming cuesWithTiming = (CuesWithTiming)sortedCuesWithTimingList.get(i);
            long startTimeUs = CuesWithTimingSubtitle.normalizeUnsetStartTimeToZero(cuesWithTiming.startTimeUs);
            long endTimeUs = startTimeUs + cuesWithTiming.durationUs;
            if (eventIndex == 0 || this.eventTimesUs[eventIndex - 1] < startTimeUs) {
                this.eventTimesUs[eventIndex++] = startTimeUs;
                eventCues.add(cuesWithTiming.cues);
            } else if (this.eventTimesUs[eventIndex - 1] == startTimeUs && ((ImmutableList)eventCues.get(eventIndex - 1)).isEmpty()) {
                eventCues.set(eventIndex - 1, cuesWithTiming.cues);
            } else {
                Log.w((String)TAG, (String)"Truncating unsupported overlapping cues.");
                this.eventTimesUs[eventIndex - 1] = startTimeUs;
                eventCues.set(eventIndex - 1, cuesWithTiming.cues);
            }
            if (cuesWithTiming.durationUs == -9223372036854775807L) continue;
            this.eventTimesUs[eventIndex++] = endTimeUs;
            eventCues.add(ImmutableList.of());
        }
        this.eventCues = ImmutableList.copyOf(eventCues);
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil((long[])this.eventTimesUs, (long)timeUs, (boolean)false, (boolean)false);
        return index < this.eventCues.size() ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.eventCues.size();
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument((index < this.eventCues.size() ? 1 : 0) != 0);
        return this.eventTimesUs[index];
    }

    public ImmutableList<Cue> getCues(long timeUs) {
        int index = Util.binarySearchFloor((long[])this.eventTimesUs, (long)timeUs, (boolean)true, (boolean)false);
        return index == -1 ? ImmutableList.of() : (ImmutableList)this.eventCues.get(index);
    }

    private static long normalizeUnsetStartTimeToZero(long startTime) {
        return startTime == -9223372036854775807L ? 0L : startTime;
    }
}

