/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.IndexSeekMap;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.text.CueEncoder;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.SubtitleParser;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public class SubtitleExtractor
implements Extractor {
    private static final int STATE_CREATED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_EXTRACTING = 2;
    private static final int STATE_SEEKING = 3;
    private static final int STATE_FINISHED = 4;
    private static final int STATE_RELEASED = 5;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final SubtitleParser subtitleParser;
    private final CueEncoder cueEncoder;
    private final Format format;
    private final List<Sample> samples;
    private final ParsableByteArray scratchSampleArray;
    private byte[] subtitleData;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int bytesRead;
    private int state;
    private long[] timestamps;
    private long seekTimeUs;

    public SubtitleExtractor(SubtitleParser subtitleParser, Format format) {
        this.subtitleParser = subtitleParser;
        this.cueEncoder = new CueEncoder();
        this.subtitleData = Util.EMPTY_BYTE_ARRAY;
        this.scratchSampleArray = new ParsableByteArray();
        this.format = format.buildUpon().setSampleMimeType("application/x-media3-cues").setCodecs(format.sampleMimeType).setCueReplacementBehavior(subtitleParser.getCueReplacementBehavior()).build();
        this.samples = new ArrayList<Sample>();
        this.state = 0;
        this.timestamps = Util.EMPTY_LONG_ARRAY;
        this.seekTimeUs = -9223372036854775807L;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return true;
    }

    @Override
    public void init(ExtractorOutput output) {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.trackOutput = output.track(0, 3);
        this.trackOutput.format(this.format);
        output.endTracks();
        output.seekMap(new IndexSeekMap(new long[]{0L}, new long[]{0L}, -9223372036854775807L));
        this.state = 1;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        boolean inputFinished;
        Assertions.checkState((this.state != 0 && this.state != 5 ? 1 : 0) != 0);
        if (this.state == 1) {
            int length;
            int n = length = input.getLength() != -1L ? Ints.checkedCast((long)input.getLength()) : 1024;
            if (length > this.subtitleData.length) {
                this.subtitleData = new byte[length];
            }
            this.bytesRead = 0;
            this.state = 2;
        }
        if (this.state == 2 && (inputFinished = this.readFromInput(input))) {
            this.parseAndWriteToOutput();
            this.state = 4;
        }
        if (this.state == 3 && (inputFinished = this.skipInput(input))) {
            this.writeToOutput();
            this.state = 4;
        }
        if (this.state == 4) {
            return -1;
        }
        return 0;
    }

    @Override
    public void seek(long position, long timeUs) {
        Assertions.checkState((this.state != 0 && this.state != 5 ? 1 : 0) != 0);
        this.seekTimeUs = timeUs;
        if (this.state == 2) {
            this.state = 1;
        }
        if (this.state == 4) {
            this.state = 3;
        }
    }

    @Override
    public void release() {
        if (this.state == 5) {
            return;
        }
        this.subtitleParser.reset();
        this.state = 5;
    }

    private boolean skipInput(ExtractorInput input) throws IOException {
        return input.skip(input.getLength() != -1L ? Ints.checkedCast((long)input.getLength()) : 1024) == -1;
    }

    private boolean readFromInput(ExtractorInput input) throws IOException {
        long inputLength;
        int readResult;
        if (this.subtitleData.length == this.bytesRead) {
            this.subtitleData = Arrays.copyOf(this.subtitleData, this.subtitleData.length + 1024);
        }
        if ((readResult = input.read(this.subtitleData, this.bytesRead, this.subtitleData.length - this.bytesRead)) != -1) {
            this.bytesRead += readResult;
        }
        return (inputLength = input.getLength()) != -1L && (long)this.bytesRead == inputLength || readResult == -1;
    }

    private void parseAndWriteToOutput() throws IOException {
        try {
            SubtitleParser.OutputOptions outputOptions = this.seekTimeUs != -9223372036854775807L ? SubtitleParser.OutputOptions.cuesAfterThenRemainingCuesBefore(this.seekTimeUs) : SubtitleParser.OutputOptions.allCues();
            this.subtitleParser.parse(this.subtitleData, outputOptions, (Consumer<CuesWithTiming>)((Consumer)cuesWithTiming -> {
                Sample sample = new Sample(cuesWithTiming.startTimeUs, this.cueEncoder.encode((List<Cue>)cuesWithTiming.cues, cuesWithTiming.durationUs));
                this.samples.add(sample);
                if (this.seekTimeUs == -9223372036854775807L || cuesWithTiming.startTimeUs >= this.seekTimeUs) {
                    this.writeToOutput(sample);
                }
            }));
            Collections.sort(this.samples);
            this.timestamps = new long[this.samples.size()];
            for (int i = 0; i < this.samples.size(); ++i) {
                this.timestamps[i] = this.samples.get(i).timeUs;
            }
            this.subtitleData = Util.EMPTY_BYTE_ARRAY;
        }
        catch (RuntimeException e) {
            throw ParserException.createForMalformedContainer((String)"SubtitleParser failed.", (Throwable)e);
        }
    }

    private void writeToOutput() {
        int index;
        for (int i = index = this.seekTimeUs == -9223372036854775807L ? 0 : Util.binarySearchFloor((long[])this.timestamps, (long)this.seekTimeUs, (boolean)true, (boolean)true); i < this.samples.size(); ++i) {
            this.writeToOutput(this.samples.get(i));
        }
    }

    private void writeToOutput(Sample sample) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        int size = sample.data.length;
        this.scratchSampleArray.reset(sample.data);
        this.trackOutput.sampleData(this.scratchSampleArray, size);
        this.trackOutput.sampleMetadata(sample.timeUs, 1, size, 0, null);
    }

    private static class Sample
    implements Comparable<Sample> {
        private final long timeUs;
        private final byte[] data;

        private Sample(long timeUs, byte[] data) {
            this.timeUs = timeUs;
            this.data = data;
        }

        @Override
        public int compareTo(Sample sample) {
            return Long.compare(this.timeUs, sample.timeUs);
        }
    }
}

