/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.MpeghUtil;
import androidx.media3.extractor.ts.TsPayloadReader;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class MpeghReader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_PACKET_HEADER = 1;
    private static final int STATE_READING_PACKET_PAYLOAD = 2;
    private static final int MHAS_SYNC_WORD_LENGTH = 3;
    private static final int MIN_MHAS_PACKET_HEADER_SIZE = 2;
    private static final int MAX_MHAS_PACKET_HEADER_SIZE = 15;
    private final ParsableByteArray headerScratchBytes = new ParsableByteArray(new byte[15], 2);
    private final ParsableBitArray headerScratchBits = new ParsableBitArray();
    private final ParsableByteArray dataScratchBytes = new ParsableByteArray();
    private int state = 0;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private double timeUs = -9.223372036854776E18;
    private double timeUsPending = -9.223372036854776E18;
    private boolean dataPending;
    private boolean rapPending = true;
    private int flags;
    private int syncBytes;
    private boolean headerDataFinished = true;
    private int payloadBytesRead;
    private int frameBytes;
    private MpeghUtil.MhasPacketHeader header = new MpeghUtil.MhasPacketHeader();
    private int samplingRate = -2147483647;
    private int standardFrameLength = -1;
    private int truncationSamples;
    private long mainStreamLabel = -1L;
    private boolean configFound;

    @Override
    public void seek() {
        this.state = 0;
        this.syncBytes = 0;
        this.headerScratchBytes.reset(2);
        this.payloadBytesRead = 0;
        this.frameBytes = 0;
        this.samplingRate = -2147483647;
        this.standardFrameLength = -1;
        this.truncationSamples = 0;
        this.mainStreamLabel = -1L;
        this.configFound = false;
        this.dataPending = false;
        this.headerDataFinished = true;
        this.rapPending = true;
        this.timeUs = -9.223372036854776E18;
        this.timeUsPending = -9.223372036854776E18;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 1);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.flags = flags;
        if (!(this.rapPending || this.frameBytes == 0 && this.headerDataFinished)) {
            this.dataPending = true;
        }
        if (pesTimeUs != -9223372036854775807L) {
            if (this.dataPending) {
                this.timeUsPending = pesTimeUs;
            } else {
                this.timeUs = pesTimeUs;
            }
        }
    }

    @Override
    public void consume(ParsableByteArray data) throws ParserException {
        Assertions.checkStateNotNull((Object)this.output);
        block5: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSync(data)) continue block5;
                    this.state = 1;
                    continue block5;
                }
                case 1: {
                    this.copyData(data, this.headerScratchBytes, false);
                    if (this.headerScratchBytes.bytesLeft() == 0) {
                        if (this.parseHeader()) {
                            this.headerScratchBytes.setPosition(0);
                            this.output.sampleData(this.headerScratchBytes, this.headerScratchBytes.limit());
                            this.headerScratchBytes.reset(2);
                            this.dataScratchBytes.reset(this.header.packetLength);
                            this.headerDataFinished = true;
                            this.state = 2;
                            continue block5;
                        }
                        if (this.headerScratchBytes.limit() >= 15) continue block5;
                        this.headerScratchBytes.setLimit(this.headerScratchBytes.limit() + 1);
                        this.headerDataFinished = false;
                        continue block5;
                    }
                    this.headerDataFinished = false;
                    continue block5;
                }
                case 2: {
                    if (this.shouldParsePacket(this.header.packetType)) {
                        this.copyData(data, this.dataScratchBytes, true);
                    }
                    this.writeSampleData(data);
                    if (this.payloadBytesRead != this.header.packetLength) continue block5;
                    if (this.header.packetType == 1) {
                        this.parseConfig(new ParsableBitArray(this.dataScratchBytes.getData()));
                    } else if (this.header.packetType == 17) {
                        this.truncationSamples = MpeghUtil.parseAudioTruncationInfo(new ParsableBitArray(this.dataScratchBytes.getData()));
                    } else if (this.header.packetType == 2) {
                        this.finalizeFrame();
                    }
                    this.state = 1;
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void packetFinished(boolean isEndOfInput) {
    }

    private void copyData(ParsableByteArray source, ParsableByteArray target, boolean resetSourcePosition) {
        int sourcePosition = source.getPosition();
        int bytesToRead = Math.min(source.bytesLeft(), target.bytesLeft());
        source.readBytes(target.getData(), target.getPosition(), bytesToRead);
        target.skipBytes(bytesToRead);
        if (resetSourcePosition) {
            source.setPosition(sourcePosition);
        }
    }

    private boolean skipToNextSync(ParsableByteArray pesBuffer) {
        if ((this.flags & 2) == 0) {
            pesBuffer.setPosition(pesBuffer.limit());
            return false;
        }
        if ((this.flags & 4) == 0) {
            while (pesBuffer.bytesLeft() > 0) {
                this.syncBytes <<= 8;
                this.syncBytes |= pesBuffer.readUnsignedByte();
                if (!MpeghUtil.isSyncWord(this.syncBytes)) continue;
                pesBuffer.setPosition(pesBuffer.getPosition() - 3);
                this.syncBytes = 0;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean parseHeader() throws ParserException {
        int headerLength = this.headerScratchBytes.limit();
        this.headerScratchBits.reset(this.headerScratchBytes.getData(), headerLength);
        boolean result = MpeghUtil.parseMhasPacketHeader(this.headerScratchBits, this.header);
        if (result) {
            this.payloadBytesRead = 0;
            this.frameBytes += this.header.packetLength + headerLength;
        }
        return result;
    }

    private boolean shouldParsePacket(int packetType) {
        return packetType == 1 || packetType == 17;
    }

    @RequiresNonNull(value={"output"})
    private void writeSampleData(ParsableByteArray data) {
        int bytesToRead = Math.min(data.bytesLeft(), this.header.packetLength - this.payloadBytesRead);
        this.output.sampleData(data, bytesToRead);
        this.payloadBytesRead += bytesToRead;
    }

    @RequiresNonNull(value={"output"})
    private void parseConfig(ParsableBitArray bitArray) throws ParserException {
        MpeghUtil.Mpegh3daConfig config = MpeghUtil.parseMpegh3daConfig(bitArray);
        this.samplingRate = config.samplingFrequency;
        this.standardFrameLength = config.standardFrameLength;
        if (this.mainStreamLabel != this.header.packetLabel) {
            this.mainStreamLabel = this.header.packetLabel;
            String codecs = "mhm1";
            if (config.profileLevelIndication != -1) {
                codecs = codecs + String.format(".%02X", config.profileLevelIndication);
            }
            ImmutableList initializationData = null;
            if (config.compatibleProfileLevelSet != null && config.compatibleProfileLevelSet.length > 0) {
                initializationData = ImmutableList.of((Object)Util.EMPTY_BYTE_ARRAY, (Object)config.compatibleProfileLevelSet);
            }
            Format format = new Format.Builder().setId(this.formatId).setSampleMimeType("audio/mhm1").setSampleRate(this.samplingRate).setCodecs(codecs).setInitializationData((List)initializationData).build();
            this.output.format(format);
        }
        this.configFound = true;
    }

    @RequiresNonNull(value={"output"})
    private void finalizeFrame() {
        int flag = 0;
        if (this.configFound) {
            flag = 1;
            this.rapPending = false;
        }
        double sampleDurationUs = 1000000.0 * (double)(this.standardFrameLength - this.truncationSamples) / (double)this.samplingRate;
        long pts = Math.round(this.timeUs);
        if (this.dataPending) {
            this.dataPending = false;
            this.timeUs = this.timeUsPending;
        } else {
            this.timeUs += sampleDurationUs;
        }
        this.output.sampleMetadata(pts, flag, this.frameBytes, 0, null);
        this.configFound = false;
        this.truncationSamples = 0;
        this.frameBytes = 0;
    }
}

