/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

@UnstableApi
public final class DtsUtil {
    public static final int FRAME_TYPE_UNKNOWN = 0;
    public static final int FRAME_TYPE_CORE = 1;
    public static final int FRAME_TYPE_EXTENSION_SUBSTREAM = 2;
    public static final int FRAME_TYPE_UHD_SYNC = 3;
    public static final int FRAME_TYPE_UHD_NON_SYNC = 4;
    public static final int DTS_MAX_RATE_BYTES_PER_SECOND = 192000;
    public static final int DTS_HD_MAX_RATE_BYTES_PER_SECOND = 2250000;
    public static final int DTS_EXPRESS_MAX_RATE_BITS_PER_SECOND = 768000;
    private static final int SYNC_VALUE_BE = 2147385345;
    private static final int SYNC_VALUE_14B_BE = 536864768;
    private static final int SYNC_VALUE_LE = -25230976;
    private static final int SYNC_VALUE_14B_LE = -14745368;
    private static final int SYNC_VALUE_EXTSS_BE = 1683496997;
    private static final int SYNC_VALUE_EXTSS_LE = 622876772;
    private static final int SYNC_VALUE_UHD_FTOC_SYNC_BE = 1078008818;
    private static final int SYNC_VALUE_UHD_FTOC_SYNC_LE = -233094848;
    private static final int SYNC_VALUE_UHD_FTOC_NONSYNC_BE = 1908687592;
    private static final int SYNC_VALUE_UHD_FTOC_NONSYNC_LE = -398277519;
    private static final byte FIRST_BYTE_BE = 127;
    private static final byte FIRST_BYTE_14B_BE = 31;
    private static final byte FIRST_BYTE_LE = -2;
    private static final byte FIRST_BYTE_14B_LE = -1;
    private static final byte FIRST_BYTE_EXTSS_BE = 100;
    private static final byte FIRST_BYTE_EXTSS_LE = 37;
    private static final byte FIRST_BYTE_UHD_FTOC_SYNC_BE = 64;
    private static final byte FIRST_BYTE_UHD_FTOC_SYNC_LE = -14;
    private static final byte FIRST_BYTE_UHD_FTOC_NONSYNC_BE = 113;
    private static final byte FIRST_BYTE_UHD_FTOC_NONSYNC_LE = -24;
    private static final int[] CHANNELS_BY_AMODE = new int[]{1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 6, 7, 8, 8};
    private static final int[] SAMPLE_RATE_BY_SFREQ = new int[]{-1, 8000, 16000, 32000, -1, -1, 11025, 22050, 44100, -1, -1, 12000, 24000, 48000, -1, -1};
    private static final int[] TWICE_BITRATE_KBPS_BY_RATE = new int[]{64, 112, 128, 192, 224, 256, 384, 448, 512, 640, 768, 896, 1024, 1152, 1280, 1536, 1920, 2048, 2304, 2560, 2688, 2816, 2823, 2944, 3072, 3840, 4096, 6144, 7680};
    private static final int[] SAMPLE_RATE_BY_INDEX = new int[]{8000, 16000, 32000, 64000, 128000, 22050, 44100, 88200, 176400, 352800, 12000, 24000, 48000, 96000, 192000, 384000};
    private static final int[] UHD_FTOC_PAYLOAD_LENGTH_TABLE = new int[]{5, 8, 10, 12};
    private static final int[] UHD_METADATA_CHUNK_SIZE_LENGTH_TABLE = new int[]{6, 9, 12, 15};
    private static final int[] UHD_AUDIO_CHUNK_ID_LENGTH_TABLE = new int[]{2, 4, 6, 8};
    private static final int[] UHD_AUDIO_CHUNK_SIZE_LENGTH_TABLE = new int[]{9, 11, 13, 16};
    private static final int[] UHD_HEADER_SIZE_LENGTH_TABLE = new int[]{5, 8, 10, 12};

    public static int getFrameType(int word) {
        if (word == 2147385345 || word == -25230976 || word == 536864768 || word == -14745368) {
            return 1;
        }
        if (word == 1683496997 || word == 622876772) {
            return 2;
        }
        if (word == 1078008818 || word == -233094848) {
            return 3;
        }
        if (word == 1908687592 || word == -398277519) {
            return 4;
        }
        return 0;
    }

    public static Format parseDtsFormat(byte[] frame, @Nullable String trackId, @Nullable String language, int roleFlags, @Nullable DrmInitData drmInitData) {
        ParsableBitArray frameBits = DtsUtil.getNormalizedFrame(frame);
        frameBits.skipBits(60);
        int amode = frameBits.readBits(6);
        int channelCount = CHANNELS_BY_AMODE[amode];
        int sfreq = frameBits.readBits(4);
        int sampleRate = SAMPLE_RATE_BY_SFREQ[sfreq];
        int rate = frameBits.readBits(5);
        int bitrate = rate >= TWICE_BITRATE_KBPS_BY_RATE.length ? -1 : TWICE_BITRATE_KBPS_BY_RATE[rate] * 1000 / 2;
        frameBits.skipBits(10);
        return new Format.Builder().setId(trackId).setSampleMimeType("audio/vnd.dts").setAverageBitrate(bitrate).setChannelCount(channelCount += frameBits.readBits(2) > 0 ? 1 : 0).setSampleRate(sampleRate).setDrmInitData(drmInitData).setLanguage(language).setRoleFlags(roleFlags).build();
    }

    public static int parseDtsAudioSampleCount(byte[] data) {
        int nblks;
        switch (data[0]) {
            case -2: {
                nblks = (data[5] & 1) << 6 | (data[4] & 0xFC) >> 2;
                break;
            }
            case -1: {
                nblks = (data[4] & 7) << 4 | (data[7] & 0x3C) >> 2;
                break;
            }
            case 31: {
                nblks = (data[5] & 7) << 4 | (data[6] & 0x3C) >> 2;
                break;
            }
            default: {
                nblks = (data[4] & 1) << 6 | (data[5] & 0xFC) >> 2;
            }
        }
        return (nblks + 1) * 32;
    }

    public static int parseDtsAudioSampleCount(ByteBuffer buffer) {
        int nblks;
        if (buffer.getInt(0) == -233094848 || buffer.getInt(0) == -398277519) {
            return 1024;
        }
        if (buffer.getInt(0) == 622876772) {
            return 4096;
        }
        int position = buffer.position();
        switch (buffer.get(position)) {
            case -2: {
                nblks = (buffer.get(position + 5) & 1) << 6 | (buffer.get(position + 4) & 0xFC) >> 2;
                break;
            }
            case -1: {
                nblks = (buffer.get(position + 4) & 7) << 4 | (buffer.get(position + 7) & 0x3C) >> 2;
                break;
            }
            case 31: {
                nblks = (buffer.get(position + 5) & 7) << 4 | (buffer.get(position + 6) & 0x3C) >> 2;
                break;
            }
            default: {
                nblks = (buffer.get(position + 4) & 1) << 6 | (buffer.get(position + 5) & 0xFC) >> 2;
            }
        }
        return (nblks + 1) * 32;
    }

    public static int getDtsFrameSize(byte[] data) {
        int fsize;
        boolean uses14BitPerWord = false;
        switch (data[0]) {
            case 31: {
                fsize = ((data[6] & 3) << 12 | (data[7] & 0xFF) << 4 | (data[8] & 0x3C) >> 2) + 1;
                uses14BitPerWord = true;
                break;
            }
            case -2: {
                fsize = ((data[4] & 3) << 12 | (data[7] & 0xFF) << 4 | (data[6] & 0xF0) >> 4) + 1;
                break;
            }
            case -1: {
                fsize = ((data[7] & 3) << 12 | (data[6] & 0xFF) << 4 | (data[9] & 0x3C) >> 2) + 1;
                uses14BitPerWord = true;
                break;
            }
            default: {
                fsize = ((data[5] & 3) << 12 | (data[6] & 0xFF) << 4 | (data[7] & 0xF0) >> 4) + 1;
            }
        }
        return uses14BitPerWord ? fsize * 16 / 14 : fsize;
    }

    public static DtsHeader parseDtsHdHeader(byte[] header) throws ParserException {
        int extensionSubstreamFrameDurationCode;
        int referenceClockCode;
        int extensionSubstreamFrameSizeBits;
        int headerSizeInBits;
        ParsableBitArray headerBits = DtsUtil.getNormalizedFrame(header);
        headerBits.skipBits(40);
        int extensionSubstreamIndex = headerBits.readBits(2);
        if (!headerBits.readBit()) {
            headerSizeInBits = 8;
            extensionSubstreamFrameSizeBits = 16;
        } else {
            headerSizeInBits = 12;
            extensionSubstreamFrameSizeBits = 20;
        }
        headerBits.skipBits(headerSizeInBits);
        int extensionSubstreamFrameSize = headerBits.readBits(extensionSubstreamFrameSizeBits) + 1;
        boolean staticFieldsPresent = headerBits.readBit();
        if (staticFieldsPresent) {
            referenceClockCode = headerBits.readBits(2);
            extensionSubstreamFrameDurationCode = 512 * (headerBits.readBits(3) + 1);
            if (headerBits.readBit()) {
                headerBits.skipBits(36);
            }
            int audioPresentationsCount = headerBits.readBits(3) + 1;
            int assetsCount = headerBits.readBits(3) + 1;
            if (audioPresentationsCount != 1 || assetsCount != 1) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Multiple audio presentations or assets not supported");
            }
            int activeExtensionSubstreamMask = headerBits.readBits(extensionSubstreamIndex + 1);
            for (int i = 0; i < extensionSubstreamIndex + 1; ++i) {
                if ((activeExtensionSubstreamMask >> i & 1) != 1) continue;
                headerBits.skipBits(8);
            }
            if (headerBits.readBit()) {
                headerBits.skipBits(2);
                int mixerOutputMaskBits = headerBits.readBits(2) + 1 << 2;
                int mixerOutputConfigurationCount = headerBits.readBits(2) + 1;
                for (int i = 0; i < mixerOutputConfigurationCount; ++i) {
                    headerBits.skipBits(mixerOutputMaskBits);
                }
            }
        } else {
            referenceClockCode = -1;
            extensionSubstreamFrameDurationCode = 0;
        }
        headerBits.skipBits(extensionSubstreamFrameSizeBits);
        int sampleRate = -2147483647;
        int channelCount = -1;
        headerBits.skipBits(12);
        if (staticFieldsPresent) {
            if (headerBits.readBit()) {
                headerBits.skipBits(4);
            }
            if (headerBits.readBit()) {
                headerBits.skipBits(24);
            }
            if (headerBits.readBit()) {
                int infoTextByteSize = headerBits.readBits(10) + 1;
                headerBits.skipBytes(infoTextByteSize);
            }
            headerBits.skipBits(5);
            sampleRate = SAMPLE_RATE_BY_INDEX[headerBits.readBits(4)];
            channelCount = headerBits.readBits(8) + 1;
        }
        long frameDurationUs = -9223372036854775807L;
        if (staticFieldsPresent) {
            int referenceClockFrequency;
            switch (referenceClockCode) {
                case 0: {
                    referenceClockFrequency = 32000;
                    break;
                }
                case 1: {
                    referenceClockFrequency = 44100;
                    break;
                }
                case 2: {
                    referenceClockFrequency = 48000;
                    break;
                }
                default: {
                    throw ParserException.createForMalformedContainer((String)("Unsupported reference clock code in DTS HD header: " + referenceClockCode), null);
                }
            }
            frameDurationUs = Util.scaleLargeTimestamp((long)extensionSubstreamFrameDurationCode, (long)1000000L, (long)referenceClockFrequency);
        }
        return new DtsHeader("audio/vnd.dts.hd;profile=lbr", channelCount, sampleRate, extensionSubstreamFrameSize, frameDurationUs, 0);
    }

    public static int parseDtsHdHeaderSize(byte[] headerPrefix) {
        ParsableBitArray headerPrefixBits = DtsUtil.getNormalizedFrame(headerPrefix);
        headerPrefixBits.skipBits(42);
        int headerBits = headerPrefixBits.readBit() ? 12 : 8;
        return headerPrefixBits.readBits(headerBits) + 1;
    }

    public static DtsHeader parseDtsUhdHeader(byte[] header, AtomicInteger uhdAudioChunkId) throws ParserException {
        ParsableBitArray headerBits = DtsUtil.getNormalizedFrame(header);
        int syncWord = headerBits.readBits(32);
        boolean syncFrameFlag = syncWord == 1078008818;
        int ftocPayloadInBytes = DtsUtil.parseUnsignedVarInt(headerBits, UHD_FTOC_PAYLOAD_LENGTH_TABLE, true) + 1;
        int sampleRate = -2147483647;
        long frameDurationUs = -9223372036854775807L;
        if (syncFrameFlag) {
            int clockRateHertz;
            int baseDuration;
            if (!headerBits.readBit()) {
                throw ParserException.createForUnsupportedContainerFeature((String)"Only supports full channel mask-based audio presentation");
            }
            DtsUtil.checkCrc(header, ftocPayloadInBytes);
            int baseDurationIndex = headerBits.readBits(2);
            switch (baseDurationIndex) {
                case 0: {
                    baseDuration = 512;
                    break;
                }
                case 1: {
                    baseDuration = 480;
                    break;
                }
                case 2: {
                    baseDuration = 384;
                    break;
                }
                default: {
                    throw ParserException.createForMalformedContainer((String)("Unsupported base duration index in DTS UHD header: " + baseDurationIndex), null);
                }
            }
            int frameDurationInClockPeriods = baseDuration * (headerBits.readBits(3) + 1);
            int clockRateIndex = headerBits.readBits(2);
            switch (clockRateIndex) {
                case 0: {
                    clockRateHertz = 32000;
                    break;
                }
                case 1: {
                    clockRateHertz = 44100;
                    break;
                }
                case 2: {
                    clockRateHertz = 48000;
                    break;
                }
                default: {
                    throw ParserException.createForMalformedContainer((String)("Unsupported clock rate index in DTS UHD header: " + clockRateIndex), null);
                }
            }
            if (headerBits.readBit()) {
                headerBits.skipBits(36);
            }
            int sampleRateMultiplier = 1 << headerBits.readBits(2);
            sampleRate = clockRateHertz * sampleRateMultiplier;
            frameDurationUs = Util.scaleLargeTimestamp((long)frameDurationInClockPeriods, (long)1000000L, (long)clockRateHertz);
        }
        int chunkPayloadBytes = 0;
        int numOfMetadataChunks = syncFrameFlag ? 1 : 0;
        for (int i = 0; i < numOfMetadataChunks; ++i) {
            int metadataChunkSize = DtsUtil.parseUnsignedVarInt(headerBits, UHD_METADATA_CHUNK_SIZE_LENGTH_TABLE, true);
            chunkPayloadBytes += metadataChunkSize;
        }
        int numAudioChunks = 1;
        for (int i = 0; i < numAudioChunks; ++i) {
            if (syncFrameFlag) {
                uhdAudioChunkId.set(DtsUtil.parseUnsignedVarInt(headerBits, UHD_AUDIO_CHUNK_ID_LENGTH_TABLE, true));
            }
            int audioChunkSize = uhdAudioChunkId.get() != 0 ? DtsUtil.parseUnsignedVarInt(headerBits, UHD_AUDIO_CHUNK_SIZE_LENGTH_TABLE, true) : 0;
            chunkPayloadBytes += audioChunkSize;
        }
        int frameSize = ftocPayloadInBytes + chunkPayloadBytes;
        return new DtsHeader("audio/vnd.dts.uhd;profile=p2", 2, sampleRate, frameSize, frameDurationUs, 0);
    }

    public static int parseDtsUhdHeaderSize(byte[] headerPrefix) {
        ParsableBitArray headerPrefixBits = DtsUtil.getNormalizedFrame(headerPrefix);
        headerPrefixBits.skipBits(32);
        return DtsUtil.parseUnsignedVarInt(headerPrefixBits, UHD_HEADER_SIZE_LENGTH_TABLE, true) + 1;
    }

    private static void checkCrc(byte[] frame, int sizeInBytes) throws ParserException {
        int initialValue = 65535;
        int extractedCrc = frame[sizeInBytes - 2] << 8 & initialValue | frame[sizeInBytes - 1] & 0xFF;
        int calculatedCrc = Util.crc16((byte[])frame, (int)0, (int)(sizeInBytes - 2), (int)initialValue);
        if (extractedCrc != calculatedCrc) {
            throw ParserException.createForMalformedContainer((String)"CRC check failed", null);
        }
    }

    private static int parseUnsignedVarInt(ParsableBitArray frameBits, int[] lengths, boolean extractAndAddFlag) {
        int index = 0;
        for (int i = 0; i < 3 && frameBits.readBit(); ++i) {
            ++index;
        }
        int value = 0;
        if (extractAndAddFlag) {
            for (int i = 0; i < index; ++i) {
                value += 1 << lengths[i];
            }
        }
        return value + frameBits.readBits(lengths[index]);
    }

    private static ParsableBitArray getNormalizedFrame(byte[] frame) {
        if (frame[0] == 127 || frame[0] == 100 || frame[0] == 64 || frame[0] == 113) {
            return new ParsableBitArray(frame);
        }
        if (DtsUtil.isLittleEndianFrameHeader(frame = Arrays.copyOf(frame, frame.length))) {
            for (int i = 0; i < frame.length - 1; i += 2) {
                byte temp = frame[i];
                frame[i] = frame[i + 1];
                frame[i + 1] = temp;
            }
        }
        ParsableBitArray frameBits = new ParsableBitArray(frame);
        if (frame[0] == 31) {
            ParsableBitArray scratchBits = new ParsableBitArray(frame);
            while (scratchBits.bitsLeft() >= 16) {
                scratchBits.skipBits(2);
                frameBits.putInt(scratchBits.readBits(14), 14);
            }
        }
        frameBits.reset(frame);
        return frameBits;
    }

    private static boolean isLittleEndianFrameHeader(byte[] frameHeader) {
        return frameHeader[0] == -2 || frameHeader[0] == -1 || frameHeader[0] == 37 || frameHeader[0] == -14 || frameHeader[0] == -24;
    }

    private DtsUtil() {
    }

    public static final class DtsHeader {
        public final String mimeType;
        public final int sampleRate;
        public final int channelCount;
        public final int frameSize;
        public final long frameDurationUs;
        public final int bitrate;

        private DtsHeader(String mimeType, int channelCount, int sampleRate, int frameSize, long frameDurationUs, int bitrate) {
            this.mimeType = mimeType;
            this.channelCount = channelCount;
            this.sampleRate = sampleRate;
            this.frameSize = frameSize;
            this.frameDurationUs = frameDurationUs;
            this.bitrate = bitrate;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface FrameType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface DtsAudioMimeType {
    }
}

