/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.metadata.id3.Id3Frame;
import java.util.Arrays;

@UnstableApi
public final class ApicFrame
extends Id3Frame {
    public static final String ID = "APIC";
    public final String mimeType;
    @Nullable
    public final String description;
    public final int pictureType;
    public final byte[] pictureData;
    public static final Parcelable.Creator<ApicFrame> CREATOR = new Parcelable.Creator<ApicFrame>(){

        public ApicFrame createFromParcel(Parcel in) {
            return new ApicFrame(in);
        }

        public ApicFrame[] newArray(int size) {
            return new ApicFrame[size];
        }
    };

    public ApicFrame(String mimeType, @Nullable String description, int pictureType, byte[] pictureData) {
        super(ID);
        this.mimeType = mimeType;
        this.description = description;
        this.pictureType = pictureType;
        this.pictureData = pictureData;
    }

    ApicFrame(Parcel in) {
        super(ID);
        this.mimeType = (String)Util.castNonNull((Object)in.readString());
        this.description = in.readString();
        this.pictureType = in.readInt();
        this.pictureData = (byte[])Util.castNonNull((Object)in.createByteArray());
    }

    public void populateMediaMetadata(MediaMetadata.Builder builder) {
        builder.maybeSetArtworkData(this.pictureData, this.pictureType);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApicFrame other = (ApicFrame)obj;
        return this.pictureType == other.pictureType && Util.areEqual((Object)this.mimeType, (Object)other.mimeType) && Util.areEqual((Object)this.description, (Object)other.description) && Arrays.equals(this.pictureData, other.pictureData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.pictureType;
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.pictureData);
        return result;
    }

    @Override
    public String toString() {
        return this.id + ": mimeType=" + this.mimeType + ", description=" + this.description;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mimeType);
        dest.writeString(this.description);
        dest.writeInt(this.pictureType);
        dest.writeByteArray(this.pictureData);
    }
}

