/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp4;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.container.MdtaMetadataEntry;
import androidx.media3.extractor.GaplessInfoHolder;
import androidx.media3.extractor.metadata.id3.ApicFrame;
import androidx.media3.extractor.metadata.id3.CommentFrame;
import androidx.media3.extractor.metadata.id3.Id3Frame;
import androidx.media3.extractor.metadata.id3.Id3Util;
import androidx.media3.extractor.metadata.id3.InternalFrame;
import androidx.media3.extractor.metadata.id3.TextInformationFrame;
import androidx.media3.extractor.mp4.Atom;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class MetadataUtil {
    private static final String TAG = "MetadataUtil";
    private static final int SHORT_TYPE_NAME_1 = 7233901;
    private static final int SHORT_TYPE_NAME_2 = 7631467;
    private static final int SHORT_TYPE_COMMENT = 6516084;
    private static final int SHORT_TYPE_YEAR = 6578553;
    private static final int SHORT_TYPE_ARTIST = 4280916;
    private static final int SHORT_TYPE_ENCODER = 7630703;
    private static final int SHORT_TYPE_ALBUM = 6384738;
    private static final int SHORT_TYPE_COMPOSER_1 = 6516589;
    private static final int SHORT_TYPE_COMPOSER_2 = 0x777274;
    private static final int SHORT_TYPE_LYRICS = 7108978;
    private static final int SHORT_TYPE_GENRE = 6776174;
    private static final int TYPE_COVER_ART = 1668249202;
    private static final int TYPE_GENRE = 1735291493;
    private static final int TYPE_GROUPING = 6779504;
    private static final int TYPE_DISK_NUMBER = 1684632427;
    private static final int TYPE_TRACK_NUMBER = 1953655662;
    private static final int TYPE_TEMPO = 1953329263;
    private static final int TYPE_COMPILATION = 1668311404;
    private static final int TYPE_ALBUM_ARTIST = 1631670868;
    private static final int TYPE_SORT_TRACK_NAME = 1936682605;
    private static final int TYPE_SORT_ALBUM = 1936679276;
    private static final int TYPE_SORT_ARTIST = 1936679282;
    private static final int TYPE_SORT_ALBUM_ARTIST = 1936679265;
    private static final int TYPE_SORT_COMPOSER = 1936679791;
    private static final int TYPE_RATING = 1920233063;
    private static final int TYPE_GAPLESS_ALBUM = 1885823344;
    private static final int TYPE_TV_SORT_SHOW = 1936683886;
    private static final int TYPE_TV_SHOW = 1953919848;
    private static final int TYPE_INTERNAL = 0x2D2D2D2D;
    private static final int PICTURE_TYPE_FRONT_COVER = 3;
    private static final int TYPE_TOP_BYTE_COPYRIGHT = 169;
    private static final int TYPE_TOP_BYTE_REPLACEMENT = 253;

    private MetadataUtil() {
    }

    public static void setFormatMetadata(int trackType, @Nullable Metadata mdtaMetadata, Format.Builder formatBuilder, Metadata ... additionalMetadata) {
        Metadata formatMetadata = new Metadata(new Metadata.Entry[0]);
        if (mdtaMetadata != null) {
            for (int i = 0; i < mdtaMetadata.length(); ++i) {
                Metadata.Entry entry = mdtaMetadata.get(i);
                if (!(entry instanceof MdtaMetadataEntry)) continue;
                MdtaMetadataEntry mdtaMetadataEntry = (MdtaMetadataEntry)entry;
                if (mdtaMetadataEntry.key.equals("com.android.capture.fps")) {
                    if (trackType != 2) continue;
                    formatMetadata = formatMetadata.copyWithAppendedEntries(new Metadata.Entry[]{mdtaMetadataEntry});
                    continue;
                }
                formatMetadata = formatMetadata.copyWithAppendedEntries(new Metadata.Entry[]{mdtaMetadataEntry});
            }
        }
        for (Metadata metadata : additionalMetadata) {
            formatMetadata = formatMetadata.copyWithAppendedEntriesFrom(metadata);
        }
        if (formatMetadata.length() > 0) {
            formatBuilder.setMetadata(formatMetadata);
        }
    }

    public static void setFormatGaplessInfo(int trackType, GaplessInfoHolder gaplessInfoHolder, Format.Builder formatBuilder) {
        if (trackType == 1 && gaplessInfoHolder.hasGaplessInfo()) {
            formatBuilder.setEncoderDelay(gaplessInfoHolder.encoderDelay).setEncoderPadding(gaplessInfoHolder.encoderPadding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Metadata.Entry parseIlstElement(ParsableByteArray ilst) {
        int position = ilst.getPosition();
        int endPosition = position + ilst.readInt();
        int type = ilst.readInt();
        int typeTopByte = type >> 24 & 0xFF;
        try {
            if (typeTopByte == 169 || typeTopByte == 253) {
                int shortType = type & 0xFFFFFF;
                if (shortType == 6516084) {
                    CommentFrame commentFrame = MetadataUtil.parseCommentAttribute(type, ilst);
                    return commentFrame;
                }
                if (shortType == 7233901 || shortType == 7631467) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TIT2", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6516589 || shortType == 0x777274) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TCOM", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6578553) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TDRC", ilst);
                    return textInformationFrame;
                }
                if (shortType == 4280916) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TPE1", ilst);
                    return textInformationFrame;
                }
                if (shortType == 7630703) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSSE", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6384738) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TALB", ilst);
                    return textInformationFrame;
                }
                if (shortType == 7108978) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "USLT", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6776174) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TCON", ilst);
                    return textInformationFrame;
                }
                if (shortType == 6779504) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TIT1", ilst);
                    return textInformationFrame;
                }
            } else {
                if (type == 1735291493) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseStandardGenreAttribute(ilst);
                    return textInformationFrame;
                }
                if (type == 1684632427) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseIndexAndCountAttribute(type, "TPOS", ilst);
                    return textInformationFrame;
                }
                if (type == 1953655662) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseIndexAndCountAttribute(type, "TRCK", ilst);
                    return textInformationFrame;
                }
                if (type == 1953329263) {
                    Id3Frame id3Frame = MetadataUtil.parseIntegerAttribute(type, "TBPM", ilst, true, false);
                    return id3Frame;
                }
                if (type == 1668311404) {
                    Id3Frame id3Frame = MetadataUtil.parseIntegerAttribute(type, "TCMP", ilst, true, true);
                    return id3Frame;
                }
                if (type == 1668249202) {
                    ApicFrame apicFrame = MetadataUtil.parseCoverArt(ilst);
                    return apicFrame;
                }
                if (type == 1631670868) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TPE2", ilst);
                    return textInformationFrame;
                }
                if (type == 1936682605) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOT", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679276) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOA", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679282) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOP", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679265) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSO2", ilst);
                    return textInformationFrame;
                }
                if (type == 1936679791) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TSOC", ilst);
                    return textInformationFrame;
                }
                if (type == 1920233063) {
                    Id3Frame id3Frame = MetadataUtil.parseIntegerAttribute(type, "ITUNESADVISORY", ilst, false, false);
                    return id3Frame;
                }
                if (type == 1885823344) {
                    Id3Frame id3Frame = MetadataUtil.parseIntegerAttribute(type, "ITUNESGAPLESS", ilst, false, true);
                    return id3Frame;
                }
                if (type == 1936683886) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TVSHOWSORT", ilst);
                    return textInformationFrame;
                }
                if (type == 1953919848) {
                    TextInformationFrame textInformationFrame = MetadataUtil.parseTextAttribute(type, "TVSHOW", ilst);
                    return textInformationFrame;
                }
                if (type == 0x2D2D2D2D) {
                    Id3Frame id3Frame = MetadataUtil.parseInternalAttribute(ilst, endPosition);
                    return id3Frame;
                }
            }
            Log.d((String)TAG, (String)("Skipped unknown metadata entry: " + Atom.getAtomTypeString(type)));
            Metadata.Entry entry = null;
            return entry;
        }
        finally {
            ilst.setPosition(endPosition);
        }
    }

    @Nullable
    public static MdtaMetadataEntry parseMdtaMetadataEntryFromIlst(ParsableByteArray ilst, int endPosition, String key) {
        int atomPosition;
        while ((atomPosition = ilst.getPosition()) < endPosition) {
            int atomSize = ilst.readInt();
            int atomType = ilst.readInt();
            if (atomType == 1684108385) {
                int typeIndicator = ilst.readInt();
                int localeIndicator = ilst.readInt();
                int dataSize = atomSize - 16;
                byte[] value = new byte[dataSize];
                ilst.readBytes(value, 0, dataSize);
                return new MdtaMetadataEntry(key, value, localeIndicator, typeIndicator);
            }
            ilst.setPosition(atomPosition + atomSize);
        }
        return null;
    }

    @Nullable
    private static TextInformationFrame parseTextAttribute(int type, String id, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            data.skipBytes(8);
            String value = data.readNullTerminatedString(atomSize - 16);
            return new TextInformationFrame(id, null, (List<String>)ImmutableList.of((Object)value));
        }
        Log.w((String)TAG, (String)("Failed to parse text attribute: " + Atom.getAtomTypeString(type)));
        return null;
    }

    @Nullable
    private static CommentFrame parseCommentAttribute(int type, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            data.skipBytes(8);
            String value = data.readNullTerminatedString(atomSize - 16);
            return new CommentFrame("und", value, value);
        }
        Log.w((String)TAG, (String)("Failed to parse comment attribute: " + Atom.getAtomTypeString(type)));
        return null;
    }

    @Nullable
    private static Id3Frame parseIntegerAttribute(int type, String id, ParsableByteArray data, boolean isTextInformationFrame, boolean isBoolean) {
        int value = MetadataUtil.parseIntegerAttribute(data);
        if (isBoolean) {
            value = Math.min(1, value);
        }
        if (value >= 0) {
            return isTextInformationFrame ? new TextInformationFrame(id, null, (List<String>)ImmutableList.of((Object)Integer.toString(value))) : new CommentFrame("und", id, Integer.toString(value));
        }
        Log.w((String)TAG, (String)("Failed to parse uint8 attribute: " + Atom.getAtomTypeString(type)));
        return null;
    }

    private static int parseIntegerAttribute(ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            data.skipBytes(8);
            switch (atomSize - 16) {
                case 1: {
                    return data.readUnsignedByte();
                }
                case 2: {
                    return data.readUnsignedShort();
                }
                case 3: {
                    return data.readUnsignedInt24();
                }
                case 4: {
                    if ((data.peekUnsignedByte() & 0x80) != 0) break;
                    return data.readUnsignedIntToInt();
                }
            }
        }
        Log.w((String)TAG, (String)"Failed to parse data atom to int");
        return -1;
    }

    @Nullable
    private static TextInformationFrame parseIndexAndCountAttribute(int type, String attributeName, ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385 && atomSize >= 22) {
            data.skipBytes(10);
            int index = data.readUnsignedShort();
            if (index > 0) {
                String value = "" + index;
                int count = data.readUnsignedShort();
                if (count > 0) {
                    value = value + "/" + count;
                }
                return new TextInformationFrame(attributeName, null, (List<String>)ImmutableList.of((Object)value));
            }
        }
        Log.w((String)TAG, (String)("Failed to parse index/count attribute: " + Atom.getAtomTypeString(type)));
        return null;
    }

    @Nullable
    private static TextInformationFrame parseStandardGenreAttribute(ParsableByteArray data) {
        int genreCode = MetadataUtil.parseIntegerAttribute(data);
        String genreString = Id3Util.resolveV1Genre(genreCode - 1);
        if (genreString != null) {
            return new TextInformationFrame("TCON", null, (List<String>)ImmutableList.of((Object)genreString));
        }
        Log.w((String)TAG, (String)"Failed to parse standard genre code");
        return null;
    }

    @Nullable
    private static ApicFrame parseCoverArt(ParsableByteArray data) {
        int atomSize = data.readInt();
        int atomType = data.readInt();
        if (atomType == 1684108385) {
            String mimeType;
            int fullVersionInt = data.readInt();
            int flags = Atom.parseFullAtomFlags(fullVersionInt);
            String string = flags == 13 ? "image/jpeg" : (mimeType = flags == 14 ? "image/png" : null);
            if (mimeType == null) {
                Log.w((String)TAG, (String)("Unrecognized cover art flags: " + flags));
                return null;
            }
            data.skipBytes(4);
            byte[] pictureData = new byte[atomSize - 16];
            data.readBytes(pictureData, 0, pictureData.length);
            return new ApicFrame(mimeType, null, 3, pictureData);
        }
        Log.w((String)TAG, (String)"Failed to parse cover art attribute");
        return null;
    }

    @Nullable
    private static Id3Frame parseInternalAttribute(ParsableByteArray data, int endPosition) {
        String domain = null;
        String name = null;
        int dataAtomPosition = -1;
        int dataAtomSize = -1;
        while (data.getPosition() < endPosition) {
            int atomPosition = data.getPosition();
            int atomSize = data.readInt();
            int atomType = data.readInt();
            data.skipBytes(4);
            if (atomType == 1835360622) {
                domain = data.readNullTerminatedString(atomSize - 12);
                continue;
            }
            if (atomType == 1851878757) {
                name = data.readNullTerminatedString(atomSize - 12);
                continue;
            }
            if (atomType == 1684108385) {
                dataAtomPosition = atomPosition;
                dataAtomSize = atomSize;
            }
            data.skipBytes(atomSize - 12);
        }
        if (domain == null || name == null || dataAtomPosition == -1) {
            return null;
        }
        data.setPosition(dataAtomPosition);
        data.skipBytes(16);
        String value = data.readNullTerminatedString(dataAtomSize - 16);
        return new InternalFrame(domain, name, value);
    }
}

