/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Ac4Util;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.ts.Ac4Reader;
import androidx.media3.extractor.ts.TsPayloadReader;
import java.io.IOException;

@UnstableApi
public final class Ac4Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new Ac4Extractor()};
    private static final int MAX_SNIFF_BYTES = 8192;
    private static final int READ_BUFFER_SIZE = 16384;
    private static final int FRAME_HEADER_SIZE = 7;
    private final Ac4Reader reader = new Ac4Reader();
    private final ParsableByteArray sampleData = new ParsableByteArray(16384);
    private boolean startedPacket;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(10);
        int startPosition = 0;
        while (true) {
            input.peekFully(scratch.getData(), 0, 10);
            scratch.setPosition(0);
            if (scratch.readUnsignedInt24() != 0x494433) break;
            scratch.skipBytes(3);
            int length = scratch.readSynchSafeInt();
            startPosition += 10 + length;
            input.advancePeekPosition(length);
        }
        input.resetPeekPosition();
        input.advancePeekPosition(startPosition);
        int headerPosition = startPosition;
        int validFramesCount = 0;
        while (true) {
            input.peekFully(scratch.getData(), 0, 7);
            scratch.setPosition(0);
            int syncBytes = scratch.readUnsignedShort();
            if (syncBytes != 44096 && syncBytes != 44097) {
                validFramesCount = 0;
                input.resetPeekPosition();
                if (++headerPosition - startPosition >= 8192) {
                    return false;
                }
                input.advancePeekPosition(headerPosition);
                continue;
            }
            if (++validFramesCount >= 4) {
                return true;
            }
            int frameSize = Ac4Util.parseAc4SyncframeSize(scratch.getData(), syncBytes);
            if (frameSize == -1) {
                return false;
            }
            input.advancePeekPosition(frameSize - 7);
        }
    }

    @Override
    public void init(ExtractorOutput output) {
        this.reader.createTracks(output, new TsPayloadReader.TrackIdGenerator(0, 1));
        output.endTracks();
        output.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
    }

    @Override
    public void seek(long position, long timeUs) {
        this.startedPacket = false;
        this.reader.seek();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        int bytesRead = input.read(this.sampleData.getData(), 0, 16384);
        if (bytesRead == -1) {
            return -1;
        }
        this.sampleData.setPosition(0);
        this.sampleData.setLimit(bytesRead);
        if (!this.startedPacket) {
            this.reader.packetStarted(0L, 4);
            this.startedPacket = true;
        }
        this.reader.consume(this.sampleData);
        return 0;
    }
}

