/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableBitArray;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

final class MpeghUtil {
    private static final int MHAS_SYNC_WORD = 12583333;

    public static boolean isSyncWord(int word) {
        return (word & 0xFFFFFF) == 12583333;
    }

    public static boolean parseMhasPacketHeader(ParsableBitArray data, MhasPacketHeader header) throws ParserException {
        int dataStartPos = data.getBytePosition();
        header.packetType = MpeghUtil.readEscapedIntValue(data, 3, 8, 8);
        if (header.packetType == -1) {
            return false;
        }
        header.packetLabel = MpeghUtil.readEscapedLongValue(data, 2, 8, 32);
        if (header.packetLabel == -1L) {
            return false;
        }
        if (header.packetLabel > 16L) {
            throw ParserException.createForUnsupportedContainerFeature((String)("Contains sub-stream with an invalid packet label " + header.packetLabel));
        }
        if (header.packetLabel == 0L) {
            switch (header.packetType) {
                case 1: {
                    throw ParserException.createForMalformedContainer((String)"Mpegh3daConfig packet with invalid packet label 0", null);
                }
                case 17: {
                    throw ParserException.createForMalformedContainer((String)"AudioTruncation packet with invalid packet label 0", null);
                }
                case 2: {
                    throw ParserException.createForMalformedContainer((String)"Mpegh3daFrame packet with invalid packet label 0", null);
                }
            }
        }
        header.packetLength = MpeghUtil.readEscapedIntValue(data, 11, 24, 24);
        return header.packetLength != -1;
    }

    private static int getOutputFrameLength(int index) throws ParserException {
        switch (index) {
            case 0: {
                return 768;
            }
            case 1: {
                return 1024;
            }
            case 2: 
            case 3: {
                return 2048;
            }
            case 4: {
                return 4096;
            }
        }
        throw ParserException.createForUnsupportedContainerFeature((String)("Unsupported coreSbrFrameLengthIndex " + index));
    }

    private static int getSbrRatioIndex(int index) throws ParserException {
        switch (index) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
        }
        throw ParserException.createForUnsupportedContainerFeature((String)("Unsupported coreSbrFrameLengthIndex " + index));
    }

    private static double getResamplingRatio(int usacSamplingFrequency) throws ParserException {
        switch (usacSamplingFrequency) {
            case 44100: 
            case 48000: 
            case 88200: 
            case 96000: {
                return 1.0;
            }
            case 29400: 
            case 32000: 
            case 58800: 
            case 64000: {
                return 1.5;
            }
            case 22050: 
            case 24000: {
                return 2.0;
            }
            case 14700: 
            case 16000: {
                return 3.0;
            }
        }
        throw ParserException.createForUnsupportedContainerFeature((String)("Unsupported sampling rate " + usacSamplingFrequency));
    }

    public static Mpegh3daConfig parseMpegh3daConfig(ParsableBitArray data) throws ParserException {
        byte[] compatibleProfileLevelSet = null;
        int profileLevelIndication = data.readBits(8);
        int samplingFrequencyIndex = data.readBits(5);
        int usacSamplingFrequency = samplingFrequencyIndex == 31 ? data.readBits(24) : MpeghUtil.getSamplingFrequency(samplingFrequencyIndex);
        int coreSbrFrameLengthIndex = data.readBits(3);
        int outputFrameLength = MpeghUtil.getOutputFrameLength(coreSbrFrameLengthIndex);
        int sbrRatioIndex = MpeghUtil.getSbrRatioIndex(coreSbrFrameLengthIndex);
        data.skipBits(2);
        MpeghUtil.skipSpeakerConfig3d(data);
        int numSignals = MpeghUtil.parseSignals3d(data);
        MpeghUtil.skipMpegh3daDecoderConfig(data, numSignals, sbrRatioIndex);
        if (data.readBit()) {
            int numConfigExtensions = MpeghUtil.readEscapedIntValue(data, 2, 4, 8) + 1;
            for (int confExtIdx = 0; confExtIdx < numConfigExtensions; ++confExtIdx) {
                int usacConfigExtType = MpeghUtil.readEscapedIntValue(data, 4, 8, 16);
                int usacConfigExtLength = MpeghUtil.readEscapedIntValue(data, 4, 8, 16);
                if (usacConfigExtType == 7) {
                    int numCompatibleSets = data.readBits(4) + 1;
                    data.skipBits(4);
                    compatibleProfileLevelSet = new byte[numCompatibleSets];
                    for (int idx = 0; idx < numCompatibleSets; ++idx) {
                        compatibleProfileLevelSet[idx] = (byte)data.readBits(8);
                    }
                    continue;
                }
                data.skipBits(8 * usacConfigExtLength);
            }
        }
        double resamplingRatio = MpeghUtil.getResamplingRatio(usacSamplingFrequency);
        int samplingFrequency = (int)((double)usacSamplingFrequency * resamplingRatio);
        int standardFrameLength = (int)((double)outputFrameLength * resamplingRatio);
        return new Mpegh3daConfig(profileLevelIndication, samplingFrequency, standardFrameLength, compatibleProfileLevelSet);
    }

    private static int getSamplingFrequency(int index) throws ParserException {
        switch (index) {
            case 0: {
                return 96000;
            }
            case 1: {
                return 88200;
            }
            case 2: {
                return 64000;
            }
            case 3: {
                return 48000;
            }
            case 4: {
                return 44100;
            }
            case 5: {
                return 32000;
            }
            case 6: {
                return 24000;
            }
            case 7: {
                return 22050;
            }
            case 8: {
                return 16000;
            }
            case 9: {
                return 12000;
            }
            case 10: {
                return 11025;
            }
            case 11: {
                return 8000;
            }
            case 12: {
                return 7350;
            }
            case 15: {
                return 57600;
            }
            case 16: {
                return 51200;
            }
            case 17: {
                return 40000;
            }
            case 18: {
                return 38400;
            }
            case 19: {
                return 34150;
            }
            case 20: {
                return 28800;
            }
            case 21: {
                return 25600;
            }
            case 22: {
                return 20000;
            }
            case 23: {
                return 19200;
            }
            case 24: {
                return 17075;
            }
            case 25: {
                return 14400;
            }
            case 26: {
                return 12800;
            }
            case 27: {
                return 9600;
            }
        }
        throw ParserException.createForUnsupportedContainerFeature((String)("Unsupported sampling rate index " + index));
    }

    public static int parseAudioTruncationInfo(ParsableBitArray data) {
        if (data.readBit()) {
            data.skipBits(2);
            return data.readBits(13);
        }
        return 0;
    }

    private static void skipSpeakerConfig3d(ParsableBitArray data) {
        int speakerLayoutType = data.readBits(2);
        if (speakerLayoutType == 0) {
            data.skipBits(6);
            return;
        }
        int numberOfSpeakers = MpeghUtil.readEscapedIntValue(data, 5, 8, 16) + 1;
        if (speakerLayoutType == 1) {
            data.skipBits(7 * numberOfSpeakers);
        } else if (speakerLayoutType == 2) {
            MpeghUtil.skipMpegh3daFlexibleSpeakerConfig(data, numberOfSpeakers);
        }
    }

    private static void skipMpegh3daFlexibleSpeakerConfig(ParsableBitArray data, int numberOfSpeakers) {
        boolean angularPrecision = data.readBit();
        int angularPrecisionDegrees = angularPrecision ? 1 : 5;
        int elevationAngleBits = angularPrecision ? 7 : 5;
        int azimuthAngleBits = angularPrecision ? 8 : 6;
        for (int i = 0; i < numberOfSpeakers; ++i) {
            int azimuthAngle = 0;
            if (data.readBit()) {
                data.skipBits(7);
            } else {
                int azimuthAngleIdx;
                int elevationAngleIdx;
                int elevationAngle;
                int elevationClass = data.readBits(2);
                if (elevationClass == 3 && (elevationAngle = (elevationAngleIdx = data.readBits(elevationAngleBits)) * angularPrecisionDegrees) != 0) {
                    data.skipBit();
                }
                if ((azimuthAngle = (azimuthAngleIdx = data.readBits(azimuthAngleBits)) * angularPrecisionDegrees) != 0 && azimuthAngle != 180) {
                    data.skipBit();
                }
                data.skipBit();
            }
            if (azimuthAngle == 0 || azimuthAngle == 180 || !data.readBit()) continue;
            ++i;
        }
    }

    private static int parseSignals3d(ParsableBitArray data) {
        int numberOfSignals = 0;
        int numberOfSignalGroupsInBitstream = data.readBits(5);
        for (int grp = 0; grp < numberOfSignalGroupsInBitstream + 1; ++grp) {
            int signalGroupType = data.readBits(3);
            int bsNumberOfSignals = MpeghUtil.readEscapedIntValue(data, 5, 8, 16);
            numberOfSignals += bsNumberOfSignals + 1;
            if (signalGroupType != 0 && signalGroupType != 2 || !data.readBit()) continue;
            MpeghUtil.skipSpeakerConfig3d(data);
        }
        return numberOfSignals;
    }

    private static void skipMpegh3daDecoderConfig(ParsableBitArray data, int numSignals, int sbrRatioIndex) {
        int numElements = MpeghUtil.readEscapedIntValue(data, 4, 8, 16) + 1;
        data.skipBit();
        block5: for (int elemIdx = 0; elemIdx < numElements; ++elemIdx) {
            int usacElementType = data.readBits(2);
            switch (usacElementType) {
                case 0: {
                    MpeghUtil.parseMpegh3daCoreConfig(data);
                    if (sbrRatioIndex <= 0) continue block5;
                    MpeghUtil.skipSbrConfig(data);
                    continue block5;
                }
                case 1: {
                    boolean enhancedNoiseFilling = MpeghUtil.parseMpegh3daCoreConfig(data);
                    if (enhancedNoiseFilling) {
                        data.skipBit();
                    }
                    int stereoConfigIndex = 0;
                    if (sbrRatioIndex > 0) {
                        MpeghUtil.skipSbrConfig(data);
                        stereoConfigIndex = data.readBits(2);
                    }
                    if (stereoConfigIndex > 0) {
                        data.skipBits(6);
                        int bsTempShapeConfig = data.readBits(2);
                        data.skipBits(4);
                        if (data.readBit()) {
                            data.skipBits(5);
                        }
                        if (stereoConfigIndex == 2 || stereoConfigIndex == 3) {
                            data.skipBits(6);
                        }
                        if (bsTempShapeConfig == 2) {
                            data.skipBit();
                        }
                    }
                    int nBits = (int)Math.floor(Math.log(numSignals - 1) / Math.log(2.0)) + 1;
                    int qceIndex = data.readBits(2);
                    if (qceIndex > 0 && data.readBit()) {
                        data.skipBits(nBits);
                    }
                    if (data.readBit()) {
                        data.skipBits(nBits);
                    }
                    if (sbrRatioIndex != 0 || qceIndex != 0) continue block5;
                    data.skipBit();
                    continue block5;
                }
                case 3: {
                    MpeghUtil.readEscapedIntValue(data, 4, 8, 16);
                    int usacExtElementConfigLength = MpeghUtil.readEscapedIntValue(data, 4, 8, 16);
                    if (data.readBit()) {
                        MpeghUtil.readEscapedIntValue(data, 8, 16, 0);
                    }
                    data.skipBit();
                    if (usacExtElementConfigLength <= 0) continue block5;
                    data.skipBits(8 * usacExtElementConfigLength);
                    continue block5;
                }
            }
        }
    }

    private static boolean parseMpegh3daCoreConfig(ParsableBitArray data) {
        data.skipBits(3);
        boolean enhancedNoiseFilling = data.readBit();
        if (enhancedNoiseFilling) {
            data.skipBits(13);
        }
        return enhancedNoiseFilling;
    }

    private static void skipSbrConfig(ParsableBitArray data) {
        data.skipBits(3);
        data.skipBits(8);
        boolean dfltHeaderExtra1 = data.readBit();
        boolean dfltHeaderExtra2 = data.readBit();
        if (dfltHeaderExtra1) {
            data.skipBits(5);
        }
        if (dfltHeaderExtra2) {
            data.skipBits(6);
        }
    }

    private static int readEscapedIntValue(ParsableBitArray data, int bits1, int bits2, int bits3) {
        int maxBitCount = Math.max(Math.max(bits1, bits2), bits3);
        Assertions.checkArgument((maxBitCount <= 31 ? 1 : 0) != 0);
        int unused = IntMath.checkedAdd((int)IntMath.checkedAdd((int)((1 << bits1) - 1), (int)((1 << bits2) - 1)), (int)(1 << bits3));
        if (data.bitsLeft() < bits1) {
            return -1;
        }
        int value = data.readBits(bits1);
        if (value == (1 << bits1) - 1) {
            if (data.bitsLeft() < bits2) {
                return -1;
            }
            int valueAdd = data.readBits(bits2);
            value += valueAdd;
            if (valueAdd == (1 << bits2) - 1) {
                if (data.bitsLeft() < bits3) {
                    return -1;
                }
                valueAdd = data.readBits(bits3);
                value += valueAdd;
            }
        }
        return value;
    }

    private static long readEscapedLongValue(ParsableBitArray data, int bits1, int bits2, int bits3) {
        int maxBitCount = Math.max(Math.max(bits1, bits2), bits3);
        Assertions.checkArgument((maxBitCount <= 63 ? 1 : 0) != 0);
        long unused = LongMath.checkedAdd((long)LongMath.checkedAdd((long)((1L << bits1) - 1L), (long)((1L << bits2) - 1L)), (long)(1L << bits3));
        if (data.bitsLeft() < bits1) {
            return -1L;
        }
        long value = data.readBitsToLong(bits1);
        if (value == (1L << bits1) - 1L) {
            if (data.bitsLeft() < bits2) {
                return -1L;
            }
            long valueAdd = data.readBitsToLong(bits2);
            value += valueAdd;
            if (valueAdd == (1L << bits2) - 1L) {
                if (data.bitsLeft() < bits3) {
                    return -1L;
                }
                valueAdd = data.readBitsToLong(bits3);
                value += valueAdd;
            }
        }
        return value;
    }

    private MpeghUtil() {
    }

    public static class MhasPacketHeader {
        public static final int PACTYP_FILLDATA = 0;
        public static final int PACTYP_MPEGH3DACFG = 1;
        public static final int PACTYP_MPEGH3DAFRAME = 2;
        public static final int PACTYP_AUDIOSCENEINFO = 3;
        public static final int PACTYP_SYNC = 6;
        public static final int PACTYP_SYNCGAP = 7;
        public static final int PACTYP_MARKER = 8;
        public static final int PACTYP_CRC16 = 9;
        public static final int PACTYP_CRC32 = 10;
        public static final int PACTYP_DESCRIPTOR = 11;
        public static final int PACTYP_USERINTERACTION = 12;
        public static final int PACTYP_LOUDNESS_DRC = 13;
        public static final int PACTYP_BUFFERINFO = 14;
        public static final int PACTYP_GLOBAL_CRC16 = 15;
        public static final int PACTYP_GLOBAL_CRC32 = 16;
        public static final int PACTYP_AUDIOTRUNCATION = 17;
        public static final int PACTYP_GENDATA = 18;
        public static final int PACTYPE_EARCON = 19;
        public static final int PACTYPE_PCMCONFIG = 20;
        public static final int PACTYPE_PCMDATA = 21;
        public static final int PACTYP_LOUDNESS = 22;
        public int packetType;
        public long packetLabel;
        public int packetLength;

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface Type {
        }
    }

    public static class Mpegh3daConfig {
        public final int profileLevelIndication;
        public final int samplingFrequency;
        public final int standardFrameLength;
        @Nullable
        public final byte[] compatibleProfileLevelSet;

        private Mpegh3daConfig(int profileLevelIndication, int samplingFrequency, int standardFrameLength, @Nullable byte[] compatibleProfileLevelSet) {
            this.profileLevelIndication = profileLevelIndication;
            this.samplingFrequency = samplingFrequency;
            this.standardFrameLength = standardFrameLength;
            this.compatibleProfileLevelSet = compatibleProfileLevelSet;
        }
    }
}

