/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.dynamicfeatures.fragment.ui;

import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.navigation.dynamicfeatures.fragment.R;
import androidx.navigation.dynamicfeatures.fragment.ui.AbstractProgressFragment;
import androidx.navigation.fragment.FragmentKt;
import com.google.android.play.core.splitinstall.model.SplitInstallErrorCode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0014J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\fH\u0014J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J\u001a\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/navigation/dynamicfeatures/fragment/ui/DefaultProgressFragment;", "Landroidx/navigation/dynamicfeatures/fragment/ui/AbstractProgressFragment;", "()V", "action", "Landroid/widget/Button;", "progressBar", "Landroid/widget/ProgressBar;", "title", "Landroid/widget/TextView;", "displayAction", "", "text", "", "onClick", "Lkotlin/Function0;", "displayErrorState", "onCancelled", "onDestroyView", "onFailed", "errorCode", "onProgress", "status", "bytesDownloaded", "", "bytesTotal", "onViewCreated", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "setActivityIcon", "activityIcon", "Landroid/widget/ImageView;", "Companion", "navigation-dynamic-features-fragment_release"})
public final class DefaultProgressFragment
extends AbstractProgressFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TextView title;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private Button action;
    private static final int PROGRESS_MAX = 100;
    @NotNull
    private static final String TAG = "DefaultProgressFragment";

    public DefaultProgressFragment() {
        super(R.layout.dynamic_feature_install_fragment);
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        View $this$onViewCreated_u24lambda_u2d0 = view;
        boolean bl = false;
        this.title = (TextView)$this$onViewCreated_u24lambda_u2d0.findViewById(R.id.progress_title);
        this.progressBar = (ProgressBar)$this$onViewCreated_u24lambda_u2d0.findViewById(R.id.installation_progress);
        View view2 = $this$onViewCreated_u24lambda_u2d0.findViewById(R.id.progress_icon);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.progress_icon)");
        this.setActivityIcon((ImageView)view2);
        this.action = (Button)$this$onViewCreated_u24lambda_u2d0.findViewById(R.id.progress_action);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.title = null;
        this.progressBar = null;
        this.action = null;
    }

    private final void setActivityIcon(ImageView activityIcon) {
        Drawable drawable;
        PackageManager $this$setActivityIcon_u24lambda_u2d1 = this.requireContext().getPackageManager();
        boolean bl = false;
        try {
            drawable = $this$setActivityIcon_u24lambda_u2d1.getActivityIcon(new ComponentName(this.requireContext(), this.requireActivity().getClass()));
        }
        catch (PackageManager.NameNotFoundException e) {
            drawable = $this$setActivityIcon_u24lambda_u2d1.getDefaultActivityIcon();
        }
        Drawable drawable2 = drawable;
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"try {\n                ge\u2026ctivityIcon\n            }");
        Drawable icon = drawable2;
        activityIcon.setImageDrawable(icon);
    }

    @Override
    protected void onProgress(int status, long bytesDownloaded, long bytesTotal) {
        block2: {
            ProgressBar progressBar = this.progressBar;
            if (progressBar == null) break block2;
            ProgressBar $this$onProgress_u24lambda_u2d2 = progressBar;
            boolean bl = false;
            $this$onProgress_u24lambda_u2d2.setVisibility(0);
            if (bytesTotal == 0L) {
                $this$onProgress_u24lambda_u2d2.setIndeterminate(true);
            } else {
                $this$onProgress_u24lambda_u2d2.setProgress((int)((long)100 * bytesDownloaded / bytesTotal));
                $this$onProgress_u24lambda_u2d2.setIndeterminate(false);
            }
        }
    }

    @Override
    protected void onCancelled() {
        this.displayErrorState(R.string.installation_cancelled);
        this.displayAction(R.string.retry, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultProgressFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.navigate$navigation_dynamic_features_fragment_release();
            }
        }));
    }

    @Override
    protected void onFailed(@SplitInstallErrorCode int errorCode) {
        Log.w((String)TAG, (String)("Installation failed with error " + errorCode));
        this.displayErrorState(R.string.installation_failed);
        this.displayAction(R.string.ok, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultProgressFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FragmentKt.findNavController((Fragment)this.this$0).popBackStack();
            }
        }));
    }

    private final void displayErrorState(@StringRes int text) {
        TextView textView = this.title;
        if (textView != null) {
            textView.setText(text);
        }
        ProgressBar progressBar = this.progressBar;
        if (progressBar != null) {
            progressBar.setVisibility(4);
        }
    }

    private final void displayAction(@StringRes int text, Function0<Unit> onClick) {
        block0: {
            Button button = this.action;
            if (button == null) break block0;
            Button $this$displayAction_u24lambda_u2d4 = button;
            boolean bl = false;
            $this$displayAction_u24lambda_u2d4.setText(text);
            $this$displayAction_u24lambda_u2d4.setOnClickListener(arg_0 -> DefaultProgressFragment.displayAction$lambda-4$lambda-3(onClick, arg_0));
            $this$displayAction_u24lambda_u2d4.setVisibility(0);
        }
    }

    private static final void displayAction$lambda-4$lambda-3(Function0 $onClick, View it) {
        Intrinsics.checkNotNullParameter((Object)$onClick, (String)"$onClick");
        $onClick.invoke();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/dynamicfeatures/fragment/ui/DefaultProgressFragment$Companion;", "", "()V", "PROGRESS_MAX", "", "TAG", "", "navigation-dynamic-features-fragment_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

