/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.NavHostFragment;
import androidx.navigation.fragment.R;
import org.jacoco.agent.rt.internal_1f1cc91.Offline;

@Navigator.Name(value="dialog")
public final class DialogFragmentNavigator
extends Navigator<Destination> {
    private static final String TAG = "DialogFragmentNavigator";
    private static final String KEY_DIALOG_COUNT = "androidx-nav-dialogfragment:navigator:count";
    private static final String DIALOG_TAG = "androidx-nav-fragment:navigator:dialog:";
    private final Context mContext;
    private final FragmentManager mFragmentManager;
    private int mDialogCount;
    private LifecycleEventObserver mObserver;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public DialogFragmentNavigator(@NonNull Context context, @NonNull FragmentManager fragmentManager) {
        void manager;
        void context2;
        boolean[] blArray = DialogFragmentNavigator.$jacocoInit();
        this.mDialogCount = 0;
        blArray[0] = true;
        this.mObserver = new LifecycleEventObserver(this){
            final /* synthetic */ DialogFragmentNavigator this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onStateChanged(@NonNull LifecycleOwner lifecycleOwner, @NonNull Lifecycle.Event event) {
                void event2;
                boolean[] blArray = 1.$jacocoInit();
                if (event2 != Lifecycle.Event.ON_STOP) {
                    blArray[1] = true;
                } else {
                    void dialogFragment;
                    void source;
                    DialogFragment dialogFragment2 = (DialogFragment)source;
                    blArray[2] = true;
                    if (dialogFragment.requireDialog().isShowing()) {
                        blArray[3] = true;
                    } else {
                        blArray[4] = true;
                        NavHostFragment.findNavController((Fragment)dialogFragment).popBackStack();
                        blArray[5] = true;
                    }
                }
                blArray[6] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-3829173810684620466L, (String)"androidx/navigation/fragment/DialogFragmentNavigator$1", (int)7);
                }
                return blArray;
            }
        };
        this.mContext = context2;
        this.mFragmentManager = manager;
        blArray[1] = true;
    }

    public boolean popBackStack() {
        boolean[] blArray = DialogFragmentNavigator.$jacocoInit();
        if (this.mDialogCount == 0) {
            blArray[2] = true;
            return false;
        }
        if (this.mFragmentManager.isStateSaved()) {
            blArray[3] = true;
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            blArray[4] = true;
            return false;
        }
        blArray[5] = true;
        Fragment existingFragment = this.mFragmentManager.findFragmentByTag(DIALOG_TAG + --this.mDialogCount);
        if (existingFragment == null) {
            blArray[6] = true;
        } else {
            blArray[7] = true;
            existingFragment.getLifecycle().removeObserver((LifecycleObserver)this.mObserver);
            blArray[8] = true;
            ((DialogFragment)existingFragment).dismiss();
            blArray[9] = true;
        }
        blArray[10] = true;
        return true;
    }

    @NonNull
    public Destination createDestination() {
        boolean[] blArray = DialogFragmentNavigator.$jacocoInit();
        blArray[11] = true;
        return new Destination(this);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NavDestination navigate(@NonNull Destination destination, @Nullable Bundle bundle, @Nullable NavOptions navOptions, @Nullable Navigator.Extras extras) {
        void args;
        void dialogFragment;
        void frag;
        String className;
        void destination2;
        boolean[] blArray = DialogFragmentNavigator.$jacocoInit();
        if (this.mFragmentManager.isStateSaved()) {
            blArray[12] = true;
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            blArray[13] = true;
            return null;
        }
        String string = destination2.getClassName();
        blArray[14] = true;
        if (className.charAt(0) != '.') {
            blArray[15] = true;
        } else {
            blArray[16] = true;
            className = this.mContext.getPackageName() + className;
            blArray[17] = true;
        }
        blArray[18] = true;
        blArray[19] = true;
        Fragment fragment = this.mFragmentManager.getFragmentFactory().instantiate(this.mContext.getClassLoader(), className);
        blArray[20] = true;
        if (!DialogFragment.class.isAssignableFrom(frag.getClass())) {
            blArray[21] = true;
            blArray[22] = true;
            throw new IllegalArgumentException("Dialog destination " + destination2.getClassName() + " is not an instance of DialogFragment");
        }
        DialogFragment dialogFragment2 = (DialogFragment)frag;
        blArray[23] = true;
        dialogFragment.setArguments((Bundle)args);
        blArray[24] = true;
        dialogFragment.getLifecycle().addObserver((LifecycleObserver)this.mObserver);
        blArray[25] = true;
        dialogFragment.show(this.mFragmentManager, DIALOG_TAG + this.mDialogCount++);
        blArray[26] = true;
        return destination2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Bundle onSaveState() {
        void b;
        boolean[] blArray = DialogFragmentNavigator.$jacocoInit();
        if (this.mDialogCount == 0) {
            blArray[27] = true;
            return null;
        }
        Bundle bundle = new Bundle();
        blArray[28] = true;
        b.putInt(KEY_DIALOG_COUNT, this.mDialogCount);
        blArray[29] = true;
        return b;
    }

    /*
     * WARNING - void declaration
     */
    public void onRestoreState(@Nullable Bundle bundle) {
        void savedState;
        boolean[] blArray = DialogFragmentNavigator.$jacocoInit();
        if (savedState == null) {
            blArray[30] = true;
        } else {
            blArray[31] = true;
            this.mDialogCount = savedState.getInt(KEY_DIALOG_COUNT, 0);
            boolean bl = false;
            blArray[32] = true;
            while (true) {
                void index;
                if (index >= this.mDialogCount) {
                    blArray[33] = true;
                    break;
                }
                blArray[34] = true;
                blArray[35] = true;
                DialogFragment fragment = (DialogFragment)this.mFragmentManager.findFragmentByTag(DIALOG_TAG + (int)index);
                if (fragment == null) {
                    blArray[37] = true;
                    throw new IllegalStateException("DialogFragment " + (int)index + " doesn't exist in the FragmentManager");
                }
                blArray[36] = true;
                fragment.getLifecycle().addObserver((LifecycleObserver)this.mObserver);
                ++index;
                blArray[38] = true;
            }
        }
        blArray[39] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-4706204255732397005L, (String)"androidx/navigation/fragment/DialogFragmentNavigator", (int)42);
        }
        return blArray;
    }

    @NavDestination.ClassType(value=DialogFragment.class)
    public static class Destination
    extends NavDestination
    implements FloatingWindow {
        private String mClassName;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public Destination(@NonNull NavigatorProvider navigatorProvider) {
            void navigatorProvider2;
            boolean[] blArray = Destination.$jacocoInit();
            this((Navigator<? extends Destination>)navigatorProvider2.getNavigator(DialogFragmentNavigator.class));
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        public Destination(@NonNull Navigator<? extends Destination> navigator) {
            void fragmentNavigator;
            boolean[] blArray = Destination.$jacocoInit();
            super((Navigator)fragmentNavigator);
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @CallSuper
        public void onInflate(@NonNull Context context, @NonNull AttributeSet attributeSet) {
            void a;
            void attrs;
            void context2;
            boolean[] blArray = Destination.$jacocoInit();
            super.onInflate((Context)context2, (AttributeSet)attrs);
            blArray[2] = true;
            TypedArray typedArray = context2.getResources().obtainAttributes((AttributeSet)attrs, R.styleable.DialogFragmentNavigator);
            blArray[3] = true;
            String className = a.getString(R.styleable.DialogFragmentNavigator_android_name);
            if (className == null) {
                blArray[4] = true;
            } else {
                blArray[5] = true;
                this.setClassName(className);
                blArray[6] = true;
            }
            a.recycle();
            blArray[7] = true;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public final Destination setClassName(@NonNull String string) {
            void className;
            boolean[] blArray = Destination.$jacocoInit();
            this.mClassName = className;
            blArray[8] = true;
            return this;
        }

        @NonNull
        public final String getClassName() {
            boolean[] blArray = Destination.$jacocoInit();
            if (this.mClassName == null) {
                blArray[9] = true;
                blArray[10] = true;
                throw new IllegalStateException("DialogFragment class was not set");
            }
            blArray[11] = true;
            return this.mClassName;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)1122517619574226897L, (String)"androidx/navigation/fragment/DialogFragmentNavigator$Destination", (int)12);
            }
            return blArray;
        }
    }
}

