/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.NavigationRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.TaskStackBuilder;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavAction;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDeepLinkBuilder;
import androidx.navigation.NavDestination;
import androidx.navigation.NavDirections;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jacoco.agent.rt.internal_1f1cc91.Offline;

public class NavController {
    private static final String TAG = "NavController";
    private static final String KEY_NAVIGATOR_STATE = "android-support-nav:controller:navigatorState";
    private static final String KEY_NAVIGATOR_STATE_NAMES = "android-support-nav:controller:navigatorState:names";
    private static final String KEY_BACK_STACK_UUIDS = "android-support-nav:controller:backStackUUIDs";
    private static final String KEY_BACK_STACK_IDS = "android-support-nav:controller:backStackIds";
    private static final String KEY_BACK_STACK_ARGS = "android-support-nav:controller:backStackArgs";
    static final String KEY_DEEP_LINK_IDS = "android-support-nav:controller:deepLinkIds";
    static final String KEY_DEEP_LINK_EXTRAS = "android-support-nav:controller:deepLinkExtras";
    static final String KEY_DEEP_LINK_HANDLED = "android-support-nav:controller:deepLinkHandled";
    @NonNull
    public static final String KEY_DEEP_LINK_INTENT = "android-support-nav:controller:deepLinkIntent";
    private final Context mContext;
    private Activity mActivity;
    private NavInflater mInflater;
    private NavGraph mGraph;
    private Bundle mNavigatorStateToRestore;
    private String[] mBackStackUUIDsToRestore;
    private int[] mBackStackIdsToRestore;
    private Parcelable[] mBackStackArgsToRestore;
    private boolean mDeepLinkHandled;
    private final Deque<NavBackStackEntry> mBackStack;
    private LifecycleOwner mLifecycleOwner;
    private NavControllerViewModel mViewModel;
    private final NavigatorProvider mNavigatorProvider;
    private final CopyOnWriteArrayList<OnDestinationChangedListener> mOnDestinationChangedListeners;
    private final OnBackPressedCallback mOnBackPressedCallback;
    private boolean mEnableOnBackPressedCallback;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public NavController(@NonNull Context context) {
        Context context2;
        boolean[] blArray = NavController.$jacocoInit();
        blArray[0] = true;
        this.mBackStack = new ArrayDeque<NavBackStackEntry>();
        blArray[1] = true;
        this.mNavigatorProvider = new NavigatorProvider();
        blArray[2] = true;
        this.mOnDestinationChangedListeners = new CopyOnWriteArrayList();
        blArray[3] = true;
        this.mOnBackPressedCallback = new OnBackPressedCallback(this, false){
            final /* synthetic */ NavController this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void x0;
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                super((boolean)x0);
                blArray[0] = true;
            }

            public void handleOnBackPressed() {
                boolean[] blArray = 1.$jacocoInit();
                this.this$0.popBackStack();
                blArray[1] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-4456151459671271456L, (String)"androidx/navigation/NavController$1", (int)2);
                }
                return blArray;
            }
        };
        this.mEnableOnBackPressedCallback = true;
        this.mContext = context2;
        blArray[4] = true;
        while (true) {
            if (!(context2 instanceof ContextWrapper)) {
                blArray[5] = true;
                break;
            }
            if (context2 instanceof Activity) {
                this.mActivity = (Activity)context2;
                blArray[6] = true;
                break;
            }
            context2 = ((ContextWrapper)context2).getBaseContext();
            blArray[7] = true;
        }
        this.mNavigatorProvider.addNavigator((Navigator)new NavGraphNavigator(this.mNavigatorProvider));
        blArray[8] = true;
        this.mNavigatorProvider.addNavigator((Navigator)new ActivityNavigator(this.mContext));
        blArray[9] = true;
    }

    @NonNull
    Context getContext() {
        boolean[] blArray = NavController.$jacocoInit();
        blArray[10] = true;
        return this.mContext;
    }

    @NonNull
    public NavigatorProvider getNavigatorProvider() {
        boolean[] blArray = NavController.$jacocoInit();
        blArray[11] = true;
        return this.mNavigatorProvider;
    }

    /*
     * WARNING - void declaration
     */
    public void addOnDestinationChangedListener(@NonNull OnDestinationChangedListener onDestinationChangedListener) {
        void listener;
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mBackStack.isEmpty()) {
            blArray[12] = true;
        } else {
            void backStackEntry;
            blArray[13] = true;
            NavBackStackEntry navBackStackEntry = this.mBackStack.peekLast();
            blArray[14] = true;
            blArray[15] = true;
            blArray[16] = true;
            listener.onDestinationChanged(this, backStackEntry.getDestination(), backStackEntry.getArguments());
            blArray[17] = true;
        }
        this.mOnDestinationChangedListeners.add((OnDestinationChangedListener)listener);
        blArray[18] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void removeOnDestinationChangedListener(@NonNull OnDestinationChangedListener onDestinationChangedListener) {
        void listener;
        boolean[] blArray = NavController.$jacocoInit();
        this.mOnDestinationChangedListeners.remove(listener);
        blArray[19] = true;
    }

    public boolean popBackStack() {
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mBackStack.isEmpty()) {
            blArray[20] = true;
            return false;
        }
        blArray[21] = true;
        return this.popBackStack(this.getCurrentDestination().getId(), true);
    }

    /*
     * Unable to fully structure code
     */
    public boolean popBackStack(@IdRes int var1_1, boolean var2_2) {
        block2: {
            var3_3 = NavController.$jacocoInit();
            var4_4 = this.popBackStackInternal((int)destinationId, (boolean)inclusive);
            var3_3[22] = true;
            if (popped != false) break block2;
            var3_3[23] = true;
            ** GOTO lbl12
        }
        if (this.dispatchOnDestinationChanged()) {
            v0 = var3_3[25] = true;
        } else {
            var3_3[24] = true;
lbl12:
            // 2 sources

            v0 = false;
            var3_3[26] = true;
        }
        var3_3[27] = true;
        return v0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    boolean popBackStackInternal(@IdRes int var1_1, boolean var2_2) {
        var3_3 = NavController.$jacocoInit();
        if (this.mBackStack.isEmpty()) {
            var3_3[28] = true;
            return false;
        }
        var4_4 = new ArrayList<E>();
        var3_3[29] = true;
        iterator = this.mBackStack.descendingIterator();
        var6_6 = false;
        var3_3[30] = true;
        while (true) {
            block12: {
                if (!iterator.hasNext()) {
                    var3_3[31] = true;
                    break;
                }
                var3_3[32] = true;
                destination /* !! */  = iterator.next().getDestination();
                var3_3[33] = true;
                var3_3[34] = true;
                var8_9 = this.mNavigatorProvider.getNavigator(destination /* !! */ .getNavigatorName());
                var3_3[35] = true;
                if (inclusive == false) break block12;
                var3_3[36] = true;
                ** GOTO lbl28
            }
            if (destination /* !! */ .getId() == destinationId) {
                var3_3[37] = true;
            } else {
                var3_3[38] = true;
lbl28:
                // 2 sources

                popOperations.add(navigator);
                var3_3[39] = true;
            }
            if (destination /* !! */ .getId() == destinationId) {
                foundDestination = true;
                var3_3[40] = true;
                break;
            }
            var3_3[41] = true;
        }
        if (!foundDestination) {
            var3_3[42] = true;
            destination /* !! */  = NavDestination.getDisplayName((Context)this.mContext, (int)destinationId);
            var3_3[43] = true;
            Log.i((String)"NavController", (String)("Ignoring popBackStack to destination " + (String)destinationName + " as it was not found on the current back stack"));
            var3_3[44] = true;
            return false;
        }
        destinationName = false;
        var3_3[45] = true;
        var8_9 = popOperations.iterator();
        var3_3[46] = true;
        while (true) {
            if (!var8_9.hasNext()) {
                var3_3[47] = true;
                break;
            }
            var9_10 = (Navigator)var8_9.next();
            var3_3[48] = true;
            if (!navigator.popBackStack()) {
                var3_3[49] = true;
                break;
            }
            var3_3[50] = true;
            entry = this.mBackStack.removeLast();
            if (this.mViewModel == null) {
                var3_3[51] = true;
            } else {
                var3_3[52] = true;
                this.mViewModel.clear(entry.mId);
                var3_3[53] = true;
            }
            popped = true;
            var3_3[54] = true;
        }
        this.updateOnBackPressedCallbackEnabled();
        var3_3[55] = true;
        return popped;
    }

    /*
     * WARNING - void declaration
     */
    public boolean navigateUp() {
        boolean[] blArray = NavController.$jacocoInit();
        if (this.getDestinationCountOnBackStack() == 1) {
            NavGraph parent;
            void currentDestination;
            blArray[56] = true;
            NavDestination navDestination = this.getCurrentDestination();
            blArray[57] = true;
            int n = currentDestination.getId();
            blArray[58] = true;
            NavGraph navGraph = currentDestination.getParent();
            blArray[59] = true;
            while (parent != null) {
                int destId;
                blArray[60] = true;
                if (parent.getStartDestination() != destId) {
                    void parentIntents;
                    blArray[61] = true;
                    blArray[62] = true;
                    blArray[63] = true;
                    TaskStackBuilder taskStackBuilder = new NavDeepLinkBuilder(this).setDestination(parent.getId()).createTaskStackBuilder();
                    blArray[64] = true;
                    parentIntents.startActivities();
                    if (this.mActivity == null) {
                        blArray[65] = true;
                    } else {
                        blArray[66] = true;
                        this.mActivity.finish();
                        blArray[67] = true;
                    }
                    blArray[68] = true;
                    return true;
                }
                destId = parent.getId();
                blArray[69] = true;
                parent = parent.getParent();
                blArray[70] = true;
            }
            blArray[71] = true;
            return false;
        }
        blArray[72] = true;
        return this.popBackStack();
    }

    /*
     * WARNING - void declaration
     */
    private int getDestinationCountOnBackStack() {
        void count;
        boolean[] blArray = NavController.$jacocoInit();
        boolean bl = false;
        blArray[73] = true;
        Iterator<NavBackStackEntry> iterator = this.mBackStack.iterator();
        blArray[74] = true;
        while (iterator.hasNext()) {
            void entry;
            NavBackStackEntry navBackStackEntry = iterator.next();
            blArray[75] = true;
            if (entry.getDestination() instanceof NavGraph) {
                blArray[76] = true;
            } else {
                ++count;
                blArray[77] = true;
            }
            blArray[78] = true;
        }
        blArray[79] = true;
        return (int)count;
    }

    /*
     * WARNING - void declaration
     */
    private boolean dispatchOnDestinationChanged() {
        boolean[] blArray = NavController.$jacocoInit();
        while (true) {
            if (this.mBackStack.isEmpty()) {
                blArray[80] = true;
                break;
            }
            blArray[81] = true;
            if (!(this.mBackStack.peekLast().getDestination() instanceof NavGraph)) {
                blArray[82] = true;
                break;
            }
            blArray[83] = true;
            if (!this.popBackStackInternal(this.mBackStack.peekLast().getDestination().getId(), true)) {
                blArray[84] = true;
                break;
            }
            blArray[85] = true;
        }
        if (!this.mBackStack.isEmpty()) {
            blArray[86] = true;
            NavBackStackEntry navBackStackEntry = this.mBackStack.peekLast();
            blArray[87] = true;
            Iterator<OnDestinationChangedListener> iterator = this.mOnDestinationChangedListeners.iterator();
            blArray[88] = true;
            while (iterator.hasNext()) {
                void backStackEntry;
                void listener;
                OnDestinationChangedListener onDestinationChangedListener = iterator.next();
                blArray[89] = true;
                blArray[90] = true;
                blArray[91] = true;
                listener.onDestinationChanged(this, backStackEntry.getDestination(), backStackEntry.getArguments());
                blArray[92] = true;
            }
            blArray[93] = true;
            return true;
        }
        blArray[94] = true;
        return false;
    }

    @NonNull
    public NavInflater getNavInflater() {
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mInflater != null) {
            blArray[95] = true;
        } else {
            blArray[96] = true;
            this.mInflater = new NavInflater(this.mContext, this.mNavigatorProvider);
            blArray[97] = true;
        }
        blArray[98] = true;
        return this.mInflater;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void setGraph(@NavigationRes int n) {
        void graphResId;
        boolean[] blArray = NavController.$jacocoInit();
        this.setGraph((int)graphResId, null);
        blArray[99] = true;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void setGraph(@NavigationRes int n, @Nullable Bundle bundle) {
        void startDestinationArgs;
        void graphResId;
        boolean[] blArray = NavController.$jacocoInit();
        this.setGraph(this.getNavInflater().inflate((int)graphResId), (Bundle)startDestinationArgs);
        blArray[100] = true;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void setGraph(@NonNull NavGraph navGraph) {
        void graph;
        boolean[] blArray = NavController.$jacocoInit();
        this.setGraph((NavGraph)graph, null);
        blArray[101] = true;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void setGraph(@NonNull NavGraph navGraph, @Nullable Bundle bundle) {
        void startDestinationArgs;
        void graph;
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mGraph == null) {
            blArray[102] = true;
        } else {
            blArray[103] = true;
            this.popBackStackInternal(this.mGraph.getId(), true);
            blArray[104] = true;
        }
        this.mGraph = graph;
        blArray[105] = true;
        this.onGraphCreated((Bundle)startDestinationArgs);
        blArray[106] = true;
    }

    /*
     * Unable to fully structure code
     */
    private void onGraphCreated(@Nullable Bundle var1_1) {
        block19: {
            block22: {
                block21: {
                    block20: {
                        block18: {
                            var2_2 = NavController.$jacocoInit();
                            if (this.mNavigatorStateToRestore == null) {
                                var2_2[107] = true;
                            } else {
                                var2_2[108] = true;
                                navigatorNames = this.mNavigatorStateToRestore.getStringArrayList("android-support-nav:controller:navigatorState:names");
                                if (navigatorNames == null) {
                                    var2_2[109] = true;
                                } else {
                                    var2_2[110] = true;
                                    var4_6 = navigatorNames.iterator();
                                    var2_2[111] = true;
                                    while (true) {
                                        if (!var4_6.hasNext()) {
                                            var2_2[112] = true;
                                            break;
                                        }
                                        var5_7 = (String)var4_6.next();
                                        var2_2[113] = true;
                                        var6_9 = this.mNavigatorProvider.getNavigator((String)name);
                                        var2_2[114] = true;
                                        bundle = this.mNavigatorStateToRestore.getBundle((String)name);
                                        if (bundle == null) {
                                            var2_2[115] = true;
                                        } else {
                                            var2_2[116] = true;
                                            navigator.onRestoreState(bundle);
                                            var2_2[117] = true;
                                        }
                                        var2_2[118] = true;
                                    }
                                }
                            }
                            if (this.mBackStackUUIDsToRestore == null) {
                                var2_2[119] = true;
                            } else {
                                navigatorNames = false;
                                var2_2[120] = true;
                                while (index < this.mBackStackUUIDsToRestore.length) {
                                    var2_2[121] = true;
                                    uuid = UUID.fromString(this.mBackStackUUIDsToRestore[index]);
                                    destinationId = this.mBackStackIdsToRestore[index];
                                    navigator = (Bundle)this.mBackStackArgsToRestore[index];
                                    var2_2[122] = true;
                                    node = this.findDestination(destinationId);
                                    if (node == null) {
                                        var2_2[123] = true;
                                        var2_2[124] = true;
                                        var2_2[125] = true;
                                        throw new IllegalStateException("unknown destination during restore: " + this.mContext.getResources().getResourceName(destinationId));
                                    }
                                    if (args == null) {
                                        var2_2[126] = true;
                                    } else {
                                        var2_2[127] = true;
                                        args.setClassLoader(this.mContext.getClassLoader());
                                        var2_2[128] = true;
                                    }
                                    this.mBackStack.add(new NavBackStackEntry(uuid, node, (Bundle)args, this.mViewModel));
                                    ++index;
                                    var2_2[129] = true;
                                }
                                this.updateOnBackPressedCallbackEnabled();
                                this.mBackStackUUIDsToRestore = null;
                                this.mBackStackIdsToRestore = null;
                                this.mBackStackArgsToRestore = null;
                                var2_2[130] = true;
                            }
                            if (this.mGraph != null) break block18;
                            var2_2[131] = true;
                            break block19;
                        }
                        if (this.mBackStack.isEmpty()) break block20;
                        var2_2[132] = true;
                        break block19;
                    }
                    if (!this.mDeepLinkHandled) break block21;
                    var2_2[133] = true;
                    ** GOTO lbl84
                }
                if (this.mActivity != null) break block22;
                var2_2[134] = true;
                ** GOTO lbl84
            }
            var2_2[135] = true;
            if (this.handleDeepLink(this.mActivity.getIntent())) {
                v0 = var2_2[137] = true;
            } else {
                var2_2[136] = true;
lbl84:
                // 3 sources

                v0 = false;
                var2_2[138] = true;
            }
            deepLinked = v0;
            if (deepLinked) {
                var2_2[139] = true;
            } else {
                var2_2[140] = true;
                this.navigate((NavDestination)this.mGraph, (Bundle)startDestinationArgs, null, null);
                var2_2[141] = true;
            }
        }
        var2_2[142] = true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean handleDeepLink(@Nullable Intent var1_1) {
        block40: {
            block39: {
                block38: {
                    block37: {
                        var2_2 = NavController.$jacocoInit();
                        if (intent == null) {
                            var2_2[143] = true;
                            return false;
                        }
                        var3_3 = intent.getExtras();
                        var2_2[144] = true;
                        if (extras != null) {
                            v0 = extras.getIntArray("android-support-nav:controller:deepLinkIds");
                            var2_2[145] = true;
                        } else {
                            v0 = null;
                            var2_2[146] = true;
                        }
                        var4_4 = v0;
                        var2_2[147] = true;
                        var5_5 = new Bundle();
                        var2_2[148] = true;
                        if (extras != null) {
                            v1 = extras.getBundle("android-support-nav:controller:deepLinkExtras");
                            var2_2[149] = true;
                        } else {
                            v1 = null;
                            var2_2[150] = true;
                        }
                        deepLinkExtras = v1;
                        if (deepLinkExtras == null) {
                            var2_2[151] = true;
                        } else {
                            var2_2[152] = true;
                            bundle.putAll(deepLinkExtras);
                            var2_2[153] = true;
                        }
                        if (deepLink != null) break block37;
                        var2_2[154] = true;
                        ** GOTO lbl38
                    }
                    if (deepLink.length != 0) {
                        var2_2[155] = true;
                    } else {
                        var2_2[156] = true;
lbl38:
                        // 2 sources

                        if (intent.getData() == null) {
                            var2_2[157] = true;
                        } else {
                            var2_2[158] = true;
                            matchingDeepLink = this.mGraph.matchDeepLink(intent.getData());
                            if (matchingDeepLink == null) {
                                var2_2[159] = true;
                            } else {
                                var2_2[160] = true;
                                deepLink = matchingDeepLink.getDestination().buildDeepLinkIds();
                                var2_2[161] = true;
                                bundle.putAll(matchingDeepLink.getMatchingArgs());
                                var2_2[162] = true;
                            }
                        }
                    }
                    if (deepLink != null) break block38;
                    var2_2[163] = true;
                    break block39;
                }
                if (deepLink.length != 0) break block40;
                var2_2[164] = true;
            }
            var2_2[165] = true;
            return false;
        }
        var2_2[166] = true;
        invalidDestinationDisplayName = this.findInvalidDestinationDisplayNameInDeepLink(deepLink);
        if (invalidDestinationDisplayName != null) {
            var2_2[167] = true;
            Log.i((String)"NavController", (String)("Could not find destination " + invalidDestinationDisplayName + " in the navigation graph, ignoring the deep link from " + intent));
            var2_2[168] = true;
            return false;
        }
        bundle.putParcelable("android-support-nav:controller:deepLinkIntent", (Parcelable)intent);
        var2_2[169] = true;
        flags = intent.getFlags();
        if ((flags & 0x10000000) == 0) {
            var2_2[170] = true;
        } else if ((flags & 32768) != 0) {
            var2_2[171] = true;
        } else {
            var2_2[172] = true;
            intent.addFlags(32768);
            var2_2[173] = true;
            var2_2[174] = true;
            var9_9 = TaskStackBuilder.create((Context)this.mContext).addNextIntentWithParentStack((Intent)intent);
            var2_2[175] = true;
            taskStackBuilder.startActivities();
            if (this.mActivity == null) {
                var2_2[176] = true;
            } else {
                var2_2[177] = true;
                this.mActivity.finish();
                var2_2[178] = true;
                this.mActivity.overridePendingTransition(0, 0);
                var2_2[179] = true;
            }
            var2_2[180] = true;
            return true;
        }
        if ((flags & 0x10000000) != 0) {
            var2_2[181] = true;
            if (this.mBackStack.isEmpty()) {
                var2_2[182] = true;
            } else {
                var2_2[183] = true;
                this.popBackStackInternal(this.mGraph.getId(), true);
                var2_2[184] = true;
            }
            taskStackBuilder = false;
            var2_2[185] = true;
            while (index < deepLink.length) {
                var10_12 = deepLink[++index];
                var2_2[186] = true;
                node = this.findDestination((int)destinationId);
                if (node == null) {
                    var2_2[187] = true;
                    var2_2[188] = true;
                    var2_2[189] = true;
                    throw new IllegalStateException("unknown destination during deep link: " + NavDestination.getDisplayName((Context)this.mContext, (int)destinationId));
                }
                var2_2[190] = true;
                var2_2[191] = true;
                this.navigate(node, (Bundle)bundle, new NavOptions.Builder().setEnterAnim(0).setExitAnim(0).build(), null);
                var2_2[192] = true;
            }
            var2_2[193] = true;
            return true;
        }
        graph = this.mGraph;
        destinationId = false;
        var2_2[194] = true;
        while (i < deepLink.length) {
            block36: {
                node = deepLink[i];
                var2_2[195] = true;
                if (i == false) {
                    v2 = this.mGraph;
                    var2_2[196] = true;
                } else {
                    v2 = graph.findNode((int)destinationId);
                    var2_2[197] = true;
                }
                node = v2;
                if (node == null) {
                    var2_2[198] = true;
                    var2_2[199] = true;
                    var2_2[200] = true;
                    throw new IllegalStateException("unknown destination during deep link: " + NavDestination.getDisplayName((Context)this.mContext, (int)destinationId));
                }
                if (i != deepLink.length - 1) {
                    graph = node;
                    var2_2[201] = true;
                    while (true) {
                        if (!(graph.findNode(graph.getStartDestination()) instanceof NavGraph)) {
                            var2_2[202] = true;
                            break block36;
                        }
                        var2_2[203] = true;
                        graph = (NavGraph)graph.findNode(graph.getStartDestination());
                        var2_2[204] = true;
                    }
                }
                var2_2[205] = true;
                var2_2[206] = true;
                var2_2[207] = true;
                this.navigate((NavDestination)node, node.addInDefaultArgs((Bundle)bundle), new NavOptions.Builder().setPopUpTo(this.mGraph.getId(), true).setEnterAnim(0).setExitAnim(0).build(), null);
                var2_2[208] = true;
            }
            ++i;
            var2_2[209] = true;
        }
        this.mDeepLinkHandled = true;
        var2_2[210] = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String findInvalidDestinationDisplayNameInDeepLink(@NonNull int[] nArray) {
        void deepLink;
        void i;
        boolean[] blArray = NavController.$jacocoInit();
        NavGraph graph = this.mGraph;
        boolean bl = false;
        blArray[211] = true;
        while (i < ((void)deepLink).length) {
            void destinationId;
            NavGraph navGraph;
            void var5_5 = deepLink[i];
            blArray[212] = true;
            if (i == false) {
                navGraph = this.mGraph;
                blArray[213] = true;
            } else {
                navGraph = graph.findNode((int)destinationId);
                blArray[214] = true;
            }
            NavGraph node = navGraph;
            if (node == null) {
                blArray[215] = true;
                blArray[216] = true;
                return NavDestination.getDisplayName((Context)this.mContext, (int)destinationId);
            }
            if (i == ((void)deepLink).length - 1) {
                blArray[217] = true;
            } else {
                graph = node;
                blArray[218] = true;
                while (true) {
                    if (!(graph.findNode(graph.getStartDestination()) instanceof NavGraph)) {
                        blArray[219] = true;
                        break;
                    }
                    blArray[220] = true;
                    graph = (NavGraph)graph.findNode(graph.getStartDestination());
                    blArray[221] = true;
                }
            }
            ++i;
            blArray[222] = true;
        }
        blArray[223] = true;
        return null;
    }

    @NonNull
    public NavGraph getGraph() {
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mGraph == null) {
            blArray[224] = true;
            blArray[225] = true;
            throw new IllegalStateException("You must call setGraph() before calling getGraph()");
        }
        blArray[226] = true;
        return this.mGraph;
    }

    @Nullable
    public NavDestination getCurrentDestination() {
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mBackStack.isEmpty()) {
            blArray[227] = true;
            return null;
        }
        blArray[228] = true;
        return this.mBackStack.getLast().getDestination();
    }

    /*
     * WARNING - void declaration
     */
    NavDestination findDestination(@IdRes int n) {
        void currentGraph;
        NavGraph navGraph;
        NavGraph navGraph2;
        void destinationId;
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mGraph == null) {
            blArray[229] = true;
            return null;
        }
        if (this.mGraph.getId() == destinationId) {
            blArray[230] = true;
            return this.mGraph;
        }
        if (this.mBackStack.isEmpty()) {
            navGraph2 = this.mGraph;
            blArray[231] = true;
        } else {
            blArray[232] = true;
            navGraph2 = this.mBackStack.getLast().getDestination();
            blArray[233] = true;
        }
        NavGraph currentNode = navGraph2;
        if (currentNode instanceof NavGraph) {
            navGraph = currentNode;
            blArray[234] = true;
        } else {
            blArray[235] = true;
            navGraph = currentNode.getParent();
            blArray[236] = true;
        }
        NavGraph navGraph3 = navGraph;
        blArray[237] = true;
        blArray[238] = true;
        return currentGraph.findNode((int)destinationId);
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@IdRes int n) {
        void resId;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate((int)resId, null);
        blArray[239] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@IdRes int n, @Nullable Bundle bundle) {
        void args;
        void resId;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate((int)resId, (Bundle)args, null);
        blArray[240] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@IdRes int n, @Nullable Bundle bundle, @Nullable NavOptions navOptions) {
        void navOptions2;
        void args;
        void resId;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate((int)resId, (Bundle)args, (NavOptions)navOptions2, null);
        blArray[241] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@IdRes int n, @Nullable Bundle bundle, @Nullable NavOptions navOptions, @Nullable Navigator.Extras extras) {
        void navigatorExtras;
        void args;
        int destId;
        NavOptions navOptions2;
        void resId;
        NavGraph navGraph;
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mBackStack.isEmpty()) {
            navGraph = this.mGraph;
            blArray[242] = true;
        } else {
            blArray[243] = true;
            navGraph = this.mBackStack.getLast().getDestination();
            blArray[244] = true;
        }
        NavGraph currentNode = navGraph;
        if (currentNode == null) {
            blArray[245] = true;
            blArray[246] = true;
            throw new IllegalStateException("no current navigation node");
        }
        void var7_7 = resId;
        blArray[247] = true;
        NavAction navAction = currentNode.getAction((int)resId);
        Bundle combinedArgs = null;
        if (navAction == null) {
            blArray[248] = true;
        } else {
            if (navOptions2 != null) {
                blArray[249] = true;
            } else {
                blArray[250] = true;
                navOptions2 = navAction.getNavOptions();
                blArray[251] = true;
            }
            destId = navAction.getDestinationId();
            blArray[252] = true;
            Bundle navActionArgs = navAction.getDefaultArguments();
            if (navActionArgs == null) {
                blArray[253] = true;
            } else {
                blArray[254] = true;
                combinedArgs = new Bundle();
                blArray[255] = true;
                combinedArgs.putAll(navActionArgs);
                blArray[256] = true;
            }
        }
        if (args == null) {
            blArray[257] = true;
        } else {
            if (combinedArgs != null) {
                blArray[258] = true;
            } else {
                blArray[259] = true;
                combinedArgs = new Bundle();
                blArray[260] = true;
            }
            combinedArgs.putAll((Bundle)args);
            blArray[261] = true;
        }
        if (destId != 0) {
            blArray[262] = true;
        } else if (navOptions2 == null) {
            blArray[263] = true;
        } else if (navOptions2.getPopUpTo() == -1) {
            blArray[264] = true;
        } else {
            blArray[265] = true;
            this.popBackStack(navOptions2.getPopUpTo(), navOptions2.isPopUpToInclusive());
            blArray[266] = true;
            return;
        }
        if (destId == 0) {
            blArray[267] = true;
            blArray[268] = true;
            throw new IllegalArgumentException("Destination id == 0 can only be used in conjunction with a valid navOptions.popUpTo");
        }
        NavDestination node = this.findDestination(destId);
        if (node == null) {
            String string;
            void dest;
            blArray[269] = true;
            String string2 = NavDestination.getDisplayName((Context)this.mContext, (int)destId);
            blArray[270] = true;
            StringBuilder stringBuilder = new StringBuilder().append("navigation destination ").append((String)dest);
            if (navAction != null) {
                blArray[271] = true;
                string = " referenced from action " + NavDestination.getDisplayName((Context)this.mContext, (int)resId);
                blArray[272] = true;
            } else {
                string = "";
                blArray[273] = true;
            }
            blArray[274] = true;
            throw new IllegalArgumentException(stringBuilder.append(string).append(" is unknown to this NavController").toString());
        }
        this.navigate(node, combinedArgs, navOptions2, (Navigator.Extras)navigatorExtras);
        blArray[275] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NonNull Uri uri) {
        void deepLink;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate((Uri)deepLink, null);
        blArray[276] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NonNull Uri uri, @Nullable NavOptions navOptions) {
        void navOptions2;
        void deepLink;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate((Uri)deepLink, (NavOptions)navOptions2, null);
        blArray[277] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NonNull Uri uri, @Nullable NavOptions navOptions, @Nullable Navigator.Extras extras) {
        void navigatorExtras;
        void navOptions2;
        void args;
        void node;
        void deepLink;
        boolean[] blArray = NavController.$jacocoInit();
        NavDestination.DeepLinkMatch deepLinkMatch = this.mGraph.matchDeepLink((Uri)deepLink);
        if (deepLinkMatch == null) {
            blArray[281] = true;
            throw new IllegalArgumentException("navigation destination with deepLink " + deepLink + " is unknown to this NavController");
        }
        blArray[278] = true;
        Bundle bundle = deepLinkMatch.getMatchingArgs();
        blArray[279] = true;
        NavDestination navDestination = deepLinkMatch.getDestination();
        blArray[280] = true;
        this.navigate((NavDestination)node, (Bundle)args, (NavOptions)navOptions2, (Navigator.Extras)navigatorExtras);
        blArray[282] = true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void navigate(@NonNull NavDestination var1_1, @Nullable Bundle var2_2, @Nullable NavOptions var3_3, @Nullable Navigator.Extras var4_4) {
        block21: {
            var5_5 = NavController.$jacocoInit();
            popped = false;
            if (navOptions == null) {
                var5_5[283] = true;
            } else {
                var5_5[284] = true;
                if (navOptions.getPopUpTo() == -1) {
                    var5_5[285] = true;
                } else {
                    var5_5[286] = true;
                    var5_5[287] = true;
                    var5_5[288] = true;
                    popped = this.popBackStackInternal(navOptions.getPopUpTo(), navOptions.isPopUpToInclusive());
                    var5_5[289] = true;
                }
            }
            var5_5[290] = true;
            var5_5[291] = true;
            var7_7 = this.mNavigatorProvider.getNavigator(node.getNavigatorName());
            var5_5[292] = true;
            var8_8 = node.addInDefaultArgs((Bundle)args);
            var5_5[293] = true;
            newDest = navigator.navigate((NavDestination)node, (Bundle)finalArgs, (NavOptions)navOptions, (Navigator.Extras)navigatorExtras);
            if (newDest == null) {
                var5_5[294] = true;
            } else {
                if (newDest instanceof FloatingWindow) {
                    var5_5[295] = true;
                } else {
                    var5_5[296] = true;
                    while (true) {
                        if (this.mBackStack.isEmpty()) {
                            var5_5[297] = true;
                            break;
                        }
                        var5_5[298] = true;
                        if (!(this.mBackStack.peekLast().getDestination() instanceof FloatingWindow)) {
                            var5_5[299] = true;
                            break;
                        }
                        var5_5[300] = true;
                        var5_5[301] = true;
                        if (!this.popBackStackInternal(this.mBackStack.peekLast().getDestination().getId(), true)) {
                            var5_5[302] = true;
                            break;
                        }
                        var5_5[303] = true;
                    }
                }
                if (!this.mBackStack.isEmpty()) {
                    var5_5[304] = true;
                } else {
                    var5_5[305] = true;
                    this.mBackStack.add(new NavBackStackEntry((NavDestination)this.mGraph, (Bundle)finalArgs, this.mViewModel));
                    var5_5[306] = true;
                }
                hierarchy = new ArrayDeque<NavBackStackEntry>();
                var11_11 = newDest;
                var5_5[307] = true;
                while (true) {
                    if (destination == null) {
                        var5_5[308] = true;
                        break;
                    }
                    if (this.findDestination(destination.getId()) != null) {
                        var5_5[309] = true;
                        break;
                    }
                    var5_5[310] = true;
                    parent /* !! */  = destination.getParent();
                    if (parent /* !! */  == null) {
                        var5_5[311] = true;
                    } else {
                        var5_5[312] = true;
                        hierarchy.addFirst(new NavBackStackEntry((NavDestination)parent /* !! */ , (Bundle)finalArgs, this.mViewModel));
                        var5_5[313] = true;
                    }
                    destination = parent /* !! */ ;
                    var5_5[314] = true;
                }
                this.mBackStack.addAll(hierarchy);
                var5_5[315] = true;
                parent /* !! */  = new NavBackStackEntry(newDest, newDest.addInDefaultArgs((Bundle)finalArgs), this.mViewModel);
                var5_5[316] = true;
                this.mBackStack.add((NavBackStackEntry)newBackStackEntry);
                var5_5[317] = true;
            }
            this.updateOnBackPressedCallbackEnabled();
            if (!popped) break block21;
            var5_5[318] = true;
            ** GOTO lbl89
        }
        if (newDest == null) {
            var5_5[319] = true;
        } else {
            var5_5[320] = true;
lbl89:
            // 2 sources

            this.dispatchOnDestinationChanged();
            var5_5[321] = true;
        }
        var5_5[322] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NonNull NavDirections navDirections) {
        void directions;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate(directions.getActionId(), directions.getArguments());
        blArray[323] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NonNull NavDirections navDirections, @Nullable NavOptions navOptions) {
        void navOptions2;
        void directions;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate(directions.getActionId(), directions.getArguments(), (NavOptions)navOptions2);
        blArray[324] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NonNull NavDirections navDirections, @NonNull Navigator.Extras extras) {
        void navigatorExtras;
        void directions;
        boolean[] blArray = NavController.$jacocoInit();
        this.navigate(directions.getActionId(), directions.getArguments(), null, (Navigator.Extras)navigatorExtras);
        blArray[325] = true;
    }

    @NonNull
    public NavDeepLinkBuilder createDeepLink() {
        boolean[] blArray = NavController.$jacocoInit();
        blArray[326] = true;
        return new NavDeepLinkBuilder(this);
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @Nullable
    public Bundle saveState() {
        Bundle b;
        void navigatorState;
        void navigatorNames;
        int[] entry;
        boolean[] blArray = NavController.$jacocoInit();
        Object var2_2 = null;
        blArray[327] = true;
        ArrayList arrayList = new ArrayList();
        blArray[328] = true;
        Bundle bundle = new Bundle();
        blArray[329] = true;
        String[] stringArray = this.mNavigatorProvider.getNavigators().entrySet().iterator();
        blArray[330] = true;
        while (stringArray.hasNext()) {
            Map.Entry entry2 = stringArray.next();
            blArray[331] = true;
            String string = (String)entry.getKey();
            blArray[332] = true;
            Bundle savedState = ((Navigator)entry.getValue()).onSaveState();
            if (savedState == null) {
                blArray[333] = true;
            } else {
                void name;
                blArray[334] = true;
                navigatorNames.add(name);
                blArray[335] = true;
                navigatorState.putBundle((String)name, savedState);
                blArray[336] = true;
            }
            blArray[337] = true;
        }
        if (navigatorNames.isEmpty()) {
            blArray[338] = true;
        } else {
            blArray[339] = true;
            b = new Bundle();
            blArray[340] = true;
            navigatorState.putStringArrayList(KEY_NAVIGATOR_STATE_NAMES, (ArrayList)navigatorNames);
            blArray[341] = true;
            b.putBundle(KEY_NAVIGATOR_STATE, (Bundle)navigatorState);
            blArray[342] = true;
        }
        if (this.mBackStack.isEmpty()) {
            blArray[343] = true;
        } else {
            void backStackIds;
            void backStackUUIDs;
            if (b != null) {
                blArray[344] = true;
            } else {
                blArray[345] = true;
                b = new Bundle();
                blArray[346] = true;
            }
            stringArray = new String[this.mBackStack.size()];
            blArray[347] = true;
            entry = new int[this.mBackStack.size()];
            blArray[348] = true;
            Parcelable[] backStackArgs = new Parcelable[this.mBackStack.size()];
            boolean savedState = false;
            blArray[349] = true;
            Iterator<NavBackStackEntry> iterator = this.mBackStack.iterator();
            blArray[350] = true;
            while (iterator.hasNext()) {
                void backStackEntry;
                NavBackStackEntry navBackStackEntry = iterator.next();
                blArray[351] = true;
                backStackUUIDs[index] = backStackEntry.mId.toString();
                blArray[352] = true;
                backStackIds[index] = backStackEntry.getDestination().getId();
                blArray[353] = true;
                backStackArgs[++index] = backStackEntry.getArguments();
                blArray[354] = true;
            }
            b.putStringArray(KEY_BACK_STACK_UUIDS, (String[])backStackUUIDs);
            blArray[355] = true;
            b.putIntArray(KEY_BACK_STACK_IDS, (int[])backStackIds);
            blArray[356] = true;
            b.putParcelableArray(KEY_BACK_STACK_ARGS, backStackArgs);
            blArray[357] = true;
        }
        if (!this.mDeepLinkHandled) {
            blArray[358] = true;
        } else {
            if (b != null) {
                blArray[359] = true;
            } else {
                blArray[360] = true;
                b = new Bundle();
                blArray[361] = true;
            }
            b.putBoolean(KEY_DEEP_LINK_HANDLED, this.mDeepLinkHandled);
            blArray[362] = true;
        }
        blArray[363] = true;
        return b;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void restoreState(@Nullable Bundle bundle) {
        void navState;
        boolean[] blArray = NavController.$jacocoInit();
        if (navState == null) {
            blArray[364] = true;
            return;
        }
        navState.setClassLoader(this.mContext.getClassLoader());
        blArray[365] = true;
        this.mNavigatorStateToRestore = navState.getBundle(KEY_NAVIGATOR_STATE);
        blArray[366] = true;
        this.mBackStackUUIDsToRestore = navState.getStringArray(KEY_BACK_STACK_UUIDS);
        blArray[367] = true;
        this.mBackStackIdsToRestore = navState.getIntArray(KEY_BACK_STACK_IDS);
        blArray[368] = true;
        this.mBackStackArgsToRestore = navState.getParcelableArray(KEY_BACK_STACK_ARGS);
        blArray[369] = true;
        this.mDeepLinkHandled = navState.getBoolean(KEY_DEEP_LINK_HANDLED);
        blArray[370] = true;
    }

    /*
     * WARNING - void declaration
     */
    void setLifecycleOwner(@NonNull LifecycleOwner lifecycleOwner) {
        void owner;
        boolean[] blArray = NavController.$jacocoInit();
        this.mLifecycleOwner = owner;
        blArray[371] = true;
    }

    /*
     * WARNING - void declaration
     */
    void setOnBackPressedDispatcher(@NonNull OnBackPressedDispatcher onBackPressedDispatcher) {
        void dispatcher;
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mLifecycleOwner == null) {
            blArray[372] = true;
            blArray[373] = true;
            throw new IllegalStateException("You must call setLifecycleOwner() before calling setOnBackPressedDispatcher()");
        }
        this.mOnBackPressedCallback.remove();
        blArray[374] = true;
        dispatcher.addCallback(this.mLifecycleOwner, this.mOnBackPressedCallback);
        blArray[375] = true;
    }

    /*
     * WARNING - void declaration
     */
    void enableOnBackPressed(boolean bl) {
        void enabled;
        boolean[] blArray = NavController.$jacocoInit();
        this.mEnableOnBackPressedCallback = enabled;
        blArray[376] = true;
        this.updateOnBackPressedCallbackEnabled();
        blArray[377] = true;
    }

    /*
     * Unable to fully structure code
     */
    private void updateOnBackPressedCallbackEnabled() {
        block2: {
            var1_1 = NavController.$jacocoInit();
            if (this.mEnableOnBackPressedCallback) break block2;
            var1_1[378] = true;
            ** GOTO lbl11
        }
        var1_1[379] = true;
        if (this.getDestinationCountOnBackStack() > 1) {
            v0 = var1_1[381] = true;
        } else {
            var1_1[380] = true;
lbl11:
            // 2 sources

            v0 = false;
            var1_1[382] = true;
        }
        this.mOnBackPressedCallback.setEnabled(v0);
        var1_1[383] = true;
    }

    /*
     * WARNING - void declaration
     */
    void setViewModelStore(@NonNull ViewModelStore viewModelStore) {
        void viewModelStore2;
        boolean[] blArray = NavController.$jacocoInit();
        this.mViewModel = NavControllerViewModel.getInstance((ViewModelStore)viewModelStore2);
        blArray[384] = true;
        Iterator<NavBackStackEntry> iterator = this.mBackStack.iterator();
        blArray[385] = true;
        while (iterator.hasNext()) {
            void entry;
            NavBackStackEntry navBackStackEntry = iterator.next();
            blArray[386] = true;
            entry.setNavControllerViewModel(this.mViewModel);
            blArray[387] = true;
        }
        blArray[388] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public ViewModelStore getViewModelStore(@IdRes int n) {
        void navGraphId;
        boolean[] blArray = NavController.$jacocoInit();
        blArray[389] = true;
        return this.getViewModelStoreOwner((int)navGraphId).getViewModelStore();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ViewModelStoreOwner getViewModelStoreOwner(@IdRes int n) {
        void lastFromBackStack;
        void navGraphId;
        boolean[] blArray = NavController.$jacocoInit();
        if (this.mViewModel == null) {
            blArray[390] = true;
            blArray[391] = true;
            throw new IllegalStateException("You must call setViewModelStore() before calling getViewModelStoreOwner().");
        }
        Object var3_3 = null;
        blArray[392] = true;
        Iterator<NavBackStackEntry> iterator = this.mBackStack.descendingIterator();
        blArray[393] = true;
        while (true) {
            void destination;
            void entry;
            void iterator2;
            if (!iterator2.hasNext()) {
                blArray[394] = true;
                break;
            }
            blArray[395] = true;
            NavBackStackEntry navBackStackEntry = (NavBackStackEntry)iterator2.next();
            blArray[396] = true;
            NavDestination navDestination = entry.getDestination();
            blArray[397] = true;
            if (!(destination instanceof NavGraph)) {
                blArray[398] = true;
            } else if (destination.getId() != navGraphId) {
                blArray[399] = true;
            } else {
                lastFromBackStack = entry;
                blArray[400] = true;
                break;
            }
            blArray[401] = true;
        }
        if (lastFromBackStack == null) {
            blArray[402] = true;
            blArray[403] = true;
            throw new IllegalArgumentException("No NavGraph with ID " + (int)navGraphId + " is on the NavController's back stack");
        }
        blArray[404] = true;
        return lastFromBackStack;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)5750627055367397687L, (String)"androidx/navigation/NavController", (int)405);
        }
        return blArray;
    }

    public static interface OnDestinationChangedListener {
        public void onDestinationChanged(@NonNull NavController var1, @NonNull NavDestination var2, @Nullable Bundle var3);
    }
}

