/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDestination;
import java.util.UUID;

final class NavBackStackEntry
implements ViewModelStoreOwner {
    private final NavDestination mDestination;
    private final Bundle mArgs;
    @NonNull
    final UUID mId;
    private NavControllerViewModel mNavControllerViewModel;

    NavBackStackEntry(@NonNull NavDestination destination, @Nullable Bundle args, @Nullable NavControllerViewModel navControllerViewModel) {
        this(UUID.randomUUID(), destination, args, navControllerViewModel);
    }

    NavBackStackEntry(@NonNull UUID uuid, @NonNull NavDestination destination, @Nullable Bundle args, @Nullable NavControllerViewModel navControllerViewModel) {
        this.mId = uuid;
        this.mDestination = destination;
        this.mArgs = args;
        this.mNavControllerViewModel = navControllerViewModel;
    }

    @NonNull
    public NavDestination getDestination() {
        return this.mDestination;
    }

    @Nullable
    public Bundle getArguments() {
        return this.mArgs;
    }

    void setNavControllerViewModel(@NonNull NavControllerViewModel navControllerViewModel) {
        this.mNavControllerViewModel = navControllerViewModel;
    }

    @NonNull
    public ViewModelStore getViewModelStore() {
        return this.mNavControllerViewModel.getViewModelStore(this.mId);
    }
}

