/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.navigation.NavBackStackEntry;
import java.util.UUID;

@SuppressLint(value={"BanParcelableUsage"})
final class NavBackStackEntryState
implements Parcelable {
    private final UUID mUUID;
    private final int mDestinationId;
    private final Bundle mArgs;
    private final Bundle mSavedState;
    public static final Parcelable.Creator<NavBackStackEntryState> CREATOR = new Parcelable.Creator<NavBackStackEntryState>(){

        public NavBackStackEntryState createFromParcel(Parcel in) {
            return new NavBackStackEntryState(in);
        }

        public NavBackStackEntryState[] newArray(int size) {
            return new NavBackStackEntryState[size];
        }
    };

    NavBackStackEntryState(NavBackStackEntry entry) {
        this.mUUID = entry.mId;
        this.mDestinationId = entry.getDestination().getId();
        this.mArgs = entry.getArguments();
        this.mSavedState = new Bundle();
        entry.saveState(this.mSavedState);
    }

    NavBackStackEntryState(Parcel in) {
        this.mUUID = UUID.fromString(in.readString());
        this.mDestinationId = in.readInt();
        this.mArgs = in.readBundle(this.getClass().getClassLoader());
        this.mSavedState = in.readBundle(this.getClass().getClassLoader());
    }

    @NonNull
    UUID getUUID() {
        return this.mUUID;
    }

    int getDestinationId() {
        return this.mDestinationId;
    }

    @Nullable
    Bundle getArgs() {
        return this.mArgs;
    }

    @NonNull
    Bundle getSavedState() {
        return this.mSavedState;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int i) {
        parcel.writeString(this.mUUID.toString());
        parcel.writeInt(this.mDestinationId);
        parcel.writeBundle(this.mArgs);
        parcel.writeBundle(this.mSavedState);
    }
}

