/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.core.app.ActivityCompat;
import androidx.core.app.ActivityOptionsCompat;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="activity")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0016\u0017\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0002H\u0016J0\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\u0003\u001a\u00020\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/navigation/ActivityNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/ActivityNavigator$Destination;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "hostActivity", "Landroid/app/Activity;", "createDestination", "navigate", "Landroidx/navigation/NavDestination;", "destination", "args", "Landroid/os/Bundle;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "popBackStack", "", "Companion", "Destination", "Extras", "navigation-runtime_release"})
public class ActivityNavigator
extends Navigator<Destination> {
    private final Activity hostActivity;
    @NotNull
    private final Context context;
    private static final String EXTRA_NAV_SOURCE = "android-support-navigation:ActivityNavigator:source";
    private static final String EXTRA_NAV_CURRENT = "android-support-navigation:ActivityNavigator:current";
    private static final String EXTRA_POP_ENTER_ANIM = "android-support-navigation:ActivityNavigator:popEnterAnim";
    private static final String EXTRA_POP_EXIT_ANIM = "android-support-navigation:ActivityNavigator:popExitAnim";
    private static final String LOG_TAG = "ActivityNavigator";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Destination createDestination() {
        return new Destination((Navigator<? extends Destination>)((Navigator)this));
    }

    public boolean popBackStack() {
        if (this.hostActivity != null) {
            this.hostActivity.finish();
            return true;
        }
        return false;
    }

    @Nullable
    public NavDestination navigate(@NotNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        int hostCurrentId;
        Intent hostIntent;
        Intrinsics.checkNotNullParameter((Object)((Object)destination), (String)"destination");
        Intent intent = destination.getIntent();
        boolean bl = false;
        boolean bl2 = false;
        if (intent == null) {
            boolean bl3 = false;
            String string = "Destination " + destination.getId() + " does not have an Intent set.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intent intent2 = new Intent(destination.getIntent());
        if (args != null) {
            intent2.putExtras(args);
            String dataPattern = destination.getDataPattern();
            CharSequence charSequence = dataPattern;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                StringBuffer data = new StringBuffer();
                Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
                Matcher matcher = fillInPattern.matcher(dataPattern);
                while (matcher.find()) {
                    String argName = matcher.group(1);
                    if (args.containsKey(argName)) {
                        matcher.appendReplacement(data, "");
                        data.append(Uri.encode((String)String.valueOf(args.get(argName))));
                        continue;
                    }
                    throw (Throwable)new IllegalArgumentException("Could not find " + argName + " in " + args + " to fill data pattern " + dataPattern);
                }
                matcher.appendTail(data);
                intent2.setData(Uri.parse((String)data.toString()));
            }
        }
        if (navigatorExtras instanceof Extras) {
            intent2.addFlags(((Extras)navigatorExtras).getFlags());
        }
        if (this.hostActivity == null) {
            intent2.addFlags(0x10000000);
        }
        if (navOptions != null && navOptions.shouldLaunchSingleTop()) {
            intent2.addFlags(0x20000000);
        }
        if (this.hostActivity != null && (hostIntent = this.hostActivity.getIntent()) != null && (hostCurrentId = hostIntent.getIntExtra(EXTRA_NAV_CURRENT, 0)) != 0) {
            intent2.putExtra(EXTRA_NAV_SOURCE, hostCurrentId);
        }
        int destId = destination.getId();
        intent2.putExtra(EXTRA_NAV_CURRENT, destId);
        Resources resources = this.context.getResources();
        if (navOptions != null) {
            int popEnterAnim = navOptions.getPopEnterAnim();
            int popExitAnim = navOptions.getPopExitAnim();
            if (popEnterAnim > 0 && Intrinsics.areEqual((Object)resources.getResourceTypeName(popEnterAnim), (Object)"animator") || popExitAnim > 0 && Intrinsics.areEqual((Object)resources.getResourceTypeName(popExitAnim), (Object)"animator")) {
                Log.w((String)LOG_TAG, (String)("Activity destinations do not support Animator resource. Ignoring " + "popEnter resource " + resources.getResourceName(popEnterAnim) + " and " + "popExit resource " + resources.getResourceName(popExitAnim) + " when " + "launching " + (Object)((Object)destination)));
            } else {
                intent2.putExtra(EXTRA_POP_ENTER_ANIM, popEnterAnim);
                Intrinsics.checkNotNullExpressionValue((Object)intent2.putExtra(EXTRA_POP_EXIT_ANIM, popExitAnim), (String)"intent.putExtra(EXTRA_POP_EXIT_ANIM, popExitAnim)");
            }
        }
        if (navigatorExtras instanceof Extras) {
            ActivityOptionsCompat activityOptions = ((Extras)navigatorExtras).getActivityOptions();
            if (activityOptions != null) {
                ActivityCompat.startActivity((Context)this.context, (Intent)intent2, (Bundle)activityOptions.toBundle());
            } else {
                this.context.startActivity(intent2);
            }
        } else {
            this.context.startActivity(intent2);
        }
        if (navOptions != null && this.hostActivity != null) {
            int enterAnim = navOptions.getEnterAnim();
            int exitAnim = navOptions.getExitAnim();
            if (enterAnim > 0 && Intrinsics.areEqual((Object)resources.getResourceTypeName(enterAnim), (Object)"animator") || exitAnim > 0 && Intrinsics.areEqual((Object)resources.getResourceTypeName(exitAnim), (Object)"animator")) {
                Log.w((String)LOG_TAG, (String)("Activity destinations do not support Animator resource. Ignoring enter resource " + resources.getResourceName(enterAnim) + " and exit resource " + resources.getResourceName(exitAnim) + "when " + "launching " + (Object)((Object)destination)));
            } else if (enterAnim >= 0 || exitAnim >= 0) {
                enterAnim = RangesKt.coerceAtLeast((int)enterAnim, (int)0);
                exitAnim = RangesKt.coerceAtLeast((int)exitAnim, (int)0);
                this.hostActivity.overridePendingTransition(enterAnim, exitAnim);
            }
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public ActivityNavigator(@NotNull Context context) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            Sequence sequence = SequencesKt.generateSequence((Object)this.context, (Function1)hostActivity.1.INSTANCE);
            ActivityNavigator activityNavigator = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Context it = (Context)element$iv;
                boolean bl = false;
                if (!(it instanceof Activity)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var9_9 = v0;
        activityNavigator.hostActivity = var9_9;
    }

    @JvmStatic
    public static final void applyPopAnimationsToPendingTransition(@NotNull Activity activity2) {
        Companion.applyPopAnimationsToPendingTransition(activity2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\tJ\u0010\u0010$\u001a\u00020\u00002\b\u0010%\u001a\u0004\u0018\u00010\rJ\u0010\u0010&\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0010\u0010'\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\tJ\u0010\u0010(\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017J\u0010\u0010)\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010\tJ\b\u0010+\u001a\u00020,H\u0017J\b\u0010-\u001a\u00020\tH\u0016R$\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\r8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\b\u001a\u0004\u0018\u00010\u00118F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\b\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\f\u00a8\u0006."}, d2={"Landroidx/navigation/ActivityNavigator$Destination;", "Landroidx/navigation/NavDestination;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "activityNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "<set-?>", "", "action", "getAction", "()Ljava/lang/String;", "Landroid/content/ComponentName;", "component", "getComponent", "()Landroid/content/ComponentName;", "Landroid/net/Uri;", "data", "getData", "()Landroid/net/Uri;", "dataPattern", "getDataPattern", "Landroid/content/Intent;", "intent", "getIntent", "()Landroid/content/Intent;", "targetPackage", "getTargetPackage", "onInflate", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "setAction", "setComponentName", "name", "setData", "setDataPattern", "setIntent", "setTargetPackage", "packageName", "supportsActions", "", "toString", "navigation-runtime_release"})
    @NavDestination.ClassType(value=Activity.class)
    public static class Destination
    extends NavDestination {
        @Nullable
        private Intent intent;
        @Nullable
        private String dataPattern;
        @Nullable
        private String targetPackage;
        @Nullable
        private ComponentName component;
        @Nullable
        private String action;
        @Nullable
        private Uri data;

        @Nullable
        public final Intent getIntent() {
            return this.intent;
        }

        @Nullable
        public final String getDataPattern() {
            return this.dataPattern;
        }

        @NotNull
        public final Destination setIntent(@Nullable Intent intent) {
            this.intent = intent;
            return this;
        }

        @NotNull
        public final Destination setDataPattern(@Nullable String dataPattern) {
            this.dataPattern = dataPattern;
            return this;
        }

        @CallSuper
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.ActivityNavigator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026tyNavigator\n            )");
            TypedArray $this$use$iv = typedArray;
            boolean $i$f$use = false;
            TypedArray array = $this$use$iv;
            boolean bl = false;
            String targetPackage = array.getString(R.styleable.ActivityNavigator_targetPackage);
            if (targetPackage != null) {
                String string = context.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
                targetPackage = StringsKt.replace$default((String)targetPackage, (String)"${applicationId}", (String)string, (boolean)false, (int)4, null);
            }
            this.setTargetPackage(targetPackage);
            String className = array.getString(R.styleable.ActivityNavigator_android_name);
            if (className != null) {
                if (className.charAt(0) == '.') {
                    className = context.getPackageName() + className;
                }
                this.setComponentName(new ComponentName(context, className));
            }
            this.setAction(array.getString(R.styleable.ActivityNavigator_action));
            String data = array.getString(R.styleable.ActivityNavigator_data);
            if (data != null) {
                this.setData(Uri.parse((String)data));
            }
            Destination destination = this.setDataPattern(array.getString(R.styleable.ActivityNavigator_dataPattern));
            boolean bl2 = false;
            boolean bl3 = false;
            Destination it$iv = destination;
            boolean bl4 = false;
            $this$use$iv.recycle();
        }

        @Nullable
        public final String getTargetPackage() {
            Intent intent = this.intent;
            return intent != null ? intent.getPackage() : null;
        }

        @NotNull
        public final Destination setTargetPackage(@Nullable String packageName) {
            if (this.intent == null) {
                this.intent = new Intent();
            }
            Intent intent = this.intent;
            Intrinsics.checkNotNull((Object)intent);
            intent.setPackage(packageName);
            return this;
        }

        @Nullable
        public final ComponentName getComponent() {
            Intent intent = this.intent;
            return intent != null ? intent.getComponent() : null;
        }

        @NotNull
        public final Destination setComponentName(@Nullable ComponentName name) {
            if (this.intent == null) {
                this.intent = new Intent();
            }
            Intent intent = this.intent;
            Intrinsics.checkNotNull((Object)intent);
            intent.setComponent(name);
            return this;
        }

        @Nullable
        public final String getAction() {
            Intent intent = this.intent;
            return intent != null ? intent.getAction() : null;
        }

        @NotNull
        public final Destination setAction(@Nullable String action) {
            if (this.intent == null) {
                this.intent = new Intent();
            }
            Intent intent = this.intent;
            Intrinsics.checkNotNull((Object)intent);
            intent.setAction(action);
            return this;
        }

        @Nullable
        public final Uri getData() {
            Intent intent = this.intent;
            return intent != null ? intent.getData() : null;
        }

        @NotNull
        public final Destination setData(@Nullable Uri data) {
            if (this.intent == null) {
                this.intent = new Intent();
            }
            Intent intent = this.intent;
            Intrinsics.checkNotNull((Object)intent);
            intent.setData(data);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean supportsActions() {
            return false;
        }

        @NotNull
        public String toString() {
            ComponentName componentName = this.getComponent();
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (componentName != null) {
                sb.append(" class=");
                sb.append(componentName.getClassName());
            } else {
                String action = this.getAction();
                if (action != null) {
                    sb.append(" action=");
                    sb.append(action);
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public Destination(@NotNull Navigator<? extends Destination> activityNavigator) {
            Intrinsics.checkNotNullParameter(activityNavigator, (String)"activityNavigator");
            super(activityNavigator);
        }

        public Destination(@NotNull NavigatorProvider navigatorProvider) {
            Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(ActivityNavigator.class));
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/navigation/ActivityNavigator$Extras;", "Landroidx/navigation/Navigator$Extras;", "flags", "", "activityOptions", "Landroidx/core/app/ActivityOptionsCompat;", "(ILandroidx/core/app/ActivityOptionsCompat;)V", "getActivityOptions", "()Landroidx/core/app/ActivityOptionsCompat;", "getFlags", "()I", "Builder", "navigation-runtime_release"})
    public static final class Extras
    implements Navigator.Extras {
        private final int flags;
        @Nullable
        private final ActivityOptionsCompat activityOptions;

        public final int getFlags() {
            return this.flags;
        }

        @Nullable
        public final ActivityOptionsCompat getActivityOptions() {
            return this.activityOptions;
        }

        public Extras(int flags, @Nullable ActivityOptionsCompat activityOptions) {
            this.flags = flags;
            this.activityOptions = activityOptions;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/navigation/ActivityNavigator$Extras$Builder;", "", "()V", "activityOptions", "Landroidx/core/app/ActivityOptionsCompat;", "flags", "", "addFlags", "build", "Landroidx/navigation/ActivityNavigator$Extras;", "setActivityOptions", "navigation-runtime_release"})
        public static final class Builder {
            private int flags;
            private ActivityOptionsCompat activityOptions;

            @NotNull
            public final Builder addFlags(int flags) {
                this.flags |= flags;
                return this;
            }

            @NotNull
            public final Builder setActivityOptions(@NotNull ActivityOptionsCompat activityOptions) {
                Intrinsics.checkNotNullParameter((Object)activityOptions, (String)"activityOptions");
                this.activityOptions = activityOptions;
                return this;
            }

            @NotNull
            public final Extras build() {
                return new Extras(this.flags, this.activityOptions);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/navigation/ActivityNavigator$Companion;", "", "()V", "EXTRA_NAV_CURRENT", "", "EXTRA_NAV_SOURCE", "EXTRA_POP_ENTER_ANIM", "EXTRA_POP_EXIT_ANIM", "LOG_TAG", "applyPopAnimationsToPendingTransition", "", "activity", "Landroid/app/Activity;", "navigation-runtime_release"})
    public static final class Companion {
        @JvmStatic
        public final void applyPopAnimationsToPendingTransition(@NotNull Activity activity2) {
            Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
            Intent intent = activity2.getIntent();
            if (intent == null) {
                return;
            }
            Intent intent2 = intent;
            int popEnterAnim = intent2.getIntExtra(ActivityNavigator.EXTRA_POP_ENTER_ANIM, -1);
            int popExitAnim = intent2.getIntExtra(ActivityNavigator.EXTRA_POP_EXIT_ANIM, -1);
            if (popEnterAnim != -1 || popExitAnim != -1) {
                popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
                popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
                activity2.overridePendingTransition(popEnterAnim, popExitAnim);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

