/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.MainThread;
import androidx.annotation.NavigationRes;
import androidx.annotation.RestrictTo;
import androidx.core.app.TaskStackBuilder;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavAction;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavBackStackEntryState;
import androidx.navigation.NavController;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDeepLinkBuilder;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.NavDirections;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.NavOptionsBuilder;
import androidx.navigation.NavOptionsBuilderKt;
import androidx.navigation.NavViewModelStoreProvider;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.NavigatorState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u009e\u00012\u00020\u0001:\u0006\u009e\u0001\u009f\u0001\u00a0\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010Z\u001a\u00020\u00132\u0006\u0010[\u001a\u00020,2\b\u0010\\\u001a\u0004\u0018\u00010N2\u0006\u0010\u0012\u001a\u00020\u00072\u000e\b\u0002\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00070^H\u0002J\u0010\u0010_\u001a\u00020\u00132\u0006\u0010`\u001a\u00020SH\u0016J\b\u0010a\u001a\u00020bH\u0016J\b\u0010c\u001a\u000200H\u0002J\u0010\u0010d\u001a\u00020\u00132\u0006\u0010e\u001a\u000200H\u0017J\u0014\u0010f\u001a\u0004\u0018\u00010,2\b\b\u0001\u0010g\u001a\u00020\u001aH\u0007J\u0012\u0010f\u001a\u0004\u0018\u00010,2\u0006\u0010h\u001a\u00020\u001bH\u0007J\u0012\u0010i\u001a\u0004\u0018\u00010\u001b2\u0006\u0010j\u001a\u00020kH\u0002J\u0012\u0010l\u001a\u00020\u00072\b\b\u0001\u0010g\u001a\u00020\u001aH\u0016J\u000e\u0010l\u001a\u00020\u00072\u0006\u0010m\u001a\u00020\u001bJ\u0012\u0010n\u001a\u00020o2\b\b\u0001\u0010p\u001a\u00020\u001aH\u0016J\u0012\u0010q\u001a\u0002002\b\u0010r\u001a\u0004\u0018\u00010sH\u0017J\u001e\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00070^2\u000e\u0010u\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u0015H\u0002J\u0010\u0010v\u001a\u00020\u00132\u0006\u0010j\u001a\u00020wH\u0017J\u001a\u0010v\u001a\u00020\u00132\u0006\u0010j\u001a\u00020w2\b\u0010x\u001a\u0004\u0018\u00010yH\u0017J$\u0010v\u001a\u00020\u00132\u0006\u0010j\u001a\u00020w2\b\u0010x\u001a\u0004\u0018\u00010y2\b\u0010z\u001a\u0004\u0018\u00010{H\u0017J\u0010\u0010v\u001a\u00020\u00132\u0006\u0010|\u001a\u00020}H\u0017J\u001a\u0010v\u001a\u00020\u00132\u0006\u0010|\u001a\u00020}2\b\u0010x\u001a\u0004\u0018\u00010yH\u0017J$\u0010v\u001a\u00020\u00132\u0006\u0010|\u001a\u00020}2\b\u0010x\u001a\u0004\u0018\u00010y2\b\u0010z\u001a\u0004\u0018\u00010{H\u0017J.\u0010v\u001a\u00020\u00132\u0006\u0010[\u001a\u00020,2\b\u0010~\u001a\u0004\u0018\u00010N2\b\u0010x\u001a\u0004\u0018\u00010y2\b\u0010z\u001a\u0004\u0018\u00010{H\u0003J\u0011\u0010v\u001a\u00020\u00132\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0017J\u001b\u0010v\u001a\u00020\u00132\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010x\u001a\u0004\u0018\u00010yH\u0017J\u0019\u0010v\u001a\u00020\u00132\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010z\u001a\u00020{H\u0017J\u0013\u0010v\u001a\u00020\u00132\t\b\u0001\u0010\u0081\u0001\u001a\u00020\u001aH\u0017J\u001d\u0010v\u001a\u00020\u00132\t\b\u0001\u0010\u0081\u0001\u001a\u00020\u001a2\b\u0010~\u001a\u0004\u0018\u00010NH\u0017J'\u0010v\u001a\u00020\u00132\t\b\u0001\u0010\u0081\u0001\u001a\u00020\u001a2\b\u0010~\u001a\u0004\u0018\u00010N2\b\u0010x\u001a\u0004\u0018\u00010yH\u0017J1\u0010v\u001a\u00020\u00132\t\b\u0001\u0010\u0081\u0001\u001a\u00020\u001a2\b\u0010~\u001a\u0004\u0018\u00010N2\b\u0010x\u001a\u0004\u0018\u00010y2\b\u0010z\u001a\u0004\u0018\u00010{H\u0017J(\u0010v\u001a\u00020\u00132\u0006\u0010m\u001a\u00020\u001b2\n\b\u0002\u0010x\u001a\u0004\u0018\u00010y2\n\b\u0002\u0010z\u001a\u0004\u0018\u00010{H\u0007J*\u0010v\u001a\u00020\u00132\u0006\u0010m\u001a\u00020\u001b2\u001a\u0010\u0082\u0001\u001a\u0015\u0012\u0005\u0012\u00030\u0083\u0001\u0012\u0004\u0012\u00020\u00130\u000f\u00a2\u0006\u0003\b\u0084\u0001J\t\u0010\u0085\u0001\u001a\u000200H\u0017J\u0014\u0010\u0086\u0001\u001a\u00020\u00132\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010NH\u0003J\t\u0010\u0088\u0001\u001a\u000200H\u0017J\u001c\u0010\u0088\u0001\u001a\u0002002\b\b\u0001\u0010g\u001a\u00020\u001a2\u0007\u0010\u0089\u0001\u001a\u000200H\u0017J%\u0010\u0088\u0001\u001a\u0002002\b\b\u0001\u0010g\u001a\u00020\u001a2\u0007\u0010\u0089\u0001\u001a\u0002002\u0007\u0010\u008a\u0001\u001a\u000200H\u0017J%\u0010\u0088\u0001\u001a\u0002002\u0006\u0010m\u001a\u00020\u001b2\u0007\u0010\u0089\u0001\u001a\u0002002\t\b\u0002\u0010\u008a\u0001\u001a\u000200H\u0007J'\u0010\u008b\u0001\u001a\u0002002\b\b\u0001\u0010g\u001a\u00020\u001a2\u0007\u0010\u0089\u0001\u001a\u0002002\t\b\u0002\u0010\u008a\u0001\u001a\u000200H\u0003J)\u0010\u008c\u0001\u001a\u00020\u00132\u0006\u0010U\u001a\u00020\u00072\u0007\u0010\u008a\u0001\u001a\u0002002\r\u0010\u008d\u0001\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015H\u0002J\u0011\u0010\u008e\u0001\u001a\u00020\u00132\u0006\u0010`\u001a\u00020SH\u0016J\u0014\u0010\u008f\u0001\u001a\u00020\u00132\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010NH\u0017J\u000b\u0010\u008a\u0001\u001a\u0004\u0018\u00010NH\u0017J\u001b\u00108\u001a\u00020\u00132\u0006\u00105\u001a\u00020\t2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010NH\u0017J\u0013\u00108\u001a\u00020\u00132\t\b\u0001\u0010\u0091\u0001\u001a\u00020\u001aH\u0017J\u001e\u00108\u001a\u00020\u00132\t\b\u0001\u0010\u0091\u0001\u001a\u00020\u001a2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010NH\u0017J\u0012\u0010\u0092\u0001\u001a\u00020\u00132\u0007\u0010\u0093\u0001\u001a\u00020?H\u0017J\u0013\u0010\u0094\u0001\u001a\u00020\u00132\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0017J\u0013\u0010\u0097\u0001\u001a\u00020\u00132\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0017J\t\u0010\u009a\u0001\u001a\u00020\u0013H\u0002J\u0018\u0010f\u001a\u0004\u0018\u00010,*\u00020,2\b\b\u0001\u0010g\u001a\u00020\u001aH\u0002J^\u0010\u009b\u0001\u001a\u00020\u0013*\n\u0012\u0006\b\u0001\u0012\u00020,0K2\r\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070^2\b\u0010x\u001a\u0004\u0018\u00010y2\b\u0010z\u001a\u0004\u0018\u00010{2$\b\u0002\u0010\u009d\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fH\u0002JL\u0010\u008b\u0001\u001a\u00020\u0013*\n\u0012\u0006\b\u0001\u0012\u00020,0K2\u0006\u0010U\u001a\u00020\u00072\u0007\u0010\u008a\u0001\u001a\u0002002$\b\u0002\u0010\u009d\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(U\u0012\u0004\u0012\u00020\u00130\u000fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u000e\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00150\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\t2\u0006\u00105\u001a\u00020\t8W@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010@\u001a\u00020;8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bA\u0010BR$\u0010E\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u000b8V@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR&\u0010J\u001a\u001a\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020,0K\u0012\b\u0012\u00060LR\u00020\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010T\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(U\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010V\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010&R\u0010\u0010X\u001a\u0004\u0018\u00010YX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a1\u0001"}, d2={"Landroidx/navigation/NavController;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "_currentBackStackEntryFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Landroidx/navigation/NavBackStackEntry;", "_graph", "Landroidx/navigation/NavGraph;", "_navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "activity", "Landroid/app/Activity;", "addToBackStackHandler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "backStackEntry", "", "backQueue", "Lkotlin/collections/ArrayDeque;", "getBackQueue", "()Lkotlin/collections/ArrayDeque;", "backStackMap", "", "", "", "backStackStates", "Landroidx/navigation/NavBackStackEntryState;", "backStackToRestore", "", "Landroid/os/Parcelable;", "[Landroid/os/Parcelable;", "getContext", "()Landroid/content/Context;", "currentBackStackEntry", "getCurrentBackStackEntry", "()Landroidx/navigation/NavBackStackEntry;", "currentBackStackEntryFlow", "Lkotlinx/coroutines/flow/Flow;", "getCurrentBackStackEntryFlow", "()Lkotlinx/coroutines/flow/Flow;", "currentDestination", "Landroidx/navigation/NavDestination;", "getCurrentDestination", "()Landroidx/navigation/NavDestination;", "deepLinkHandled", "", "destinationCountOnBackStack", "getDestinationCountOnBackStack", "()I", "enableOnBackPressedCallback", "graph", "getGraph", "()Landroidx/navigation/NavGraph;", "setGraph", "(Landroidx/navigation/NavGraph;)V", "inflater", "Landroidx/navigation/NavInflater;", "lifecycleObserver", "Landroidx/lifecycle/LifecycleObserver;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "navInflater", "getNavInflater", "()Landroidx/navigation/NavInflater;", "navInflater$delegate", "Lkotlin/Lazy;", "navigatorProvider", "getNavigatorProvider", "()Landroidx/navigation/NavigatorProvider;", "setNavigatorProvider", "(Landroidx/navigation/NavigatorProvider;)V", "navigatorState", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavController$NavControllerNavigatorState;", "navigatorStateToRestore", "Landroid/os/Bundle;", "onBackPressedCallback", "Landroidx/activity/OnBackPressedCallback;", "onDestinationChangedListeners", "", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "popFromBackStackHandler", "popUpTo", "previousBackStackEntry", "getPreviousBackStackEntry", "viewModel", "Landroidx/navigation/NavControllerViewModel;", "addEntryToBackStack", "node", "finalArgs", "restoredEntries", "", "addOnDestinationChangedListener", "listener", "createDeepLink", "Landroidx/navigation/NavDeepLinkBuilder;", "dispatchOnDestinationChanged", "enableOnBackPressed", "enabled", "findDestination", "destinationId", "destinationRoute", "findInvalidDestinationDisplayNameInDeepLink", "deepLink", "", "getBackStackEntry", "route", "getViewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "navGraphId", "handleDeepLink", "intent", "Landroid/content/Intent;", "instantiateBackStack", "backStackState", "navigate", "Landroid/net/Uri;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "request", "Landroidx/navigation/NavDeepLinkRequest;", "args", "directions", "Landroidx/navigation/NavDirections;", "resId", "builder", "Landroidx/navigation/NavOptionsBuilder;", "Lkotlin/ExtensionFunctionType;", "navigateUp", "onGraphCreated", "startDestinationArgs", "popBackStack", "inclusive", "saveState", "popBackStackInternal", "popEntryFromBackStack", "savedState", "removeOnDestinationChangedListener", "restoreState", "navState", "graphResId", "setLifecycleOwner", "owner", "setOnBackPressedDispatcher", "dispatcher", "Landroidx/activity/OnBackPressedDispatcher;", "setViewModelStore", "viewModelStore", "Landroidx/lifecycle/ViewModelStore;", "updateOnBackPressedCallbackEnabled", "navigateInternal", "entries", "handler", "Companion", "NavControllerNavigatorState", "OnDestinationChangedListener", "navigation-runtime_release"})
public class NavController {
    private Activity activity;
    private NavInflater inflater;
    private NavGraph _graph;
    private Bundle navigatorStateToRestore;
    private Parcelable[] backStackToRestore;
    private boolean deepLinkHandled;
    @NotNull
    private final ArrayDeque<NavBackStackEntry> backQueue;
    private final Map<Integer, String> backStackMap;
    private final Map<String, ArrayDeque<NavBackStackEntryState>> backStackStates;
    private LifecycleOwner lifecycleOwner;
    private NavControllerViewModel viewModel;
    private final List<OnDestinationChangedListener> onDestinationChangedListeners;
    private final LifecycleObserver lifecycleObserver;
    private final OnBackPressedCallback onBackPressedCallback;
    private boolean enableOnBackPressedCallback;
    private NavigatorProvider _navigatorProvider;
    private final Map<Navigator<? extends NavDestination>, NavControllerNavigatorState> navigatorState;
    private Function1<? super NavBackStackEntry, Unit> addToBackStackHandler;
    private Function1<? super NavBackStackEntry, Unit> popFromBackStackHandler;
    @NotNull
    private final Lazy navInflater$delegate;
    private final MutableSharedFlow<NavBackStackEntry> _currentBackStackEntryFlow;
    @NotNull
    private final Flow<NavBackStackEntry> currentBackStackEntryFlow;
    @NotNull
    private final Context context;
    private static final String TAG = "NavController";
    private static final String KEY_NAVIGATOR_STATE = "android-support-nav:controller:navigatorState";
    private static final String KEY_NAVIGATOR_STATE_NAMES = "android-support-nav:controller:navigatorState:names";
    private static final String KEY_BACK_STACK = "android-support-nav:controller:backStack";
    private static final String KEY_BACK_STACK_DEST_IDS = "android-support-nav:controller:backStackDestIds";
    private static final String KEY_BACK_STACK_IDS = "android-support-nav:controller:backStackIds";
    private static final String KEY_BACK_STACK_STATES_IDS = "android-support-nav:controller:backStackStates";
    private static final String KEY_BACK_STACK_STATES_PREFIX = "android-support-nav:controller:backStackStates:";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String KEY_DEEP_LINK_IDS = "android-support-nav:controller:deepLinkIds";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String KEY_DEEP_LINK_ARGS = "android-support-nav:controller:deepLinkArgs";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String KEY_DEEP_LINK_EXTRAS = "android-support-nav:controller:deepLinkExtras";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String KEY_DEEP_LINK_HANDLED = "android-support-nav:controller:deepLinkHandled";
    @NotNull
    public static final String KEY_DEEP_LINK_INTENT = "android-support-nav:controller:deepLinkIntent";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @MainThread
    @NotNull
    public NavGraph getGraph() {
        NavGraph navGraph = this._graph;
        boolean bl = false;
        boolean bl2 = false;
        if (navGraph == null) {
            boolean bl3 = false;
            String string = "You must call setGraph() before calling getGraph()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NavGraph navGraph2 = this._graph;
        if (navGraph2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavGraph");
        }
        return navGraph2;
    }

    @MainThread
    @CallSuper
    public void setGraph(@NotNull NavGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.setGraph(graph, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public ArrayDeque<NavBackStackEntry> getBackQueue() {
        return this.backQueue;
    }

    @NotNull
    public NavigatorProvider getNavigatorProvider() {
        return this._navigatorProvider;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setNavigatorProvider(@NotNull NavigatorProvider navigatorProvider) {
        Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
        boolean bl = this.getBackQueue().isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "NavigatorProvider must be set before setGraph call";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this._navigatorProvider = navigatorProvider;
    }

    private final void navigateInternal(Navigator<? extends NavDestination> $this$navigateInternal, List<NavBackStackEntry> entries, NavOptions navOptions, Navigator.Extras navigatorExtras, Function1<? super NavBackStackEntry, Unit> handler) {
        this.addToBackStackHandler = handler;
        $this$navigateInternal.navigate(entries, navOptions, navigatorExtras);
        this.addToBackStackHandler = null;
    }

    static /* synthetic */ void navigateInternal$default(NavController navController, Navigator navigator, List list, NavOptions navOptions, Navigator.Extras extras, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigateInternal");
        }
        if ((n & 8) != 0) {
            function1 = navigateInternal.1.INSTANCE;
        }
        navController.navigateInternal((Navigator<? extends NavDestination>)navigator, list, navOptions, extras, (Function1<? super NavBackStackEntry, Unit>)function1);
    }

    private final void popBackStackInternal(Navigator<? extends NavDestination> $this$popBackStackInternal, NavBackStackEntry popUpTo, boolean saveState, Function1<? super NavBackStackEntry, Unit> handler) {
        this.popFromBackStackHandler = handler;
        $this$popBackStackInternal.popBackStack(popUpTo, saveState);
        this.popFromBackStackHandler = null;
    }

    static /* synthetic */ void popBackStackInternal$default(NavController navController, Navigator navigator, NavBackStackEntry navBackStackEntry, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: popBackStackInternal");
        }
        if ((n & 4) != 0) {
            function1 = popBackStackInternal.1.INSTANCE;
        }
        navController.popBackStackInternal((Navigator<? extends NavDestination>)navigator, navBackStackEntry, bl, (Function1<? super NavBackStackEntry, Unit>)function1);
    }

    public void addOnDestinationChangedListener(@NotNull OnDestinationChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Collection collection = (Collection)this.getBackQueue();
        boolean bl = false;
        if (!collection.isEmpty()) {
            NavBackStackEntry backStackEntry = (NavBackStackEntry)this.getBackQueue().last();
            listener.onDestinationChanged(this, backStackEntry.getDestination(), backStackEntry.getArguments());
        }
        this.onDestinationChangedListeners.add(listener);
    }

    public void removeOnDestinationChangedListener(@NotNull OnDestinationChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.onDestinationChangedListeners.remove(listener);
    }

    @MainThread
    public boolean popBackStack() {
        boolean bl;
        if (this.getBackQueue().isEmpty()) {
            bl = false;
        } else {
            NavDestination navDestination = this.getCurrentDestination();
            Intrinsics.checkNotNull((Object)navDestination);
            bl = this.popBackStack(navDestination.getId(), true);
        }
        return bl;
    }

    @MainThread
    public boolean popBackStack(@IdRes int destinationId, boolean inclusive) {
        return this.popBackStack(destinationId, inclusive, false);
    }

    @MainThread
    public boolean popBackStack(@IdRes int destinationId, boolean inclusive, boolean saveState) {
        boolean popped = this.popBackStackInternal(destinationId, inclusive, saveState);
        return popped && this.dispatchOnDestinationChanged();
    }

    @MainThread
    @JvmOverloads
    public final boolean popBackStack(@NotNull String route, boolean inclusive, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        return this.popBackStack(NavDestination.Companion.createRoute(route).hashCode(), inclusive, saveState);
    }

    public static /* synthetic */ boolean popBackStack$default(NavController navController, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: popBackStack");
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return navController.popBackStack(string, bl, bl2);
    }

    @MainThread
    @JvmOverloads
    public final boolean popBackStack(@NotNull String route, boolean inclusive) {
        return NavController.popBackStack$default(this, route, inclusive, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    private final boolean popBackStackInternal(@IdRes int destinationId, boolean inclusive, boolean saveState) {
        void popped;
        Iterator receivedPop;
        Object destinationName;
        if (this.getBackQueue().isEmpty()) {
            return false;
        }
        boolean bl = false;
        List popOperations = new ArrayList();
        Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)this.getBackQueue())).iterator();
        NavDestination foundDestination = null;
        while (iterator.hasNext()) {
            NavDestination destination = ((NavBackStackEntry)iterator.next()).getDestination();
            Navigator navigator = this._navigatorProvider.getNavigator(destination.getNavigatorName());
            if (inclusive || destination.getId() != destinationId) {
                popOperations.add(navigator);
            }
            if (destination.getId() != destinationId) continue;
            foundDestination = destination;
            break;
        }
        if (foundDestination == null) {
            destinationName = NavDestination.Companion.getDisplayName(this.context, destinationId);
            Log.i((String)TAG, (String)("Ignoring popBackStack to destination " + (String)destinationName + " as it was not found " + "on the current back stack"));
            return false;
        }
        destinationName = new Ref.BooleanRef();
        destinationName.element = false;
        ArrayDeque savedState = new ArrayDeque();
        for (Navigator navigator : popOperations) {
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            this.popBackStackInternal((Navigator<? extends NavDestination>)navigator, (NavBackStackEntry)this.getBackQueue().last(), saveState, (Function1<? super NavBackStackEntry, Unit>)((Function1)new Function1<NavBackStackEntry, Unit>(this, (Ref.BooleanRef)receivedPop, (Ref.BooleanRef)popped, saveState, savedState){
                final /* synthetic */ NavController this$0;
                final /* synthetic */ Ref.BooleanRef $receivedPop;
                final /* synthetic */ Ref.BooleanRef $popped;
                final /* synthetic */ boolean $saveState;
                final /* synthetic */ ArrayDeque $savedState;

                public final void invoke(@NotNull NavBackStackEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    this.$receivedPop.element = true;
                    this.$popped.element = true;
                    NavController.access$popEntryFromBackStack(this.this$0, entry, this.$saveState, this.$savedState);
                }
                {
                    this.this$0 = navController;
                    this.$receivedPop = booleanRef;
                    this.$popped = booleanRef2;
                    this.$saveState = bl;
                    this.$savedState = arrayDeque;
                    super(1);
                }
            }));
            if (((Ref.BooleanRef)receivedPop).element) continue;
            break;
        }
        if (saveState) {
            Collection $this$forEach$iv;
            if (!inclusive) {
                Navigator navigator;
                navigator = SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)foundDestination, (Function1)popBackStackInternal.3.INSTANCE), (Function1)((Function1)new Function1<NavDestination, Boolean>(this){
                    final /* synthetic */ NavController this$0;

                    public final boolean invoke(@NotNull NavDestination destination) {
                        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                        return !NavController.access$getBackStackMap$p(this.this$0).containsKey(destination.getId());
                    }
                    {
                        this.this$0 = navController;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    NavDestination destination = (NavDestination)element$iv;
                    boolean bl2 = false;
                    NavBackStackEntryState navBackStackEntryState = (NavBackStackEntryState)savedState.firstOrNull();
                    this.backStackMap.put(destination.getId(), navBackStackEntryState != null ? navBackStackEntryState.getId() : null);
                }
            }
            $this$forEach$iv = (Collection)savedState;
            boolean $i$f$forEach = false;
            if (!$this$forEach$iv.isEmpty()) {
                void $this$forEach$iv2;
                NavBackStackEntryState firstState = (NavBackStackEntryState)savedState.first();
                NavDestination firstStateDestination = this.findDestination(firstState.getDestinationId());
                receivedPop = SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)firstStateDestination, (Function1)popBackStackInternal.6.INSTANCE), (Function1)((Function1)new Function1<NavDestination, Boolean>(this){
                    final /* synthetic */ NavController this$0;

                    public final boolean invoke(@NotNull NavDestination destination) {
                        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                        return !NavController.access$getBackStackMap$p(this.this$0).containsKey(destination.getId());
                    }
                    {
                        this.this$0 = navController;
                        super(1);
                    }
                }));
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    NavDestination destination = (NavDestination)element$iv;
                    boolean bl3 = false;
                    this.backStackMap.put(destination.getId(), firstState.getId());
                }
                this.backStackStates.put(firstState.getId(), (ArrayDeque<NavBackStackEntryState>)savedState);
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        return popped.element;
    }

    static /* synthetic */ boolean popBackStackInternal$default(NavController navController, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: popBackStackInternal");
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return navController.popBackStackInternal(n, bl, bl2);
    }

    private final void popEntryFromBackStack(NavBackStackEntry popUpTo, boolean saveState, ArrayDeque<NavBackStackEntryState> savedState) {
        block4: {
            NavBackStackEntry entry = (NavBackStackEntry)this.getBackQueue().last();
            boolean bl = Intrinsics.areEqual((Object)entry, (Object)popUpTo);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Attempted to pop " + popUpTo.getDestination() + ", which is not the top of the back stack " + '(' + entry.getDestination() + ')';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.getBackQueue().removeLast();
            if (entry.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.CREATED)) {
                if (saveState) {
                    entry.setMaxLifecycle(Lifecycle.State.CREATED);
                    savedState.addFirst((Object)new NavBackStackEntryState(entry));
                }
                entry.setMaxLifecycle(Lifecycle.State.DESTROYED);
            }
            if (saveState) break block4;
            NavControllerViewModel navControllerViewModel = this.viewModel;
            if (navControllerViewModel != null) {
                navControllerViewModel.clear(entry.getId());
            }
        }
    }

    @MainThread
    public boolean navigateUp() {
        boolean bl;
        if (this.getDestinationCountOnBackStack() == 1) {
            NavDestination currentDestination;
            NavDestination navDestination = currentDestination = this.getCurrentDestination();
            Intrinsics.checkNotNull((Object)navDestination);
            int destId = navDestination.getId();
            for (NavGraph parent = currentDestination.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getStartDestinationId() != destId) {
                    Bundle args = new Bundle();
                    if (this.activity != null) {
                        Activity activity2 = this.activity;
                        Intrinsics.checkNotNull((Object)activity2);
                        if (activity2.getIntent() != null) {
                            Activity activity3 = this.activity;
                            Intrinsics.checkNotNull((Object)activity3);
                            Intent intent = activity3.getIntent();
                            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"activity!!.intent");
                            Uri data = intent.getData();
                            if (data != null) {
                                Activity activity4 = this.activity;
                                Intrinsics.checkNotNull((Object)activity4);
                                args.putParcelable(KEY_DEEP_LINK_INTENT, (Parcelable)activity4.getIntent());
                                NavGraph navGraph = this._graph;
                                Intrinsics.checkNotNull((Object)navGraph);
                                Activity activity5 = this.activity;
                                Intrinsics.checkNotNull((Object)activity5);
                                Intent intent2 = activity5.getIntent();
                                Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"activity!!.intent");
                                NavDestination.DeepLinkMatch matchingDeepLink = navGraph.matchDeepLink(new NavDeepLinkRequest(intent2));
                                if (matchingDeepLink != null) {
                                    Bundle destinationArgs = matchingDeepLink.getDestination().addInDefaultArgs(matchingDeepLink.getMatchingArgs());
                                    args.putAll(destinationArgs);
                                }
                            }
                        }
                    }
                    TaskStackBuilder parentIntents = NavDeepLinkBuilder.setDestination$default(new NavDeepLinkBuilder(this), parent.getId(), null, 2, null).setArguments(args).createTaskStackBuilder();
                    parentIntents.startActivities();
                    Activity activity6 = this.activity;
                    if (activity6 != null) {
                        activity6.finish();
                    }
                    return true;
                }
                destId = parent.getId();
            }
            bl = false;
        } else {
            bl = this.popBackStack();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final int getDestinationCountOnBackStack() {
        int n;
        Iterable $this$count$iv = (Iterable)this.getBackQueue();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!(!(entry.getDestination() instanceof NavGraph))) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    private final boolean dispatchOnDestinationChanged() {
        while (!this.getBackQueue().isEmpty() && ((NavBackStackEntry)this.getBackQueue().last()).getDestination() instanceof NavGraph && NavController.popBackStackInternal$default(this, ((NavBackStackEntry)this.getBackQueue().last()).getDestination().getId(), true, false, 4, null)) {
        }
        if (!this.getBackQueue().isEmpty()) {
            NavDestination nextResumed = ((NavBackStackEntry)this.getBackQueue().last()).getDestination();
            NavDestination nextStarted = null;
            if (nextResumed instanceof FloatingWindow) {
                Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)this.getBackQueue())).iterator();
                while (iterator.hasNext()) {
                    NavDestination destination = ((NavBackStackEntry)iterator.next()).getDestination();
                    if (destination instanceof NavGraph || destination instanceof FloatingWindow) continue;
                    nextStarted = destination;
                    break;
                }
            }
            HashMap upwardStateTransitions = new HashMap();
            for (NavBackStackEntry entry : CollectionsKt.reversed((Iterable)((Iterable)this.getBackQueue()))) {
                Lifecycle.State currentMaxLifecycle = entry.getMaxLifecycle();
                NavDestination destination = entry.getDestination();
                if (nextResumed != null && destination.getId() == nextResumed.getId()) {
                    if (currentMaxLifecycle != Lifecycle.State.RESUMED) {
                        ((Map)upwardStateTransitions).put(entry, Lifecycle.State.RESUMED);
                    }
                    nextResumed = (NavDestination)nextResumed.getParent();
                    continue;
                }
                if (nextStarted != null && destination.getId() == nextStarted.getId()) {
                    if (currentMaxLifecycle == Lifecycle.State.RESUMED) {
                        entry.setMaxLifecycle(Lifecycle.State.STARTED);
                    } else if (currentMaxLifecycle != Lifecycle.State.STARTED) {
                        ((Map)upwardStateTransitions).put(entry, Lifecycle.State.STARTED);
                    }
                    nextStarted = (NavDestination)nextStarted.getParent();
                    continue;
                }
                entry.setMaxLifecycle(Lifecycle.State.CREATED);
            }
            for (NavBackStackEntry entry : this.getBackQueue()) {
                Lifecycle.State newState = (Lifecycle.State)upwardStateTransitions.get(entry);
                if (newState != null) {
                    entry.setMaxLifecycle(newState);
                    continue;
                }
                entry.updateState();
            }
            NavBackStackEntry backStackEntry = (NavBackStackEntry)this.getBackQueue().last();
            for (OnDestinationChangedListener listener : this.onDestinationChangedListeners) {
                listener.onDestinationChanged(this, backStackEntry.getDestination(), backStackEntry.getArguments());
            }
            this._currentBackStackEntryFlow.tryEmit((Object)backStackEntry);
            return true;
        }
        return false;
    }

    @NotNull
    public NavInflater getNavInflater() {
        Lazy lazy = this.navInflater$delegate;
        NavController navController = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NavInflater)lazy.getValue();
    }

    @MainThread
    @CallSuper
    public void setGraph(@NavigationRes int graphResId) {
        this.setGraph(this.getNavInflater().inflate(graphResId), null);
    }

    @MainThread
    @CallSuper
    public void setGraph(@NavigationRes int graphResId, @Nullable Bundle startDestinationArgs) {
        this.setGraph(this.getNavInflater().inflate(graphResId), startDestinationArgs);
    }

    @MainThread
    @CallSuper
    public void setGraph(@NotNull NavGraph graph, @Nullable Bundle startDestinationArgs) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        NavGraph navGraph = this._graph;
        if (navGraph != null) {
            NavGraph navGraph2 = navGraph;
            boolean bl = false;
            boolean bl2 = false;
            NavGraph previousGraph = navGraph2;
            boolean bl3 = false;
            NavController.popBackStackInternal$default(this, previousGraph.getId(), true, false, 4, null);
        }
        this._graph = graph;
        this.onGraphCreated(startDestinationArgs);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @MainThread
    private final void onGraphCreated(Bundle startDestinationArgs) {
        void $this$filterNotTo$iv$iv;
        boolean bl;
        Bundle bundle = this.navigatorStateToRestore;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            bl = false;
            boolean bl2 = false;
            Bundle bundle3 = bundle2;
            boolean bl3 = false;
            ArrayList navigatorNames = bundle3.getStringArrayList(KEY_NAVIGATOR_STATE_NAMES);
            if (navigatorNames != null) {
                Iterator iterator = navigatorNames.iterator();
                while (iterator.hasNext()) {
                    NavControllerNavigatorState navControllerNavigatorState;
                    String name;
                    String string = name = (String)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    Navigator navigator = this._navigatorProvider.getNavigator(string);
                    Map<Navigator<? extends NavDestination>, NavControllerNavigatorState> $this$getOrPut$iv = this.navigatorState;
                    boolean $i$f$getOrPut = false;
                    NavControllerNavigatorState value$iv = $this$getOrPut$iv.get(navigator);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        NavControllerNavigatorState answer$iv = new NavControllerNavigatorState((Navigator<? extends NavDestination>)navigator);
                        $this$getOrPut$iv.put((Navigator<? extends NavDestination>)navigator, answer$iv);
                        navControllerNavigatorState = answer$iv;
                    } else {
                        navControllerNavigatorState = value$iv;
                    }
                    NavControllerNavigatorState navigatorBackStack = navControllerNavigatorState;
                    navigator.onAttach((NavigatorState)navigatorBackStack);
                    Bundle bundle4 = bundle3.getBundle(name);
                    if (bundle4 == null) continue;
                    navigator.onRestoreState(bundle4);
                }
            }
        }
        Iterable $this$filterNot$iv = this._navigatorProvider.getNavigators().values();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Navigator it = (Navigator)element$iv$iv;
            boolean bl5 = false;
            if (it.isAttached()) continue;
            collection.add(element$iv$iv);
        }
        Parcelable[] $this$forEach$iv = (Parcelable[])((List)collection);
        boolean $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            NavControllerNavigatorState navControllerNavigatorState;
            Navigator navigator = (Navigator)e;
            boolean bl6 = false;
            Map<Navigator<? extends NavDestination>, NavControllerNavigatorState> $this$getOrPut$iv = this.navigatorState;
            boolean $i$f$getOrPut = false;
            NavControllerNavigatorState value$iv = $this$getOrPut$iv.get(navigator);
            if (value$iv == null) {
                boolean bl7 = false;
                NavControllerNavigatorState answer$iv = new NavControllerNavigatorState((Navigator<? extends NavDestination>)navigator);
                $this$getOrPut$iv.put((Navigator<? extends NavDestination>)navigator, answer$iv);
                navControllerNavigatorState = answer$iv;
            } else {
                navControllerNavigatorState = value$iv;
            }
            NavControllerNavigatorState navigatorBackStack = navControllerNavigatorState;
            navigator.onAttach((NavigatorState)navigatorBackStack);
        }
        if (this.backStackToRestore != null) {
            $this$forEach$iv = this.backStackToRestore;
            bl = false;
            boolean bl8 = false;
            Parcelable[] parcelableArray = $this$forEach$iv;
            boolean bl9 = false;
            Parcelable[] parcelableArray2 = parcelableArray;
            int n = parcelableArray2.length;
            for (int i = 0; i < n; ++i) {
                Parcelable parcelable;
                Parcelable parcelable2 = parcelable = parcelableArray2[i];
                if (parcelable2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavBackStackEntryState");
                }
                NavBackStackEntryState state = (NavBackStackEntryState)parcelable2;
                NavDestination node = this.findDestination(state.getDestinationId());
                if (node == null) {
                    String dest = NavDestination.Companion.getDisplayName(this.context, state.getDestinationId());
                    throw (Throwable)new IllegalStateException("Restoring the Navigation back stack failed: destination " + dest + " cannot be " + "found from the current destination " + this.getCurrentDestination());
                }
                NavBackStackEntry entry = state.instantiate(this.context, node, this.lifecycleOwner, this.viewModel);
                Navigator navigator = this._navigatorProvider.getNavigator(node.getNavigatorName());
                NavControllerNavigatorState navControllerNavigatorState = this.navigatorState.get(navigator);
                boolean bl10 = false;
                boolean bl11 = false;
                if (navControllerNavigatorState == null) {
                    boolean bl12 = false;
                    String string = "NavigatorBackStack for " + node.getNavigatorName() + " should already be created";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                NavControllerNavigatorState navigatorBackStack = navControllerNavigatorState;
                this.getBackQueue().add((Object)entry);
                navigatorBackStack.addInternal(entry);
            }
            this.updateOnBackPressedCallbackEnabled();
            this.backStackToRestore = null;
        }
        if (this._graph != null && this.getBackQueue().isEmpty()) {
            if (!this.deepLinkHandled && this.activity != null) {
                Activity activity2 = this.activity;
                Intrinsics.checkNotNull((Object)activity2);
                if (this.handleDeepLink(activity2.getIntent())) {
                    return;
                }
            }
            boolean bl13 = false;
            boolean deepLinked = bl13;
            if (deepLinked) return;
            NavGraph navGraph = this._graph;
            Intrinsics.checkNotNull((Object)navGraph);
            this.navigate((NavDestination)navGraph, startDestinationArgs, null, null);
            return;
        } else {
            this.dispatchOnDestinationChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    public boolean handleDeepLink(@Nullable Intent intent) {
        Bundle arguments;
        Bundle globalArgs;
        ArrayList deepLinkArgs;
        int[] deepLink;
        block38: {
            block37: {
                Object matchingDeepLink;
                block36: {
                    block35: {
                        Bundle deepLinkExtras;
                        Bundle extras;
                        if (intent == null) {
                            return false;
                        }
                        Bundle bundle = extras = intent.getExtras();
                        deepLink = (int[])(bundle != null ? bundle.getIntArray(KEY_DEEP_LINK_IDS) : null);
                        Bundle bundle2 = extras;
                        deepLinkArgs = bundle2 != null ? bundle2.getParcelableArrayList(KEY_DEEP_LINK_ARGS) : null;
                        globalArgs = new Bundle();
                        Bundle bundle3 = extras;
                        Object object = deepLinkExtras = bundle3 != null ? bundle3.getBundle(KEY_DEEP_LINK_EXTRAS) : null;
                        if (deepLinkExtras != null) {
                            globalArgs.putAll(deepLinkExtras);
                        }
                        if (deepLink == null) break block35;
                        int[] nArray = deepLink;
                        boolean bl = false;
                        if (!(nArray.length == 0)) break block36;
                    }
                    if (intent.getData() != null) {
                        NavGraph navGraph = this._graph;
                        Intrinsics.checkNotNull((Object)navGraph);
                        matchingDeepLink = navGraph.matchDeepLink(new NavDeepLinkRequest(intent));
                        if (matchingDeepLink != null) {
                            NavDestination destination = matchingDeepLink.getDestination();
                            deepLink = NavDestination.buildDeepLinkIds$default((NavDestination)destination, null, (int)1, null);
                            deepLinkArgs = null;
                            Bundle destinationArgs = destination.addInDefaultArgs(matchingDeepLink.getMatchingArgs());
                            globalArgs.putAll(destinationArgs);
                        }
                    }
                }
                if (deepLink == null) break block37;
                matchingDeepLink = deepLink;
                boolean destination = false;
                if (!(((int[])matchingDeepLink).length == 0)) break block38;
            }
            return false;
        }
        String invalidDestinationDisplayName = this.findInvalidDestinationDisplayNameInDeepLink(deepLink);
        if (invalidDestinationDisplayName != null) {
            Log.i((String)TAG, (String)("Could not find destination " + invalidDestinationDisplayName + " in the " + "navigation graph, ignoring the deep link from " + intent));
            return false;
        }
        globalArgs.putParcelable(KEY_DEEP_LINK_INTENT, (Parcelable)intent);
        Bundle[] args = new Bundle[deepLink.length];
        int destinationArgs = 0;
        int n = args.length;
        while (destinationArgs < n) {
            void index;
            Bundle deepLinkArguments;
            arguments = new Bundle();
            arguments.putAll(globalArgs);
            if (deepLinkArgs != null && (deepLinkArguments = (Bundle)deepLinkArgs.get((int)index)) != null) {
                arguments.putAll(deepLinkArguments);
            }
            args[index] = arguments;
            ++index;
        }
        int flags = intent.getFlags();
        if ((flags & 0x10000000) != 0 && (flags & 0x8000) == 0) {
            intent.addFlags(32768);
            TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this.context).addNextIntentWithParentStack(intent);
            Intrinsics.checkNotNullExpressionValue((Object)taskStackBuilder, (String)"TaskStackBuilder\n       \u2026ntWithParentStack(intent)");
            TaskStackBuilder taskStackBuilder2 = taskStackBuilder;
            taskStackBuilder2.startActivities();
            Activity activity2 = this.activity;
            if (activity2 != null) {
                arguments = activity2;
                boolean deepLinkArguments = false;
                boolean bl = false;
                Bundle activity3 = arguments;
                boolean bl2 = false;
                activity3.finish();
                activity3.overridePendingTransition(0, 0);
            }
            return true;
        }
        if ((flags & 0x10000000) != 0) {
            if (!this.getBackQueue().isEmpty()) {
                NavGraph navGraph = this._graph;
                Intrinsics.checkNotNull((Object)navGraph);
                NavController.popBackStackInternal$default(this, navGraph.getId(), true, false, 4, null);
            }
            int index = 0;
            while (index < deepLink.length) {
                int destinationId = deepLink[index];
                Bundle arguments2 = args[index++];
                NavDestination node = this.findDestination(destinationId);
                if (node == null) {
                    String dest = NavDestination.Companion.getDisplayName(this.context, destinationId);
                    throw (Throwable)new IllegalStateException("Deep Linking failed: destination " + dest + " cannot be found from the current " + "destination " + this.getCurrentDestination());
                }
                this.navigate(node, arguments2, new NavOptions.Builder().setEnterAnim(0).setExitAnim(0).build(), null);
            }
            return true;
        }
        NavGraph graph = this._graph;
        int destinationId = 0;
        int n2 = deepLink.length;
        while (destinationId < n2) {
            NavDestination node;
            NavDestination navDestination;
            void i;
            int destinationId2 = deepLink[i];
            Bundle arguments3 = args[i];
            if (i == false) {
                navDestination = (NavDestination)this._graph;
            } else {
                NavGraph navGraph = graph;
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = node = navGraph.findNode(destinationId2);
            }
            if (node == null) {
                String dest = NavDestination.Companion.getDisplayName(this.context, destinationId2);
                throw (Throwable)new IllegalStateException("Deep Linking failed: destination " + dest + " cannot be found in graph " + graph);
            }
            if (i != deepLink.length - 1) {
                if (node instanceof NavGraph) {
                    graph = (NavGraph)node;
                    while (true) {
                        NavGraph navGraph = graph;
                        Intrinsics.checkNotNull((Object)navGraph);
                        if (navGraph.findNode(graph.getStartDestinationId()) instanceof NavGraph) {
                            graph = (NavGraph)graph.findNode(graph.getStartDestinationId());
                            continue;
                        }
                        break;
                    }
                }
            } else {
                NavOptions.Builder builder = new NavOptions.Builder();
                NavGraph navGraph = this._graph;
                Intrinsics.checkNotNull((Object)navGraph);
                this.navigate(node, arguments3, NavOptions.Builder.setPopUpTo$default((NavOptions.Builder)builder, (int)navGraph.getId(), (boolean)true, (boolean)false, (int)4, null).setEnterAnim(0).setExitAnim(0).build(), null);
            }
            ++i;
        }
        this.deepLinkHandled = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String findInvalidDestinationDisplayNameInDeepLink(int[] deepLink) {
        NavGraph graph = this._graph;
        int n = 0;
        int n2 = deepLink.length;
        while (n < n2) {
            NavDestination navDestination;
            void i;
            int destinationId = deepLink[i];
            if (i == false) {
                NavGraph navGraph = this._graph;
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = (NavDestination)(navGraph.getId() == destinationId ? this._graph : null);
            } else {
                NavGraph navGraph = graph;
                Intrinsics.checkNotNull((Object)navGraph);
                navDestination = navGraph.findNode(destinationId);
            }
            if (navDestination == null) {
                return NavDestination.Companion.getDisplayName(this.context, destinationId);
            }
            NavDestination node = navDestination;
            if (i != deepLink.length - 1 && node instanceof NavGraph) {
                graph = (NavGraph)node;
                while (true) {
                    NavGraph navGraph = graph;
                    Intrinsics.checkNotNull((Object)navGraph);
                    if (!(navGraph.findNode(graph.getStartDestinationId()) instanceof NavGraph)) break;
                    graph = (NavGraph)graph.findNode(graph.getStartDestinationId());
                }
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public NavDestination getCurrentDestination() {
        NavBackStackEntry navBackStackEntry = this.getCurrentBackStackEntry();
        return navBackStackEntry != null ? navBackStackEntry.getDestination() : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findDestination(@IdRes int destinationId) {
        if (this._graph == null) {
            return null;
        }
        NavGraph navGraph = this._graph;
        Intrinsics.checkNotNull((Object)navGraph);
        if (navGraph.getId() == destinationId) {
            return (NavDestination)this._graph;
        }
        NavBackStackEntry navBackStackEntry = (NavBackStackEntry)this.getBackQueue().lastOrNull();
        if (navBackStackEntry == null || (navBackStackEntry = navBackStackEntry.getDestination()) == null) {
            NavGraph navGraph2 = this._graph;
            Intrinsics.checkNotNull((Object)navGraph2);
            navBackStackEntry = (NavDestination)navGraph2;
        }
        NavBackStackEntry currentNode = navBackStackEntry;
        return this.findDestination((NavDestination)currentNode, destinationId);
    }

    private final NavDestination findDestination(NavDestination $this$findDestination, @IdRes int destinationId) {
        NavGraph navGraph;
        if ($this$findDestination.getId() == destinationId) {
            return $this$findDestination;
        }
        if ($this$findDestination instanceof NavGraph) {
            navGraph = (NavGraph)$this$findDestination;
        } else {
            NavGraph navGraph2 = $this$findDestination.getParent();
            navGraph = navGraph2;
            Intrinsics.checkNotNull((Object)navGraph2);
        }
        NavGraph currentGraph = navGraph;
        return currentGraph.findNode(destinationId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final NavDestination findDestination(@NotNull String destinationRoute) {
        NavGraph navGraph;
        NavBackStackEntry currentNode;
        Intrinsics.checkNotNullParameter((Object)destinationRoute, (String)"destinationRoute");
        if (this._graph == null) {
            return null;
        }
        NavGraph navGraph2 = this._graph;
        Intrinsics.checkNotNull((Object)navGraph2);
        if (Intrinsics.areEqual((Object)navGraph2.getRoute(), (Object)destinationRoute)) {
            return (NavDestination)this._graph;
        }
        NavBackStackEntry navBackStackEntry = (NavBackStackEntry)this.getBackQueue().lastOrNull();
        if (navBackStackEntry == null || (navBackStackEntry = navBackStackEntry.getDestination()) == null) {
            NavGraph navGraph3 = this._graph;
            Intrinsics.checkNotNull((Object)navGraph3);
            navBackStackEntry = currentNode = (NavDestination)navGraph3;
        }
        if (currentNode instanceof NavGraph) {
            navGraph = (NavGraph)currentNode;
        } else {
            NavGraph navGraph4 = currentNode.getParent();
            navGraph = navGraph4;
            Intrinsics.checkNotNull((Object)navGraph4);
        }
        NavGraph currentGraph = navGraph;
        return currentGraph.findNode(destinationRoute);
    }

    @MainThread
    public void navigate(@IdRes int resId) {
        this.navigate(resId, null);
    }

    @MainThread
    public void navigate(@IdRes int resId, @Nullable Bundle args) {
        this.navigate(resId, args, null);
    }

    @MainThread
    public void navigate(@IdRes int resId, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        this.navigate(resId, args, navOptions, null);
    }

    @MainThread
    public void navigate(@IdRes int resId, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        NavOptions finalNavOptions = navOptions;
        NavDestination navDestination = this.getBackQueue().isEmpty() ? (NavDestination)this._graph : ((NavBackStackEntry)this.getBackQueue().last()).getDestination();
        if (navDestination == null) {
            throw (Throwable)new IllegalStateException("no current navigation node");
        }
        NavDestination currentNode = navDestination;
        int destId = resId;
        NavAction navAction = currentNode.getAction(resId);
        Bundle combinedArgs = null;
        if (navAction != null) {
            if (finalNavOptions == null) {
                finalNavOptions = navAction.getNavOptions();
            }
            destId = navAction.getDestinationId();
            Bundle navActionArgs = navAction.getDefaultArguments();
            if (navActionArgs != null) {
                combinedArgs = new Bundle();
                combinedArgs.putAll(navActionArgs);
            }
        }
        if (args != null) {
            if (combinedArgs == null) {
                combinedArgs = new Bundle();
            }
            combinedArgs.putAll(args);
        }
        if (destId == 0 && finalNavOptions != null && finalNavOptions.getPopUpToId() != -1) {
            this.popBackStack(finalNavOptions.getPopUpToId(), finalNavOptions.isPopUpToInclusive());
            return;
        }
        boolean navActionArgs = destId != 0;
        boolean bl = false;
        boolean bl2 = false;
        if (!navActionArgs) {
            boolean bl3 = false;
            String string = "Destination id == 0 can only be used in conjunction with a valid navOptions.popUpTo";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        NavDestination node = this.findDestination(destId);
        if (node == null) {
            String dest = NavDestination.Companion.getDisplayName(this.context, destId);
            bl2 = navAction == null;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl2) {
                boolean bl6 = false;
                String string = "Navigation destination " + dest + " referenced from action " + NavDestination.Companion.getDisplayName(this.context, resId) + " cannot be found from " + "the current destination " + currentNode;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            throw (Throwable)new IllegalArgumentException("Navigation action/destination " + dest + " cannot be found from the current " + "destination " + currentNode);
        }
        this.navigate(node, combinedArgs, finalNavOptions, navigatorExtras);
    }

    @MainThread
    public void navigate(@NotNull Uri deepLink) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        this.navigate(new NavDeepLinkRequest(deepLink, null, null));
    }

    @MainThread
    public void navigate(@NotNull Uri deepLink, @Nullable NavOptions navOptions) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        this.navigate(new NavDeepLinkRequest(deepLink, null, null), navOptions, null);
    }

    @MainThread
    public void navigate(@NotNull Uri deepLink, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter((Object)deepLink, (String)"deepLink");
        this.navigate(new NavDeepLinkRequest(deepLink, null, null), navOptions, navigatorExtras);
    }

    @MainThread
    public void navigate(@NotNull NavDeepLinkRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.navigate(request, null);
    }

    @MainThread
    public void navigate(@NotNull NavDeepLinkRequest request, @Nullable NavOptions navOptions) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.navigate(request, navOptions, null);
    }

    @MainThread
    public void navigate(@NotNull NavDeepLinkRequest request, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        NavGraph navGraph = this._graph;
        Intrinsics.checkNotNull((Object)navGraph);
        NavDestination.DeepLinkMatch deepLinkMatch = navGraph.matchDeepLink(request);
        if (deepLinkMatch != null) {
            NavDestination destination = deepLinkMatch.getDestination();
            bundle = destination.addInDefaultArgs(deepLinkMatch.getMatchingArgs());
            if (bundle == null) {
                bundle = new Bundle();
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Navigation destination that matches request " + request + " cannot be found in the " + "navigation graph " + this._graph);
        }
        Bundle args = bundle;
        NavDestination node = deepLinkMatch.getDestination();
        Intent intent = new Intent();
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.setDataAndType(request.getUri(), request.getMimeType());
        $this$apply.setAction(request.getAction());
        Intent intent2 = intent;
        args.putParcelable(KEY_DEEP_LINK_INTENT, (Parcelable)intent2);
        this.navigate(node, args, navOptions, navigatorExtras);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @MainThread
    private final void navigate(NavDestination node, Bundle args, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        void navigated;
        NavBackStackEntry navBackStackEntry;
        boolean popped = false;
        boolean launchSingleTop = false;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        if (navOptions != null && navOptions.getPopUpToId() != -1) {
            popped = this.popBackStackInternal(navOptions.getPopUpToId(), navOptions.isPopUpToInclusive(), navOptions.shouldPopUpToSaveState());
        }
        Bundle finalArgs = node.addInDefaultArgs(args);
        NavBackStackEntry currentBackStackEntry = this.getCurrentBackStackEntry();
        NavOptions navOptions2 = navOptions;
        if (navOptions2 != null && navOptions2.shouldLaunchSingleTop() && (navBackStackEntry = currentBackStackEntry) != null) {
            if ((navBackStackEntry = navBackStackEntry.getDestination()) != null && node.getId() == navBackStackEntry.getId()) {
                launchSingleTop = true;
                currentBackStackEntry.replaceArguments(finalArgs);
                Navigator navigator = this._navigatorProvider.getNavigator(node.getNavigatorName());
                navigator.onLaunchSingleTop(currentBackStackEntry);
            }
        }
        NavOptions navOptions3 = navOptions;
        if (navOptions3 == null || !navOptions3.shouldRestoreState() || !this.backStackMap.containsKey(node.getId())) {
            if (!launchSingleTop) {
                NavBackStackEntry backStackEntry = NavBackStackEntry.Companion.create$default((NavBackStackEntry.Companion)NavBackStackEntry.Companion, (Context)this.context, (NavDestination)node, (Bundle)finalArgs, (LifecycleOwner)this.lifecycleOwner, (NavViewModelStoreProvider)this.viewModel, null, null, (int)96, null);
                Navigator navigator = this._navigatorProvider.getNavigator(node.getNavigatorName());
                this.navigateInternal((Navigator<? extends NavDestination>)navigator, CollectionsKt.listOf((Object)backStackEntry), navOptions, navigatorExtras, (Function1<? super NavBackStackEntry, Unit>)((Function1)new Function1<NavBackStackEntry, Unit>(this, (Ref.BooleanRef)navigated, node, finalArgs){
                    final /* synthetic */ NavController this$0;
                    final /* synthetic */ Ref.BooleanRef $navigated;
                    final /* synthetic */ NavDestination $node;
                    final /* synthetic */ Bundle $finalArgs;

                    public final void invoke(@NotNull NavBackStackEntry it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$navigated.element = true;
                        NavController.addEntryToBackStack$default(this.this$0, this.$node, this.$finalArgs, it, null, 8, null);
                    }
                    {
                        this.this$0 = navController;
                        this.$navigated = booleanRef;
                        this.$node = navDestination;
                        this.$finalArgs = bundle;
                        super(1);
                    }
                }));
            }
        } else {
            void $this$forEach$iv;
            Iterator $this$filterNotTo$iv$iv;
            String backStackId = this.backStackMap.get(node.getId());
            CollectionsKt.removeAll((Iterable)this.backStackMap.values(), (Function1)((Function1)new Function1<String, Boolean>(backStackId){
                final /* synthetic */ String $backStackId;

                public final boolean invoke(@Nullable String it) {
                    return Intrinsics.areEqual((Object)it, (Object)this.$backStackId);
                }
                {
                    this.$backStackId = string;
                    super(1);
                }
            }));
            Map<String, ArrayDeque<NavBackStackEntryState>> map = this.backStackStates;
            boolean bl = false;
            Map<String, ArrayDeque<NavBackStackEntryState>> map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            ArrayDeque backStackState = (ArrayDeque)TypeIntrinsics.asMutableMap(map2).remove(backStackId);
            List<NavBackStackEntry> entries = this.instantiateBackStack((ArrayDeque<NavBackStackEntryState>)backStackState);
            boolean bl2 = false;
            List entriesGroupedByNavigator = new ArrayList();
            Iterable $this$filterNot$iv = entries;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection collection = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                NavBackStackEntry entry = (NavBackStackEntry)element$iv$iv;
                boolean bl3 = false;
                if (entry.getDestination() instanceof NavGraph) continue;
                collection.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)collection;
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                Collection collection2;
                String previousNavigatorName;
                NavBackStackEntry entry = (NavBackStackEntry)t;
                boolean bl4 = false;
                List previousEntryList = (List)CollectionsKt.lastOrNull((List)entriesGroupedByNavigator);
                List list = previousEntryList;
                String string = list != null && (list = (NavBackStackEntry)CollectionsKt.last((List)list)) != null && (list = list.getDestination()) != null ? list.getNavigatorName() : (previousNavigatorName = null);
                if (Intrinsics.areEqual((Object)previousNavigatorName, (Object)entry.getDestination().getNavigatorName())) {
                    collection2 = previousEntryList;
                    boolean bl5 = false;
                    collection2.add(entry);
                    continue;
                }
                collection2 = entriesGroupedByNavigator;
                List list2 = CollectionsKt.mutableListOf((Object[])new NavBackStackEntry[]{entry});
                boolean bl6 = false;
                collection2.add(list2);
            }
            for (List entryList : entriesGroupedByNavigator) {
                void lastDestination;
                Navigator navigator = this._navigatorProvider.getNavigator(((NavBackStackEntry)CollectionsKt.first((List)entryList)).getDestination().getNavigatorName());
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = 0;
                Ref.ObjectRef entry = new Ref.ObjectRef();
                entry.element = node;
                this.navigateInternal((Navigator<? extends NavDestination>)navigator, entryList, navOptions, navigatorExtras, (Function1<? super NavBackStackEntry, Unit>)((Function1)new Function1<NavBackStackEntry, Unit>(this, (Ref.BooleanRef)navigated, entries, intRef, (Ref.ObjectRef)lastDestination, finalArgs){
                    final /* synthetic */ NavController this$0;
                    final /* synthetic */ Ref.BooleanRef $navigated;
                    final /* synthetic */ List $entries;
                    final /* synthetic */ Ref.IntRef $lastNavigatedIndex;
                    final /* synthetic */ Ref.ObjectRef $lastDestination;
                    final /* synthetic */ Bundle $finalArgs;

                    public final void invoke(@NotNull NavBackStackEntry entry) {
                        List<E> list;
                        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                        this.$navigated.element = true;
                        int entryIndex = this.$entries.indexOf(entry);
                        if (entryIndex != -1) {
                            List<E> list2 = this.$entries.subList(this.$lastNavigatedIndex.element, entryIndex + 1);
                            boolean bl = false;
                            boolean bl2 = false;
                            List<E> it = list2;
                            boolean bl3 = false;
                            this.$lastNavigatedIndex.element = entryIndex + 1;
                            this.$lastDestination.element = entry.getDestination();
                            list = list2;
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                        List<E> restoredEntries = list;
                        NavController.access$addEntryToBackStack(this.this$0, (NavDestination)this.$lastDestination.element, this.$finalArgs, entry, restoredEntries);
                    }
                    {
                        this.this$0 = navController;
                        this.$navigated = booleanRef;
                        this.$entries = list;
                        this.$lastNavigatedIndex = intRef;
                        this.$lastDestination = objectRef;
                        this.$finalArgs = bundle;
                        super(1);
                    }
                }));
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        if (popped || navigated.element || launchSingleTop) {
            this.dispatchOnDestinationChanged();
        }
    }

    private final List<NavBackStackEntry> instantiateBackStack(ArrayDeque<NavBackStackEntryState> backStackState) {
        boolean bl = false;
        List backStack = new ArrayList();
        NavBackStackEntry navBackStackEntry = (NavBackStackEntry)this.getBackQueue().lastOrNull();
        if (navBackStackEntry == null || (navBackStackEntry = navBackStackEntry.getDestination()) == null) {
            navBackStackEntry = (NavDestination)this.getGraph();
        }
        NavBackStackEntry currentDestination = navBackStackEntry;
        ArrayDeque<NavBackStackEntryState> arrayDeque = backStackState;
        if (arrayDeque != null) {
            Iterable $this$forEach$iv = (Iterable)arrayDeque;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NavBackStackEntryState state = (NavBackStackEntryState)element$iv;
                boolean bl2 = false;
                NavDestination node = this.findDestination((NavDestination)currentDestination, state.getDestinationId());
                boolean bl3 = false;
                boolean bl4 = false;
                if (node == null) {
                    boolean bl5 = false;
                    String dest = NavDestination.Companion.getDisplayName(this.context, state.getDestinationId());
                    String string = "Restore State failed: destination " + dest + " cannot be found from the current " + "destination " + currentDestination;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Collection collection = backStack;
                NavBackStackEntry navBackStackEntry2 = state.instantiate(this.context, node, this.lifecycleOwner, this.viewModel);
                boolean bl6 = false;
                collection.add(navBackStackEntry2);
                currentDestination = node;
            }
        }
        return backStack;
    }

    private final void addEntryToBackStack(NavDestination node, Bundle finalArgs, NavBackStackEntry backStackEntry, List<NavBackStackEntry> restoredEntries) {
        NavDestination overlappingDestination;
        NavBackStackEntry entry;
        NavBackStackEntry restoredEntry;
        NavBackStackEntry element$iv;
        ListIterator<NavBackStackEntry> iterator$iv;
        boolean $i$f$lastOrNull;
        Collection<Object> $this$lastOrNull$iv;
        NavGraph parent;
        NavDestination newDest = backStackEntry.getDestination();
        if (!(newDest instanceof FloatingWindow)) {
            while (!this.getBackQueue().isEmpty() && ((NavBackStackEntry)this.getBackQueue().last()).getDestination() instanceof FloatingWindow && NavController.popBackStackInternal$default(this, ((NavBackStackEntry)this.getBackQueue().last()).getDestination().getId(), true, false, 4, null)) {
            }
        }
        ArrayDeque hierarchy = new ArrayDeque();
        NavDestination destination = newDest;
        if (node instanceof NavGraph) {
            do {
                NavBackStackEntry navBackStackEntry;
                NavBackStackEntry navBackStackEntry2;
                block18: {
                    NavDestination navDestination = destination;
                    Intrinsics.checkNotNull((Object)navDestination);
                    parent = navDestination.getParent();
                    if (parent == null) continue;
                    $this$lastOrNull$iv = restoredEntries;
                    $i$f$lastOrNull = false;
                    iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        restoredEntry = element$iv = iterator$iv.previous();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)restoredEntry.getDestination(), (Object)parent)) continue;
                        navBackStackEntry2 = element$iv;
                        break block18;
                    }
                    navBackStackEntry2 = null;
                }
                if ((navBackStackEntry = (NavBackStackEntry)navBackStackEntry2) == null) {
                    navBackStackEntry = NavBackStackEntry.Companion.create$default((NavBackStackEntry.Companion)NavBackStackEntry.Companion, (Context)this.context, (NavDestination)((NavDestination)parent), (Bundle)finalArgs, (LifecycleOwner)this.lifecycleOwner, (NavViewModelStoreProvider)this.viewModel, null, null, (int)96, null);
                }
                entry = navBackStackEntry;
                hierarchy.addFirst((Object)entry);
                $this$lastOrNull$iv = (Collection)this.getBackQueue();
                $i$f$lastOrNull = false;
                if (!(!$this$lastOrNull$iv.isEmpty()) || ((NavBackStackEntry)this.getBackQueue().last()).getDestination() != parent) continue;
                NavController.popBackStackInternal$default(this, parent.getId(), true, false, 4, null);
            } while ((destination = (NavDestination)parent) != null && destination != node);
        }
        NavDestination navDestination = destination = hierarchy.isEmpty() ? newDest : ((NavBackStackEntry)hierarchy.first()).getDestination();
        while (destination != null && this.findDestination(destination.getId()) == null) {
            parent = destination.getParent();
            if (parent != null) {
                NavBackStackEntry navBackStackEntry;
                NavBackStackEntry navBackStackEntry3;
                block19: {
                    $this$lastOrNull$iv = restoredEntries;
                    $i$f$lastOrNull = false;
                    iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        restoredEntry = element$iv = iterator$iv.previous();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)restoredEntry.getDestination(), (Object)parent)) continue;
                        navBackStackEntry3 = element$iv;
                        break block19;
                    }
                    navBackStackEntry3 = null;
                }
                if ((navBackStackEntry = (NavBackStackEntry)navBackStackEntry3) == null) {
                    navBackStackEntry = NavBackStackEntry.Companion.create$default((NavBackStackEntry.Companion)NavBackStackEntry.Companion, (Context)this.context, (NavDestination)((NavDestination)parent), (Bundle)parent.addInDefaultArgs(finalArgs), (LifecycleOwner)this.lifecycleOwner, (NavViewModelStoreProvider)this.viewModel, null, null, (int)96, null);
                }
                entry = navBackStackEntry;
                hierarchy.addFirst((Object)entry);
            }
            destination = (NavDestination)parent;
        }
        NavDestination navDestination2 = overlappingDestination = hierarchy.isEmpty() ? newDest : ((NavBackStackEntry)hierarchy.last()).getDestination();
        while (!this.getBackQueue().isEmpty() && ((NavBackStackEntry)this.getBackQueue().last()).getDestination() instanceof NavGraph) {
            NavDestination navDestination3 = ((NavBackStackEntry)this.getBackQueue().last()).getDestination();
            if (navDestination3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavGraph");
            }
            if (((NavGraph)navDestination3).findNode(overlappingDestination.getId(), false) == null && NavController.popBackStackInternal$default(this, ((NavBackStackEntry)this.getBackQueue().last()).getDestination().getId(), true, false, 4, null)) continue;
        }
        Iterable $this$forEach$iv = (Iterable)hierarchy;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            NavBackStackEntry entry2 = (NavBackStackEntry)element$iv2;
            boolean bl = false;
            Navigator navigator = this._navigatorProvider.getNavigator(entry2.getDestination().getNavigatorName());
            NavControllerNavigatorState navControllerNavigatorState = this.navigatorState.get(navigator);
            boolean bl2 = false;
            boolean bl3 = false;
            if (navControllerNavigatorState == null) {
                boolean bl4 = false;
                String string = "NavigatorBackStack for " + node.getNavigatorName() + " should already be created";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            NavControllerNavigatorState navigatorBackStack = navControllerNavigatorState;
            navigatorBackStack.addInternal(entry2);
        }
        this.getBackQueue().addAll((Collection)hierarchy);
        if (this.getBackQueue().isEmpty() || ((NavBackStackEntry)this.getBackQueue().first()).getDestination() != this._graph) {
            NavBackStackEntry navBackStackEntry;
            NavBackStackEntry navBackStackEntry4;
            block20: {
                List<NavBackStackEntry> $this$lastOrNull$iv2 = restoredEntries;
                boolean $i$f$lastOrNull2 = false;
                iterator$iv = $this$lastOrNull$iv2.listIterator($this$lastOrNull$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    restoredEntry = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    NavDestination navDestination4 = restoredEntry.getDestination();
                    NavGraph navGraph = this._graph;
                    Intrinsics.checkNotNull((Object)navGraph);
                    if (!Intrinsics.areEqual((Object)navDestination4, (Object)navGraph)) continue;
                    navBackStackEntry4 = element$iv;
                    break block20;
                }
                navBackStackEntry4 = null;
            }
            if ((navBackStackEntry = (NavBackStackEntry)navBackStackEntry4) == null) {
                NavGraph navGraph = this._graph;
                Intrinsics.checkNotNull((Object)navGraph);
                NavDestination navDestination5 = (NavDestination)navGraph;
                NavGraph navGraph2 = this._graph;
                Intrinsics.checkNotNull((Object)navGraph2);
                navBackStackEntry = NavBackStackEntry.Companion.create$default((NavBackStackEntry.Companion)NavBackStackEntry.Companion, (Context)this.context, (NavDestination)navDestination5, (Bundle)navGraph2.addInDefaultArgs(finalArgs), (LifecycleOwner)this.lifecycleOwner, (NavViewModelStoreProvider)this.viewModel, null, null, (int)96, null);
            }
            entry = navBackStackEntry;
            Navigator navigator = this._navigatorProvider.getNavigator(entry.getDestination().getNavigatorName());
            NavControllerNavigatorState navControllerNavigatorState = this.navigatorState.get(navigator);
            boolean bl = false;
            boolean bl5 = false;
            if (navControllerNavigatorState == null) {
                boolean bl6 = false;
                String string = "NavigatorBackStack for " + node.getNavigatorName() + " should already be created";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            NavControllerNavigatorState navigatorBackStack = navControllerNavigatorState;
            navigatorBackStack.addInternal(entry);
            this.getBackQueue().addFirst((Object)entry);
        }
        this.getBackQueue().add((Object)backStackEntry);
    }

    static /* synthetic */ void addEntryToBackStack$default(NavController navController, NavDestination navDestination, Bundle bundle, NavBackStackEntry navBackStackEntry, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addEntryToBackStack");
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        navController.addEntryToBackStack(navDestination, bundle, navBackStackEntry, list);
    }

    @MainThread
    public void navigate(@NotNull NavDirections directions) {
        Intrinsics.checkNotNullParameter((Object)directions, (String)"directions");
        this.navigate(directions.getActionId(), directions.getArguments(), null);
    }

    @MainThread
    public void navigate(@NotNull NavDirections directions, @Nullable NavOptions navOptions) {
        Intrinsics.checkNotNullParameter((Object)directions, (String)"directions");
        this.navigate(directions.getActionId(), directions.getArguments(), navOptions);
    }

    @MainThread
    public void navigate(@NotNull NavDirections directions, @NotNull Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter((Object)directions, (String)"directions");
        Intrinsics.checkNotNullParameter((Object)navigatorExtras, (String)"navigatorExtras");
        this.navigate(directions.getActionId(), directions.getArguments(), null, navigatorExtras);
    }

    public final void navigate(@NotNull String route, @NotNull Function1<? super NavOptionsBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        NavController.navigate$default(this, route, NavOptionsBuilderKt.navOptions(builder), null, 4, null);
    }

    @JvmOverloads
    public final void navigate(@NotNull String route, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        String $this$toUri$iv = NavDestination.Companion.createRoute(route);
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
        this.navigate(NavDeepLinkRequest.Builder.Companion.fromUri(uri).build(), navOptions, navigatorExtras);
    }

    public static /* synthetic */ void navigate$default(NavController navController, String string, NavOptions navOptions, Navigator.Extras extras, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigate");
        }
        if ((n & 2) != 0) {
            navOptions = null;
        }
        if ((n & 4) != 0) {
            extras = null;
        }
        navController.navigate(string, navOptions, extras);
    }

    @JvmOverloads
    public final void navigate(@NotNull String route, @Nullable NavOptions navOptions) {
        NavController.navigate$default(this, route, navOptions, null, 4, null);
    }

    @JvmOverloads
    public final void navigate(@NotNull String route) {
        NavController.navigate$default(this, route, null, null, 6, null);
    }

    @NotNull
    public NavDeepLinkBuilder createDeepLink() {
        return new NavDeepLinkBuilder(this);
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @Nullable
    public Bundle saveState() {
        Object backStackDestIds;
        int index;
        Parcelable[] backStack;
        Object object;
        Bundle b = null;
        ArrayList<void> navigatorNames = new ArrayList<void>();
        Bundle navigatorState = new Bundle();
        Iterator<Map.Entry<String, ArrayDeque<NavBackStackEntryState>>> iterator = this._navigatorProvider.getNavigators();
        boolean bl = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            void name;
            Object object2 = object = iterator2.next();
            boolean bl2 = false;
            iterator = (String)object2.getKey();
            object2 = object;
            bl2 = false;
            Navigator value = (Navigator)object2.getValue();
            Bundle savedState = value.onSaveState();
            if (savedState == null) continue;
            navigatorNames.add(name);
            navigatorState.putBundle((String)name, savedState);
        }
        object = navigatorNames;
        boolean bl3 = false;
        if (!object.isEmpty()) {
            b = new Bundle();
            navigatorState.putStringArrayList(KEY_NAVIGATOR_STATE_NAMES, navigatorNames);
            b.putBundle(KEY_NAVIGATOR_STATE, navigatorState);
        }
        object = (Collection)this.getBackQueue();
        bl3 = false;
        if (!object.isEmpty()) {
            if (b == null) {
                b = new Bundle();
            }
            backStack = new Parcelable[this.getBackQueue().size()];
            index = 0;
            for (NavBackStackEntry backStackEntry : this.getBackQueue()) {
                backStack[index++] = new NavBackStackEntryState(backStackEntry);
            }
            b.putParcelableArray(KEY_BACK_STACK, backStack);
        }
        backStack = this.backStackMap;
        index = 0;
        if (!backStack.isEmpty()) {
            if (b == null) {
                b = new Bundle();
            }
            backStackDestIds = new int[this.backStackMap.size()];
            ArrayList backStackIds = new ArrayList();
            int index2 = 0;
            Map<Integer, String> map = this.backStackMap;
            boolean bl4 = false;
            for (Map.Entry value : map.entrySet()) {
                void destId;
                Object object3 = value;
                boolean bl5 = false;
                int n = ((Number)object3.getKey()).intValue();
                object3 = value;
                bl5 = false;
                String id2 = (String)object3.getValue();
                backStackDestIds[index2++] = destId;
                object3 = backStackIds;
                bl5 = false;
                object3.add(id2);
            }
            b.putIntArray(KEY_BACK_STACK_DEST_IDS, (int[])backStackDestIds);
            b.putStringArrayList(KEY_BACK_STACK_IDS, backStackIds);
        }
        backStackDestIds = this.backStackStates;
        boolean bl6 = false;
        if (!backStackDestIds.isEmpty()) {
            if (b == null) {
                b = new Bundle();
            }
            ArrayList backStackStateIds = new ArrayList();
            Object value = this.backStackStates;
            boolean savedState = false;
            for (Map.Entry<String, ArrayDeque<NavBackStackEntryState>> entry : value.entrySet()) {
                void id;
                Object destId = entry;
                boolean id2 = false;
                value = destId.getKey();
                destId = entry;
                id2 = false;
                ArrayDeque<NavBackStackEntryState> backStackStates = destId.getValue();
                destId = backStackStateIds;
                id2 = false;
                destId.add(id);
                Parcelable[] states = new Parcelable[backStackStates.size()];
                Iterable $this$forEachIndexed$iv = (Iterable)backStackStates;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void backStackState;
                    int n = index$iv++;
                    boolean bl7 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    NavBackStackEntryState navBackStackEntryState = (NavBackStackEntryState)item$iv;
                    int stateIndex = n;
                    boolean bl8 = false;
                    states[stateIndex] = (Parcelable)backStackState;
                }
                b.putParcelableArray(KEY_BACK_STACK_STATES_PREFIX + (String)id, states);
            }
            b.putStringArrayList(KEY_BACK_STACK_STATES_IDS, backStackStateIds);
        }
        if (this.deepLinkHandled) {
            if (b == null) {
                b = new Bundle();
            }
            b.putBoolean(KEY_DEEP_LINK_HANDLED, this.deepLinkHandled);
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void restoreState(@Nullable Bundle navState) {
        ArrayList backStackStateIds;
        if (navState == null) {
            return;
        }
        navState.setClassLoader(this.context.getClassLoader());
        this.navigatorStateToRestore = navState.getBundle(KEY_NAVIGATOR_STATE);
        this.backStackToRestore = navState.getParcelableArray(KEY_BACK_STACK);
        this.backStackStates.clear();
        int[] backStackDestIds = navState.getIntArray(KEY_BACK_STACK_DEST_IDS);
        ArrayList backStackIds = navState.getStringArrayList(KEY_BACK_STACK_IDS);
        if (backStackDestIds != null && backStackIds != null) {
            int[] $this$forEachIndexed$iv = backStackDestIds;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int item$iv : $this$forEachIndexed$iv) {
                void id;
                int n = index$iv++;
                int n2 = item$iv;
                int index = n;
                boolean bl = false;
                this.backStackMap.put((int)id, (String)backStackIds.get(index));
            }
        }
        ArrayList arrayList = backStackStateIds = navState.getStringArrayList(KEY_BACK_STACK_STATES_IDS);
        if (arrayList != null) {
            Iterable $this$forEach$iv = arrayList;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                String string;
                Object element$iv = object.next();
                String id = (String)element$iv;
                boolean bl = false;
                Parcelable[] backStackState = navState.getParcelableArray(KEY_BACK_STACK_STATES_PREFIX + id);
                if (backStackState == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                ArrayDeque arrayDeque = new ArrayDeque(backStackState.length);
                boolean bl2 = false;
                boolean bl3 = false;
                ArrayDeque arrayDeque2 = arrayDeque;
                Map<String, ArrayDeque<NavBackStackEntryState>> map = this.backStackStates;
                boolean bl4 = false;
                Parcelable[] parcelableArray = backStackState;
                int n = parcelableArray.length;
                for (int i = 0; i < n; ++i) {
                    void $this$apply;
                    Parcelable parcelable;
                    Parcelable parcelable2 = parcelable = parcelableArray[i];
                    if (parcelable2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.navigation.NavBackStackEntryState");
                    }
                    $this$apply.add((Object)((NavBackStackEntryState)parcelable2));
                }
                Unit unit = Unit.INSTANCE;
                map.put(string, (ArrayDeque<NavBackStackEntryState>)arrayDeque);
            }
        }
        this.deepLinkHandled = navState.getBoolean(KEY_DEEP_LINK_HANDLED);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setLifecycleOwner(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (Intrinsics.areEqual((Object)owner, (Object)this.lifecycleOwner)) {
            return;
        }
        LifecycleOwner lifecycleOwner = this.lifecycleOwner;
        if (lifecycleOwner != null && (lifecycleOwner = lifecycleOwner.getLifecycle()) != null) {
            lifecycleOwner.removeObserver(this.lifecycleObserver);
        }
        this.lifecycleOwner = owner;
        owner.getLifecycle().addObserver(this.lifecycleObserver);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setOnBackPressedDispatcher(@NotNull OnBackPressedDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        LifecycleOwner lifecycleOwner = this.lifecycleOwner;
        boolean bl = false;
        boolean bl2 = false;
        if (lifecycleOwner == null) {
            boolean bl3 = false;
            String string = "You must call setLifecycleOwner() before calling setOnBackPressedDispatcher()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.onBackPressedCallback.remove();
        LifecycleOwner lifecycleOwner2 = this.lifecycleOwner;
        Intrinsics.checkNotNull((Object)lifecycleOwner2);
        dispatcher.addCallback(lifecycleOwner2, this.onBackPressedCallback);
        LifecycleOwner lifecycleOwner3 = this.lifecycleOwner;
        Intrinsics.checkNotNull((Object)lifecycleOwner3);
        lifecycleOwner = lifecycleOwner3.getLifecycle();
        bl = false;
        bl2 = false;
        LifecycleOwner $this$apply = lifecycleOwner;
        boolean bl4 = false;
        $this$apply.removeObserver(this.lifecycleObserver);
        $this$apply.addObserver(this.lifecycleObserver);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void enableOnBackPressed(boolean enabled) {
        this.enableOnBackPressedCallback = enabled;
        this.updateOnBackPressedCallbackEnabled();
    }

    private final void updateOnBackPressedCallbackEnabled() {
        this.onBackPressedCallback.setEnabled(this.enableOnBackPressedCallback && this.getDestinationCountOnBackStack() > 1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setViewModelStore(@NotNull ViewModelStore viewModelStore) {
        Intrinsics.checkNotNullParameter((Object)viewModelStore, (String)"viewModelStore");
        if (Intrinsics.areEqual((Object)((Object)this.viewModel), (Object)((Object)NavControllerViewModel.Companion.getInstance(viewModelStore)))) {
            return;
        }
        boolean bl = this.getBackQueue().isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "ViewModelStore should be set before setGraph call";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.viewModel = NavControllerViewModel.Companion.getInstance(viewModelStore);
    }

    @NotNull
    public ViewModelStoreOwner getViewModelStoreOwner(@IdRes int navGraphId) {
        NavControllerViewModel navControllerViewModel = this.viewModel;
        boolean bl = false;
        boolean bl2 = false;
        if (navControllerViewModel == null) {
            boolean bl3 = false;
            String string = "You must call setViewModelStore() before calling getViewModelStoreOwner().";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        NavBackStackEntry lastFromBackStack = this.getBackStackEntry(navGraphId);
        bl = lastFromBackStack.getDestination() instanceof NavGraph;
        bl2 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "No NavGraph with ID " + navGraphId + " is on the NavController's back stack";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (ViewModelStoreOwner)lastFromBackStack;
    }

    @NotNull
    public NavBackStackEntry getBackStackEntry(@IdRes int destinationId) {
        Object v0;
        block2: {
            List $this$lastOrNull$iv = (List)this.getBackQueue();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!(entry.getDestination().getId() == destinationId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        NavBackStackEntry lastFromBackStack = v0;
        boolean bl = false;
        boolean bl2 = false;
        if (lastFromBackStack == null) {
            boolean bl3 = false;
            String string = "No destination with ID " + destinationId + " is on the NavController's back stack. The " + "current destination is " + this.getCurrentDestination();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return lastFromBackStack;
    }

    @NotNull
    public final NavBackStackEntry getBackStackEntry(@NotNull String route) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            List $this$lastOrNull$iv = (List)this.getBackQueue();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)entry.getDestination().getRoute(), (Object)route)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        NavBackStackEntry lastFromBackStack = v0;
        boolean bl = false;
        boolean bl2 = false;
        if (lastFromBackStack == null) {
            boolean bl3 = false;
            String string = "No destination with route " + route + " is on the NavController's back stack. The " + "current destination is " + this.getCurrentDestination();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return lastFromBackStack;
    }

    @Nullable
    public NavBackStackEntry getCurrentBackStackEntry() {
        return (NavBackStackEntry)this.getBackQueue().lastOrNull();
    }

    @NotNull
    public final Flow<NavBackStackEntry> getCurrentBackStackEntryFlow() {
        return this.currentBackStackEntryFlow;
    }

    @Nullable
    public NavBackStackEntry getPreviousBackStackEntry() {
        Object v0;
        block2: {
            Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)this.getBackQueue())).iterator();
            if (iterator.hasNext()) {
                iterator.next();
            }
            Sequence $this$firstOrNull$iv = SequencesKt.asSequence(iterator);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NavBackStackEntry entry = (NavBackStackEntry)element$iv;
                boolean bl = false;
                if (!(!(entry.getDestination() instanceof NavGraph))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public NavController(@NotNull Context context) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            Sequence sequence = SequencesKt.generateSequence((Object)this.context, (Function1)activity.1.INSTANCE);
            NavController navController = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Context it = (Context)element$iv;
                boolean bl = false;
                if (!(it instanceof Activity)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var9_10 = v0;
        navController.activity = var9_10;
        this.backQueue = new ArrayDeque();
        boolean bl = false;
        this.backStackMap = new LinkedHashMap();
        bl = false;
        this.backStackStates = new LinkedHashMap();
        bl = false;
        this.onDestinationChangedListeners = new ArrayList();
        this.lifecycleObserver = (LifecycleObserver)new LifecycleEventObserver(this){
            final /* synthetic */ NavController this$0;

            public final void onStateChanged(@NotNull LifecycleOwner $noName_0, @NotNull Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (NavController.access$get_graph$p(this.this$0) != null) {
                    for (NavBackStackEntry entry : this.this$0.getBackQueue()) {
                        entry.handleLifecycleEvent(event);
                    }
                }
            }
            {
                this.this$0 = navController;
            }
        };
        this.onBackPressedCallback = new OnBackPressedCallback(this, false){
            final /* synthetic */ NavController this$0;

            public void handleOnBackPressed() {
                this.this$0.popBackStack();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.enableOnBackPressedCallback = true;
        this._navigatorProvider = new NavigatorProvider();
        bl = false;
        this.navigatorState = new LinkedHashMap();
        this._navigatorProvider.addNavigator((Navigator)new NavGraphNavigator(this._navigatorProvider));
        this._navigatorProvider.addNavigator((Navigator)new ActivityNavigator(this.context));
        this.navInflater$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NavInflater>(this){
            final /* synthetic */ NavController this$0;

            @NotNull
            public final NavInflater invoke() {
                NavInflater navInflater2 = NavController.access$getInflater$p(this.this$0);
                if (navInflater2 == null) {
                    navInflater2 = new NavInflater(this.this$0.getContext(), NavController.access$get_navigatorProvider$p(this.this$0));
                }
                return navInflater2;
            }
            {
                this.this$0 = navController;
                super(0);
            }
        }));
        this._currentBackStackEntryFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.currentBackStackEntryFlow = (Flow)FlowKt.asSharedFlow(this._currentBackStackEntryFlow);
    }

    public static final /* synthetic */ void access$set_navigatorProvider$p(NavController $this, NavigatorProvider navigatorProvider) {
        $this._navigatorProvider = navigatorProvider;
    }

    public static final /* synthetic */ void access$setAddToBackStackHandler$p(NavController $this, Function1 function1) {
        $this.addToBackStackHandler = function1;
    }

    public static final /* synthetic */ void access$setLifecycleOwner$p(NavController $this, LifecycleOwner lifecycleOwner) {
        $this.lifecycleOwner = lifecycleOwner;
    }

    public static final /* synthetic */ void access$setViewModel$p(NavController $this, NavControllerViewModel navControllerViewModel) {
        $this.viewModel = navControllerViewModel;
    }

    public static final /* synthetic */ void access$setPopFromBackStackHandler$p(NavController $this, Function1 function1) {
        $this.popFromBackStackHandler = function1;
    }

    public static final /* synthetic */ void access$popEntryFromBackStack(NavController $this, NavBackStackEntry popUpTo, boolean saveState, ArrayDeque savedState) {
        $this.popEntryFromBackStack(popUpTo, saveState, (ArrayDeque<NavBackStackEntryState>)savedState);
    }

    public static final /* synthetic */ Map access$getBackStackMap$p(NavController $this) {
        return $this.backStackMap;
    }

    public static final /* synthetic */ void access$addEntryToBackStack(NavController $this, NavDestination node, Bundle finalArgs, NavBackStackEntry backStackEntry, List restoredEntries) {
        $this.addEntryToBackStack(node, finalArgs, backStackEntry, restoredEntries);
    }

    public static final /* synthetic */ NavGraph access$get_graph$p(NavController $this) {
        return $this._graph;
    }

    public static final /* synthetic */ void access$set_graph$p(NavController $this, NavGraph navGraph) {
        $this._graph = navGraph;
    }

    public static final /* synthetic */ NavInflater access$getInflater$p(NavController $this) {
        return $this.inflater;
    }

    public static final /* synthetic */ void access$setInflater$p(NavController $this, NavInflater navInflater2) {
        $this.inflater = navInflater2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Landroidx/navigation/NavController$OnDestinationChangedListener;", "", "onDestinationChanged", "", "controller", "Landroidx/navigation/NavController;", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "navigation-runtime_release"})
    public static interface OnDestinationChangedListener {
        public void onDestinationChanged(@NotNull NavController var1, @NotNull NavDestination var2, @Nullable Bundle var3);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Landroidx/navigation/NavController$NavControllerNavigatorState;", "Landroidx/navigation/NavigatorState;", "navigator", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavDestination;", "(Landroidx/navigation/NavController;Landroidx/navigation/Navigator;)V", "getNavigator", "()Landroidx/navigation/Navigator;", "add", "", "backStackEntry", "Landroidx/navigation/NavBackStackEntry;", "addInternal", "createBackStackEntry", "destination", "arguments", "Landroid/os/Bundle;", "pop", "popUpTo", "saveState", "", "navigation-runtime_release"})
    private final class NavControllerNavigatorState
    extends NavigatorState {
        @NotNull
        private final Navigator<? extends NavDestination> navigator;

        /*
         * WARNING - void declaration
         */
        public void add(@NotNull NavBackStackEntry backStackEntry) {
            void $this$get$iv;
            Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
            NavigatorProvider navigatorProvider = NavController.this._navigatorProvider;
            String name$iv = backStackEntry.getDestination().getNavigatorName();
            boolean $i$f$get = false;
            Navigator destinationNavigator = $this$get$iv.getNavigator(name$iv);
            if (Intrinsics.areEqual((Object)destinationNavigator, this.navigator)) {
                Function1 handler = NavController.this.addToBackStackHandler;
                if (handler != null) {
                    handler.invoke((Object)backStackEntry);
                    this.addInternal(backStackEntry);
                } else {
                    Log.i((String)NavController.TAG, (String)("Ignoring add of destination " + backStackEntry.getDestination() + ' ' + "outside of the call to navigate(). "));
                }
            } else {
                Object v = NavController.this.navigatorState.get(destinationNavigator);
                boolean bl = false;
                boolean bl2 = false;
                if (v == null) {
                    boolean bl3 = false;
                    String string = "NavigatorBackStack for " + backStackEntry.getDestination().getNavigatorName() + " should " + "already be created";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                NavControllerNavigatorState navigatorBackStack = (NavControllerNavigatorState)((Object)v);
                navigatorBackStack.add(backStackEntry);
            }
        }

        public final void addInternal(@NotNull NavBackStackEntry backStackEntry) {
            Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
            super.add(backStackEntry);
        }

        @NotNull
        public NavBackStackEntry createBackStackEntry(@NotNull NavDestination destination, @Nullable Bundle arguments) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return NavBackStackEntry.Companion.create$default((NavBackStackEntry.Companion)NavBackStackEntry.Companion, (Context)NavController.this.getContext(), (NavDestination)destination, (Bundle)arguments, (LifecycleOwner)NavController.this.lifecycleOwner, (NavViewModelStoreProvider)NavController.this.viewModel, null, null, (int)96, null);
        }

        /*
         * WARNING - void declaration
         */
        public void pop(@NotNull NavBackStackEntry popUpTo, boolean saveState) {
            void $this$get$iv;
            Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
            NavigatorProvider navigatorProvider = NavController.this._navigatorProvider;
            String name$iv = popUpTo.getDestination().getNavigatorName();
            boolean $i$f$get = false;
            Navigator destinationNavigator = $this$get$iv.getNavigator(name$iv);
            if (Intrinsics.areEqual((Object)destinationNavigator, this.navigator)) {
                Function1 handler = NavController.this.popFromBackStackHandler;
                if (handler != null) {
                    handler.invoke((Object)popUpTo);
                    super.pop(popUpTo, saveState);
                } else {
                    Log.i((String)NavController.TAG, (String)("Ignoring pop of destination " + popUpTo.getDestination() + ' ' + "outside of the call to popBackStack(). "));
                }
            } else {
                Object v = NavController.this.navigatorState.get(destinationNavigator);
                Intrinsics.checkNotNull(v);
                ((NavControllerNavigatorState)((Object)v)).pop(popUpTo, saveState);
            }
        }

        @NotNull
        public final Navigator<? extends NavDestination> getNavigator() {
            return this.navigator;
        }

        public NavControllerNavigatorState(Navigator<? extends NavDestination> navigator) {
            Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
            this.navigator = navigator;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/navigation/NavController$Companion;", "", "()V", "KEY_BACK_STACK", "", "KEY_BACK_STACK_DEST_IDS", "KEY_BACK_STACK_IDS", "KEY_BACK_STACK_STATES_IDS", "KEY_BACK_STACK_STATES_PREFIX", "KEY_DEEP_LINK_ARGS", "KEY_DEEP_LINK_EXTRAS", "getKEY_DEEP_LINK_EXTRAS$annotations", "KEY_DEEP_LINK_HANDLED", "KEY_DEEP_LINK_IDS", "KEY_DEEP_LINK_INTENT", "KEY_NAVIGATOR_STATE", "KEY_NAVIGATOR_STATE_NAMES", "TAG", "navigation-runtime_release"})
    public static final class Companion {
        public static /* synthetic */ void getKEY_DEEP_LINK_EXTRAS$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

