/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import androidx.annotation.NavigationRes;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavAction;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.NavType;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.R;
import androidx.navigation.common.R;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0007\u001a\u00020\u00112\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0019\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u001c\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/navigation/NavInflater;", "", "context", "Landroid/content/Context;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroid/content/Context;Landroidx/navigation/NavigatorProvider;)V", "inflate", "Landroidx/navigation/NavDestination;", "res", "Landroid/content/res/Resources;", "parser", "Landroid/content/res/XmlResourceParser;", "attrs", "Landroid/util/AttributeSet;", "graphResId", "", "Landroidx/navigation/NavGraph;", "inflateAction", "", "dest", "inflateArgument", "Landroidx/navigation/NavArgument;", "a", "Landroid/content/res/TypedArray;", "inflateArgumentForBundle", "bundle", "Landroid/os/Bundle;", "inflateArgumentForDestination", "inflateDeepLink", "Companion", "navigation-runtime_release"})
public final class NavInflater {
    private final Context context;
    private final NavigatorProvider navigatorProvider;
    private static final String TAG_ARGUMENT = "argument";
    private static final String TAG_DEEP_LINK = "deepLink";
    private static final String TAG_ACTION = "action";
    private static final String TAG_INCLUDE = "include";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final String APPLICATION_ID_PLACEHOLDER = "${applicationId}";
    private static final ThreadLocal<TypedValue> sTmpValue;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ResourceType"})
    @NotNull
    public final NavGraph inflate(@NavigationRes int graphResId) {
        NavGraph navGraph;
        Resources res = this.context.getResources();
        XmlResourceParser xmlResourceParser = res.getXml(graphResId);
        Intrinsics.checkNotNullExpressionValue((Object)xmlResourceParser, (String)"res.getXml(graphResId)");
        XmlResourceParser parser = xmlResourceParser;
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser));
        try {
            boolean bl;
            int n;
            int type = 0;
            do {
                n = parser.next();
                boolean bl2 = false;
                bl = false;
                int it = n;
                boolean bl3 = false;
                type = it;
            } while (n != 2 && type != 1);
            if (type != 2) {
                throw (Throwable)new XmlPullParserException("No start tag found");
            }
            String rootElement = parser.getName();
            Resources resources = res;
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"res");
            AttributeSet attributeSet = attrs;
            Intrinsics.checkNotNullExpressionValue((Object)attributeSet, (String)"attrs");
            NavDestination destination = this.inflate(resources, parser, attributeSet, graphResId);
            bl = destination instanceof NavGraph;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Root element <" + rootElement + "> did not inflate into a NavGraph";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            navGraph = (NavGraph)destination;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Exception inflating " + res.getResourceName(graphResId) + " line " + parser.getLineNumber(), e);
        }
        finally {
            parser.close();
        }
        return navGraph;
    }

    private final NavDestination inflate(Resources res, XmlResourceParser parser, AttributeSet attrs, int graphResId) throws XmlPullParserException, IOException {
        String string = parser.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.name");
        Navigator navigator = this.navigatorProvider.getNavigator(string);
        NavDestination dest = navigator.createDestination();
        dest.onInflate(this.context, attrs);
        int innerDepth = parser.getDepth() + 1;
        int type = 0;
        int depth = 0;
        while (true) {
            int n = parser.next();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            type = it;
            if (n == 1) break;
            n = parser.getDepth();
            bl = false;
            bl2 = false;
            it = n;
            boolean bl4 = false;
            depth = it;
            if (n < innerDepth && type == 3) break;
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (Intrinsics.areEqual((Object)TAG_ARGUMENT, (Object)name)) {
                this.inflateArgumentForDestination(res, dest, attrs, graphResId);
                continue;
            }
            if (Intrinsics.areEqual((Object)TAG_DEEP_LINK, (Object)name)) {
                this.inflateDeepLink(res, dest, attrs);
                continue;
            }
            if (Intrinsics.areEqual((Object)TAG_ACTION, (Object)name)) {
                this.inflateAction(res, dest, attrs, parser, graphResId);
                continue;
            }
            if (Intrinsics.areEqual((Object)TAG_INCLUDE, (Object)name) && dest instanceof NavGraph) {
                TypedArray $this$use$iv;
                Intrinsics.checkNotNullExpressionValue((Object)res.obtainAttributes(attrs, R.styleable.NavInclude), (String)"res.obtainAttributes(att\u2026n.R.styleable.NavInclude)");
                boolean $i$f$use = false;
                TypedArray it2 = $this$use$iv;
                boolean bl5 = false;
                int id = it2.getResourceId(R.styleable.NavInclude_graph, 0);
                ((NavGraph)dest).addDestination((NavDestination)this.inflate(id));
                Unit unit = Unit.INSTANCE;
                boolean bl6 = false;
                boolean bl7 = false;
                Unit it$iv = unit;
                boolean bl8 = false;
                $this$use$iv.recycle();
                continue;
            }
            if (!(dest instanceof NavGraph)) continue;
            ((NavGraph)dest).addDestination(this.inflate(res, parser, attrs, graphResId));
        }
        return dest;
    }

    private final void inflateArgumentForDestination(Resources res, NavDestination dest, AttributeSet attrs, int graphResId) throws XmlPullParserException {
        TypedArray typedArray = res.obtainAttributes(attrs, R.styleable.NavArgument);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"res.obtainAttributes(att\u2026 R.styleable.NavArgument)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray array = $this$use$iv;
        boolean bl = false;
        String string = array.getString(R.styleable.NavArgument_android_name);
        if (string == null) {
            throw (Throwable)new XmlPullParserException("Arguments must have a name");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"array.getString(R.stylea\u2026uments must have a name\")");
        String name = string;
        NavArgument argument = this.inflateArgument(array, res, graphResId);
        dest.addArgument(name, argument);
        Unit unit = Unit.INSTANCE;
        boolean bl2 = false;
        boolean bl3 = false;
        Unit it$iv = unit;
        boolean bl4 = false;
        $this$use$iv.recycle();
    }

    private final void inflateArgumentForBundle(Resources res, Bundle bundle, AttributeSet attrs, int graphResId) throws XmlPullParserException {
        TypedArray typedArray = res.obtainAttributes(attrs, R.styleable.NavArgument);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"res.obtainAttributes(att\u2026 R.styleable.NavArgument)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray array = $this$use$iv;
        boolean bl = false;
        String string = array.getString(R.styleable.NavArgument_android_name);
        if (string == null) {
            throw (Throwable)new XmlPullParserException("Arguments must have a name");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"array.getString(R.stylea\u2026uments must have a name\")");
        String name = string;
        NavArgument argument = this.inflateArgument(array, res, graphResId);
        if (argument.isDefaultValuePresent()) {
            argument.putDefaultValue(name, bundle);
        }
        Unit unit = Unit.INSTANCE;
        boolean bl2 = false;
        boolean bl3 = false;
        Unit it$iv = unit;
        boolean bl4 = false;
        $this$use$iv.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final NavArgument inflateArgument(TypedArray a, Resources res, int graphResId) throws XmlPullParserException {
        NavArgument.Builder argumentBuilder = new NavArgument.Builder();
        argumentBuilder.setIsNullable(a.getBoolean(R.styleable.NavArgument_nullable, false));
        TypedValue value = sTmpValue.get();
        if (value == null) {
            value = new TypedValue();
            sTmpValue.set(value);
        }
        Object defaultValue = null;
        NavType<?> navType = null;
        String argType = a.getString(R.styleable.NavArgument_argType);
        if (argType != null) {
            navType = NavType.Companion.fromArgType(argType, res.getResourcePackageName(graphResId));
        }
        if (a.getValue(R.styleable.NavArgument_android_defaultValue, value)) {
            if (navType == NavType.ReferenceType) {
                int n;
                if (value.resourceId != 0) {
                    n = value.resourceId;
                } else {
                    if (value.type != 16 || value.data != 0) throw (Throwable)new XmlPullParserException("unsupported value '" + value.string + "' for " + navType.getName() + ". Must be a " + "reference to a resource.");
                    n = 0;
                }
                defaultValue = n;
            } else if (value.resourceId != 0) {
                if (navType != null) throw (Throwable)new XmlPullParserException("unsupported value '" + value.string + "' for " + navType.getName() + ". You must use a " + '\"' + NavType.ReferenceType.getName() + "\" type to reference other resources.");
                navType = NavType.ReferenceType;
                defaultValue = value.resourceId;
            } else if (navType == NavType.StringType) {
                defaultValue = a.getString(R.styleable.NavArgument_android_defaultValue);
            } else {
                switch (value.type) {
                    case 3: {
                        String stringValue = ((Object)value.string).toString();
                        if (navType == null) {
                            navType = NavType.Companion.inferFromValue(stringValue);
                        }
                        defaultValue = navType.parseValue(stringValue);
                        break;
                    }
                    case 5: {
                        navType = Companion.checkNavType$navigation_runtime_release(value, navType, NavType.IntType, argType, "dimension");
                        defaultValue = (int)value.getDimension(res.getDisplayMetrics());
                        break;
                    }
                    case 4: {
                        navType = Companion.checkNavType$navigation_runtime_release(value, navType, NavType.FloatType, argType, "float");
                        defaultValue = Float.valueOf(value.getFloat());
                        break;
                    }
                    case 18: {
                        navType = Companion.checkNavType$navigation_runtime_release(value, navType, NavType.BoolType, argType, "boolean");
                        defaultValue = value.data != 0;
                        break;
                    }
                    default: {
                        if (value.type < 16 || value.type > 31) throw (Throwable)new XmlPullParserException("unsupported argument type " + value.type);
                        if (navType == NavType.FloatType) {
                            navType = Companion.checkNavType$navigation_runtime_release(value, navType, NavType.FloatType, argType, "float");
                            defaultValue = Float.valueOf(value.data);
                            break;
                        }
                        navType = Companion.checkNavType$navigation_runtime_release(value, navType, NavType.IntType, argType, "integer");
                        defaultValue = value.data;
                        break;
                    }
                }
            }
        }
        if (defaultValue != null) {
            argumentBuilder.setDefaultValue(defaultValue);
        }
        if (navType == null) return argumentBuilder.build();
        argumentBuilder.setType((NavType)navType);
        return argumentBuilder.build();
    }

    private final void inflateDeepLink(Resources res, NavDestination dest, AttributeSet attrs) throws XmlPullParserException {
        TypedArray typedArray = res.obtainAttributes(attrs, R.styleable.NavDeepLink);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"res.obtainAttributes(att\u2026 R.styleable.NavDeepLink)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray array = $this$use$iv;
        boolean bl = false;
        String uri = array.getString(R.styleable.NavDeepLink_uri);
        String action = array.getString(R.styleable.NavDeepLink_action);
        String mimeType = array.getString(R.styleable.NavDeepLink_mimeType);
        CharSequence charSequence = uri;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = action;
            bl2 = false;
            bl3 = false;
            if (charSequence == null || charSequence.length() == 0) {
                charSequence = mimeType;
                bl2 = false;
                bl3 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    throw (Throwable)new XmlPullParserException("Every <deepLink> must include at least one of app:uri, app:action, or app:mimeType");
                }
            }
        }
        NavDeepLink.Builder builder = new NavDeepLink.Builder();
        if (uri != null) {
            String string = this.context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
            builder.setUriPattern(StringsKt.replace$default((String)uri, (String)APPLICATION_ID_PLACEHOLDER, (String)string, (boolean)false, (int)4, null));
        }
        CharSequence charSequence2 = action;
        bl3 = false;
        boolean bl4 = false;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            String string = this.context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
            builder.setAction(StringsKt.replace$default((String)action, (String)APPLICATION_ID_PLACEHOLDER, (String)string, (boolean)false, (int)4, null));
        }
        if (mimeType != null) {
            String string = this.context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
            builder.setMimeType(StringsKt.replace$default((String)mimeType, (String)APPLICATION_ID_PLACEHOLDER, (String)string, (boolean)false, (int)4, null));
        }
        dest.addDeepLink(builder.build());
        Unit unit = Unit.INSTANCE;
        boolean bl5 = false;
        boolean bl6 = false;
        Unit it$iv = unit;
        boolean bl7 = false;
        $this$use$iv.recycle();
    }

    private final void inflateAction(Resources res, NavDestination dest, AttributeSet attrs, XmlResourceParser parser, int graphResId) throws IOException, XmlPullParserException {
        TypedArray typedArray = res.obtainAttributes(attrs, R.styleable.NavAction);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"res.obtainAttributes(attrs, R.styleable.NavAction)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray array = $this$use$iv;
        boolean bl = false;
        int id = array.getResourceId(R.styleable.NavAction_android_id, 0);
        int destId = array.getResourceId(R.styleable.NavAction_destination, 0);
        NavAction action = new NavAction(destId, null, null, 6, null);
        NavOptions.Builder builder = new NavOptions.Builder();
        builder.setLaunchSingleTop(array.getBoolean(R.styleable.NavAction_launchSingleTop, false));
        builder.setRestoreState(array.getBoolean(R.styleable.NavAction_restoreState, false));
        builder.setPopUpTo(array.getResourceId(R.styleable.NavAction_popUpTo, -1), array.getBoolean(R.styleable.NavAction_popUpToInclusive, false), array.getBoolean(R.styleable.NavAction_popUpToSaveState, false));
        builder.setEnterAnim(array.getResourceId(R.styleable.NavAction_enterAnim, -1));
        builder.setExitAnim(array.getResourceId(R.styleable.NavAction_exitAnim, -1));
        builder.setPopEnterAnim(array.getResourceId(R.styleable.NavAction_popEnterAnim, -1));
        builder.setPopExitAnim(array.getResourceId(R.styleable.NavAction_popExitAnim, -1));
        action.setNavOptions(builder.build());
        Bundle args = new Bundle();
        int innerDepth = parser.getDepth() + 1;
        int type = 0;
        int depth = 0;
        while (true) {
            String name;
            int n = parser.next();
            boolean bl2 = false;
            boolean bl3 = false;
            int it = n;
            boolean bl4 = false;
            type = it;
            if (n == 1) break;
            n = parser.getDepth();
            bl2 = false;
            bl3 = false;
            it = n;
            boolean bl5 = false;
            depth = it;
            if (n < innerDepth && type == 3) break;
            if (type != 2 || depth > innerDepth || !Intrinsics.areEqual((Object)TAG_ARGUMENT, (Object)(name = parser.getName()))) continue;
            this.inflateArgumentForBundle(res, args, attrs, graphResId);
        }
        if (!args.isEmpty()) {
            action.setDefaultArguments(args);
        }
        dest.putAction(id, action);
        Unit unit = Unit.INSTANCE;
        boolean bl6 = false;
        boolean bl7 = false;
        Unit it$iv = unit;
        boolean bl8 = false;
        $this$use$iv.recycle();
    }

    public NavInflater(@NotNull Context context, @NotNull NavigatorProvider navigatorProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
        this.context = context;
        this.navigatorProvider = navigatorProvider;
    }

    static {
        Companion = new Companion(null);
        sTmpValue = new ThreadLocal();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/navigation/NavInflater$Companion;", "", "()V", "APPLICATION_ID_PLACEHOLDER", "", "TAG_ACTION", "TAG_ARGUMENT", "TAG_DEEP_LINK", "TAG_INCLUDE", "sTmpValue", "Ljava/lang/ThreadLocal;", "Landroid/util/TypedValue;", "checkNavType", "Landroidx/navigation/NavType;", "value", "navType", "expectedNavType", "argType", "foundType", "checkNavType$navigation_runtime_release", "navigation-runtime_release"})
    public static final class Companion {
        @NotNull
        public final NavType<?> checkNavType$navigation_runtime_release(@NotNull TypedValue value, @Nullable NavType<?> navType, @NotNull NavType<?> expectedNavType, @Nullable String argType, @NotNull String foundType) throws XmlPullParserException {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(expectedNavType, (String)"expectedNavType");
            Intrinsics.checkNotNullParameter((Object)foundType, (String)"foundType");
            if (navType != null && navType != expectedNavType) {
                throw (Throwable)new XmlPullParserException("Type is " + argType + " but found " + foundType + ": " + value.data);
            }
            NavType<?> navType2 = navType;
            if (navType2 == null) {
                navType2 = expectedNavType;
            }
            return navType2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

