/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.annotation.SuppressLint;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.customview.widget.Openable;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.navigation.NavGraph;
import androidx.navigation.ui.NavigationUI;
import java.util.HashSet;
import java.util.Set;

public final class AppBarConfiguration {
    @NonNull
    private final Set<Integer> mTopLevelDestinations;
    @Nullable
    private final Openable mOpenableLayout;
    @Nullable
    private final OnNavigateUpListener mFallbackOnNavigateUpListener;

    private AppBarConfiguration(@NonNull Set<Integer> topLevelDestinations, @Nullable Openable openableLayout, @Nullable OnNavigateUpListener fallbackOnNavigateUpListener) {
        this.mTopLevelDestinations = topLevelDestinations;
        this.mOpenableLayout = openableLayout;
        this.mFallbackOnNavigateUpListener = fallbackOnNavigateUpListener;
    }

    @NonNull
    public Set<Integer> getTopLevelDestinations() {
        return this.mTopLevelDestinations;
    }

    @Nullable
    public Openable getOpenableLayout() {
        return this.mOpenableLayout;
    }

    @Deprecated
    @Nullable
    public DrawerLayout getDrawerLayout() {
        if (this.mOpenableLayout instanceof DrawerLayout) {
            return (DrawerLayout)this.mOpenableLayout;
        }
        return null;
    }

    @Nullable
    public OnNavigateUpListener getFallbackOnNavigateUpListener() {
        return this.mFallbackOnNavigateUpListener;
    }

    public static final class Builder {
        @NonNull
        private final Set<Integer> mTopLevelDestinations = new HashSet<Integer>();
        @Nullable
        private Openable mOpenableLayout;
        @Nullable
        private OnNavigateUpListener mFallbackOnNavigateUpListener;

        public Builder(@NonNull NavGraph navGraph) {
            this.mTopLevelDestinations.add(NavigationUI.findStartDestination(navGraph).getId());
        }

        public Builder(@NonNull Menu topLevelMenu) {
            int size = topLevelMenu.size();
            for (int index = 0; index < size; ++index) {
                MenuItem item = topLevelMenu.getItem(index);
                this.mTopLevelDestinations.add(item.getItemId());
            }
        }

        public Builder(int ... topLevelDestinationIds) {
            for (int destinationId : topLevelDestinationIds) {
                this.mTopLevelDestinations.add(destinationId);
            }
        }

        public Builder(@NonNull Set<Integer> topLevelDestinationIds) {
            this.mTopLevelDestinations.addAll(topLevelDestinationIds);
        }

        @Deprecated
        @NonNull
        public Builder setDrawerLayout(@Nullable DrawerLayout drawerLayout) {
            this.mOpenableLayout = drawerLayout;
            return this;
        }

        @NonNull
        public Builder setOpenableLayout(@Nullable Openable openableLayout) {
            this.mOpenableLayout = openableLayout;
            return this;
        }

        @NonNull
        public Builder setFallbackOnNavigateUpListener(@Nullable OnNavigateUpListener fallbackOnNavigateUpListener) {
            this.mFallbackOnNavigateUpListener = fallbackOnNavigateUpListener;
            return this;
        }

        @SuppressLint(value={"SyntheticAccessor"})
        @NonNull
        public AppBarConfiguration build() {
            return new AppBarConfiguration(this.mTopLevelDestinations, this.mOpenableLayout, this.mFallbackOnNavigateUpListener);
        }
    }

    public static interface OnNavigateUpListener {
        public boolean onNavigateUp();
    }
}

