/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import androidx.annotation.StringRes;
import androidx.appcompat.graphics.drawable.DrawerArrowDrawable;
import androidx.customview.widget.Openable;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.R;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u001c\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH$J\u0012\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010!H$R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/navigation/ui/AbstractAppBarOnDestinationChangedListener;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "context", "Landroid/content/Context;", "configuration", "Landroidx/navigation/ui/AppBarConfiguration;", "(Landroid/content/Context;Landroidx/navigation/ui/AppBarConfiguration;)V", "animator", "Landroid/animation/ValueAnimator;", "arrowDrawable", "Landroidx/appcompat/graphics/drawable/DrawerArrowDrawable;", "openableLayoutWeakReference", "Ljava/lang/ref/WeakReference;", "Landroidx/customview/widget/Openable;", "kotlin.jvm.PlatformType", "onDestinationChanged", "", "controller", "Landroidx/navigation/NavController;", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "setActionBarUpIndicator", "showAsDrawerIndicator", "", "setNavigationIcon", "icon", "Landroid/graphics/drawable/Drawable;", "contentDescription", "", "setTitle", "title", "", "navigation-ui_release"})
public abstract class AbstractAppBarOnDestinationChangedListener
implements NavController.OnDestinationChangedListener {
    @NotNull
    private final Context context;
    @NotNull
    private final AppBarConfiguration configuration;
    @Nullable
    private final WeakReference<Openable> openableLayoutWeakReference;
    @Nullable
    private DrawerArrowDrawable arrowDrawable;
    @Nullable
    private ValueAnimator animator;

    /*
     * WARNING - void declaration
     */
    public AbstractAppBarOnDestinationChangedListener(@NotNull Context context, @NotNull AppBarConfiguration configuration) {
        WeakReference<void> weakReference;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.context = context;
        this.configuration = configuration;
        AbstractAppBarOnDestinationChangedListener abstractAppBarOnDestinationChangedListener = this;
        Openable openable = this.configuration.getOpenableLayout();
        if (openable != null) {
            void $this$openableLayoutWeakReference_u24lambda_u240;
            Openable openable2 = openable;
            AbstractAppBarOnDestinationChangedListener abstractAppBarOnDestinationChangedListener2 = abstractAppBarOnDestinationChangedListener;
            boolean bl = false;
            weakReference = new WeakReference<void>($this$openableLayoutWeakReference_u24lambda_u240);
            abstractAppBarOnDestinationChangedListener = abstractAppBarOnDestinationChangedListener2;
        } else {
            weakReference = null;
        }
        abstractAppBarOnDestinationChangedListener.openableLayoutWeakReference = weakReference;
    }

    protected abstract void setTitle(@Nullable CharSequence var1);

    protected abstract void setNavigationIcon(@Nullable Drawable var1, @StringRes int var2);

    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Openable openableLayout;
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination instanceof FloatingWindow) {
            return;
        }
        WeakReference<Openable> weakReference = this.openableLayoutWeakReference;
        Object object = openableLayout = weakReference != null ? (Openable)weakReference.get() : null;
        if (this.openableLayoutWeakReference != null && openableLayout == null) {
            controller.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            return;
        }
        String label = destination.fillInLabel(this.context, arguments);
        if (label != null) {
            this.setTitle(label);
        }
        boolean isTopLevelDestination = this.configuration.isTopLevelDestination(destination);
        if (openableLayout == null && isTopLevelDestination) {
            this.setNavigationIcon(null, 0);
        } else {
            this.setActionBarUpIndicator(openableLayout != null && isTopLevelDestination);
        }
    }

    @SuppressLint(value={"ObjectAnimatorBinding"})
    private final void setActionBarUpIndicator(boolean showAsDrawerIndicator) {
        float endValue;
        DrawerArrowDrawable drawerArrowDrawable;
        block7: {
            DrawerArrowDrawable drawerArrowDrawable2;
            block6: {
                drawerArrowDrawable = this.arrowDrawable;
                if (drawerArrowDrawable == null) break block6;
                DrawerArrowDrawable $this$setActionBarUpIndicator_u24lambda_u241 = drawerArrowDrawable;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)$this$setActionBarUpIndicator_u24lambda_u241, (Object)true);
                drawerArrowDrawable = pair;
                if (pair != null) break block7;
            }
            DrawerArrowDrawable it = drawerArrowDrawable2 = new DrawerArrowDrawable(this.context);
            boolean bl = false;
            this.arrowDrawable = it;
            drawerArrowDrawable = TuplesKt.to((Object)drawerArrowDrawable2, (Object)false);
        }
        DrawerArrowDrawable drawerArrowDrawable3 = drawerArrowDrawable;
        DrawerArrowDrawable arrow = (DrawerArrowDrawable)drawerArrowDrawable3.component1();
        boolean animate = (Boolean)drawerArrowDrawable3.component2();
        this.setNavigationIcon((Drawable)arrow, showAsDrawerIndicator ? R.string.nav_app_bar_open_drawer_description : R.string.nav_app_bar_navigate_up_description);
        float f = endValue = showAsDrawerIndicator ? 0.0f : 1.0f;
        if (animate) {
            float startValue = arrow.getProgress();
            ValueAnimator valueAnimator = this.animator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            float[] fArray = new float[]{startValue, endValue};
            ValueAnimator valueAnimator2 = this.animator = (ValueAnimator)ObjectAnimator.ofFloat((Object)arrow, (String)"progress", (float[])fArray);
            Intrinsics.checkNotNull((Object)valueAnimator2, (String)"null cannot be cast to non-null type android.animation.ObjectAnimator");
            ((ObjectAnimator)valueAnimator2).start();
        } else {
            arrow.setProgress(endValue);
        }
    }
}

