/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.annotation.SuppressLint;
import android.view.Menu;
import android.view.MenuItem;
import androidx.customview.widget.Openable;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B)\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Landroidx/navigation/ui/AppBarConfiguration;", "", "topLevelDestinations", "", "", "openableLayout", "Landroidx/customview/widget/Openable;", "fallbackOnNavigateUpListener", "Landroidx/navigation/ui/AppBarConfiguration$OnNavigateUpListener;", "(Ljava/util/Set;Landroidx/customview/widget/Openable;Landroidx/navigation/ui/AppBarConfiguration$OnNavigateUpListener;)V", "drawerLayout", "Landroidx/drawerlayout/widget/DrawerLayout;", "getDrawerLayout", "()Landroidx/drawerlayout/widget/DrawerLayout;", "getFallbackOnNavigateUpListener", "()Landroidx/navigation/ui/AppBarConfiguration$OnNavigateUpListener;", "getOpenableLayout", "()Landroidx/customview/widget/Openable;", "getTopLevelDestinations", "()Ljava/util/Set;", "isTopLevelDestination", "", "destination", "Landroidx/navigation/NavDestination;", "Builder", "OnNavigateUpListener", "navigation-ui_release"})
public final class AppBarConfiguration {
    @NotNull
    private final Set<Integer> topLevelDestinations;
    @Nullable
    private final Openable openableLayout;
    @Nullable
    private final OnNavigateUpListener fallbackOnNavigateUpListener;

    private AppBarConfiguration(Set<Integer> topLevelDestinations, Openable openableLayout, OnNavigateUpListener fallbackOnNavigateUpListener) {
        this.topLevelDestinations = topLevelDestinations;
        this.openableLayout = openableLayout;
        this.fallbackOnNavigateUpListener = fallbackOnNavigateUpListener;
    }

    @NotNull
    public final Set<Integer> getTopLevelDestinations() {
        return this.topLevelDestinations;
    }

    @Nullable
    public final Openable getOpenableLayout() {
        return this.openableLayout;
    }

    @Nullable
    public final OnNavigateUpListener getFallbackOnNavigateUpListener() {
        return this.fallbackOnNavigateUpListener;
    }

    @Deprecated(message="Use {@link #getOpenableLayout()}.")
    @Nullable
    public final DrawerLayout getDrawerLayout() {
        return this.openableLayout instanceof DrawerLayout ? (DrawerLayout)this.openableLayout : null;
    }

    public final boolean isTopLevelDestination(@NotNull NavDestination destination) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Sequence $this$any$iv = NavDestination.Companion.getHierarchy(destination);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                NavDestination parent = (NavDestination)element$iv;
                boolean bl2 = false;
                boolean bl3 = this.topLevelDestinations.contains(parent.getId()) ? (parent instanceof NavGraph ? destination.getId() == NavGraph.Companion.findStartDestination((NavGraph)parent).getId() : true) : false;
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public /* synthetic */ AppBarConfiguration(Set topLevelDestinations, Openable openableLayout, OnNavigateUpListener fallbackOnNavigateUpListener, DefaultConstructorMarker $constructor_marker) {
        this(topLevelDestinations, openableLayout, fallbackOnNavigateUpListener);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Landroidx/navigation/ui/AppBarConfiguration$OnNavigateUpListener;", "", "onNavigateUp", "", "navigation-ui_release"})
    public static interface OnNavigateUpListener {
        public boolean onNavigateUp();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0013\b\u0016\u0012\n\u0010\b\u001a\u00020\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0015\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/ui/AppBarConfiguration$Builder;", "", "navGraph", "Landroidx/navigation/NavGraph;", "(Landroidx/navigation/NavGraph;)V", "topLevelMenu", "Landroid/view/Menu;", "(Landroid/view/Menu;)V", "topLevelDestinationIds", "", "", "([I)V", "", "(Ljava/util/Set;)V", "fallbackOnNavigateUpListener", "Landroidx/navigation/ui/AppBarConfiguration$OnNavigateUpListener;", "openableLayout", "Landroidx/customview/widget/Openable;", "topLevelDestinations", "", "build", "Landroidx/navigation/ui/AppBarConfiguration;", "setDrawerLayout", "drawerLayout", "Landroidx/drawerlayout/widget/DrawerLayout;", "setFallbackOnNavigateUpListener", "setOpenableLayout", "navigation-ui_release"})
    public static final class Builder {
        @NotNull
        private final Set<Integer> topLevelDestinations;
        @Nullable
        private Openable openableLayout;
        @Nullable
        private OnNavigateUpListener fallbackOnNavigateUpListener;

        public Builder(@NotNull NavGraph navGraph) {
            Intrinsics.checkNotNullParameter((Object)navGraph, (String)"navGraph");
            this.topLevelDestinations = new HashSet();
            this.topLevelDestinations.add(NavGraph.Companion.findStartDestination(navGraph).getId());
        }

        public Builder(@NotNull Menu topLevelMenu) {
            Intrinsics.checkNotNullParameter((Object)topLevelMenu, (String)"topLevelMenu");
            this.topLevelDestinations = new HashSet();
            int size = topLevelMenu.size();
            for (int index = 0; index < size; ++index) {
                MenuItem item = topLevelMenu.getItem(index);
                this.topLevelDestinations.add(item.getItemId());
            }
        }

        public Builder(int ... topLevelDestinationIds) {
            Intrinsics.checkNotNullParameter((Object)topLevelDestinationIds, (String)"topLevelDestinationIds");
            this.topLevelDestinations = new HashSet();
            for (int destinationId : topLevelDestinationIds) {
                this.topLevelDestinations.add(destinationId);
            }
        }

        public Builder(@NotNull Set<Integer> topLevelDestinationIds) {
            Intrinsics.checkNotNullParameter(topLevelDestinationIds, (String)"topLevelDestinationIds");
            this.topLevelDestinations = new HashSet();
            this.topLevelDestinations.addAll((Collection<Integer>)topLevelDestinationIds);
        }

        @Deprecated(message="Use {@link #setOpenableLayout(Openable)}.")
        @NotNull
        public final Builder setDrawerLayout(@Nullable DrawerLayout drawerLayout) {
            this.openableLayout = (Openable)drawerLayout;
            return this;
        }

        @NotNull
        public final Builder setOpenableLayout(@Nullable Openable openableLayout) {
            this.openableLayout = openableLayout;
            return this;
        }

        @NotNull
        public final Builder setFallbackOnNavigateUpListener(@Nullable OnNavigateUpListener fallbackOnNavigateUpListener) {
            this.fallbackOnNavigateUpListener = fallbackOnNavigateUpListener;
            return this;
        }

        @SuppressLint(value={"SyntheticAccessor"})
        @NotNull
        public final AppBarConfiguration build() {
            return new AppBarConfiguration(this.topLevelDestinations, this.openableLayout, this.fallbackOnNavigateUpListener, null);
        }
    }
}

