/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutParameterProcessor;
import androidx.room.vo.ShortcutQueryParameter;
import com.google.auto.common.MoreTypes;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0012H\u0007J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Landroidx/room/processor/ShortcutParameterProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "element", "Ljavax/lang/model/element/VariableElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/VariableElement;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/VariableElement;", "extractEntityType", "Lkotlin/Pair;", "Ljavax/lang/model/type/TypeMirror;", "", "typeMirror", "process", "Landroidx/room/vo/ShortcutQueryParameter;", "room-compiler"})
public final class ShortcutParameterProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final VariableElement element;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShortcutQueryParameter process() {
        void entityType;
        TypeMirror asMember = MoreTypes.asMemberOf((Types)this.context.getProcessingEnv().getTypeUtils(), (DeclaredType)this.containing, (VariableElement)this.element);
        String name = this.element.getSimpleName().toString();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), this.element, ProcessorErrors.INSTANCE.getQUERY_PARAMETERS_CANNOT_START_WITH_UNDERSCORE(), new Object[0]);
        TypeMirror typeMirror = asMember;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"asMember");
        Pair<TypeMirror, Boolean> pair = this.extractEntityType(typeMirror);
        TypeMirror typeMirror2 = (TypeMirror)pair.component1();
        boolean isMultiple = (Boolean)pair.component2();
        this.context.getChecker().check(entityType != null, this.element, ProcessorErrors.INSTANCE.getCANNOT_FIND_ENTITY_FOR_SHORTCUT_QUERY_PARAMETER(), new Object[0]);
        return new ShortcutQueryParameter(name, asMember, (TypeMirror)entityType, isMultiple);
    }

    @NotNull
    public final Pair<TypeMirror, Boolean> extractEntityType(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkParameterIsNotNull((Object)typeMirror, (String)"typeMirror");
        Elements elementUtils = this.context.getProcessingEnv().getElementUtils();
        Types typeUtils = this.context.getProcessingEnv().getTypeUtils();
        extractEntityType.1 verifyAndPair$ = extractEntityType.1.INSTANCE;
        Function1<DeclaredType, TypeMirror> extractEntityTypeFromIterator$ = new Function1<DeclaredType, TypeMirror>(elementUtils, typeUtils){
            final /* synthetic */ Elements $elementUtils;
            final /* synthetic */ Types $typeUtils;

            @NotNull
            public final TypeMirror invoke(@NotNull DeclaredType iterableType) {
                Intrinsics.checkParameterIsNotNull((Object)iterableType, (String)"iterableType");
                Element element = this.$typeUtils.asElement(iterableType);
                if (element == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                List<ExecutableElement> list = ElementFilter.methodsIn((Iterable<? extends Element>)this.$elementUtils.getAllMembers((TypeElement)element));
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"ElementFilter.methodsIn(\u2026bleType) as TypeElement))");
                Iterable $receiver$iv = list;
                for (T element$iv : $receiver$iv) {
                    ExecutableElement it;
                    ExecutableElement executableElement = it = (ExecutableElement)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"it");
                    if (!Intrinsics.areEqual((Object)executableElement.getSimpleName().toString(), (Object)"iterator")) continue;
                    ExecutableType executableType = MoreTypes.asExecutable((TypeMirror)this.$typeUtils.asMemberOf(iterableType, it));
                    Intrinsics.checkExpressionValueIsNotNull((Object)executableType, (String)"MoreTypes.asExecutable(\n\u2026mberOf(iterableType, it))");
                    DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)executableType.getReturnType());
                    Intrinsics.checkExpressionValueIsNotNull((Object)declaredType, (String)"MoreTypes.asDeclared(Mor\u2026bleType, it)).returnType)");
                    List<? extends TypeMirror> list2 = declaredType.getTypeArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"MoreTypes.asDeclared(Mor\u2026           .typeArguments");
                    Object object = CollectionsKt.first(list2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"MoreTypes.asDeclared(Mor\u2026   .typeArguments.first()");
                    return (TypeMirror)object;
                }
                throw (Throwable)new IllegalArgumentException("iterator() not found in Iterable " + iterableType);
            }
            {
                this.$elementUtils = elements;
                this.$typeUtils = types;
                super(1);
            }
        };
        TypeMirror iterableType = typeUtils.erasure(elementUtils.getTypeElement("java.lang.Iterable").asType());
        if (typeUtils.isAssignable(typeMirror, iterableType)) {
            DeclaredType declared;
            DeclaredType declaredType = declared = MoreTypes.asDeclared((TypeMirror)typeMirror);
            Intrinsics.checkExpressionValueIsNotNull((Object)declaredType, (String)"declared");
            TypeMirror entity = extractEntityTypeFromIterator$.invoke(declaredType);
            return verifyAndPair$.invoke(entity, true);
        }
        if (typeMirror instanceof ArrayType) {
            TypeMirror entity;
            TypeMirror typeMirror2 = entity = ((ArrayType)typeMirror).getComponentType();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"entity");
            return verifyAndPair$.invoke(typeMirror2, true);
        }
        return verifyAndPair$.invoke(typeMirror, false);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final VariableElement getElement() {
        return this.element;
    }

    public ShortcutParameterProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull VariableElement element) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.containing = containing;
        this.element = element;
        this.context = baseContext.fork(this.element);
    }
}

