/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.ext.CommonTypeNames;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.Index;
import androidx.room.writer.TableInfoValidationWriter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Landroidx/room/writer/TableInfoValidationWriter;", "", "entity", "Landroidx/room/vo/Entity;", "(Landroidx/room/vo/Entity;)V", "getEntity", "()Landroidx/room/vo/Entity;", "statementCount", "", "write", "", "dbParam", "Lcom/squareup/javapoet/ParameterSpec;", "scope", "Landroidx/room/solver/CodeGenScope;", "room-compiler"})
public final class TableInfoValidationWriter {
    @NotNull
    private final Entity entity;

    public final void write(@NotNull ParameterSpec dbParam, @NotNull CodeGenScope scope) {
        CodeBlock.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)dbParam, (String)"dbParam");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        String suffix = StringsKt.capitalize((String)String_extKt.stripNonJava(this.entity.getTableName()));
        String expectedInfoVar = scope.getTmpVar("_info" + suffix);
        CodeBlock.Builder $receiver = builder = scope.builder();
        String columnListVar = scope.getTmpVar("_columns" + suffix);
        ParameterizedTypeName columnListType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashMap.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING(), (TypeName)RoomTypeNames.INSTANCE.getTABLE_INFO_COLUMN()});
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{columnListType, columnListVar, columnListType, this.entity.getFields().size()});
        Iterable $receiver$iv = this.entity.getFields();
        for (Object element$iv : $receiver$iv) {
            Field field = (Field)element$iv;
            String string = Javapoet_extKt.getL() + ".put(" + Javapoet_extKt.getS() + ", new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + "))";
            Object[] objectArray = new Object[7];
            objectArray[0] = columnListVar;
            objectArray[1] = field.getColumnName();
            objectArray[2] = RoomTypeNames.INSTANCE.getTABLE_INFO_COLUMN();
            objectArray[3] = field.getColumnName();
            Object object = field.getAffinity();
            if (object == null || (object = object.name()) == null) {
                object = SQLTypeAffinity.TEXT.name();
            }
            objectArray[4] = object;
            objectArray[5] = field.getNonNull();
            objectArray[6] = this.entity.getPrimaryKey().getFields().indexOf(field) + 1;
            $receiver.addStatement(string, objectArray);
        }
        String foreignKeySetVar = scope.getTmpVar("_foreignKeys" + suffix);
        ParameterizedTypeName foreignKeySetType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashSet.class)), (TypeName[])new TypeName[]{(TypeName)RoomTypeNames.INSTANCE.getTABLE_INFO_FOREIGN_KEY()});
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{foreignKeySetType, foreignKeySetVar, foreignKeySetType, this.entity.getForeignKeys().size()});
        Iterable $receiver$iv2 = this.entity.getForeignKeys();
        for (Object element$iv : $receiver$iv2) {
            ForeignKey it = (ForeignKey)element$iv;
            String myColumnNames2 = CollectionsKt.joinToString$default((Iterable)it.getChildFields(), (CharSequence)",", null, null, (int)0, null, (Function1)write.1.2.myColumnNames.1.INSTANCE, (int)30, null);
            String refColumnNames2 = CollectionsKt.joinToString$default((Iterable)it.getParentColumns(), (CharSequence)",", null, null, (int)0, null, (Function1)write.1.2.refColumnNames.1.INSTANCE, (int)30, null);
            $receiver.addStatement(Javapoet_extKt.getL() + ".add(new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ',' + Javapoet_extKt.getT() + ".asList(" + Javapoet_extKt.getL() + "), " + Javapoet_extKt.getT() + ".asList(" + Javapoet_extKt.getL() + ")))", new Object[]{foreignKeySetVar, RoomTypeNames.INSTANCE.getTABLE_INFO_FOREIGN_KEY(), it.getParentTable(), it.getOnDelete().getSqlName(), it.getOnUpdate().getSqlName(), Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(Arrays.class)), myColumnNames2, Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(Arrays.class)), refColumnNames2});
        }
        String indicesSetVar = scope.getTmpVar("_indices" + suffix);
        ParameterizedTypeName indicesType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashSet.class)), (TypeName[])new TypeName[]{(TypeName)RoomTypeNames.INSTANCE.getTABLE_INFO_INDEX()});
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{indicesType, indicesSetVar, indicesType, this.entity.getIndices().size()});
        Iterable $receiver$iv3 = this.entity.getIndices();
        CodeBlock.Builder builder2 = $receiver$iv3.iterator();
        while (builder2.hasNext()) {
            Object element$iv = builder2.next();
            Index index = (Index)element$iv;
            String columnNames2 = CollectionsKt.joinToString$default((Iterable)index.getFields(), (CharSequence)",", null, null, (int)0, null, (Function1)write.1.3.columnNames.1.INSTANCE, (int)30, null);
            $receiver.addStatement(Javapoet_extKt.getL() + ".add(new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getT() + ".asList(" + Javapoet_extKt.getL() + ")))", new Object[]{indicesSetVar, RoomTypeNames.INSTANCE.getTABLE_INFO_INDEX(), index.getName(), index.getUnique(), Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(Arrays.class)), columnNames2});
        }
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ')', new Object[]{RoomTypeNames.INSTANCE.getTABLE_INFO(), expectedInfoVar, RoomTypeNames.INSTANCE.getTABLE_INFO(), this.entity.getTableName(), columnListVar, foreignKeySetVar, indicesSetVar});
        String existingVar = scope.getTmpVar("_existing" + suffix);
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getT() + ".read(" + Javapoet_extKt.getN() + ", " + Javapoet_extKt.getS() + ')', new Object[]{RoomTypeNames.INSTANCE.getTABLE_INFO(), existingVar, RoomTypeNames.INSTANCE.getTABLE_INFO(), dbParam, this.entity.getTableName()});
        CodeBlock.Builder $receiver2 = builder2 = $receiver.beginControlFlow("if (! " + Javapoet_extKt.getL() + ".equals(" + Javapoet_extKt.getL() + "))", new Object[]{expectedInfoVar, existingVar});
        $receiver2.addStatement("throw new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getS() + " + " + Javapoet_extKt.getL() + " + " + Javapoet_extKt.getS() + " + " + Javapoet_extKt.getL() + ')', new Object[]{Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(IllegalStateException.class)), "Migration didn't properly handle " + this.entity.getTableName() + '(' + this.entity.getElement().getQualifiedName() + ").\n Expected:\n", expectedInfoVar, "\n Found:\n", existingVar});
        $receiver.endControlFlow();
    }

    public final int statementCount() {
        return this.entity.getFields().size() + this.entity.getForeignKeys().size() + this.entity.getIndices().size();
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    public TableInfoValidationWriter(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entity = entity;
    }
}

