/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.ext.Element_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.Index;
import androidx.room.vo.InsertionMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutMethod;
import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J,\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010!\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/element/TypeElement;)V", "baseClassElement", "Ljavax/lang/model/type/TypeMirror;", "getBaseClassElement", "()Ljavax/lang/model/type/TypeMirror;", "baseClassElement$delegate", "Lkotlin/Lazy;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "doProcess", "Landroidx/room/vo/Database;", "process", "processEntities", "", "Landroidx/room/vo/Entity;", "dbAnnotation", "Ljavax/lang/model/element/AnnotationMirror;", "validateForeignKeys", "", "entities", "validateUniqueDaoClasses", "dbElement", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableNames", "room-compiler"})
public final class DatabaseProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy baseClassElement$delegate;
    @NotNull
    private final TypeElement element;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseProcessor.class), "baseClassElement", "getBaseClassElement()Ljavax/lang/model/type/TypeMirror;"))};
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final TypeMirror getBaseClassElement() {
        Lazy lazy = this.baseClassElement$delegate;
        DatabaseProcessor databaseProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (TypeMirror)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        List<Entity> list;
        boolean bl;
        boolean exportSchema;
        int version;
        List daoMethods;
        List<Entity> entities;
        block7: {
            Element it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            AnnotationMirror dbAnnotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)this.element, Database.class).orNull();
            entities = this.processEntities(dbAnnotation, this.element);
            this.validateUniqueTableNames(this.element, entities);
            this.validateForeignKeys(this.element, entities);
            boolean extendsRoomDb = this.context.getProcessingEnv().getTypeUtils().isAssignable(MoreElements.asType((Element)this.element).asType(), this.getBaseClassElement());
            this.context.getChecker().check(extendsRoomDb, this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
            List<? extends Element> allMembers = this.context.getProcessingEnv().getElementUtils().getAllMembers(this.element);
            DatabaseVerifier dbVerifier = Element_extKt.hasAnnotation(this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, this.element, entities);
            this.context.setDatabaseVerifier(dbVerifier);
            DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)this.element.asType());
            List<? extends Element> list2 = allMembers;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"allMembers");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Element element = it = (Element)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                if (!(Element_extKt.hasAnyOf(element, Modifier.ABSTRACT) && it.getKind() == ElementKind.METHOD)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Element element = it = (Element)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                Element containing = element.getEnclosingElement();
                if (MoreElements.isType((Element)containing) && Intrinsics.areEqual((Object)TypeName.get((TypeMirror)containing.asType()), (Object)RoomTypeNames.INSTANCE.getROOM_DB())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                TypeElement daoType;
                ExecutableElement executable;
                it = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                ExecutableElement executableElement = executable = MoreElements.asExecutable((Element)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"executable");
                TypeElement typeElement = daoType = MoreTypes.asTypeElement((TypeMirror)executableElement.getReturnType());
                Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"daoType");
                DeclaredType declaredType2 = declaredType;
                Intrinsics.checkExpressionValueIsNotNull((Object)declaredType2, (String)"declaredType");
                Dao dao = new DaoProcessor(this.context, typeElement, declaredType2, dbVerifier).process();
                DaoMethod daoMethod = new DaoMethod(executable, executable.getSimpleName().toString(), dao);
                collection.add(daoMethod);
            }
            daoMethods = (List)destination$iv$iv;
            this.validateUniqueDaoClasses(this.element, daoMethods, entities);
            this.validateUniqueIndices(this.element, entities);
            AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)dbAnnotation, (String)"version");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors.getAnn\u2026(dbAnnotation, \"version\")");
            Integer n = Element_extKt.getAsInt(annotationValue, 1);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            version = n;
            AnnotationValue annotationValue2 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)dbAnnotation, (String)"exportSchema");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue2, (String)"AnnotationMirrors.getAnn\u2026notation, \"exportSchema\")");
            exportSchema = Element_extKt.getAsBoolean(annotationValue2, true);
            Iterable $receiver$iv2 = entities;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    Entity it2 = (Entity)element$iv;
                    list = (List<Entity>)it2.getForeignKeys();
                    if (!(!list.isEmpty())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasForeignKeys = bl;
        TypeMirror typeMirror2 = MoreElements.asType((Element)this.element).asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"MoreElements.asType(element).asType()");
        boolean bl2 = hasForeignKeys;
        boolean bl3 = exportSchema;
        List list3 = daoMethods;
        list = entities;
        TypeMirror typeMirror3 = typeMirror2;
        TypeElement typeElement = this.element;
        int n = version;
        androidx.room.vo.Database database = new androidx.room.vo.Database(typeElement, typeMirror3, list, list3, n, bl3, bl2);
        return database;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(TypeElement element, List<Entity> entities) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = entities;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map2 = destination$iv$iv;
            String string = it.getTableName();
            map2.put(string, element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        $receiver$iv = entities;
        for (Object element$iv : $receiver$iv) {
            Entity entity = (Entity)element$iv;
            Iterable $receiver$iv2 = entity.getForeignKeys();
            for (Object element$iv2 : $receiver$iv2) {
                Collection<String> collection;
                void $receiver$iv$iv2;
                void $receiver$iv3;
                Object element$iv$iv$iv;
                void $receiver$iv$iv22;
                List<String> $receiver$iv32;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e(element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName().toString()), new Object[0]);
                    continue;
                }
                List<String> list = $receiver$iv32 = (List<String>)foreignKey.getParentColumns();
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv22;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Field field;
                    Object v0;
                    Iterable iterable2;
                    Iterable iterable3;
                    String columnName;
                    block9: {
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        columnName = (String)element$iv$iv;
                        iterable2 = iterable3 = (Iterable)parent.getFields();
                        for (Object object : iterable2) {
                            Field it = (Field)object;
                            if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)columnName)) continue;
                            v0 = object;
                            break block9;
                        }
                        v0 = null;
                    }
                    Field parentField = v0;
                    if (parentField == null) {
                        Collection<String> collection2;
                        void $receiver$iv$iv3;
                        void $receiver$iv4;
                        Object object;
                        iterable3 = parent.getFields();
                        String string = columnName;
                        String string2 = parent.getElement().getQualifiedName().toString();
                        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                        Element element2 = entity.getElement();
                        RLog rLog = this.context.getLogger();
                        iterable2 = $receiver$iv4;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                        object = $receiver$iv$iv3.iterator();
                        while (object.hasNext()) {
                            void it;
                            Object item$iv$iv = object.next();
                            Field $i$a$1$find = (Field)item$iv$iv;
                            collection2 = destination$iv$iv3;
                            String string3 = it.getColumnName();
                            collection2.add(string3);
                        }
                        collection2 = (List)destination$iv$iv3;
                        rLog.e(element2, processorErrors.foreignKeyParentColumnDoesNotExist(string2, string, (List<String>)collection2), new Object[0]);
                    }
                    if (parentField == null) continue;
                    Field it$iv$iv = field;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                $receiver$iv32 = foreignKey.getChildFields();
                List<String> list2 = foreignKey.getParentColumns();
                String string = entity.getElement().getQualifiedName().toString();
                String string4 = parent.getElement().getQualifiedName().toString();
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                Element element3 = parent.getElement();
                RLog rLog = this.context.getLogger();
                $receiver$iv$iv22 = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object t : $receiver$iv$iv2) {
                    void it;
                    element$iv$iv$iv = (Field)t;
                    collection = destination$iv$iv3;
                    String string5 = it.getColumnName();
                    collection.add(string5);
                }
                Collection<String> collection3 = collection = (List)destination$iv$iv3;
                list = list2;
                String string6 = string;
                rLog.e(element3, processorErrors.foreignKeyMissingIndexInParent(string4, list, string6, (List<String>)collection3), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(TypeElement element, List<Entity> entities) {
        Object object;
        Object object2;
        Object object3;
        Object element$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = entities;
        Object object4 = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        Object object5 = $receiver$iv$iv.iterator();
        while (object5.hasNext()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            element$iv$iv = object5.next();
            Entity entity = (Entity)element$iv$iv;
            Iterable iterable = $receiver$iv2 = (Iterable)entity.getIndices();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                object3 = (Index)item$iv$iv;
                object2 = destination$iv$iv2;
                object = new Pair((Object)it.getName(), (Object)entity);
                object2.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object5 = $receiver$iv$iv.iterator();
        while (object5.hasNext()) {
            Object object6;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = object5.next();
            Pair pair = (Pair)element$iv$iv;
            String key$iv$iv = (String)pair.getFirst();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object6 = answer$iv$iv$iv;
            } else {
                object6 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object6;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object5 = $receiver$iv$iv;
        for (Map.Entry entry : object5.entrySet()) {
            Map.Entry it = entry;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = destination$iv$iv;
        object4 = $receiver$iv;
        Iterator iterator = object4.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            void $receiver$iv$iv3;
            TypeName key$iv;
            Pair it;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = iterator.next();
            Iterable iterable = (Iterable)it2.getValue();
            Iterable<Object> set$iv = new HashSet<TypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : iterable) {
                it = (Pair)e$iv;
                key$iv = ((Entity)it.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            Iterable iterable2 = (Iterable)it2.getValue();
            object3 = (String)it2.getKey();
            object2 = ProcessorErrors.INSTANCE;
            object = element;
            RLog rLog = this.context.getLogger();
            set$iv = iterable2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                key$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                String string = ((Entity)it.getSecond()).getTypeName() + " > " + (String)it.getFirst();
                collection.add(string);
            }
            collection = (List)destination$iv$iv3;
            rLog.e((Element)object, ((ProcessorErrors)object2).duplicateIndexInDatabase((String)object3, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(TypeElement dbElement, List<DaoMethod> daoMethods, List<Entity> entities) {
        Iterable $receiver$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Object $receiver$iv$iv$iv;
        Object it;
        Object $receiver$iv$iv;
        Object $receiver$iv2 = entities;
        Iterable iterable = $receiver$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeName typeName2 = ((Pojo)it).getTypeName();
            collection.add(typeName2);
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv2 = (Iterable)daoMethods;
        destination$iv$iv = new LinkedHashMap();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            it = (DaoMethod)element$iv$iv;
            key$iv$iv = ((DaoMethod)it).getDao().getTypeName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        for (Map.Entry element$iv : $receiver$iv$iv.entrySet()) {
            Collection<String> $i$f$groupByTo;
            Iterator $receiver$iv$iv2;
            Map.Entry it2 = element$iv;
            if (((List)it2.getValue()).size() <= 1) continue;
            it = (Iterable)it2.getValue();
            TypeName typeName3 = (TypeName)it2.getKey();
            key$iv$iv = ProcessorErrors.INSTANCE;
            $receiver$iv$iv$iv = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            answer$iv$iv$iv = $receiver$iv$iv2.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = answer$iv$iv$iv.next();
                DaoMethod $i$f$getOrPut = (DaoMethod)item$iv$iv;
                $i$f$groupByTo = destination$iv$iv2;
                String $i$f$groupBy = it3.getName();
                $i$f$groupByTo.add($i$f$groupBy);
            }
            $i$f$groupByTo = (List)destination$iv$iv2;
            String error = ((ProcessorErrors)key$iv$iv).duplicateDao(typeName3, (List<String>)$i$f$groupByTo);
            $receiver$iv = (Iterable)it2.getValue();
            $receiver$iv$iv2 = $receiver$iv.iterator();
            while ($receiver$iv$iv2.hasNext()) {
                Object element$iv2 = $receiver$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                this.context.getLogger().e(daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<Element, Dao, TypeName, Unit>(this, entityTypeNames, dbElement){
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ Set $entityTypeNames;
            final /* synthetic */ TypeElement $dbElement;

            public final void invoke(@NotNull Element element, @NotNull Dao dao, @Nullable TypeName typeName2) {
                block1: {
                    TypeName typeName3;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)dao, (String)"dao");
                    TypeName typeName4 = typeName2;
                    if (typeName4 == null) break block1;
                    TypeName it = typeName3 = typeName4;
                    if (!this.$entityTypeNames.contains(typeName2)) {
                        RLog rLog = this.this$0.getContext().getLogger();
                        String string = this.$dbElement.getQualifiedName().toString();
                        String string2 = dao.getTypeName().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dao.typeName.toString()");
                        String string3 = typeName2.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"typeName.toString()");
                        rLog.e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(string, string2, string3), new Object[0]);
                    }
                }
            }
            {
                this.this$0 = databaseProcessor;
                this.$entityTypeNames = set;
                this.$dbElement = typeElement;
                super(3);
            }
        };
        Iterable $receiver$iv3 = daoMethods;
        for (Map.Entry element$iv : $receiver$iv3) {
            Map.Entry<String, Entity> it4;
            Map.Entry<String, Entity> element$iv3;
            Iterator<Map.Entry<String, Entity>> iterator2;
            Map<String, Entity> map2;
            Map<String, Entity> $receiver$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)((Object)element$iv);
            $receiver$iv = daoMethod.getDao().getShortcutMethods();
            for (Object element$iv4 : $receiver$iv) {
                method = (ShortcutMethod)element$iv4;
                map2 = $receiver$iv4 = ((ShortcutMethod)method).getEntities();
                iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it4 = element$iv3 = iterator2.next();
                    check2.invoke((Object)((ShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getTypeName());
                }
            }
            $receiver$iv = daoMethod.getDao().getInsertionMethods();
            for (Object element$iv4 : $receiver$iv) {
                method = (InsertionMethod)element$iv4;
                map2 = $receiver$iv4 = ((InsertionMethod)method).getEntities();
                iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it4 = element$iv3 = iterator2.next();
                    check2.invoke((Object)((InsertionMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableNames(TypeElement dbElement, List<Entity> entities) {
        Object list$iv$iv;
        String string;
        Object $receiver$iv$iv;
        Object $receiver$iv = entities;
        Object object = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Object object2 = $receiver$iv$iv.iterator();
        while (object2.hasNext()) {
            Object object3;
            String key$iv$iv;
            Object element$iv$iv = object2.next();
            Entity entity = (Entity)element$iv$iv;
            String string2 = string = entity.getTableName();
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object2 = $receiver$iv$iv;
        for (Map.Entry entry : object2.entrySet()) {
            Map.Entry it = entry;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = destination$iv$iv;
        object = $receiver$iv;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            void $receiver$iv$iv2;
            Map.Entry element$iv;
            Map.Entry byTableName = element$iv = iterator.next();
            Iterable iterable = (Iterable)byTableName.getValue();
            string = (String)byTableName.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            Iterable $i$f$filterTo = iterable;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                list$iv$iv = (Entity)item$iv$iv;
                collection = destination$iv$iv2;
                String string3 = it.getTypeName().toString();
                collection.add(string3);
            }
            collection = (List)destination$iv$iv2;
            String error = processorErrors.duplicateTableNames(string, (List<String>)collection);
            Iterable iterable2 = (Iterable)byTableName.getValue();
            for (Object element$iv2 : iterable2) {
                Entity entity = (Entity)element$iv2;
                this.context.getLogger().e(entity.getElement(), error, new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(AnnotationMirror dbAnnotation, TypeElement element) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        AnnotationValue entityList;
        if (!this.context.getChecker().check(dbAnnotation != null, element, ProcessorErrors.INSTANCE.getDATABASE_MUST_BE_ANNOTATED_WITH_DATABASE(), new Object[0])) {
            return CollectionsKt.emptyList();
        }
        AnnotationValue annotationValue = entityList = AnnotationMirrors.getAnnotationValue((AnnotationMirror)dbAnnotation, (String)"entities");
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"entityList");
        List<TypeMirror> listOfTypes = Element_extKt.toListOfClassTypes(annotationValue);
        Collection collection = listOfTypes;
        Object object = this.context.getChecker();
        boolean bl = !collection.isEmpty();
        ((Checks)object).check(bl, element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable iterable = $receiver$iv = (Iterable)listOfTypes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            object = destination$iv$iv;
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"MoreTypes.asTypeElement(it)");
            Entity entity = new EntityProcessor(this.context, typeElement, null, 4, null).process();
            object.add(entity);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull TypeElement element) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.element = element;
        this.context = baseContext.fork(this.element);
        this.baseClassElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeMirror>(this){
            final /* synthetic */ DatabaseProcessor this$0;

            public final TypeMirror invoke() {
                return this.this$0.getContext().getProcessingEnv().getElementUtils().getTypeElement(RoomTypeNames.INSTANCE.getROOM_DB().packageName() + "." + RoomTypeNames.INSTANCE.getROOM_DB().simpleName()).asType();
            }
            {
                this.this$0 = databaseProcessor;
                super(0);
            }
        }));
    }
}

