/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.ColumnInfo;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.parser.Collate;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.FieldProcessor$WhenMappings;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.types.ColumnTypeAdapter;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.Field;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Landroidx/room/processor/FieldProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "element", "Ljavax/lang/model/element/Element;", "bindingScope", "Landroidx/room/processor/FieldProcessor$BindingScope;", "fieldParent", "Landroidx/room/vo/EmbeddedField;", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/Element;Landroidx/room/processor/FieldProcessor$BindingScope;Landroidx/room/vo/EmbeddedField;)V", "getBindingScope", "()Landroidx/room/processor/FieldProcessor$BindingScope;", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/Element;", "getFieldParent", "()Landroidx/room/vo/EmbeddedField;", "process", "Landroidx/room/vo/Field;", "BindingScope", "room-compiler"})
public final class FieldProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final Element element;
    @NotNull
    private final BindingScope bindingScope;
    @Nullable
    private final EmbeddedField fieldParent;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Field process() {
        SQLTypeAffinity sQLTypeAffinity;
        TypeMirror member = this.context.getProcessingEnv().getTypeUtils().asMemberOf(this.containing, this.element);
        TypeName type = TypeName.get((TypeMirror)member);
        AnnotationBox annotationBox = Element_extKt.toAnnotationBox(this.element, Reflection.getOrCreateKotlinClass(ColumnInfo.class));
        ColumnInfo columnInfo2 = annotationBox != null ? (ColumnInfo)annotationBox.getValue() : null;
        String name = this.element.getSimpleName().toString();
        String rawCName = columnInfo2 != null && Intrinsics.areEqual((Object)columnInfo2.name(), (Object)"[field-name]") ^ true ? columnInfo2.name() : name;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.fieldParent;
        if (object == null || (object = ((EmbeddedField)object).getPrefix()) == null) {
            object = "";
        }
        String columnName = stringBuilder.append((String)object).append(rawCName).toString();
        try {
            ColumnInfo columnInfo3 = columnInfo2;
            sQLTypeAffinity = SQLTypeAffinity.Companion.fromAnnotationValue(columnInfo3 != null ? Integer.valueOf(columnInfo3.typeAffinity()) : null);
        }
        catch (NumberFormatException ex) {
            sQLTypeAffinity = null;
        }
        SQLTypeAffinity affinity = sQLTypeAffinity;
        this.context.getChecker().notBlank(columnName, this.element, ProcessorErrors.INSTANCE.getCOLUMN_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        Checks checks = this.context.getChecker();
        TypeName typeName2 = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"type");
        checks.notUnbound(typeName2, this.element, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_ENTITY_FIELDS(), new Object[0]);
        TypeMirror typeMirror2 = member;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"member");
        ColumnInfo columnInfo4 = columnInfo2;
        ColumnInfo columnInfo5 = columnInfo2;
        boolean ex = columnInfo5 != null ? columnInfo5.index() : false;
        EmbeddedField embeddedField = this.fieldParent;
        Collate collate = Collate.Companion.fromAnnotationValue(columnInfo4 != null ? Integer.valueOf(columnInfo4.collate()) : null);
        SQLTypeAffinity sQLTypeAffinity2 = affinity;
        String string = columnName;
        Element element = this.element;
        TypeMirror typeMirror3 = typeMirror2;
        String string2 = name;
        Field field = new Field(element, string2, typeMirror3, sQLTypeAffinity2, collate, string, embeddedField, ex);
        switch (FieldProcessor$WhenMappings.$EnumSwitchMapping$0[this.bindingScope.ordinal()]) {
            case 1: {
                ColumnTypeAdapter adapter = this.context.getTypeAdapterStore().findColumnTypeAdapter(field.getType(), field.getAffinity());
                field.setStatementBinder(adapter);
                field.setCursorValueReader(adapter);
                Object object2 = adapter;
                if (object2 == null || (object2 = object2.getTypeAffinity()) == null) {
                    object2 = field.getAffinity();
                }
                field.setAffinity((SQLTypeAffinity)((Object)object2));
                this.context.getChecker().check(adapter != null, field.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_COLUMN_TYPE_ADAPTER(), new Object[0]);
                break;
            }
            case 2: {
                field.setStatementBinder(this.context.getTypeAdapterStore().findStatementValueBinder(field.getType(), field.getAffinity()));
                this.context.getChecker().check(field.getStatementBinder() != null, field.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_STMT_BINDER(), new Object[0]);
                break;
            }
            case 3: {
                field.setCursorValueReader(this.context.getTypeAdapterStore().findCursorValueReader(field.getType(), field.getAffinity()));
                this.context.getChecker().check(field.getCursorValueReader() != null, field.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_CURSOR_READER(), new Object[0]);
            }
        }
        return field;
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    @NotNull
    public final BindingScope getBindingScope() {
        return this.bindingScope;
    }

    @Nullable
    public final EmbeddedField getFieldParent() {
        return this.fieldParent;
    }

    public FieldProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull Element element, @NotNull BindingScope bindingScope, @Nullable EmbeddedField fieldParent) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bindingScope), (String)"bindingScope");
        this.containing = containing;
        this.element = element;
        this.bindingScope = bindingScope;
        this.fieldParent = fieldParent;
        this.context = baseContext.fork(this.element);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/room/processor/FieldProcessor$BindingScope;", "", "(Ljava/lang/String;I)V", "TWO_WAY", "BIND_TO_STMT", "READ_FROM_CURSOR", "room-compiler"})
    public static final class BindingScope
    extends Enum<BindingScope> {
        public static final /* enum */ BindingScope TWO_WAY;
        public static final /* enum */ BindingScope BIND_TO_STMT;
        public static final /* enum */ BindingScope READ_FROM_CURSOR;
        private static final /* synthetic */ BindingScope[] $VALUES;

        static {
            BindingScope[] bindingScopeArray = new BindingScope[3];
            BindingScope[] bindingScopeArray2 = bindingScopeArray;
            bindingScopeArray[0] = TWO_WAY = new BindingScope();
            bindingScopeArray[1] = BIND_TO_STMT = new BindingScope();
            bindingScopeArray[2] = READ_FROM_CURSOR = new BindingScope();
            $VALUES = bindingScopeArray;
        }

        public static BindingScope[] values() {
            return (BindingScope[])$VALUES.clone();
        }

        public static BindingScope valueOf(String string) {
            return Enum.valueOf(BindingScope.class, string);
        }
    }
}

