/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ShortcutParameterProcessor;
import androidx.room.vo.Entity;
import androidx.room.vo.ShortcutQueryParameter;
import com.google.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ,\u0010\u001d\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020 0\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u001e2\u0006\u0010#\u001a\u00020\u001bJ\u0006\u0010$\u001a\u00020\nR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u000b*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/room/processor/ShortcutMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "executableElement", "Ljavax/lang/model/element/ExecutableElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/ExecutableElement;)V", "asMember", "Ljavax/lang/model/type/TypeMirror;", "kotlin.jvm.PlatformType", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Ljavax/lang/model/element/ExecutableElement;", "executableType", "Ljavax/lang/model/type/ExecutableType;", "extractAnnotation", "T", "", "klass", "Lkotlin/reflect/KClass;", "errorMsg", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;)Ljava/lang/annotation/Annotation;", "extractParams", "Lkotlin/Pair;", "", "Landroidx/room/vo/Entity;", "", "Landroidx/room/vo/ShortcutQueryParameter;", "missingParamError", "extractReturnType", "room-compiler"})
public final class ShortcutMethodProcessor {
    @NotNull
    private final Context context;
    private final TypeMirror asMember;
    private final ExecutableType executableType;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final ExecutableElement executableElement;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final <T extends Annotation> T extractAnnotation(@NotNull KClass<T> klass, @NotNull String errorMsg) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
        AnnotationBox<T> annotation = Element_extKt.toAnnotationBox(this.executableElement, klass);
        this.context.getChecker().check(annotation != null, this.executableElement, errorMsg, new Object[0]);
        AnnotationBox<T> annotationBox = annotation;
        return (T)(annotationBox != null ? annotationBox.getValue() : null);
    }

    @NotNull
    public final TypeMirror extractReturnType() {
        ExecutableType executableType = this.executableType;
        Intrinsics.checkExpressionValueIsNotNull((Object)executableType, (String)"executableType");
        TypeMirror typeMirror2 = executableType.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"executableType.returnType");
        return typeMirror2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Map<String, Entity>, List<ShortcutQueryParameter>> extractParams(@NotNull String missingParamError) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Object object;
        Iterable $receiver$iv$iv3;
        Intrinsics.checkParameterIsNotNull((Object)missingParamError, (String)"missingParamError");
        List<? extends VariableElement> list = this.executableElement.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"executableElement.parameters");
        Iterable $receiver$iv2 = list;
        Iterable iterable = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            void it;
            VariableElement variableElement = (VariableElement)item$iv$iv;
            object = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            ShortcutQueryParameter shortcutQueryParameter = new ShortcutParameterProcessor(this.context, this.containing, (VariableElement)v1).process();
            object.add(shortcutQueryParameter);
        }
        List params = (List)destination$iv$iv;
        $receiver$iv2 = params;
        object = this.context.getChecker();
        boolean bl = !$receiver$iv2.isEmpty();
        ((Checks)object).check(bl, this.executableElement, missingParamError, new Object[0]);
        $receiver$iv$iv3 = params;
        destination$iv$iv = $receiver$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            if (!(it.getEntityType() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv2 = $receiver$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            ShortcutQueryParameter it;
            ShortcutQueryParameter $i$a$1$filter = (ShortcutQueryParameter)element$iv$iv;
            object = destination$iv$iv3;
            String string = it.getName();
            it = (ShortcutQueryParameter)element$iv$iv;
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)it.getEntityType());
            Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"MoreTypes.asTypeElement(it.entityType)");
            Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, typeElement, null, 4, null).process();
            object.put(string, entity);
        }
        Map entities = destination$iv$iv3;
        return new Pair((Object)entities, (Object)params);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public ShortcutMethodProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull ExecutableElement executableElement) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = baseContext.fork(this.executableElement);
        this.asMember = this.context.getProcessingEnv().getTypeUtils().asMemberOf(this.containing, this.executableElement);
        this.executableType = MoreTypes.asExecutable((TypeMirror)this.asMember);
    }
}

