/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.verifier;

import androidx.room.processor.Context;
import androidx.room.verifier.DatabaseVerificaitonErrors;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.Index;
import androidx.room.vo.Warning;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.JDBC;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Landroidx/room/verifier/DatabaseVerifier;", "", "connection", "Ljava/sql/Connection;", "context", "Landroidx/room/processor/Context;", "entities", "", "Landroidx/room/vo/Entity;", "views", "Landroidx/room/vo/DatabaseView;", "(Ljava/sql/Connection;Landroidx/room/processor/Context;Ljava/util/List;Ljava/util/List;)V", "getConnection", "()Ljava/sql/Connection;", "getContext", "()Landroidx/room/processor/Context;", "getEntities", "()Ljava/util/List;", "analyze", "Landroidx/room/verifier/QueryResultInfo;", "sql", "", "closeConnection", "", "stripLocalizeCollations", "kotlin.jvm.PlatformType", "Companion", "room-compiler"})
public final class DatabaseVerifier {
    @NotNull
    private final Connection connection;
    @NotNull
    private final Context context;
    @NotNull
    private final List<Entity> entities;
    private static final String CONNECTION_URL = "jdbc:sqlite::memory:";
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final QueryResultInfo analyze(@NotNull String sql) {
        QueryResultInfo queryResultInfo;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.connection.prepareStatement(this.stripLocalizeCollations(sql));
            Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"stmt");
            queryResultInfo = new QueryResultInfo(Jdbc_extKt.columnInfo(preparedStatement), null, 2, null);
        }
        catch (SQLException ex) {
            queryResultInfo = new QueryResultInfo(CollectionsKt.emptyList(), ex);
        }
        return queryResultInfo;
    }

    private final String stripLocalizeCollations(String sql) {
        return COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql).replaceAll(" COLLATE NOCASE");
    }

    public final void closeConnection(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (Throwable t) {
                context.getLogger().d("failed to close the database connection " + t.getMessage(), new Object[0]);
            }
        }
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<Entity> getEntities() {
        return this.entities;
    }

    private DatabaseVerifier(Connection connection, Context context, List<? extends Entity> entities, List<DatabaseView> views) {
        Statement stmt;
        this.connection = connection;
        this.context = context;
        this.entities = entities;
        Iterable $receiver$iv = this.entities;
        for (Object element$iv : $receiver$iv) {
            Entity entity = (Entity)element$iv;
            stmt = this.connection.createStatement();
            stmt.executeUpdate(this.stripLocalizeCollations(entity.getCreateTableQuery()));
            Iterable $receiver$iv2 = entity.getIndices();
            for (Object element$iv2 : $receiver$iv2) {
                Index it = (Index)element$iv2;
                stmt.executeUpdate(it.createQuery(entity.getTableName()));
            }
        }
        $receiver$iv = views;
        for (Object element$iv : $receiver$iv) {
            DatabaseView view = (DatabaseView)element$iv;
            stmt = this.connection.createStatement();
            stmt.executeUpdate(this.stripLocalizeCollations(view.getCreateViewQuery()));
        }
    }

    static {
        Companion = new Companion(null);
        COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            File outDir = new File(tmpDir, "room-" + UUID.randomUUID());
            outDir.mkdirs();
            outDir.deleteOnExit();
            System.setProperty("org.sqlite.tmpdir", outDir.getAbsolutePath());
            JDBC.isValidURL((String)CONNECTION_URL);
            DatabaseVerifier.Companion.unregisterDrivers();
        }
    }

    public /* synthetic */ DatabaseVerifier(@NotNull Connection connection, @NotNull Context context, @NotNull List entities, @NotNull List views, DefaultConstructorMarker $constructor_marker) {
        this(connection, context, entities, views);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/room/verifier/DatabaseVerifier$Companion;", "", "()V", "COLLATE_LOCALIZED_UNICODE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CONNECTION_URL", "", "create", "Landroidx/room/verifier/DatabaseVerifier;", "context", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/Element;", "entities", "", "Landroidx/room/vo/Entity;", "views", "Landroidx/room/vo/DatabaseView;", "unregisterDrivers", "", "room-compiler"})
    public static final class Companion {
        @Nullable
        public final DatabaseVerifier create(@NotNull Context context, @NotNull Element element, @NotNull List<? extends Entity> entities, @NotNull List<DatabaseView> views) {
            DatabaseVerifier databaseVerifier;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
            Intrinsics.checkParameterIsNotNull(views, (String)"views");
            try {
                Connection connection;
                Connection connection2 = connection = JDBC.createConnection((String)DatabaseVerifier.CONNECTION_URL, (Properties)new Properties());
                Intrinsics.checkExpressionValueIsNotNull((Object)connection2, (String)"connection");
                databaseVerifier = new DatabaseVerifier(connection2, context, entities, views, null);
            }
            catch (Exception ex) {
                context.getLogger().w(Warning.CANNOT_CREATE_VERIFICATION_DATABASE, element, DatabaseVerificaitonErrors.INSTANCE.cannotCreateConnection(ex), new Object[0]);
                databaseVerifier = null;
            }
            return databaseVerifier;
        }

        private final void unregisterDrivers() {
            try {
                Driver driver = DriverManager.getDriver(DatabaseVerifier.CONNECTION_URL);
                if (driver != null) {
                    Driver driver2;
                    Driver it = driver2 = driver;
                    DriverManager.deregisterDriver(it);
                }
            }
            catch (Throwable t) {
                System.err.println("Room: cannot unregister driver " + t.getMessage());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

