/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.ext.AndroidTypeNames;
import androidx.room.ext.CommonTypeNames;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.writer.ClassWriter;
import androidx.room.writer.DatabaseWriter;
import androidx.room.writer.EntityDeleteComparator;
import androidx.room.writer.SQLiteOpenHelperWriter;
import com.google.auto.common.MoreElements;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Landroidx/room/writer/DatabaseWriter;", "Landroidx/room/writer/ClassWriter;", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "addDaoImpls", "", "builder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "createClearAllTables", "Lcom/squareup/javapoet/MethodSpec;", "createCreateInvalidationTracker", "createCreateOpenHelper", "createDaoGetter", "field", "Lcom/squareup/javapoet/FieldSpec;", "method", "Landroidx/room/vo/DaoMethod;", "createTypeSpecBuilder", "room-compiler"})
public final class DatabaseWriter
extends ClassWriter {
    @NotNull
    private final Database database;

    @Override
    @NotNull
    public TypeSpec.Builder createTypeSpecBuilder() {
        TypeSpec.Builder builder;
        TypeSpec.Builder builder2;
        TypeSpec.Builder $receiver = builder2 = (builder = TypeSpec.classBuilder((ClassName)this.database.getImplTypeName()));
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addModifiers(new Modifier[]{Modifier.FINAL});
        $receiver.superclass((TypeName)this.database.getTypeName());
        $receiver.addMethod(this.createCreateOpenHelper());
        $receiver.addMethod(this.createCreateInvalidationTracker());
        $receiver.addMethod(this.createClearAllTables());
        TypeSpec.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"builder");
        this.addDaoImpls(builder3);
        return builder;
    }

    private final MethodSpec createClearAllTables() {
        Object $receiver;
        MethodSpec.Builder builder;
        MethodSpec.Builder builder2;
        MethodSpec.Builder builder3;
        CodeGenScope scope = new CodeGenScope(this);
        MethodSpec.Builder $receiver2 = builder3 = MethodSpec.methodBuilder((String)"clearAllTables");
        $receiver2.addStatement("super.assertNotMainThread()", new Object[0]);
        String dbVar = scope.getTmpVar("_db");
        $receiver2.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = super.getOpenHelper().getWritableDatabase()", new Object[]{SupportDbTypeNames.INSTANCE.getDB(), dbVar});
        String deferVar = scope.getTmpVar("_supportsDeferForeignKeys");
        if (this.database.getEnableForeignKeys()) {
            $receiver2.addStatement("boolean " + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getL() + ".VERSION.SDK_INT >= " + Javapoet_extKt.getL() + ".VERSION_CODES.LOLLIPOP", new Object[]{deferVar, AndroidTypeNames.INSTANCE.getBUILD(), AndroidTypeNames.INSTANCE.getBUILD()});
        }
        $receiver2.addAnnotation(Override.class);
        $receiver2.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver2.returns(TypeName.VOID);
        MethodSpec.Builder $receiver3 = builder2 = $receiver2.beginControlFlow("try", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            builder = $receiver3.beginControlFlow("if (!" + Javapoet_extKt.getL() + ')', new Object[]{deferVar});
            $receiver = builder;
            $receiver.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "PRAGMA foreign_keys = FALSE"});
            $receiver3.endControlFlow();
        }
        $receiver3.addStatement("super.beginTransaction()", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            builder = $receiver3.beginControlFlow("if (" + Javapoet_extKt.getL() + ')', new Object[]{deferVar});
            $receiver = builder;
            $receiver.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "PRAGMA defer_foreign_keys = TRUE"});
            $receiver3.endControlFlow();
        }
        Iterable $receiver$iv = CollectionsKt.sortedWith((Iterable)this.database.getEntities(), (Comparator)new EntityDeleteComparator());
        for (Object element$iv : $receiver$iv) {
            Entity it = (Entity)element$iv;
            $receiver3.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "DELETE FROM `" + it.getTableName() + '`'});
        }
        $receiver3.addStatement("super.setTransactionSuccessful()", new Object[0]);
        $receiver3 = builder2 = $receiver2.nextControlFlow("finally", new Object[0]);
        $receiver3.addStatement("super.endTransaction()", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            builder = $receiver3.beginControlFlow("if (!" + Javapoet_extKt.getL() + ')', new Object[]{deferVar});
            $receiver = builder;
            $receiver.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "PRAGMA foreign_keys = TRUE"});
            $receiver3.endControlFlow();
        }
        $receiver3.addStatement(Javapoet_extKt.getL() + ".query(" + Javapoet_extKt.getS() + ").close()", new Object[]{dbVar, "PRAGMA wal_checkpoint(FULL)"});
        builder = $receiver3.beginControlFlow("if (!" + Javapoet_extKt.getL() + ".inTransaction())", new Object[]{dbVar});
        $receiver = builder;
        $receiver.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "VACUUM"});
        $receiver3.endControlFlow();
        $receiver2.endControlFlow();
        MethodSpec methodSpec = builder3.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026lFlow()\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateInvalidationTracker() {
        Object object;
        Collection collection;
        Entity it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        MethodSpec.Builder builder;
        CodeGenScope scope = new CodeGenScope(this);
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"createInvalidationTracker");
        $receiver.addAnnotation(Override.class);
        $receiver.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $receiver.returns((TypeName)RoomTypeNames.INSTANCE.getINVALIDATION_TRACKER());
        String shadowTablesVar = "_shadowTablesMap";
        ParameterizedTypeName shadowTablesTypeName = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashMap.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING(), (TypeName)CommonTypeNames.INSTANCE.getSTRING()});
        String tableNames2 = CollectionsKt.joinToString$default((Iterable)this.database.getEntities(), (CharSequence)",", null, null, (int)0, null, (Function1)createCreateInvalidationTracker.1.tableNames.1.INSTANCE, (int)30, null);
        Iterable iterable = $receiver$iv = (Iterable)this.database.getEntities();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (Entity)element$iv$iv;
            if (!(it.getShadowTableName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (Entity)item$iv$iv;
            collection = destination$iv$iv;
            object = TuplesKt.to((Object)it.getTableName(), (Object)it.getShadowTableName());
            collection.add(object);
        }
        List shadowTableNames = (List)destination$iv$iv;
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{shadowTablesTypeName, shadowTablesVar, shadowTablesTypeName, shadowTableNames.size()});
        $receiver$iv = shadowTableNames;
        for (Object element$iv : $receiver$iv) {
            Pair $tableName_shadowTableName = (Pair)element$iv;
            String tableName = (String)$tableName_shadowTableName.component1();
            String shadowTableName = (String)$tableName_shadowTableName.component2();
            $receiver.addStatement(Javapoet_extKt.getL() + ".put(" + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ')', new Object[]{shadowTablesVar, tableName, shadowTableName});
        }
        String viewTablesVar = scope.getTmpVar("_viewTables");
        ParameterizedTypeName tablesType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashSet.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING()});
        ParameterizedTypeName viewTablesType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashMap.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING(), (TypeName)ParameterizedTypeName.get((ClassName)CommonTypeNames.INSTANCE.getSET(), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING()})});
        $receiver.addStatement(Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{viewTablesType, viewTablesVar, viewTablesType, this.database.getViews().size()});
        for (DatabaseView view : this.database.getViews()) {
            String string;
            String tablesVar = scope.getTmpVar("_tables");
            $receiver.addStatement(Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{tablesType, tablesVar, tablesType, view.getTables().size()});
            for (String table : view.getTables()) {
                $receiver.addStatement(Javapoet_extKt.getL() + ".add(" + Javapoet_extKt.getS() + ')', new Object[]{tablesVar, table});
            }
            String string2 = Javapoet_extKt.getL() + ".put(" + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getL() + ')';
            Object[] objectArray = new Object[3];
            objectArray[0] = viewTablesVar;
            String string3 = view.getViewName();
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            object = string2;
            collection = $receiver;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(locale2), (String)"(this as java.lang.String).toLowerCase(locale)");
            objectArray2[n] = string;
            objectArray3[2] = tablesVar;
            collection.addStatement((String)object, objectArray3);
        }
        $receiver.addStatement("return new " + Javapoet_extKt.getT() + "(this, " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ')', new Object[]{RoomTypeNames.INSTANCE.getINVALIDATION_TRACKER(), shadowTablesVar, viewTablesVar, tableNames2});
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026eNames)\n        }.build()");
        return methodSpec;
    }

    private final void addDaoImpls(TypeSpec.Builder builder) {
        TypeSpec.Builder builder2;
        CodeGenScope scope = new CodeGenScope(this);
        TypeSpec.Builder $receiver = builder2 = builder;
        Iterable $receiver$iv = this.database.getDaoMethods();
        for (Object element$iv : $receiver$iv) {
            DaoMethod method = (DaoMethod)element$iv;
            String string = method.getDao().getTypeName().simpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.dao.typeName.simpleName()");
            String name = String_extKt.stripNonJava(StringsKt.decapitalize((String)string));
            String fieldName = scope.getTmpVar('_' + name);
            FieldSpec field = FieldSpec.builder((TypeName)((TypeName)method.getDao().getTypeName()), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).build();
            $receiver.addField(field);
            FieldSpec fieldSpec = field;
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldSpec, (String)"field");
            $receiver.addMethod(this.createDaoGetter(fieldSpec, method));
        }
    }

    private final MethodSpec createDaoGetter(FieldSpec field, DaoMethod method) {
        MethodSpec.Builder builder;
        MethodSpec.Builder builder2;
        MethodSpec.Builder builder3;
        MethodSpec.Builder builder4;
        MethodSpec.Builder $receiver = builder4 = MethodSpec.overriding((ExecutableElement)MoreElements.asExecutable((Element)method.getElement()));
        MethodSpec.Builder $receiver2 = builder3 = $receiver.beginControlFlow("if (" + Javapoet_extKt.getN() + " != null)", new Object[]{field});
        $receiver2.addStatement("return " + Javapoet_extKt.getN(), new Object[]{field});
        $receiver2 = builder3 = $receiver.nextControlFlow("else", new Object[0]);
        MethodSpec.Builder $receiver3 = builder2 = $receiver2.beginControlFlow("synchronized(this)", new Object[0]);
        MethodSpec.Builder $receiver4 = builder = $receiver3.beginControlFlow("if(" + Javapoet_extKt.getN() + " == null)", new Object[]{field});
        $receiver4.addStatement(Javapoet_extKt.getN() + " = new " + Javapoet_extKt.getT() + "(this)", new Object[]{field, method.getDao().getImplTypeName()});
        $receiver3.endControlFlow();
        $receiver3.addStatement("return " + Javapoet_extKt.getN(), new Object[]{field});
        $receiver2.endControlFlow();
        $receiver.endControlFlow();
        MethodSpec methodSpec = builder4.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.overriding(Mo\u2026lFlow()\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateOpenHelper() {
        MethodSpec.Builder builder;
        CodeGenScope scope = new CodeGenScope(this);
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"createOpenHelper");
        $receiver.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $receiver.addAnnotation(Override.class);
        $receiver.returns((TypeName)SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER());
        ParameterSpec configParam = ParameterSpec.builder((TypeName)((TypeName)RoomTypeNames.INSTANCE.getROOM_DB_CONFIG()), (String)"configuration", (Modifier[])new Modifier[0]).build();
        $receiver.addParameter(configParam);
        String openHelperVar = scope.getTmpVar("_helper");
        CodeGenScope openHelperCode = scope.fork();
        SQLiteOpenHelperWriter sQLiteOpenHelperWriter = new SQLiteOpenHelperWriter(this.database);
        ParameterSpec parameterSpec = configParam;
        Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"configParam");
        sQLiteOpenHelperWriter.write(openHelperVar, parameterSpec, openHelperCode);
        $receiver.addCode(openHelperCode.builder().build());
        $receiver.addStatement("return " + Javapoet_extKt.getL(), new Object[]{openHelperVar});
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026perVar)\n        }.build()");
        return methodSpec;
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public DatabaseWriter(@NotNull Database database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super(database.getImplTypeName());
        this.database = database;
    }
}

