/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.VisibleForTesting;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.Pojo;
import androidx.room.writer.FtsTableInfoValidationWriter;
import androidx.room.writer.TableInfoValidationWriter;
import androidx.room.writer.ValidationWriter;
import androidx.room.writer.ViewInfoValidationWriter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\"\u001a\u00020\u001e*\u00020#2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Landroidx/room/writer/SQLiteOpenHelperWriter;", "", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "createCreateAllTables", "Lcom/squareup/javapoet/MethodSpec;", "createDropAllTables", "createDropTableQuery", "", "entity", "Landroidx/room/vo/Entity;", "createDropViewQuery", "view", "Landroidx/room/vo/DatabaseView;", "createOnCreate", "scope", "Landroidx/room/solver/CodeGenScope;", "createOnOpen", "createOnPostMigrate", "createOnPreMigrate", "createOpenCallback", "Lcom/squareup/javapoet/TypeSpec;", "createTableQuery", "createValidateMigration", "", "createViewQuery", "write", "", "outVar", "configuration", "Lcom/squareup/javapoet/ParameterSpec;", "invokeCallbacks", "Lcom/squareup/javapoet/MethodSpec$Builder;", "methodName", "room-compiler"})
public final class SQLiteOpenHelperWriter {
    @NotNull
    private final Database database;

    public final void write(@NotNull String outVar, @NotNull ParameterSpec configuration, @NotNull CodeGenScope scope) {
        CodeBlock.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)outVar, (String)"outVar");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        CodeBlock.Builder $receiver = builder = scope.builder();
        String sqliteConfigVar = scope.getTmpVar("_sqliteConfig");
        String callbackVar = scope.getTmpVar("_openCallback");
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getN() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ')', new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CALLBACK(), callbackVar, RoomTypeNames.INSTANCE.getOPEN_HELPER(), configuration, this.createOpenCallback(scope), this.database.getIdentityHash(), this.database.getLegacyIdentityHash()});
        $receiver.addStatement(StringsKt.trimIndent((String)("\n                    final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getT() + ".builder(" + Javapoet_extKt.getN() + ".context)\n                    .name(" + Javapoet_extKt.getN() + ".name)\n                    .callback(" + Javapoet_extKt.getL() + ")\n                    .build()\n                    ")), new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), sqliteConfigVar, SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), configuration, configuration, callbackVar});
        $receiver.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getN() + " = " + Javapoet_extKt.getN() + ".sqliteOpenHelperFactory.create(" + Javapoet_extKt.getL() + ')', new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER(), outVar, configuration, sqliteConfigVar});
    }

    private final TypeSpec createOpenCallback(CodeGenScope scope) {
        TypeSpec.Builder builder;
        TypeSpec.Builder $receiver = builder = TypeSpec.anonymousClassBuilder((String)Javapoet_extKt.getL(), (Object[])new Object[]{this.database.getVersion()});
        $receiver.superclass((TypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_DELEGATE());
        $receiver.addMethod(this.createCreateAllTables());
        $receiver.addMethod(this.createDropAllTables());
        $receiver.addMethod(this.createOnCreate(scope.fork()));
        $receiver.addMethod(this.createOnOpen(scope.fork()));
        $receiver.addMethod(this.createOnPreMigrate());
        $receiver.addMethod(this.createOnPostMigrate());
        $receiver.addMethods((Iterable)this.createValidateMigration(scope.fork()));
        TypeSpec typeSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSpec, (String)"TypeSpec.anonymousClassB\u2026ork()))\n        }.build()");
        return typeSpec;
    }

    private final List<MethodSpec> createValidateMigration(CodeGenScope scope) {
        List list;
        List methodSpecs = new ArrayList();
        ArrayDeque entities = new ArrayDeque(this.database.getEntities());
        ArrayDeque views = new ArrayDeque(this.database.getViews());
        ParameterSpec dbParam = ParameterSpec.builder((TypeName)((TypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"_db", (Modifier[])new Modifier[0]).build();
        while (!entities.isEmpty() || !views.isEmpty()) {
            CodeGenScope methodScope;
            int statementCount;
            ValidationWriter validationWriter;
            boolean isPrimaryMethod = methodSpecs.isEmpty();
            String methodName2 = isPrimaryMethod ? "validateMigration" : "validateMigration" + (methodSpecs.size() + 1);
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName2);
            list = methodSpecs;
            MethodSpec.Builder $receiver = builder;
            if (isPrimaryMethod) {
                $receiver.addModifiers(new Modifier[]{Modifier.PROTECTED});
                $receiver.addAnnotation(Override.class);
            } else {
                $receiver.addModifiers(new Modifier[]{Modifier.PRIVATE});
            }
            $receiver.addParameter(dbParam);
            for (statementCount = 0; !entities.isEmpty() && statementCount < 1000; statementCount += validationWriter.statementCount()) {
                ValidationWriter validationWriter2;
                methodScope = scope.fork();
                Entity entity = (Entity)entities.poll();
                Entity entity2 = entity;
                if (entity2 instanceof FtsEntity) {
                    validationWriter2 = new FtsTableInfoValidationWriter((FtsEntity)entity);
                } else {
                    Entity entity3 = entity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity3, (String)"entity");
                    validationWriter2 = new TableInfoValidationWriter(entity3);
                }
                validationWriter = validationWriter2;
                ParameterSpec parameterSpec = dbParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"dbParam");
                validationWriter.write(parameterSpec, methodScope);
                $receiver.addCode(methodScope.builder().build());
            }
            while (!views.isEmpty() && statementCount < 1000) {
                DatabaseView view;
                methodScope = scope.fork();
                DatabaseView databaseView = view = (DatabaseView)views.poll();
                Intrinsics.checkExpressionValueIsNotNull((Object)databaseView, (String)"view");
                validationWriter = new ViewInfoValidationWriter(databaseView);
                ParameterSpec parameterSpec = dbParam;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"dbParam");
                validationWriter.write(parameterSpec, methodScope);
                $receiver.addCode(methodScope.builder().build());
                statementCount += validationWriter.statementCount();
            }
            MethodSpec.Builder builder2 = builder;
            MethodSpec methodSpec = builder2.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026  }\n            }.build()");
            list.add(methodSpec);
        }
        if (methodSpecs.size() > 1) {
            MethodSpec.Builder builder = ((MethodSpec)methodSpecs.get(0)).toBuilder();
            int n = 0;
            list = methodSpecs;
            MethodSpec.Builder $receiver = builder;
            Iterable $receiver$iv = CollectionsKt.drop((Iterable)methodSpecs, (int)1);
            for (Object element$iv : $receiver$iv) {
                MethodSpec it = (MethodSpec)element$iv;
                $receiver.addStatement(it.name + '(' + Javapoet_extKt.getN() + ')', new Object[]{dbParam});
            }
            MethodSpec.Builder builder3 = builder;
            MethodSpec methodSpec = builder3.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"methodSpecs[0].toBuilder\u2026  }\n            }.build()");
            list.set(n, methodSpec);
        }
        return methodSpecs;
    }

    private final MethodSpec createOnCreate(CodeGenScope scope) {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"onCreate");
        $receiver.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        this.invokeCallbacks($receiver, scope, "onCreate");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026reate\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnOpen(CodeGenScope scope) {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"onOpen");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        $receiver.addStatement("mDatabase = _db", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{"PRAGMA foreign_keys = ON"});
        }
        $receiver.addStatement("internalInitInvalidationTracker(_db)", new Object[0]);
        this.invokeCallbacks($receiver, scope, "onOpen");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026nOpen\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateAllTables() {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"createAllTables");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        List list = this.database.getBundle().buildCreateQueries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.bundle.buildCreateQueries()");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{it});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createDropAllTables() {
        Pojo it;
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"dropAllTables");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Iterable $receiver$iv = this.database.getEntities();
        for (Object element$iv : $receiver$iv) {
            it = (Entity)element$iv;
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{this.createDropTableQuery((Entity)it)});
        }
        $receiver$iv = this.database.getViews();
        for (Object element$iv : $receiver$iv) {
            it = (DatabaseView)element$iv;
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{this.createDropViewQuery((DatabaseView)it)});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnPreMigrate() {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"onPreMigrate");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        $receiver.addStatement(Javapoet_extKt.getT() + ".dropFtsSyncTriggers(" + Javapoet_extKt.getL() + ')', new Object[]{RoomTypeNames.INSTANCE.getDB_UTIL(), "_db"});
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026 \"_db\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnPostMigrate() {
        FtsEntity it;
        Iterable $receiver$iv$iv;
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"onPostMigrate");
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addAnnotation(Override.class);
        $receiver.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Iterable $receiver$iv = CollectionsKt.filterIsInstance((Iterable)this.database.getEntities(), FtsEntity.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            if (!(it.getFtsOptions().getContentEntity() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            Iterable list$iv$iv = it.getContentSyncTriggerCreateQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String syncTriggerQuery = (String)element$iv;
            $receiver.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{syncTriggerQuery});
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final void invokeCallbacks(@NotNull MethodSpec.Builder $receiver, CodeGenScope scope, String methodName2) {
        MethodSpec.Builder builder;
        MethodSpec.Builder builder2;
        String iVar = scope.getTmpVar("_i");
        String sizeVar = scope.getTmpVar("_size");
        MethodSpec.Builder $receiver2 = builder2 = $receiver.beginControlFlow("if (mCallbacks != null)", new Object[0]);
        MethodSpec.Builder $receiver3 = builder = $receiver2.beginControlFlow("for (int " + Javapoet_extKt.getN() + " = 0, " + Javapoet_extKt.getN() + " = mCallbacks.size(); " + Javapoet_extKt.getN() + " < " + Javapoet_extKt.getN() + "; " + Javapoet_extKt.getN() + "++)", new Object[]{iVar, sizeVar, iVar, sizeVar, iVar});
        $receiver3.addStatement("mCallbacks.get(" + Javapoet_extKt.getN() + ")." + Javapoet_extKt.getN() + "(_db)", new Object[]{iVar, methodName2});
        $receiver2.endControlFlow();
        $receiver.endControlFlow();
    }

    @VisibleForTesting
    @NotNull
    public final String createTableQuery(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return entity.getCreateTableQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return view.getCreateViewQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createDropTableQuery(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return "DROP TABLE IF EXISTS `" + entity.getTableName() + '`';
    }

    @VisibleForTesting
    @NotNull
    public final String createDropViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return "DROP VIEW IF EXISTS `" + view.getViewName() + '`';
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public SQLiteOpenHelperWriter(@NotNull Database database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.database = database;
    }
}

