/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.Database;
import androidx.room.checker.AutoValueTargetChecker;
import androidx.room.processor.Context;
import androidx.room.processor.DatabaseProcessor;
import androidx.room.processor.MissingTypeException;
import androidx.room.processor.ProcessorErrors;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Warning;
import androidx.room.writer.DaoWriter;
import androidx.room.writer.DatabaseWriter;
import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0014\u00a8\u0006\r"}, d2={"Landroidx/room/RoomProcessor;", "Lcom/google/auto/common/BasicAnnotationProcessor;", "()V", "getSupportedOptions", "", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "initSteps", "", "Lcom/google/auto/common/BasicAnnotationProcessor$ProcessingStep;", "DatabaseProcessingStep", "TargetCheckProcessingStep", "room-compiler"})
public final class RoomProcessor
extends BasicAnnotationProcessor {
    @Nullable
    protected Iterable<BasicAnnotationProcessor.ProcessingStep> initSteps() {
        Object[] objectArray = new BasicAnnotationProcessor.ProcessingStep[2];
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        objectArray[0] = new DatabaseProcessingStep(processingEnvironment);
        ProcessingEnvironment processingEnvironment2 = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment2, (String)"processingEnv");
        objectArray[1] = new TargetCheckProcessingStep(processingEnvironment2);
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public Set<String> getSupportedOptions() {
        return CollectionsKt.toMutableSet((Iterable)Context.Companion.getARG_OPTIONS());
    }

    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latest()");
        return sourceVersion;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bH\u0016J$\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u001a\u0010\u0014\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00130\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Landroidx/room/RoomProcessor$DatabaseProcessingStep;", "Lcom/google/auto/common/BasicAnnotationProcessor$ProcessingStep;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "annotations", "", "Ljava/lang/Class;", "", "prepareDaosForWriting", "", "databases", "", "Landroidx/room/vo/Database;", "daoMethods", "Landroidx/room/vo/DaoMethod;", "process", "Ljavax/lang/model/element/Element;", "elementsByAnnotation", "Lcom/google/common/collect/SetMultimap;", "room-compiler"})
    public static final class DatabaseProcessingStep
    implements BasicAnnotationProcessor.ProcessingStep {
        @NotNull
        private final ProcessingEnvironment processingEnv;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Set<Element> process(@NotNull SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
            List allDaoMethods;
            List list;
            Iterable $receiver$iv;
            List databases;
            List list2;
            Iterable<androidx.room.vo.Database> destination$iv$iv;
            Intrinsics.checkParameterIsNotNull(elementsByAnnotation, (String)"elementsByAnnotation");
            Context context = new Context(this.processingEnv);
            Set rejectedElements = new LinkedHashSet();
            Set set = elementsByAnnotation.get(Database.class);
            if (set != null) {
                void $receiver$iv$iv;
                void $receiver$iv2;
                Iterable iterable = set;
                void var6_5 = $receiver$iv2;
                destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    androidx.room.vo.Database database;
                    androidx.room.vo.Database database2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    Element it = (Element)element$iv$iv;
                    boolean bl = false;
                    try {
                        TypeElement typeElement = MoreElements.asType((Element)it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"MoreElements.asType(it)");
                        database2 = new DatabaseProcessor(context, typeElement).process();
                    }
                    catch (MissingTypeException ex) {
                        Element element = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                        rejectedElements.add(element);
                        database2 = null;
                    }
                    if (database2 == null) continue;
                    androidx.room.vo.Database it$iv$iv = database;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            List list3 = databases = list2;
            if (list3 != null) {
                void $receiver$iv$iv;
                $receiver$iv = list3;
                destination$iv$iv = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    androidx.room.vo.Database it = (androidx.room.vo.Database)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getDaoMethods();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = null;
            }
            List list4 = allDaoMethods = list;
            if (list4 != null) {
                Iterable it = $receiver$iv = list4;
                boolean bl = false;
                this.prepareDaosForWriting(databases, (List<DaoMethod>)it);
                Iterable $receiver$iv3 = it;
                for (Object element$iv : $receiver$iv3) {
                    DaoMethod it2 = (DaoMethod)element$iv;
                    boolean bl2 = false;
                    new DaoWriter(it2.getDao(), context.getProcessingEnv()).write(context.getProcessingEnv());
                }
            }
            List list5 = databases;
            if (list5 != null) {
                $receiver$iv = list5;
                for (Object element$iv : $receiver$iv) {
                    String qName;
                    File dbSchemaFolder;
                    androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv;
                    boolean bl = false;
                    new DatabaseWriter(db).write(context.getProcessingEnv());
                    if (!db.getExportSchema()) continue;
                    File schemaOutFolder2 = context.getSchemaOutFolder();
                    if (schemaOutFolder2 == null) {
                        context.getLogger().w(Warning.MISSING_SCHEMA_LOCATION, db.getElement(), ProcessorErrors.INSTANCE.getMISSING_SCHEMA_EXPORT_DIRECTORY(), new Object[0]);
                        continue;
                    }
                    if (!schemaOutFolder2.exists()) {
                        schemaOutFolder2.mkdirs();
                    }
                    if (!(dbSchemaFolder = new File(schemaOutFolder2, qName = db.getElement().getQualifiedName().toString())).exists()) {
                        dbSchemaFolder.mkdirs();
                    }
                    db.exportSchema(new File(dbSchemaFolder, db.getVersion() + ".json"));
                }
            }
            return rejectedElements;
        }

        @NotNull
        public Set<? extends Class<? extends Annotation>> annotations() {
            return SetsKt.mutableSetOf((Object[])new Class[]{Database.class});
        }

        /*
         * WARNING - void declaration
         */
        private final void prepareDaosForWriting(List<androidx.room.vo.Database> databases, List<DaoMethod> daoMethods) {
            Object element$iv$iv;
            Object $receiver$iv$iv;
            Object $receiver$iv;
            Object object = $receiver$iv = (Iterable)daoMethods;
            Map destination$iv$iv = new LinkedHashMap();
            Object object2 = $receiver$iv$iv.iterator();
            while (object2.hasNext()) {
                Object object3;
                element$iv$iv = object2.next();
                DaoMethod it = (DaoMethod)element$iv$iv;
                boolean bl = false;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                ClassName key$iv$iv = it.getDao().getTypeName();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            object2 = $receiver$iv$iv;
            element$iv$iv = object2.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry entry = element$iv$iv2 = (Map.Entry)element$iv$iv.next();
                boolean bl2 = false;
                if (!(((List)entry.getValue()).size() > 1)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            $receiver$iv = destination$iv$iv;
            object = $receiver$iv;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object key$iv$iv;
                void $receiver$iv$iv2;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object $receiver$iv2 = (Iterable)entry.getValue();
                Iterable bl2 = $receiver$iv2;
                Map destination$iv$iv2 = new LinkedHashMap();
                for (Object element$iv$iv3 : $receiver$iv$iv2) {
                    Object object4;
                    Object element$iv22;
                    block13: {
                        DaoMethod daoMethod = (DaoMethod)element$iv$iv3;
                        boolean bl3 = false;
                        Iterable $receiver$iv3 = databases;
                        for (Object element$iv22 : $receiver$iv3) {
                            androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv22;
                            boolean bl4 = false;
                            if (!db.getDaoMethods().contains(daoMethod)) continue;
                            break block13;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv22;
                    key$iv$iv = db.getTypeName().simpleName();
                    Map $receiver$iv$iv$iv = destination$iv$iv2;
                    Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object4 = answer$iv$iv$iv;
                    } else {
                        object4 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object4;
                    list$iv$iv.add(element$iv$iv3);
                }
                $receiver$iv2 = destination$iv$iv2;
                Object object5 = $receiver$iv2;
                Iterator iterator2 = object5.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv3;
                    Map.Entry $dbName_methods = element$iv3 = iterator2.next();
                    boolean bl5 = false;
                    Map.Entry bl3 = $dbName_methods;
                    String dbName = (String)bl3.getKey();
                    bl3 = $dbName_methods;
                    List methods = (List)bl3.getValue();
                    if (methods.size() == 1) {
                        Dao dao = ((DaoMethod)CollectionsKt.first((List)methods)).getDao();
                        String string = dbName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dbName");
                        dao.setSuffix(string);
                        continue;
                    }
                    Iterable $receiver$iv4 = methods;
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv4) {
                        void method;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        int n2 = n;
                        key$iv$iv = (DaoMethod)item$iv;
                        int index = n2;
                        boolean bl6 = false;
                        method.getDao().setSuffix(dbName + '_' + index);
                    }
                }
            }
        }

        @NotNull
        public final ProcessingEnvironment getProcessingEnv() {
            return this.processingEnv;
        }

        public DatabaseProcessingStep(@NotNull ProcessingEnvironment processingEnv) {
            Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bH\u0016J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u001a\u0010\r\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Landroidx/room/RoomProcessor$TargetCheckProcessingStep;", "Lcom/google/auto/common/BasicAnnotationProcessor$ProcessingStep;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "annotations", "", "Ljava/lang/Class;", "", "process", "Ljavax/lang/model/element/Element;", "elementsByAnnotation", "Lcom/google/common/collect/SetMultimap;", "room-compiler"})
    public static final class TargetCheckProcessingStep
    implements BasicAnnotationProcessor.ProcessingStep {
        @NotNull
        private final ProcessingEnvironment processingEnv;

        @NotNull
        public Set<Element> process(@NotNull SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
            Intrinsics.checkParameterIsNotNull(elementsByAnnotation, (String)"elementsByAnnotation");
            Context context = new Context(this.processingEnv);
            new AutoValueTargetChecker(context, elementsByAnnotation).check();
            return new LinkedHashSet();
        }

        @NotNull
        public Set<? extends Class<? extends Annotation>> annotations() {
            return AutoValueTargetChecker.Companion.requestedAnnotations();
        }

        @NotNull
        public final ProcessingEnvironment getProcessingEnv() {
            return this.processingEnv;
        }

        public TargetCheckProcessingStep(@NotNull ProcessingEnvironment processingEnv) {
            Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
        }
    }
}

