/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.parser.Table;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.verifier.DatabaseVerificaitonErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertionMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutMethod;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001e\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J,\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001e\u0010(\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J,\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J$\u0010*\u001a\u00020!2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010,\u001a\u00020-H\u0002R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/element/TypeElement;)V", "baseClassElement", "Ljavax/lang/model/type/TypeMirror;", "getBaseClassElement", "()Ljavax/lang/model/type/TypeMirror;", "baseClassElement$delegate", "Lkotlin/Lazy;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "doProcess", "Landroidx/room/vo/Database;", "process", "processDatabaseViews", "", "Landroidx/room/vo/DatabaseView;", "dbAnnotation", "Landroidx/room/ext/AnnotationBox;", "Landroidx/room/Database;", "processEntities", "", "Landroidx/room/vo/Entity;", "resolveDatabaseViews", "views", "validateExternalContentFts", "", "dbElement", "entities", "validateForeignKeys", "validateUniqueDaoClasses", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableAndViewNames", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "room-compiler"})
public final class DatabaseProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy baseClassElement$delegate;
    @NotNull
    private final TypeElement element;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseProcessor.class), "baseClassElement", "getBaseClassElement()Ljavax/lang/model/type/TypeMirror;"))};
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final TypeMirror getBaseClassElement() {
        Lazy lazy = this.baseClassElement$delegate;
        DatabaseProcessor databaseProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (TypeMirror)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        boolean bl;
        List daoMethods;
        List<DatabaseView> resolvedViews;
        List<Entity> entities;
        AnnotationBox<Database> dbAnnotation;
        block8: {
            Element it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            AnnotationBox<Database> annotationBox = Element_extKt.toAnnotationBox(this.element, Reflection.getOrCreateKotlinClass(Database.class));
            if (annotationBox == null) {
                Intrinsics.throwNpe();
            }
            dbAnnotation = annotationBox;
            entities = this.processEntities(dbAnnotation, this.element);
            Map<TypeElement, DatabaseView> viewsMap = this.processDatabaseViews(dbAnnotation);
            this.validateForeignKeys(this.element, entities);
            this.validateExternalContentFts(this.element, entities);
            boolean extendsRoomDb = this.context.getProcessingEnv().getTypeUtils().isAssignable(MoreElements.asType((Element)this.element).asType(), this.getBaseClassElement());
            this.context.getChecker().check(extendsRoomDb, this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
            List<? extends Element> allMembers = this.context.getProcessingEnv().getElementUtils().getAllMembers(this.element);
            List views = CollectionsKt.toList((Iterable)viewsMap.values());
            DatabaseVerifier dbVerifier = Element_extKt.hasAnnotation((Element)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, this.element, entities, views);
            this.context.setDatabaseVerifier(dbVerifier);
            if (dbVerifier != null) {
                this.verifyDatabaseViews(viewsMap, dbVerifier);
            }
            resolvedViews = this.resolveDatabaseViews(views);
            this.validateUniqueTableAndViewNames(this.element, entities, views);
            DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)this.element.asType());
            List<? extends Element> list = allMembers;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"allMembers");
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Element)element$iv$iv;
                boolean bl2 = false;
                Element element = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                if (!(Element_extKt.hasAnyOf(element, Modifier.ABSTRACT) && it.getKind() == ElementKind.METHOD)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Element)element$iv$iv;
                boolean bl3 = false;
                Element element = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                Element containing = element.getEnclosingElement();
                if (MoreElements.isType((Element)containing) && Intrinsics.areEqual((Object)TypeName.get((TypeMirror)containing.asType()), (Object)RoomTypeNames.INSTANCE.getROOM_DB())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                ExecutableElement executable;
                it = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ExecutableElement executableElement = executable = MoreElements.asExecutable((Element)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"executable");
                TypeMirror typeMirror2 = executableElement.getReturnType();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"executable.returnType");
                TypeElement daoType = Type_mirror_extKt.asTypeElement(typeMirror2);
                DeclaredType declaredType2 = declaredType;
                Intrinsics.checkExpressionValueIsNotNull((Object)declaredType2, (String)"declaredType");
                Dao dao = new DaoProcessor(this.context, daoType, declaredType2, dbVerifier).process();
                DaoMethod daoMethod = new DaoMethod(executable, executable.getSimpleName().toString(), dao);
                collection.add(daoMethod);
            }
            daoMethods = (List)destination$iv$iv;
            this.validateUniqueDaoClasses(this.element, daoMethods, entities);
            this.validateUniqueIndices(this.element, entities);
            Iterable $receiver$iv2 = entities;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    Entity it2 = (Entity)element$iv;
                    boolean bl5 = false;
                    Collection collection = it2.getForeignKeys();
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasForeignKeys = bl;
        int n = dbAnnotation.getValue().version();
        TypeMirror typeMirror3 = MoreElements.asType((Element)this.element).asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror3, (String)"MoreElements.asType(element).asType()");
        boolean bl6 = hasForeignKeys;
        boolean bl7 = dbAnnotation.getValue().exportSchema();
        List list = daoMethods;
        List<DatabaseView> list2 = resolvedViews;
        List<Entity> list3 = entities;
        TypeMirror typeMirror4 = typeMirror3;
        TypeElement typeElement = this.element;
        int n2 = n;
        androidx.room.vo.Database database = new androidx.room.vo.Database(typeElement, typeMirror4, list3, list2, list, n2, bl7, bl6);
        return database;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(TypeElement element, List<? extends Entity> entities) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = entities;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getTableName();
            map2.put(string, element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        $receiver$iv = entities;
        for (Object element$iv : $receiver$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Iterable $receiver$iv2 = entity.getForeignKeys();
            for (Object element$iv2 : $receiver$iv2) {
                Collection<String> collection;
                void $receiver$iv$iv2;
                void $receiver$iv3;
                Object element$iv$iv$iv;
                void $receiver$iv$iv22;
                List<String> $receiver$iv32;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e(element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName().toString()), new Object[0]);
                    continue;
                }
                List<String> list = $receiver$iv32 = (List<String>)foreignKey.getParentColumns();
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv22;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Field field;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    String columnName = (String)element$iv$iv;
                    boolean bl3 = false;
                    Field parentField = HasFieldsKt.findFieldByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.context.getLogger().e(entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName().toString(), columnName, HasFieldsKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    Field it$iv$iv = field;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                $receiver$iv32 = foreignKey.getChildFields();
                List<String> list2 = foreignKey.getParentColumns();
                String string = entity.getElement().getQualifiedName().toString();
                String string2 = parent.getElement().getQualifiedName().toString();
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                Element element2 = parent.getElement();
                RLog rLog = this.context.getLogger();
                $receiver$iv$iv22 = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object t : $receiver$iv$iv2) {
                    void it;
                    element$iv$iv$iv = (Field)t;
                    collection = destination$iv$iv3;
                    boolean bl4 = false;
                    String string3 = it.getColumnName();
                    collection.add(string3);
                }
                Collection<String> collection2 = collection = (List)destination$iv$iv3;
                list = list2;
                String string4 = string;
                rLog.e(element2, processorErrors.foreignKeyMissingIndexInParent(string2, list, string4, (List<String>)collection2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(TypeElement element, List<? extends Entity> entities) {
        Object object;
        Object object2;
        Object element$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = entities;
        Object object3 = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        Object object4 = $receiver$iv$iv.iterator();
        while (object4.hasNext()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            element$iv$iv = object4.next();
            Entity entity = (Entity)element$iv$iv;
            boolean bl = false;
            Iterable iterable = $receiver$iv2 = (Iterable)entity.getIndices();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                Index index = (Index)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                object = new Pair((Object)it.getName(), (Object)entity);
                object2.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object4 = $receiver$iv$iv.iterator();
        while (object4.hasNext()) {
            Object object5;
            element$iv$iv = object4.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            String key$iv$iv = (String)it.getFirst();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object4 = $receiver$iv$iv;
        element$iv$iv = object4.entrySet().iterator();
        while (element$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = (Map.Entry)element$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        $receiver$iv = destination$iv$iv;
        object3 = $receiver$iv;
        Iterator iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            void $receiver$iv$iv3;
            TypeName key$iv;
            Pair it;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = iterator.next();
            boolean bl = false;
            Iterable $receiver$iv3 = (Iterable)it2.getValue();
            Iterable<Object> set$iv = new HashSet<TypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $receiver$iv3) {
                it = (Pair)e$iv;
                boolean bl3 = false;
                key$iv = ((Entity)it.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            $receiver$iv3 = (Iterable)it2.getValue();
            object2 = (String)it2.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            object = element;
            RLog rLog = this.context.getLogger();
            set$iv = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                key$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                String string = ((Entity)it.getSecond()).getTypeName() + " > " + (String)it.getFirst();
                collection.add(string);
            }
            collection = (List)destination$iv$iv3;
            rLog.e((Element)object, processorErrors.duplicateIndexInDatabase((String)object2, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(TypeElement dbElement, List<DaoMethod> daoMethods, List<? extends Entity> entities) {
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Object $receiver$iv$iv$iv;
        DaoMethod it;
        Object $receiver$iv$iv;
        Object $receiver$iv = entities;
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeName typeName2 = ((Pojo)((Object)it)).getTypeName();
            collection.add(typeName2);
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv = (Iterable)daoMethods;
        destination$iv$iv = new LinkedHashMap();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            it = (DaoMethod)element$iv$iv;
            boolean bl2 = false;
            $receiver$iv$iv$iv = destination$iv$iv;
            ClassName key$iv$iv = it.getDao().getTypeName();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Iterator iterator2 = $receiver$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<String> $i$f$groupBy;
            Iterator $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = iterator2.next();
            boolean bl = false;
            if (((List)it2.getValue()).size() <= 1) continue;
            Iterable bl2 = (Iterable)it2.getValue();
            TypeName typeName3 = (TypeName)it2.getKey();
            $receiver$iv$iv$iv = ProcessorErrors.INSTANCE;
            value$iv$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            list$iv$iv = $receiver$iv$iv2.iterator();
            while (list$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = list$iv$iv.next();
                DaoMethod $i$f$groupByTo = (DaoMethod)item$iv$iv;
                $i$f$groupBy = destination$iv$iv2;
                boolean bl3 = false;
                String string = it3.getName();
                $i$f$groupBy.add(string);
            }
            $i$f$groupBy = (List)destination$iv$iv2;
            String error = ((ProcessorErrors)$receiver$iv$iv$iv).duplicateDao(typeName3, (List<String>)$i$f$groupBy);
            $receiver$iv2 = (Iterable)it2.getValue();
            $receiver$iv$iv2 = $receiver$iv2.iterator();
            while ($receiver$iv$iv2.hasNext()) {
                Object element$iv2 = $receiver$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                boolean bl4 = false;
                this.context.getLogger().e(daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<Element, Dao, TypeName, Unit>(this, entityTypeNames, dbElement){
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ Set $entityTypeNames;
            final /* synthetic */ TypeElement $dbElement;

            public final void invoke(@NotNull Element element, @NotNull Dao dao, @Nullable TypeName typeName2) {
                block1: {
                    TypeName typeName3;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)dao, (String)"dao");
                    TypeName typeName4 = typeName2;
                    if (typeName4 == null) break block1;
                    TypeName it = typeName3 = typeName4;
                    boolean bl = false;
                    if (!this.$entityTypeNames.contains(typeName2)) {
                        RLog rLog = this.this$0.getContext().getLogger();
                        String string = this.$dbElement.getQualifiedName().toString();
                        String string2 = dao.getTypeName().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dao.typeName.toString()");
                        String string3 = typeName2.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"typeName.toString()");
                        rLog.e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(string, string2, string3), new Object[0]);
                    }
                }
            }
            {
                this.this$0 = databaseProcessor;
                this.$entityTypeNames = set;
                this.$dbElement = typeElement;
                super(3);
            }
        };
        Iterable $receiver$iv3 = daoMethods;
        for (Map.Entry element$iv : $receiver$iv3) {
            Map.Entry<String, Entity> it4;
            Map.Entry<String, Entity> element$iv3;
            Iterator<Map.Entry<String, Entity>> iterator3;
            Map<String, Entity> map2;
            Map<String, Entity> $receiver$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)((Object)element$iv);
            boolean bl = false;
            Iterable $receiver$iv5 = daoMethod.getDao().getShortcutMethods();
            for (Object element$iv4 : $receiver$iv5) {
                method = (ShortcutMethod)element$iv4;
                boolean bl5 = false;
                map2 = $receiver$iv4 = ((ShortcutMethod)method).getEntities();
                iterator3 = map2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    it4 = element$iv3 = iterator3.next();
                    boolean bl6 = false;
                    check2.invoke((Object)((ShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getTypeName());
                }
            }
            $receiver$iv5 = daoMethod.getDao().getInsertionMethods();
            for (Object element$iv4 : $receiver$iv5) {
                method = (InsertionMethod)element$iv4;
                boolean bl7 = false;
                map2 = $receiver$iv4 = ((InsertionMethod)method).getEntities();
                iterator3 = map2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    it4 = element$iv3 = iterator3.next();
                    boolean bl8 = false;
                    check2.invoke((Object)((InsertionMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(TypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        Object element$iv$iv;
        ProcessorErrors processorErrors;
        Object $receiver$iv$iv;
        Triple triple;
        String string;
        Collection collection;
        Object item$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)entities;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv2) {
            String string2;
            void it;
            Entity entity = (Entity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.getTableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase((Locale)((Object)string)), (String)"(this as java.lang.String).toLowerCase(locale)");
            TypeElement typeElement = it.getElement();
            String string5 = it.getTypeName().toString();
            String string6 = string2;
            triple = new Triple((Object)string6, (Object)string5, (Object)typeElement);
            collection.add(triple);
        }
        List entitiesInfo = (List)destination$iv$iv;
        Object $receiver$iv2 = views;
        destination$iv$iv = $receiver$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        item$iv$iv2 = $receiver$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            String $i$f$mapTo;
            void it;
            Object item$iv$iv3 = item$iv$iv2.next();
            DatabaseView bl = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            string = it.getViewName();
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            String string7 = string;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string7.toLowerCase((Locale)((Object)processorErrors)), (String)"(this as java.lang.String).toLowerCase(locale)");
            TypeElement typeElement = it.getElement();
            String string8 = it.getTypeName().toString();
            String string9 = $i$f$mapTo;
            triple = new Triple((Object)string9, (Object)string8, (Object)typeElement);
            collection.add(triple);
        }
        List viewsInfo = (List)destination$iv$iv2;
        $receiver$iv2 = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new LinkedHashMap();
        item$iv$iv2 = $receiver$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            Object object;
            element$iv$iv = item$iv$iv2.next();
            Triple $name_$_$_$_$ = (Triple)element$iv$iv;
            boolean bl = false;
            Object $receiver$iv$iv$iv = destination$iv$iv2;
            String name = (String)$name_$_$_$_$.component1();
            String key$iv$iv = name;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new LinkedHashMap();
        item$iv$iv2 = $receiver$iv$iv;
        element$iv$iv = item$iv$iv2.entrySet().iterator();
        while (element$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = (Map.Entry)element$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        $receiver$iv2 = destination$iv$iv2;
        Object object = $receiver$iv2;
        Iterator<Object> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $receiver$iv$iv3;
            Iterable $receiver$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Iterable it = (Iterable)byName.getValue();
            String string10 = (String)byName.getKey();
            processorErrors = ProcessorErrors.INSTANCE;
            void $i$f$filter = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv4 : $receiver$iv$iv3) {
                void $$_$_typeName_$_$;
                String typeName2;
                Triple $i$f$getOrPut = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv3;
                boolean bl3 = false;
                String string11 = typeName2 = (String)$$_$_typeName_$_$.component2();
                collection2.add(string11);
            }
            collection2 = (List)destination$iv$iv3;
            String error = processorErrors.duplicateTableNames(string10, (List<String>)collection2);
            $receiver$iv3 = (Iterable)byName.getValue();
            for (Object element$iv2 : $receiver$iv3) {
                Triple $$_$_$_$_element = (Triple)element$iv2;
                boolean bl4 = false;
                TypeElement element = (TypeElement)$$_$_$_$_element.component3();
                this.context.getLogger().e(element, error, new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(TypeElement dbElement, List<? extends Entity> entities) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            boolean bl = false;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            boolean bl = false;
            RLog rLog = this.context.getLogger();
            Element element = dbElement;
            String string = it.getElement().getQualifiedName().toString();
            Entity entity = it.getFtsOptions().getContentEntity();
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            rLog.e(element, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName().toString()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(AnnotationBox<Database> dbAnnotation, TypeElement element) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<TypeMirror> entityList = dbAnnotation.getAsTypeMirrorList("entities");
        Collection collection = entityList;
        Object object = this.context.getChecker();
        boolean bl = !collection.isEmpty();
        ((Checks)object).check(bl, element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable iterable = $receiver$iv = (Iterable)entityList;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, Type_mirror_extKt.asTypeElement((TypeMirror)it), null, 4, null).process();
            object.add(entity);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TypeElement, DatabaseView> processDatabaseViews(AnnotationBox<Database> dbAnnotation) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<TypeMirror> viewList = dbAnnotation.getAsTypeMirrorList("views");
        Iterable iterable = $receiver$iv = (Iterable)viewList;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeElement viewElement = Type_mirror_extKt.asTypeElement((TypeMirror)it);
            Pair pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.context, viewElement, null, 4, null).process());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<TypeElement, DatabaseView> map2, DatabaseVerifier dbVerifier) {
        Map<TypeElement, DatabaseView> map3 = map2;
        Iterator<Map.Entry<TypeElement, DatabaseView>> iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TypeElement, DatabaseView> entry;
            Map.Entry<TypeElement, DatabaseView> entry2 = entry = iterator.next();
            TypeElement viewElement = entry2.getKey();
            entry2 = entry;
            DatabaseView view = entry2.getValue();
            if (Element_extKt.hasAnnotation((Element)viewElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) == null) continue;
            RLog rLog = this.context.getLogger();
            Element element = viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            if (queryResultInfo2 == null) {
                Intrinsics.throwNpe();
            }
            SQLException sQLException = queryResultInfo2.getError();
            if (sQLException == null) {
                Intrinsics.throwNpe();
            }
            rLog.e(element, DatabaseVerificaitonErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Collection collection;
        Object object;
        Object object2;
        Object object3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = $receiver$iv = (Iterable)views;
        Set<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object2 = it.getViewName();
            object3.add(object2);
        }
        List viewNames = (List)((Object)destination$iv$iv);
        Function1<String, Boolean> isTable$ = new Function1<String, Boolean>(viewNames){
            final /* synthetic */ List $viewNames;

            public final boolean invoke(@NotNull String name) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Iterable $receiver$iv = this.$viewNames;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.$viewNames = list;
                super(1);
            }
        };
        for (DatabaseView view : views) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Object item$iv$iv;
            Iterable iterable2 = view.getQuery().getTables();
            object3 = view.getTables();
            item$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Map item$iv$iv2 : $receiver$iv$iv2) {
                void $name_$_$;
                Table $i$f$map = (Table)((Object)item$iv$iv2);
                object2 = destination$iv$iv2;
                boolean bl2 = false;
                String name = $name_$_$.component1();
                object = name;
                object2.add(object);
            }
            object2 = (List)destination$iv$iv2;
            object3.addAll((Collection)object2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        Map resolvedViews = new LinkedHashMap();
        List result = new ArrayList();
        int step = 0;
        do {
            Iterable $receiver$iv2;
            Set<String> $receiver$iv3;
            Object $receiver$iv$iv3;
            Iterable $receiver$iv4;
            Object view22;
            String viewName;
            Map item$iv$iv2;
            item$iv$iv2 = resolvedViews;
            Object bl = item$iv$iv2.entrySet().iterator();
            while (bl.hasNext()) {
                Map.Entry destination$iv$iv2;
                Map.Entry bl2 = destination$iv$iv2 = bl.next();
                viewName = (String)bl2.getKey();
                bl2 = destination$iv$iv2;
                Set tables = (Set)bl2.getValue();
                for (Object view22 : unresolvedViews) {
                    if (!((DatabaseView)view22).getTables().removeIf(new Predicate<String>(viewName){
                        final /* synthetic */ String $viewName;

                        public final boolean test(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return StringsKt.equals((String)it, (String)this.$viewName, (boolean)true);
                        }
                        {
                            this.$viewName = string;
                        }
                    })) continue;
                    ((DatabaseView)view22).getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            bl = unresolvedViews;
            viewName = $receiver$iv4;
            Collection destination$iv$iv3 = new ArrayList();
            view22 = $receiver$iv$iv3.iterator();
            while (view22.hasNext()) {
                boolean bl2;
                Object element$iv$iv;
                block14: {
                    element$iv$iv = view22.next();
                    DatabaseView view232 = (DatabaseView)element$iv$iv;
                    boolean bl4 = false;
                    $receiver$iv3 = view232.getTables();
                    if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object t : $receiver$iv3) {
                            String it = (String)t;
                            boolean bl5 = false;
                            if (isTable$.invoke(it)) continue;
                            bl2 = false;
                            break block14;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $receiver$iv4 = (List)destination$iv$iv3;
            $receiver$iv$iv3 = $receiver$iv2.iterator();
            while ($receiver$iv$iv3.hasNext()) {
                Object element$iv = $receiver$iv$iv3.next();
                DatabaseView view = (DatabaseView)element$iv;
                boolean bl6 = false;
                Map view232 = resolvedViews;
                String bl4 = view.getViewName();
                $receiver$iv3 = view.getTables();
                view232.put(bl4, $receiver$iv3);
                unresolvedViews.remove(view);
                result.add(view);
                int view232 = countNewlyResolved;
                countNewlyResolved = view232 + 1;
            }
            if (countNewlyResolved == 0) {
                Collection<String> collection2;
                void $receiver$iv$iv2;
                $receiver$iv2 = unresolvedViews;
                object = ProcessorErrors.INSTANCE;
                object2 = this.element;
                object3 = this.context.getLogger();
                $receiver$iv$iv3 = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    DatabaseView view232 = (DatabaseView)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl7 = false;
                    String string = it.getViewName();
                    collection2.add(string);
                }
                collection2 = (List)destination$iv$iv2;
                ((RLog)object3).e((Element)object2, ((ProcessorErrors)object).viewCircularReferenceDetected((List<String>)collection2), new Object[0]);
                break;
            }
            ++step;
        } while (!(collection = (Collection)unresolvedViews).isEmpty());
        return result;
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull TypeElement element) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.element = element;
        this.context = baseContext.fork(this.element);
        this.baseClassElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeMirror>(this){
            final /* synthetic */ DatabaseProcessor this$0;

            public final TypeMirror invoke() {
                return this.this$0.getContext().getProcessingEnv().getElementUtils().getTypeElement(RoomTypeNames.INSTANCE.getROOM_DB().packageName() + "." + RoomTypeNames.INSTANCE.getROOM_DB().simpleName()).asType();
            }
            {
                this.this$0 = databaseProcessor;
                super(0);
            }
        }));
    }
}

