/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.DatabaseView;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.SqlParser;
import androidx.room.processor.Context;
import androidx.room.processor.EntityOrViewProcessor;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.vo.Pojo;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/room/processor/DatabaseViewProcessor;", "Landroidx/room/processor/EntityOrViewProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "Ljavax/lang/model/element/Name;", "Lkotlin/collections/LinkedHashSet;", "(Landroidx/room/processor/Context;Ljavax/lang/model/element/TypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "process", "Landroidx/room/vo/DatabaseView;", "Companion", "room-compiler"})
public final class DatabaseViewProcessor
implements EntityOrViewProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final TypeElement element;
    private final LinkedHashSet<Name> referenceStack;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.DatabaseView process() {
        ParsedQuery parsedQuery;
        String viewName;
        this.context.getChecker().hasAnnotation(this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(DatabaseView.class), ProcessorErrors.INSTANCE.getVIEW_MUST_BE_ANNOTATED_WITH_DATABASE_VIEW(), new Object[0]);
        AnnotationBox annotationBox = Element_extKt.toAnnotationBox(this.element, Reflection.getOrCreateKotlinClass(DatabaseView.class));
        String string = viewName = annotationBox != null ? Companion.extractViewName(this.element, (DatabaseView)annotationBox.getValue()) : this.element.getSimpleName().toString();
        if (annotationBox != null) {
            ParsedQuery parsedQuery2;
            ParsedQuery it = parsedQuery2 = SqlParser.Companion.parse(((DatabaseView)annotationBox.getValue()).value());
            boolean bl = false;
            this.context.getChecker().check(it.getErrors().isEmpty(), this.element, CollectionsKt.joinToString$default((Iterable)it.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            this.context.getChecker().check(it.getType() == QueryType.SELECT, this.element, ProcessorErrors.INSTANCE.getVIEW_QUERY_MUST_BE_SELECT(), new Object[0]);
            this.context.getChecker().check(it.getBindSections().isEmpty(), this.element, ProcessorErrors.INSTANCE.getVIEW_QUERY_CANNOT_TAKE_ARGUMENTS(), new Object[0]);
            parsedQuery = parsedQuery2;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query2 = parsedQuery;
        this.context.getChecker().notBlank(viewName, this.element, ProcessorErrors.INSTANCE.getVIEW_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)viewName, (String)"sqlite_", (boolean)true), this.element, ProcessorErrors.INSTANCE.getVIEW_NAME_CANNOT_START_WITH_SQLITE(), new Object[0]);
        Pojo pojo = PojoProcessor.Companion.createFor$default(PojoProcessor.Companion, this.context, this.element, FieldProcessor.BindingScope.READ_FROM_CURSOR, null, this.referenceStack, null, 32, null).process();
        return new androidx.room.vo.DatabaseView(this.element, viewName, query2, pojo.getType(), pojo.getFields(), pojo.getEmbeddedFields(), pojo.getConstructor());
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public DatabaseViewProcessor(@NotNull Context baseContext, @NotNull TypeElement element, @NotNull LinkedHashSet<Name> referenceStack) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = baseContext.fork(this.element);
    }

    public /* synthetic */ DatabaseViewProcessor(Context context, TypeElement typeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<Name>();
        }
        this(context, typeElement, linkedHashSet);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/room/processor/DatabaseViewProcessor$Companion;", "", "()V", "extractViewName", "", "element", "Ljavax/lang/model/element/TypeElement;", "annotation", "Landroidx/room/DatabaseView;", "room-compiler"})
    public static final class Companion {
        @NotNull
        public final String extractViewName(@NotNull TypeElement element, @NotNull DatabaseView annotation) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            return Intrinsics.areEqual((Object)annotation.viewName(), (Object)"") ? element.getSimpleName().toString() : annotation.viewName();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

