/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Query;
import androidx.room.SkipQueryVerification;
import androidx.room.Transaction;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.Section;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.prepared.binder.PreparedQueryResultBinder;
import androidx.room.solver.query.result.PojoRowAdapter;
import androidx.room.solver.query.result.QueryResultAdapter;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.verifier.DatabaseVerificaitonErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.QueryMethod;
import androidx.room.vo.QueryParameter;
import androidx.room.vo.ReadQueryMethod;
import androidx.room.vo.Warning;
import androidx.room.vo.WriteQueryMethod;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001e\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Landroidx/room/processor/QueryMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "executableElement", "Ljavax/lang/model/element/ExecutableElement;", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/ExecutableElement;Landroidx/room/verifier/DatabaseVerifier;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getDbVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "getExecutableElement", "()Ljavax/lang/model/element/ExecutableElement;", "getPreparedQueryMethod", "Landroidx/room/vo/WriteQueryMethod;", "delegate", "Landroidx/room/processor/MethodProcessorDelegate;", "returnType", "Ljavax/lang/model/type/TypeMirror;", "query", "Landroidx/room/parser/ParsedQuery;", "getQueryMethod", "Landroidx/room/vo/QueryMethod;", "process", "Companion", "room-compiler"})
public final class QueryMethodProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final ExecutableElement executableElement;
    @Nullable
    private final DatabaseVerifier dbVerifier;
    @NotNull
    private static final QueryType[] PREPARED_TYPES;
    public static final Companion Companion;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QueryMethod process() {
        Iterable $receiver$iv$iv;
        String string;
        Collection collection;
        Pair it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        ParsedQuery parsedQuery;
        MethodProcessorDelegate delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        TypeMirror returnType = delegate.extractReturnType();
        AnnotationBox annotationBox = Element_extKt.toAnnotationBox(this.executableElement, Reflection.getOrCreateKotlinClass(Query.class));
        Query annotation = annotationBox != null ? (Query)annotationBox.getValue() : null;
        this.context.getChecker().check(annotation != null, this.executableElement, ProcessorErrors.INSTANCE.getMISSING_QUERY_ANNOTATION(), new Object[0]);
        if (annotation != null) {
            ParsedQuery query2 = SqlParser.Companion.parse(annotation.value());
            this.context.getChecker().check(query2.getErrors().isEmpty(), this.executableElement, CollectionsKt.joinToString$default((Iterable)query2.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            if (!Element_extKt.hasAnnotation((Element)this.executableElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) {
                DatabaseVerifier databaseVerifier = this.dbVerifier;
                query2.setResultInfo(databaseVerifier != null ? databaseVerifier.analyze(query2.getOriginal()) : null);
            }
            QueryResultInfo queryResultInfo = query2.getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) != null) {
                RLog rLog = this.context.getLogger();
                Element element = this.executableElement;
                QueryResultInfo queryResultInfo2 = query2.getResultInfo();
                if (queryResultInfo2 == null) {
                    Intrinsics.throwNpe();
                }
                SQLException sQLException = queryResultInfo2.getError();
                if (sQLException == null) {
                    Intrinsics.throwNpe();
                }
                rLog.e(element, DatabaseVerificaitonErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
            }
            this.context.getChecker().check(returnType.getKind() != TypeKind.ERROR, this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_RESOLVE_RETURN_TYPE(), this.executableElement);
            parsedQuery = query2;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query3 = parsedQuery;
        TypeName returnTypeName = Javapoet_extKt.typeName(returnType);
        Checks checks = this.context.getChecker();
        TypeName typeName2 = returnTypeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"returnTypeName");
        checks.notUnbound(typeName2, this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        boolean isPreparedQuery = ArraysKt.contains((Object[])PREPARED_TYPES, (Object)((Object)query3.getType()));
        QueryMethod queryMethod = isPreparedQuery ? (QueryMethod)this.getPreparedQueryMethod(delegate, returnType, query3) : this.getQueryMethod(delegate, returnType, query3);
        Iterable iterable = queryMethod.getSectionToParamMapping();
        Collection collection2 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = ((Section)it.getFirst()).getText();
            collection.add(string);
        }
        List missing = (List)destination$iv$iv;
        $receiver$iv = missing;
        if (!$receiver$iv.isEmpty()) {
            this.context.getLogger().e(this.executableElement, ProcessorErrors.INSTANCE.missingParameterForBindVariable(missing), new Object[0]);
        }
        Iterable $receiver$iv2 = queryMethod.getParameters();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block15: {
                QueryParameter param = (QueryParameter)element$iv$iv;
                boolean bl2 = false;
                Iterable $receiver$iv3 = queryMethod.getSectionToParamMapping();
                if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv3) {
                        Pair it2 = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)((QueryParameter)it2.getSecond()), (Object)param)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object param = item$iv$iv = iterator.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            string = ((QueryParameter)receiver).getSqlName();
            collection.add(string);
        }
        List unused = (List)destination$iv$iv2;
        collection2 = unused;
        if (!collection2.isEmpty()) {
            this.context.getLogger().e(this.executableElement, ProcessorErrors.INSTANCE.unusedQueryMethodParameter(unused), new Object[0]);
        }
        return queryMethod;
    }

    private final WriteQueryMethod getPreparedQueryMethod(MethodProcessorDelegate delegate, TypeMirror returnType, ParsedQuery query2) {
        PreparedQueryResultBinder resultBinder = delegate.findPreparedResultBinder(returnType, query2);
        this.context.getChecker().check(resultBinder.getAdapter() != null, this.executableElement, ProcessorErrors.INSTANCE.cannotFindPreparedQueryResultAdapter(((Object)returnType).toString(), query2.getType()), new Object[0]);
        List<QueryParameter> parameters = delegate.extractQueryParams();
        return new WriteQueryMethod(this.executableElement, query2, this.executableElement.getSimpleName().toString(), returnType, parameters, resultBinder);
    }

    private final QueryMethod getQueryMethod(MethodProcessorDelegate delegate, TypeMirror returnType, ParsedQuery query2) {
        Object object;
        QueryResultBinder resultBinder = delegate.findResultBinder(returnType, query2);
        this.context.getChecker().check(resultBinder.getAdapter() != null, this.executableElement, ProcessorErrors.INSTANCE.cannotFindQueryResultAdapter(((Object)returnType).toString()), new Object[0]);
        boolean inTransaction = Element_extKt.hasAnnotation((Element)this.executableElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Transaction.class));
        if (query2.getType() == QueryType.SELECT && !inTransaction && (object = resultBinder.getAdapter()) != null && (object = ((QueryResultAdapter)object).getRowAdapter()) != null) {
            Collection collection;
            Object object2;
            Object rowAdapter = object2 = object;
            boolean bl = false;
            if (rowAdapter instanceof PojoRowAdapter && !(collection = (Collection)((PojoRowAdapter)rowAdapter).getRelationCollectors()).isEmpty()) {
                this.context.getLogger().w(Warning.RELATION_QUERY_WITHOUT_TRANSACTION, this.executableElement, ProcessorErrors.INSTANCE.getTRANSACTION_MISSING_ON_RELATION(), new Object[0]);
            }
        }
        List<QueryParameter> parameters = delegate.extractQueryParams();
        return new ReadQueryMethod(this.executableElement, query2, this.executableElement.getSimpleName().toString(), returnType, parameters, inTransaction, resultBinder);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    @Nullable
    public final DatabaseVerifier getDbVerifier() {
        return this.dbVerifier;
    }

    public QueryMethodProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull ExecutableElement executableElement, @Nullable DatabaseVerifier dbVerifier) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.dbVerifier = dbVerifier;
        this.context = baseContext.fork(this.executableElement);
    }

    public /* synthetic */ QueryMethodProcessor(Context context, DeclaredType declaredType, ExecutableElement executableElement, DatabaseVerifier databaseVerifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            databaseVerifier = null;
        }
        this(context, declaredType, executableElement, databaseVerifier);
    }

    static {
        Companion = new Companion(null);
        PREPARED_TYPES = new QueryType[]{QueryType.INSERT, QueryType.DELETE, QueryType.UPDATE};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Landroidx/room/processor/QueryMethodProcessor$Companion;", "", "()V", "PREPARED_TYPES", "", "Landroidx/room/parser/QueryType;", "getPREPARED_TYPES", "()[Landroidx/room/parser/QueryType;", "[Landroidx/room/parser/QueryType;", "room-compiler"})
    public static final class Companion {
        @NotNull
        public final QueryType[] getPREPARED_TYPES() {
            return PREPARED_TYPES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

