/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.ForeignKeyInput;
import androidx.room.processor.IndexInput;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.TableEntityProcessor;
import androidx.room.processor.cache.Cache;
import androidx.room.vo.Constructor;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.Field;
import androidx.room.vo.Fields;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.ForeignKeyAction;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.Pojo;
import androidx.room.vo.Warning;
import com.google.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\b\u0010$\u001a\u00020%H\u0002J$\u0010&\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00132\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020%H\u0016J$\u00100\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00132\u0006\u00103\u001a\u000204H\u0002J$\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u00106\u001a\b\u0012\u0004\u0012\u00020(0\u00132\u0006\u00103\u001a\u000204H\u0002R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Landroidx/room/processor/TableEntityProcessor;", "Landroidx/room/processor/EntityProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "Ljavax/lang/model/element/Name;", "Lkotlin/collections/LinkedHashSet;", "(Landroidx/room/processor/Context;Ljavax/lang/model/element/TypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "checkIndicesForForeignKeys", "", "entityForeignKeys", "", "Landroidx/room/vo/ForeignKey;", "primaryKey", "Landroidx/room/vo/PrimaryKey;", "indices", "Landroidx/room/vo/Index;", "choosePrimaryKey", "candidates", "typeElement", "collectPrimaryKeysFromEmbeddedFields", "embeddedFields", "Landroidx/room/vo/EmbeddedField;", "collectPrimaryKeysFromEntityAnnotations", "availableFields", "Landroidx/room/vo/Field;", "collectPrimaryKeysFromPrimaryKeyAnnotations", "fields", "doProcess", "Landroidx/room/vo/Entity;", "findAndValidatePrimaryKey", "loadSuperIndices", "Landroidx/room/processor/IndexInput;", "typeMirror", "Ljavax/lang/model/type/TypeMirror;", "tableName", "", "inherit", "", "process", "validateAndCreateForeignKeyReferences", "foreignKeyInputs", "Landroidx/room/processor/ForeignKeyInput;", "pojo", "Landroidx/room/vo/Pojo;", "validateAndCreateIndices", "inputs", "room-compiler"})
public final class TableEntityProcessor
implements EntityProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final TypeElement element;
    private final LinkedHashSet<Name> referenceStack;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.Entity process() {
        return this.context.getCache().getEntities().get(new Cache.EntityKey(this.element), (Function0<androidx.room.vo.Entity>)((Function0)new Function0<androidx.room.vo.Entity>(this){
            final /* synthetic */ TableEntityProcessor this$0;

            @NotNull
            public final androidx.room.vo.Entity invoke() {
                return TableEntityProcessor.access$doProcess(this.this$0);
            }
            {
                this.this$0 = tableEntityProcessor;
                super(0);
            }
        }));
    }

    private final androidx.room.vo.Entity doProcess() {
        Object object;
        Object element$iv$iv2;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.context.getChecker().hasAnnotation(this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), ProcessorErrors.INSTANCE.getENTITY_MUST_BE_ANNOTATED_WITH_ENTITY(), new Object[0]);
        AnnotationBox<Entity> annotationBox = Element_extKt.toAnnotationBox(this.element, Reflection.getOrCreateKotlinClass(Entity.class));
        String tableName = null;
        List<IndexInput> entityIndices = null;
        List<ForeignKeyInput> foreignKeyInputs = null;
        boolean inheritSuperIndices = false;
        Set ignoredColumns = null;
        if (annotationBox != null) {
            tableName = EntityProcessor.Companion.extractTableName(this.element, (Entity)annotationBox.getValue());
            entityIndices = EntityProcessor.Companion.extractIndices(annotationBox, tableName);
            inheritSuperIndices = annotationBox.getValue().inheritSuperIndices();
            foreignKeyInputs = EntityProcessor.Companion.extractForeignKeys(annotationBox);
            ignoredColumns = ArraysKt.toSet((Object[])annotationBox.getValue().ignoredColumns());
        } else {
            tableName = this.element.getSimpleName().toString();
            foreignKeyInputs = CollectionsKt.emptyList();
            entityIndices = CollectionsKt.emptyList();
            inheritSuperIndices = false;
            ignoredColumns = SetsKt.emptySet();
        }
        this.context.getChecker().notBlank(tableName, this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)tableName, (String)"sqlite_", (boolean)true), this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_START_WITH_SQLITE(), new Object[0]);
        Pojo pojo = PojoProcessor.Companion.createFor(this.context, this.element, FieldProcessor.BindingScope.TWO_WAY, null, this.referenceStack, ignoredColumns).process();
        this.context.getChecker().check(pojo.getRelations().isEmpty(), this.element, ProcessorErrors.INSTANCE.getRELATION_IN_ENTITY(), new Object[0]);
        Iterable iterable = pojo.getFields();
        void var10_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            Field it = (Field)element$iv$iv2;
            boolean bl = false;
            if (!it.getIndexed()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        element$iv$iv2 = $receiver$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            IndexInput indexInput;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            Field it = (Field)element$iv$iv3;
            boolean bl = false;
            if (it.getParent() != null) {
                it.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_FIELD_IS_DROPPED, it.getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedFieldIndex(it.getPath(), this.element.getQualifiedName().toString()), new Object[0]);
                indexInput = null;
            } else if (Intrinsics.areEqual((Object)it.getElement().getEnclosingElement(), (Object)this.element) ^ true && !inheritSuperIndices) {
                it.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_PARENT_FIELD_IS_DROPPED, ProcessorErrors.INSTANCE.droppedSuperClassFieldIndex(it.getColumnName(), this.element.toString(), it.getElement().getEnclosingElement().toString()), new Object[0]);
                indexInput = null;
            } else {
                indexInput = new IndexInput(EntityProcessor.Companion.createIndexName(CollectionsKt.listOf((Object)it.getColumnName()), tableName), false, CollectionsKt.listOf((Object)it.getColumnName()));
            }
            if (indexInput == null) continue;
            object = indexInput;
            IndexInput it$iv$iv = object;
            destination$iv$iv.add(it$iv$iv);
        }
        List fieldIndices = (List)destination$iv$iv;
        List<IndexInput> superIndices = this.loadSuperIndices(this.element.getSuperclass(), tableName, inheritSuperIndices);
        List indexInputs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)entityIndices, (Iterable)fieldIndices), (Iterable)superIndices);
        List<Index> indices = this.validateAndCreateIndices(indexInputs, pojo);
        androidx.room.vo.PrimaryKey primaryKey = this.findAndValidatePrimaryKey(pojo.getFields(), pojo.getEmbeddedFields());
        Object object2 = (Field)CollectionsKt.firstOrNull((List)primaryKey.getFields());
        if (object2 == null || (object2 = object2.getAffinity()) == null) {
            object2 = SQLTypeAffinity.TEXT;
        }
        Object affinity = object2;
        Checks checks = this.context.getChecker();
        boolean bl = !primaryKey.getAutoGenerateId() || affinity == SQLTypeAffinity.INTEGER;
        Object object3 = (Field)CollectionsKt.firstOrNull((List)primaryKey.getFields());
        if (object3 == null || (object3 = ((Field)object3).getElement()) == null) {
            object3 = this.element;
        }
        checks.check(bl, (Element)object3, ProcessorErrors.INSTANCE.getAUTO_INCREMENTED_PRIMARY_KEY_IS_NOT_INT(), new Object[0]);
        List<ForeignKey> entityForeignKeys = this.validateAndCreateForeignKeyReferences(foreignKeyInputs, pojo);
        this.checkIndicesForForeignKeys(entityForeignKeys, primaryKey, indices);
        this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(tableName), this.element, ProcessorErrors.INSTANCE.getINVALID_TABLE_NAME(), new Object[0]);
        Iterable $receiver$iv2 = pojo.getFields();
        for (Object element$iv : $receiver$iv2) {
            Field it = (Field)element$iv;
            boolean bl2 = false;
            this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(it.getColumnName()), it.getElement(), ProcessorErrors.INSTANCE.getINVALID_COLUMN_NAME(), new Object[0]);
        }
        Iterator iterator = null;
        Constructor constructor = pojo.getConstructor();
        object = entityForeignKeys;
        androidx.room.vo.PrimaryKey primaryKey2 = primaryKey;
        List<Index> list = indices;
        androidx.room.vo.Entity entity = new androidx.room.vo.Entity(this.element, tableName, pojo.getType(), pojo.getFields(), pojo.getEmbeddedFields(), primaryKey2, list, (List<ForeignKey>)object, constructor, (String)((Object)iterator));
        return entity;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkIndicesForForeignKeys(List<ForeignKey> entityForeignKeys, androidx.room.vo.PrimaryKey primaryKey, List<Index> indices) {
        covers$ = checkIndicesForForeignKeys.1.INSTANCE;
        $receiver$iv = entityForeignKeys;
        for (T element$iv : $receiver$iv) {
            block8: {
                fKey = (ForeignKey)element$iv;
                $i$a$-forEach-TableEntityProcessor$checkIndicesForForeignKeys$2 = false;
                var11_12 = $receiver$iv = (Iterable)fKey.getChildFields();
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var15_16 = (Field)item$iv$iv;
                    var16_18 = destination$iv$iv;
                    $i$a$-map-TableEntityProcessor$checkIndicesForForeignKeys$2$columnNames$1 = false;
                    var18_20 = it.getColumnName();
                    var16_18.add(var18_20);
                }
                columnNames = (List)destination$iv$iv;
                if (checkIndicesForForeignKeys.1.INSTANCE.invoke(columnNames, primaryKey.getFields())) ** GOTO lbl-1000
                $receiver$iv = indices;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $receiver$iv) {
                        index = (Index)element$iv;
                        $i$a$-any-TableEntityProcessor$checkIndicesForForeignKeys$2$exists$1 = false;
                        if (!checkIndicesForForeignKeys.1.INSTANCE.invoke(columnNames, index.getFields())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (exists = v1) continue;
            if (columnNames.size() == 1) {
                this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumn((String)columnNames.get(0)), new Object[0]);
                continue;
            }
            this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumns(columnNames), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForeignKey> validateAndCreateForeignKeyReferences(List<ForeignKeyInput> foreignKeyInputs, Pojo pojo) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)foreignKeyInputs;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ForeignKey foreignKey;
            Collection collection;
            block20: {
                void it;
                ForeignKeyInput foreignKeyInput = (ForeignKeyInput)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (it.getOnUpdate() == null) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                    foreignKey = null;
                } else if (it.getOnDelete() == null) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                    foreignKey = null;
                } else if (it.getChildColumns().isEmpty()) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_CHILD_COLUMN_LIST(), new Object[0]);
                    foreignKey = null;
                } else if (it.getParentColumns().isEmpty()) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_PARENT_COLUMN_LIST(), new Object[0]);
                    foreignKey = null;
                } else if (it.getChildColumns().size() != it.getParentColumns().size()) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.foreignKeyColumnNumberMismatch(it.getChildColumns(), it.getParentColumns()), new Object[0]);
                    foreignKey = null;
                } else {
                    TypeElement typeElement;
                    try {
                        Element element = MoreTypes.asElement((TypeMirror)it.getParent());
                        if (element == null) {
                            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                        }
                        typeElement = (TypeElement)element;
                    }
                    catch (IllegalArgumentException noClass) {
                        this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_CANNOT_FIND_PARENT(), new Object[0]);
                        foreignKey = null;
                        break block20;
                    }
                    TypeElement parentElement = typeElement;
                    AnnotationBox parentAnnotation = Element_extKt.toAnnotationBox(parentElement, Reflection.getOrCreateKotlinClass(Entity.class));
                    if (parentAnnotation == null) {
                        this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.foreignKeyNotAnEntity(parentElement.toString()), new Object[0]);
                        foreignKey = null;
                    } else {
                        void $receiver$iv$iv2;
                        Iterable $receiver$iv2;
                        String tableName = EntityProcessor.Companion.extractTableName(parentElement, (Entity)parentAnnotation.getValue());
                        Object object = $receiver$iv2 = (Iterable)it.getChildColumns();
                        Collection destination$iv$iv2 = new ArrayList();
                        void $receiver$iv$iv$iv = $receiver$iv$iv2;
                        Object object2 = $receiver$iv$iv$iv.iterator();
                        while (object2.hasNext()) {
                            Field field;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = object2.next();
                            String columnName = (String)element$iv$iv;
                            boolean bl2 = false;
                            Field field2 = HasFieldsKt.findFieldByColumnName(pojo, columnName);
                            if (field2 == null) {
                                this.context.getLogger().e(pojo.getElement(), ProcessorErrors.INSTANCE.foreignKeyChildColumnDoesNotExist(columnName, HasFieldsKt.getColumnNames(pojo)), new Object[0]);
                            }
                            if (field2 == null) continue;
                            Field it$iv$iv = field;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List fields = (List)destination$iv$iv2;
                        if (fields.size() != it.getChildColumns().size()) {
                            foreignKey = null;
                        } else {
                            boolean bl3 = it.getDeferred();
                            object = it.getOnUpdate();
                            ForeignKeyAction foreignKeyAction = it.getOnDelete();
                            List<String> list = it.getParentColumns();
                            object2 = fields;
                            ForeignKey foreignKey2 = new ForeignKey(tableName, list, (List<Field>)object2, foreignKeyAction, (ForeignKeyAction)((Object)object), bl3);
                            foreignKey = foreignKey2;
                        }
                    }
                }
            }
            ForeignKey foreignKey3 = foreignKey;
            collection.add(foreignKey3);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey findAndValidatePrimaryKey(List<Field> fields, List<EmbeddedField> embeddedFields) {
        androidx.room.vo.PrimaryKey candidate;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        List candidates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.collectPrimaryKeysFromEntityAnnotations(this.element, fields), (Iterable)this.collectPrimaryKeysFromPrimaryKeyAnnotations(fields)), (Iterable)this.collectPrimaryKeysFromEmbeddedFields(embeddedFields));
        Collection collection = candidates;
        Object object = this.context.getChecker();
        boolean bl = !collection.isEmpty();
        ((Checks)object).check(bl, this.element, ProcessorErrors.INSTANCE.getMISSING_PRIMARY_KEY(), new Object[0]);
        Iterable iterable = $receiver$iv = (Iterable)candidates;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            candidate = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl2 = false;
            if (!(!candidate.getAutoGenerateId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            candidate = (androidx.room.vo.PrimaryKey)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            Iterable $i$f$filter = $receiver$iv2 = (Iterable)candidate.getFields();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void field;
                Field field2 = (Field)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                if (candidate.getFields().size() > 1 || candidate.getFields().size() == 1 && field.getAffinity() != SQLTypeAffinity.INTEGER) {
                    this.context.getChecker().check(field.getNonNull(), field.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(field.getPath()), new Object[0]);
                    EmbeddedField parent = field.getParent();
                    while (parent != null) {
                        Field parentField = parent.getField();
                        this.context.getChecker().check(parentField.getNonNull(), parentField.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(parentField.getPath()), new Object[0]);
                        parent = parentField.getParent();
                    }
                }
                Unit unit = Unit.INSTANCE;
                collection2.add(unit);
            }
            List list = (List)destination$iv$iv2;
            object.add(list);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        if (candidates.size() == 1) {
            return (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)candidates);
        }
        return this.choosePrimaryKey(candidates, this.element);
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromPrimaryKeyAnnotations(List<Field> fields) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)fields;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey;
            androidx.room.vo.PrimaryKey primaryKey2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            Field field = (Field)element$iv$iv;
            boolean bl = false;
            if (Element_extKt.toAnnotationBox(field.getElement(), Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                AnnotationBox annotationBox;
                AnnotationBox it = annotationBox;
                boolean bl2 = false;
                if (field.getParent() != null) {
                    Element grandParentField = field.getParent().getMRootParent().getField().getElement();
                    this.context.fork(grandParentField).getLogger().w(Warning.PRIMARY_KEY_FROM_EMBEDDED_IS_DROPPED, grandParentField, ProcessorErrors.INSTANCE.embeddedPrimaryKeyIsDropped(this.element.getQualifiedName().toString(), field.getName()), new Object[0]);
                    primaryKey2 = null;
                } else {
                    primaryKey2 = new androidx.room.vo.PrimaryKey(field.getElement().getEnclosingElement(), new Fields(field), ((PrimaryKey)it.getValue()).autoGenerate());
                }
            } else {
                primaryKey2 = null;
            }
            if (primaryKey2 == null) continue;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey = primaryKey2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEntityAnnotations(TypeElement typeElement, List<Field> availableFields) {
        List<androidx.room.vo.PrimaryKey> list;
        Iterable fields;
        AnnotationBox annotationBox;
        block14: {
            block13: {
                List list2;
                AnnotationBox annotationBox2;
                annotationBox = Element_extKt.toAnnotationBox(typeElement, Reflection.getOrCreateKotlinClass(Entity.class));
                if (annotationBox == null) break block13;
                AnnotationBox it = annotationBox2 = annotationBox;
                boolean bl = false;
                String[] primaryKeyColumns = ((Entity)it.getValue()).primaryKeys();
                String[] stringArray = primaryKeyColumns;
                if (stringArray.length == 0) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    void $receiver$iv$iv;
                    void $receiver$iv$iv$iv;
                    String[] $receiver$iv = primaryKeyColumns;
                    String[] stringArray2 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList();
                    void var13_13 = $receiver$iv$iv$iv = $receiver$iv$iv;
                    int n = ((void)var13_13).length;
                    for (int i = 0; i < n; ++i) {
                        Field field;
                        Collection<String> collection;
                        void $receiver$iv$iv2;
                        Object v2;
                        Iterable $receiver$iv2;
                        void pKeyColumnName;
                        block12: {
                            void element$iv$iv$iv;
                            void element$iv$iv;
                            pKeyColumnName = element$iv$iv = (element$iv$iv$iv = var13_13[i]);
                            boolean bl2 = false;
                            $receiver$iv2 = availableFields;
                            for (Object element$iv : $receiver$iv2) {
                                Field it2 = (Field)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it2.getColumnName(), (Object)pKeyColumnName)) continue;
                                v2 = element$iv;
                                break block12;
                            }
                            v2 = null;
                        }
                        Field field2 = v2;
                        $receiver$iv2 = availableFields;
                        void var26_28 = pKeyColumnName;
                        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                        Element element = typeElement;
                        boolean bl4 = field2 != null;
                        Checks checks = this.context.getChecker();
                        Iterable iterable = $receiver$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv2) {
                            void it3;
                            Field $i$f$firstOrNull = (Field)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl5 = false;
                            String string = it3.getColumnName();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv2;
                        checks.check(bl4, element, processorErrors.primaryKeyColumnDoesNotExist((String)var26_28, (List<String>)collection), new Object[0]);
                        if (field2 == null) continue;
                        Field it$iv$iv = field;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    fields = (List)destination$iv$iv;
                    list2 = CollectionsKt.listOf((Object)new androidx.room.vo.PrimaryKey(typeElement, new Fields((List<Field>)fields), false));
                }
                annotationBox = list2;
                if (list2 != null) break block14;
            }
            annotationBox = CollectionsKt.emptyList();
        }
        AnnotationBox myPkeys = annotationBox;
        TypeMirror mySuper = typeElement.getSuperclass();
        if (mySuper != null && mySuper.getKind() != TypeKind.NONE) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            fields = $receiver$iv = (Iterable)availableFields;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getElement().getEnclosingElement(), (Object)typeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingFields = (List)destination$iv$iv;
            list = this.collectPrimaryKeysFromEntityAnnotations(Type_mirror_extKt.asTypeElement(mySuper), remainingFields);
        } else {
            list = CollectionsKt.emptyList();
        }
        List<androidx.room.vo.PrimaryKey> superPKeys = list;
        return CollectionsKt.plus((Collection)superPKeys, (Iterable)((Iterable)((Object)myPkeys)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEmbeddedFields(List<EmbeddedField> embeddedFields) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)embeddedFields;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey;
            androidx.room.vo.PrimaryKey primaryKey2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            EmbeddedField embeddedField = (EmbeddedField)element$iv$iv;
            boolean bl = false;
            if (Element_extKt.toAnnotationBox(embeddedField.getField().getElement(), Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                AnnotationBox annotationBox;
                AnnotationBox it = annotationBox;
                boolean bl2 = false;
                this.context.getChecker().check(!((PrimaryKey)it.getValue()).autoGenerate() || embeddedField.getPojo().getFields().size() == 1, embeddedField.getField().getElement(), ProcessorErrors.INSTANCE.getAUTO_INCREMENT_EMBEDDED_HAS_MULTIPLE_FIELDS(), new Object[0]);
                primaryKey2 = new androidx.room.vo.PrimaryKey(embeddedField.getField().getElement().getEnclosingElement(), embeddedField.getPojo().getFields(), ((PrimaryKey)it.getValue()).autoGenerate());
            } else {
                primaryKey2 = null;
            }
            if (primaryKey2 == null) continue;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey = primaryKey2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey choosePrimaryKey(List<androidx.room.vo.PrimaryKey> candidates, TypeElement typeElement) {
        Object mySuper;
        androidx.room.vo.PrimaryKey primaryKey;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)candidates;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            androidx.room.vo.PrimaryKey candidate = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)candidate.getDeclaredIn(), (Object)typeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List myPKeys = (List)destination$iv$iv;
        if (myPKeys.size() == 1) {
            $receiver$iv = CollectionsKt.minus((Iterable)candidates, (Iterable)myPKeys);
            for (Object element$iv : $receiver$iv) {
                androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv;
                boolean bl = false;
                this.context.getLogger().d(this.element, it.toHumanReadableString() + " is" + " overridden by " + ((androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys)).toHumanReadableString(), new Object[0]);
            }
            primaryKey = (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys);
        } else if (myPKeys.isEmpty()) {
            mySuper = typeElement.getSuperclass();
            if (mySuper != null && mySuper.getKind() != TypeKind.NONE) {
                return this.choosePrimaryKey(candidates, Type_mirror_extKt.asTypeElement((TypeMirror)mySuper));
            }
            primaryKey = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        } else {
            Collection<String> collection;
            mySuper = myPKeys;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            Element element = this.element;
            RLog rLog = this.context.getLogger();
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p1;
                Object item$iv$iv = iterator.next();
                androidx.room.vo.PrimaryKey $i$f$forEach = (androidx.room.vo.PrimaryKey)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = p1.toHumanReadableString();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            rLog.e(element, processorErrors.multiplePrimaryKeyAnnotations((List<String>)collection), new Object[0]);
            primaryKey = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        }
        return primaryKey;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> validateAndCreateIndices(List<IndexInput> inputs, Pojo pojo) {
        Object element$iv$iv;
        Object object;
        Object $receiver$iv$iv;
        Object $receiver$iv = inputs;
        Iterator iterator = $receiver$iv;
        Iterator<Map.Entry<String, ArrayList<Index>>> destination$iv$iv = new ArrayList();
        Object $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Index index;
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
            IndexInput input = (IndexInput)element$iv$iv2;
            boolean bl = false;
            Collection collection = input.getColumnNames();
            object = this.context.getChecker();
            boolean bl2 = !collection.isEmpty();
            ((Checks)object).check(bl2, this.element, ProcessorErrors.INSTANCE.getINDEX_COLUMNS_CANNOT_BE_EMPTY(), new Object[0]);
            Iterable iterable = $receiver$iv2 = (Iterable)input.getColumnNames();
            Collection destination$iv$iv2 = new ArrayList();
            void $receiver$iv$iv$iv2 = $receiver$iv$iv2;
            Iterator iterator3 = $receiver$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                Field field;
                Object element$iv$iv$iv2;
                Object element$iv$iv3 = element$iv$iv$iv2 = iterator3.next();
                String columnName = (String)element$iv$iv3;
                boolean bl3 = false;
                Field field2 = HasFieldsKt.findFieldByColumnName(pojo, columnName);
                this.context.getChecker().check(field2 != null, this.element, ProcessorErrors.INSTANCE.indexColumnDoesNotExist(columnName, HasFieldsKt.getColumnNames(pojo)), new Object[0]);
                if (field2 == null) continue;
                Field it$iv$iv = field;
                destination$iv$iv2.add(it$iv$iv);
            }
            List fields = (List)destination$iv$iv2;
            Index index2 = fields.isEmpty() ? null : new Index(input.getName(), input.getUnique(), fields);
            if (index2 == null) continue;
            Index it$iv$iv = index = index2;
            destination$iv$iv.add((Map.Entry<String, ArrayList<Index>>)((Object)it$iv$iv));
        }
        List indices = (List)((Object)destination$iv$iv);
        $receiver$iv = indices;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        $receiver$iv$iv$iv = $receiver$iv$iv.iterator();
        while ($receiver$iv$iv$iv.hasNext()) {
            Object object2;
            element$iv$iv = $receiver$iv$iv$iv.next();
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, ArrayList<Index>>> $receiver$iv$iv$iv3 = destination$iv$iv;
            String key$iv$iv = it.getName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv3.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv3.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        $receiver$iv$iv$iv = $receiver$iv$iv;
        element$iv$iv = $receiver$iv$iv$iv.entrySet().iterator();
        while (element$iv$iv.hasNext()) {
            Map.Entry element$iv$iv4;
            Map.Entry it = element$iv$iv4 = (Map.Entry)element$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv4.getKey(), element$iv$iv4.getValue());
        }
        $receiver$iv = destination$iv$iv;
        iterator = $receiver$iv;
        destination$iv$iv = iterator.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = destination$iv$iv.next();
            boolean bl = false;
            this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.duplicateIndexInEntity((String)it.getKey()), new Object[0]);
        }
        $receiver$iv = pojo.getEmbeddedFields();
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationBox<Entity> annotationBox;
            Object element$iv = iterator.next();
            EmbeddedField embedded = (EmbeddedField)element$iv;
            boolean bl = false;
            TypeElement embeddedElement = embedded.getPojo().getElement();
            if (Element_extKt.toAnnotationBox(embeddedElement, Reflection.getOrCreateKotlinClass(Entity.class)) == null) continue;
            AnnotationBox<Entity> it = annotationBox;
            boolean bl4 = false;
            List<IndexInput> subIndices = EntityProcessor.Companion.extractIndices(it, "");
            object = subIndices;
            if (!(!object.isEmpty())) continue;
            RLog rLog = this.context.getLogger();
            Element element = embedded.getField().getElement();
            String string = embedded.getPojo().getTypeName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"embedded.pojo.typeName.toString()");
            rLog.w(Warning.INDEX_FROM_EMBEDDED_ENTITY_IS_DROPPED, element, ProcessorErrors.INSTANCE.droppedEmbeddedIndex(string, embedded.getField().getPath(), this.element.getQualifiedName().toString()), new Object[0]);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexInput> loadSuperIndices(TypeMirror typeMirror2, String tableName, boolean inherit) {
        AnnotationBox<Entity> annotationBox;
        TypeElement parentElement;
        block10: {
            block9: {
                List list;
                AnnotationBox<Entity> annotationBox2;
                if (typeMirror2 == null || typeMirror2.getKind() == TypeKind.NONE) {
                    return CollectionsKt.emptyList();
                }
                parentElement = Type_mirror_extKt.asTypeElement(typeMirror2);
                annotationBox = Element_extKt.toAnnotationBox(parentElement, Reflection.getOrCreateKotlinClass(Entity.class));
                if (annotationBox == null) break block9;
                AnnotationBox<Entity> annotation = annotationBox2 = annotationBox;
                boolean bl = false;
                List<IndexInput> indices = EntityProcessor.Companion.extractIndices(annotation, "super");
                if (indices.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else if (inherit) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)indices;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        IndexInput indexInput = (IndexInput)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        IndexInput indexInput2 = new IndexInput(EntityProcessor.Companion.createIndexName(it.getColumnNames(), tableName), it.getUnique(), it.getColumnNames());
                        collection.add(indexInput2);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    this.context.getLogger().w(Warning.INDEX_FROM_PARENT_IS_DROPPED, parentElement, ProcessorErrors.INSTANCE.droppedSuperClassIndex(this.element.getQualifiedName().toString(), parentElement.getQualifiedName().toString()), new Object[0]);
                    list = CollectionsKt.emptyList();
                }
                annotationBox = list;
                if (list != null) break block10;
            }
            annotationBox = CollectionsKt.emptyList();
        }
        AnnotationBox<Entity> myIndices = annotationBox;
        return CollectionsKt.plus((Collection)((Collection)((Object)myIndices)), (Iterable)this.loadSuperIndices(parentElement.getSuperclass(), tableName, inherit));
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public TableEntityProcessor(@NotNull Context baseContext, @NotNull TypeElement element, @NotNull LinkedHashSet<Name> referenceStack) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = baseContext.fork(this.element);
    }

    public /* synthetic */ TableEntityProcessor(Context context, TypeElement typeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<Name>();
        }
        this(context, typeElement, linkedHashSet);
    }

    public static final /* synthetic */ androidx.room.vo.Entity access$doProcess(TableEntityProcessor $this) {
        return $this.doProcess();
    }
}

