/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.ShortcutParameterProcessor;
import androidx.room.solver.shortcut.binder.DeleteOrUpdateMethodBinder;
import androidx.room.solver.shortcut.binder.InsertMethodBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.ShortcutQueryParameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J,\u0010\u001a\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001b2\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"J\u001c\u0010&\u001a\u00020'2\u0006\u0010%\u001a\u00020\"2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Landroidx/room/processor/ShortcutMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "executableElement", "Ljavax/lang/model/element/ExecutableElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/ExecutableElement;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "delegate", "Landroidx/room/processor/MethodProcessorDelegate;", "getExecutableElement", "()Ljavax/lang/model/element/ExecutableElement;", "extractAnnotation", "T", "", "klass", "Lkotlin/reflect/KClass;", "errorMsg", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;)Ljava/lang/annotation/Annotation;", "extractParams", "Lkotlin/Pair;", "", "Landroidx/room/vo/Entity;", "", "Landroidx/room/vo/ShortcutQueryParameter;", "missingParamError", "extractReturnType", "Ljavax/lang/model/type/TypeMirror;", "findDeleteOrUpdateMethodBinder", "Landroidx/room/solver/shortcut/binder/DeleteOrUpdateMethodBinder;", "returnType", "findInsertMethodBinder", "Landroidx/room/solver/shortcut/binder/InsertMethodBinder;", "params", "room-compiler"})
public final class ShortcutMethodProcessor {
    @NotNull
    private final Context context;
    private final MethodProcessorDelegate delegate;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final ExecutableElement executableElement;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final <T extends Annotation> T extractAnnotation(@NotNull KClass<T> klass, @NotNull String errorMsg) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
        AnnotationBox<T> annotation = Element_extKt.toAnnotationBox(this.executableElement, klass);
        this.context.getChecker().check(annotation != null, this.executableElement, errorMsg, new Object[0]);
        AnnotationBox<T> annotationBox = annotation;
        return (T)(annotationBox != null ? annotationBox.getValue() : null);
    }

    @NotNull
    public final TypeMirror extractReturnType() {
        return this.delegate.extractReturnType();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Map<String, Entity>, List<ShortcutQueryParameter>> extractParams(@NotNull String missingParamError) {
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)missingParamError, (String)"missingParamError");
        Iterable $this$map$iv = this.delegate.extractParams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VariableElement variableElement = (VariableElement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            ShortcutQueryParameter shortcutQueryParameter = new ShortcutParameterProcessor(this.context, this.containing, (VariableElement)it).process();
            object.add(shortcutQueryParameter);
        }
        List params = (List)destination$iv$iv;
        $this$map$iv = params;
        object = this.context.getChecker();
        $i$f$map = false;
        boolean bl = !$this$map$iv.isEmpty();
        ((Checks)object).check(bl, this.executableElement, missingParamError, new Object[0]);
        Iterable $this$filter$iv = params;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getEntityType() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ShortcutQueryParameter it;
            ShortcutQueryParameter bl2 = (ShortcutQueryParameter)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            String string = it.getName();
            it = (ShortcutQueryParameter)element$iv$iv;
            boolean bl4 = false;
            TypeMirror typeMirror2 = it.getEntityType();
            if (typeMirror2 == null) {
                Intrinsics.throwNpe();
            }
            Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, Type_mirror_extKt.asTypeElement(typeMirror2), null, 4, null).process();
            object.put(string, entity);
        }
        Map entities = destination$iv$iv3;
        return new Pair((Object)entities, (Object)params);
    }

    @NotNull
    public final InsertMethodBinder findInsertMethodBinder(@NotNull TypeMirror returnType, @NotNull List<ShortcutQueryParameter> params) {
        Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        return this.delegate.findInsertMethodBinder(returnType, params);
    }

    @NotNull
    public final DeleteOrUpdateMethodBinder findDeleteOrUpdateMethodBinder(@NotNull TypeMirror returnType) {
        Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
        return this.delegate.findDeleteOrUpdateMethodBinder(returnType);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public ShortcutMethodProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull ExecutableElement executableElement) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = baseContext.fork(this.executableElement);
        this.delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
    }
}

