/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.ext.AndroidTypeNames;
import androidx.room.ext.CommonTypeNames;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.writer.ClassWriter;
import androidx.room.writer.DatabaseWriter;
import androidx.room.writer.EntityDeleteComparator;
import androidx.room.writer.SQLiteOpenHelperWriter;
import com.google.auto.common.MoreElements;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Landroidx/room/writer/DatabaseWriter;", "Landroidx/room/writer/ClassWriter;", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "addDaoImpls", "", "builder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "createClearAllTables", "Lcom/squareup/javapoet/MethodSpec;", "createCreateInvalidationTracker", "createCreateOpenHelper", "createDaoGetter", "field", "Lcom/squareup/javapoet/FieldSpec;", "method", "Landroidx/room/vo/DaoMethod;", "createTypeSpecBuilder", "room-compiler"})
public final class DatabaseWriter
extends ClassWriter {
    @NotNull
    private final Database database;

    @Override
    @NotNull
    public TypeSpec.Builder createTypeSpecBuilder() {
        TypeSpec.Builder builder;
        TypeSpec.Builder builder2 = builder = TypeSpec.classBuilder((ClassName)this.database.getImplTypeName());
        boolean bl = false;
        boolean bl2 = false;
        TypeSpec.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.addOriginatingElement((Element)this.database.getElement());
        $this$apply.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply.addModifiers(new Modifier[]{Modifier.FINAL});
        $this$apply.superclass((TypeName)this.database.getTypeName());
        $this$apply.addMethod(this.createCreateOpenHelper());
        $this$apply.addMethod(this.createCreateInvalidationTracker());
        $this$apply.addMethod(this.createClearAllTables());
        TypeSpec.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"builder");
        this.addDaoImpls(builder3);
        return builder;
    }

    private final MethodSpec createClearAllTables() {
        MethodSpec.Builder $this$apply;
        boolean bl;
        boolean bl2;
        MethodSpec.Builder builder;
        CodeGenScope scope = new CodeGenScope(this);
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"clearAllTables");
        boolean bl3 = false;
        boolean bl4 = false;
        MethodSpec.Builder $this$apply2 = builder2;
        boolean bl5 = false;
        $this$apply2.addStatement("super.assertNotMainThread()", new Object[0]);
        String dbVar = scope.getTmpVar("_db");
        $this$apply2.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = super.getOpenHelper().getWritableDatabase()", new Object[]{SupportDbTypeNames.INSTANCE.getDB(), dbVar});
        String deferVar = scope.getTmpVar("_supportsDeferForeignKeys");
        if (this.database.getEnableForeignKeys()) {
            $this$apply2.addStatement("boolean " + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getL() + ".VERSION.SDK_INT >= " + Javapoet_extKt.getL() + ".VERSION_CODES.LOLLIPOP", new Object[]{deferVar, AndroidTypeNames.INSTANCE.getBUILD(), AndroidTypeNames.INSTANCE.getBUILD()});
        }
        $this$apply2.addAnnotation(Override.class);
        $this$apply2.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $this$apply2.returns(TypeName.VOID);
        MethodSpec.Builder builder3 = $this$apply2.beginControlFlow("try", new Object[0]);
        boolean bl6 = false;
        boolean bl7 = false;
        MethodSpec.Builder $this$apply3 = builder3;
        boolean bl8 = false;
        if (this.database.getEnableForeignKeys()) {
            builder = $this$apply3.beginControlFlow("if (!" + Javapoet_extKt.getL() + ')', new Object[]{deferVar});
            bl2 = false;
            bl = false;
            $this$apply = builder;
            boolean bl9 = false;
            $this$apply.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "PRAGMA foreign_keys = FALSE"});
            $this$apply3.endControlFlow();
        }
        $this$apply3.addStatement("super.beginTransaction()", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            builder = $this$apply3.beginControlFlow("if (" + Javapoet_extKt.getL() + ')', new Object[]{deferVar});
            bl2 = false;
            bl = false;
            $this$apply = builder;
            boolean bl10 = false;
            $this$apply.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "PRAGMA defer_foreign_keys = TRUE"});
            $this$apply3.endControlFlow();
        }
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)this.database.getEntities(), (Comparator)new EntityDeleteComparator());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl11 = false;
            $this$apply3.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "DELETE FROM `" + it.getTableName() + '`'});
        }
        $this$apply3.addStatement("super.setTransactionSuccessful()", new Object[0]);
        builder3 = $this$apply2.nextControlFlow("finally", new Object[0]);
        bl6 = false;
        bl7 = false;
        $this$apply3 = builder3;
        boolean bl12 = false;
        $this$apply3.addStatement("super.endTransaction()", new Object[0]);
        if (this.database.getEnableForeignKeys()) {
            builder = $this$apply3.beginControlFlow("if (!" + Javapoet_extKt.getL() + ')', new Object[]{deferVar});
            bl2 = false;
            boolean bl13 = false;
            $this$apply = builder;
            boolean bl14 = false;
            $this$apply.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "PRAGMA foreign_keys = TRUE"});
            $this$apply3.endControlFlow();
        }
        $this$apply3.addStatement(Javapoet_extKt.getL() + ".query(" + Javapoet_extKt.getS() + ").close()", new Object[]{dbVar, "PRAGMA wal_checkpoint(FULL)"});
        builder = $this$apply3.beginControlFlow("if (!" + Javapoet_extKt.getL() + ".inTransaction())", new Object[]{dbVar});
        bl2 = false;
        boolean bl15 = false;
        $this$apply = builder;
        boolean bl16 = false;
        $this$apply.addStatement(Javapoet_extKt.getL() + ".execSQL(" + Javapoet_extKt.getS() + ')', new Object[]{dbVar, "VACUUM"});
        $this$apply3.endControlFlow();
        $this$apply2.endControlFlow();
        MethodSpec methodSpec = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026lFlow()\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateInvalidationTracker() {
        Object object;
        Collection collection;
        Iterator $this$mapTo$iv$iv;
        Entity it;
        Iterable $this$filterTo$iv$iv;
        CodeGenScope scope = new CodeGenScope(this);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createInvalidationTracker");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addAnnotation(Override.class);
        $this$apply.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $this$apply.returns((TypeName)RoomTypeNames.INSTANCE.getINVALIDATION_TRACKER());
        String shadowTablesVar = "_shadowTablesMap";
        ParameterizedTypeName shadowTablesTypeName = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashMap.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING(), (TypeName)CommonTypeNames.INSTANCE.getSTRING()});
        String tableNames2 = CollectionsKt.joinToString$default((Iterable)this.database.getEntities(), (CharSequence)",", null, null, (int)0, null, (Function1)createCreateInvalidationTracker.1.tableNames.1.INSTANCE, (int)30, null);
        Iterable $this$filter$iv = this.database.getEntities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Entity)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getShadowTableName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (Entity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            object = TuplesKt.to((Object)it.getTableName(), (Object)it.getShadowTableName());
            collection.add(object);
        }
        List shadowTableNames = (List)destination$iv$iv;
        $this$apply.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{shadowTablesTypeName, shadowTablesVar, shadowTablesTypeName, shadowTableNames.size()});
        Iterable $this$forEach$iv = shadowTableNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$tableName$shadowTableName = (Pair)element$iv;
            boolean bl6 = false;
            String tableName = (String)$dstr$tableName$shadowTableName.component1();
            String shadowTableName = (String)$dstr$tableName$shadowTableName.component2();
            $this$apply.addStatement(Javapoet_extKt.getL() + ".put(" + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ')', new Object[]{shadowTablesVar, tableName, shadowTableName});
        }
        String viewTablesVar = scope.getTmpVar("_viewTables");
        ParameterizedTypeName tablesType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashSet.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING()});
        ParameterizedTypeName viewTablesType = ParameterizedTypeName.get((ClassName)Javapoet_extKt.typeName(Reflection.getOrCreateKotlinClass(HashMap.class)), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING(), (TypeName)ParameterizedTypeName.get((ClassName)CommonTypeNames.INSTANCE.getSET(), (TypeName[])new TypeName[]{(TypeName)CommonTypeNames.INSTANCE.getSTRING()})});
        $this$apply.addStatement(Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{viewTablesType, viewTablesVar, viewTablesType, this.database.getViews().size()});
        for (DatabaseView view : this.database.getViews()) {
            String string;
            String tablesVar = scope.getTmpVar("_tables");
            $this$apply.addStatement(Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getL() + ')', new Object[]{tablesType, tablesVar, tablesType, view.getTables().size()});
            for (String table : view.getTables()) {
                $this$apply.addStatement(Javapoet_extKt.getL() + ".add(" + Javapoet_extKt.getS() + ')', new Object[]{tablesVar, table});
            }
            String string2 = Javapoet_extKt.getL() + ".put(" + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getL() + ')';
            Object[] objectArray = new Object[3];
            objectArray[0] = viewTablesVar;
            String string3 = view.getViewName();
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            object = string2;
            collection = $this$apply;
            boolean bl7 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(locale2), (String)"(this as java.lang.String).toLowerCase(locale)");
            objectArray2[n] = string;
            objectArray3[2] = tablesVar;
            collection.addStatement((String)object, objectArray3);
        }
        $this$apply.addStatement("return new " + Javapoet_extKt.getT() + "(this, " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ')', new Object[]{RoomTypeNames.INSTANCE.getINVALIDATION_TRACKER(), shadowTablesVar, viewTablesVar, tableNames2});
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026eNames)\n        }.build()");
        return methodSpec;
    }

    private final void addDaoImpls(TypeSpec.Builder builder) {
        CodeGenScope scope = new CodeGenScope(this);
        TypeSpec.Builder builder2 = builder;
        boolean bl = false;
        boolean bl2 = false;
        TypeSpec.Builder $this$apply = builder2;
        boolean bl3 = false;
        Iterable $this$forEach$iv = this.database.getDaoMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DaoMethod method = (DaoMethod)element$iv;
            boolean bl4 = false;
            String string = method.getDao().getTypeName().simpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.dao.typeName.simpleName()");
            String name = String_extKt.stripNonJava(StringsKt.decapitalize((String)string));
            String fieldName = scope.getTmpVar('_' + name);
            FieldSpec field = FieldSpec.builder((TypeName)((TypeName)method.getDao().getTypeName()), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).build();
            $this$apply.addField(field);
            FieldSpec fieldSpec = field;
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldSpec, (String)"field");
            $this$apply.addMethod(this.createDaoGetter(fieldSpec, method));
        }
    }

    private final MethodSpec createDaoGetter(FieldSpec field, DaoMethod method) {
        MethodSpec.Builder builder = MethodSpec.overriding((ExecutableElement)MoreElements.asExecutable((Element)method.getElement()));
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        MethodSpec.Builder builder2 = $this$apply.beginControlFlow("if (" + Javapoet_extKt.getN() + " != null)", new Object[]{field});
        boolean bl4 = false;
        boolean bl5 = false;
        MethodSpec.Builder $this$apply2 = builder2;
        boolean bl6 = false;
        $this$apply2.addStatement("return " + Javapoet_extKt.getN(), new Object[]{field});
        builder2 = $this$apply.nextControlFlow("else", new Object[0]);
        bl4 = false;
        bl5 = false;
        $this$apply2 = builder2;
        boolean bl7 = false;
        MethodSpec.Builder builder3 = $this$apply2.beginControlFlow("synchronized(this)", new Object[0]);
        boolean bl8 = false;
        boolean bl9 = false;
        MethodSpec.Builder $this$apply3 = builder3;
        boolean bl10 = false;
        MethodSpec.Builder builder4 = $this$apply3.beginControlFlow("if(" + Javapoet_extKt.getN() + " == null)", new Object[]{field});
        boolean bl11 = false;
        boolean bl12 = false;
        MethodSpec.Builder $this$apply4 = builder4;
        boolean bl13 = false;
        $this$apply4.addStatement(Javapoet_extKt.getN() + " = new " + Javapoet_extKt.getT() + "(this)", new Object[]{field, method.getDao().getImplTypeName()});
        $this$apply3.endControlFlow();
        $this$apply3.addStatement("return " + Javapoet_extKt.getN(), new Object[]{field});
        $this$apply2.endControlFlow();
        $this$apply.endControlFlow();
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.overriding(Mo\u2026lFlow()\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateOpenHelper() {
        CodeGenScope scope = new CodeGenScope(this);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createOpenHelper");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addModifiers(new Modifier[]{Modifier.PROTECTED});
        $this$apply.addAnnotation(Override.class);
        $this$apply.returns((TypeName)SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER());
        ParameterSpec configParam = ParameterSpec.builder((TypeName)((TypeName)RoomTypeNames.INSTANCE.getROOM_DB_CONFIG()), (String)"configuration", (Modifier[])new Modifier[0]).build();
        $this$apply.addParameter(configParam);
        String openHelperVar = scope.getTmpVar("_helper");
        CodeGenScope openHelperCode = scope.fork();
        SQLiteOpenHelperWriter sQLiteOpenHelperWriter = new SQLiteOpenHelperWriter(this.database);
        ParameterSpec parameterSpec = configParam;
        Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"configParam");
        sQLiteOpenHelperWriter.write(openHelperVar, parameterSpec, openHelperCode);
        $this$apply.addCode(openHelperCode.builder().build());
        $this$apply.addStatement("return " + Javapoet_extKt.getL(), new Object[]{openHelperVar});
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026perVar)\n        }.build()");
        return methodSpec;
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public DatabaseWriter(@NotNull Database database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super(database.getImplTypeName());
        this.database = database;
    }
}

