/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.TypeAdapterStore;
import androidx.room.solver.query.parameter.QueryParameterAdapter;
import androidx.room.vo.QueryParameter;
import com.google.auto.common.MoreTypes;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/room/processor/QueryParameterProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "element", "Ljavax/lang/model/element/VariableElement;", "sqlName", "", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/VariableElement;Ljava/lang/String;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/VariableElement;", "process", "Landroidx/room/vo/QueryParameter;", "room-compiler"})
public final class QueryParameterProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final VariableElement element;
    private final String sqlName;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final QueryParameter process() {
        TypeMirror asMember = MoreTypes.asMemberOf((Types)this.context.getProcessingEnv().getTypeUtils(), (DeclaredType)this.containing, (VariableElement)this.element);
        TypeAdapterStore typeAdapterStore2 = this.context.getTypeAdapterStore();
        TypeMirror typeMirror2 = asMember;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"asMember");
        QueryParameterAdapter parameterAdapter = typeAdapterStore2.findQueryParameterAdapter(typeMirror2);
        this.context.getChecker().check(parameterAdapter != null, this.element, ProcessorErrors.INSTANCE.getCANNOT_BIND_QUERY_PARAMETER_INTO_STMT(), new Object[0]);
        String name = this.element.getSimpleName().toString();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), this.element, ProcessorErrors.INSTANCE.getQUERY_PARAMETERS_CANNOT_START_WITH_UNDERSCORE(), new Object[0]);
        String string = this.sqlName;
        if (string == null) {
            string = name;
        }
        return new QueryParameter(name, string, asMember, parameterAdapter);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final VariableElement getElement() {
        return this.element;
    }

    public QueryParameterProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull VariableElement element, @Nullable String sqlName) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.containing = containing;
        this.element = element;
        this.sqlName = sqlName;
        this.context = Context.fork$default(baseContext, this.element, null, 2, null);
    }

    public /* synthetic */ QueryParameterProcessor(Context context, DeclaredType declaredType, VariableElement variableElement, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(context, declaredType, variableElement, string);
    }
}

