/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.verifier;

import androidx.room.processor.Context;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.FtsOptions;
import androidx.room.vo.Index;
import androidx.room.vo.Warning;
import java.io.Closeable;
import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConnection;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Landroidx/room/verifier/DatabaseVerifier;", "", "connection", "Ljava/sql/Connection;", "context", "Landroidx/room/processor/Context;", "entities", "", "Landroidx/room/vo/Entity;", "views", "Landroidx/room/vo/DatabaseView;", "(Ljava/sql/Connection;Landroidx/room/processor/Context;Ljava/util/List;Ljava/util/List;)V", "getConnection", "()Ljava/sql/Connection;", "getContext", "()Landroidx/room/processor/Context;", "getEntities", "()Ljava/util/List;", "analyze", "Landroidx/room/verifier/QueryResultInfo;", "sql", "", "closeConnection", "", "stripLocalizeCollations", "kotlin.jvm.PlatformType", "Companion", "room-compiler"})
public final class DatabaseVerifier {
    @NotNull
    private final Connection connection;
    @NotNull
    private final Context context;
    @NotNull
    private final List<Entity> entities;
    private static final String CONNECTION_URL = "jdbc:sqlite::memory:";
    private static final int NATIVE_LIB_RELOAD_RETRY_CNT = 5;
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN;
    private static final String[] SQLITE_NATIVE_LIB_EXTENSIONS;
    private static final File sqliteNativeLibDir;
    public static final Companion Companion;

    @NotNull
    public final QueryResultInfo analyze(@NotNull String sql) {
        QueryResultInfo queryResultInfo;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.connection.prepareStatement(this.stripLocalizeCollations(sql));
            Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"stmt");
            queryResultInfo = new QueryResultInfo(Jdbc_extKt.columnInfo(preparedStatement), null, 2, null);
        }
        catch (SQLException ex) {
            queryResultInfo = new QueryResultInfo(CollectionsKt.emptyList(), ex);
        }
        return queryResultInfo;
    }

    private final String stripLocalizeCollations(String sql) {
        return COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql).replaceAll(" COLLATE NOCASE");
    }

    public final void closeConnection(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (Throwable t) {
                context.getLogger().d("failed to close the database connection " + t.getMessage(), new Object[0]);
            }
        }
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<Entity> getEntities() {
        return this.entities;
    }

    private DatabaseVerifier(Connection connection, Context context, List<? extends Entity> entities, List<DatabaseView> views) {
        Statement stmt;
        this.connection = connection;
        this.context = context;
        this.entities = entities;
        Iterable $this$forEach$iv = this.entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            stmt = this.connection.createStatement();
            String createTableQuery2 = entity instanceof FtsEntity && !FtsOptions.Companion.getDefaultTokenizers().contains(((FtsEntity)entity).getFtsOptions().getTokenizer()) ? ((FtsEntity)entity).getCreateTableQueryWithoutTokenizer() : entity.getCreateTableQuery();
            try {
                stmt.executeUpdate(this.stripLocalizeCollations(createTableQuery2));
            }
            catch (SQLException e) {
                this.context.getLogger().e(entity.getElement(), String.valueOf(e.getMessage()), new Object[0]);
            }
            Iterable $this$forEach$iv2 = entity.getIndices();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Index it = (Index)element$iv2;
                boolean bl2 = false;
                stmt.executeUpdate(it.createQuery(entity.getTableName()));
            }
        }
        $this$forEach$iv = views;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseView view = (DatabaseView)element$iv;
            boolean bl = false;
            stmt = this.connection.createStatement();
            try {
                stmt.executeUpdate(this.stripLocalizeCollations(view.getCreateViewQuery()));
            }
            catch (SQLException e) {
                this.context.getLogger().e(view.getElement(), String.valueOf(e.getMessage()), new Object[0]);
            }
        }
    }

    static {
        Companion = new Companion(null);
        NATIVE_LIB_RELOAD_RETRY_CNT = 5;
        COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
        SQLITE_NATIVE_LIB_EXTENSIONS = new String[]{".so", ".jnilib", ".dll"};
        String tmpDir = System.getProperty("java.io.tmpdir");
        boolean bl = false;
        boolean bl2 = false;
        if (tmpDir == null) {
            boolean bl3 = false;
            String string = "Room needs java.io.tmpdir system property to be set to setup sqlite";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        sqliteNativeLibDir = new File(tmpDir, "room-" + UUID.randomUUID());
        sqliteNativeLibDir.mkdirs();
        sqliteNativeLibDir.deleteOnExit();
        System.setProperty("org.sqlite.tmpdir", sqliteNativeLibDir.getAbsolutePath());
        JDBC.isValidURL((String)CONNECTION_URL);
    }

    public /* synthetic */ DatabaseVerifier(Connection connection, Context context, List entities, List views, DefaultConstructorMarker $constructor_marker) {
        this(connection, context, entities, views);
    }

    public static final /* synthetic */ String[] access$getSQLITE_NATIVE_LIB_EXTENSIONS$cp() {
        return SQLITE_NATIVE_LIB_EXTENSIONS;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/room/verifier/DatabaseVerifier$Companion;", "", "()V", "COLLATE_LOCALIZED_UNICODE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CONNECTION_URL", "", "NATIVE_LIB_RELOAD_RETRY_CNT", "", "SQLITE_NATIVE_LIB_EXTENSIONS", "", "[Ljava/lang/String;", "sqliteNativeLibDir", "Ljava/io/File;", "create", "Landroidx/room/verifier/DatabaseVerifier;", "context", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/Element;", "entities", "", "Landroidx/room/vo/Entity;", "views", "Landroidx/room/vo/DatabaseView;", "room-compiler"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final DatabaseVerifier create(@NotNull Context context, @NotNull Element element, @NotNull List<? extends Entity> entities, @NotNull List<DatabaseView> views) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
            Intrinsics.checkParameterIsNotNull(views, (String)"views");
            int n = NATIVE_LIB_RELOAD_RETRY_CNT;
            boolean bl = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int it = n2;
                boolean bl2 = false;
                try {
                    SQLiteConnection connection;
                    SQLiteConnection sQLiteConnection = connection = JDBC.createConnection((String)DatabaseVerifier.CONNECTION_URL, (Properties)new Properties());
                    Intrinsics.checkExpressionValueIsNotNull((Object)sQLiteConnection, (String)"connection");
                    return new DatabaseVerifier((Connection)sQLiteConnection, context, entities, views, null);
                }
                catch (UnsatisfiedLinkError unsatisfied) {
                    File[] fileArray;
                    Closeable closeable = FileChannel.open(sqliteNativeLibDir.toPath(), new OpenOption[0]);
                    boolean bl3 = false;
                    Throwable throwable = null;
                    try {
                        FileChannel it2 = (FileChannel)closeable;
                        boolean bl4 = false;
                        it2.force(true);
                        fileArray = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    File[] nativeLibs2 = sqliteNativeLibDir.listFiles(create.1.nativeLibs.1.INSTANCE);
                    Intrinsics.checkExpressionValueIsNotNull((Object)nativeLibs2, (String)"nativeLibs");
                    File[] fileArray2 = nativeLibs2;
                    boolean bl5 = false;
                    fileArray = fileArray2;
                    int n4 = 0;
                    if (!(fileArray.length == 0)) {
                        File[] $this$forEach$iv = nativeLibs2;
                        boolean $i$f$forEach = false;
                        fileArray = $this$forEach$iv;
                        n4 = fileArray.length;
                        for (int i = 0; i < n4; ++i) {
                            File element$iv;
                            File it3 = element$iv = fileArray[i];
                            boolean bl6 = false;
                            it3.setExecutable(true);
                            context.getLogger().d("reloading the sqlite native file: " + it3, new Object[0]);
                            File file = it3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                            File file2 = file.getAbsoluteFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.absoluteFile");
                            System.load(file2.getAbsolutePath());
                        }
                        continue;
                    }
                    context.getLogger().w(Warning.CANNOT_CREATE_VERIFICATION_DATABASE, element, DatabaseVerificationErrors.INSTANCE.cannotCreateConnection(unsatisfied), new Object[0]);
                    return null;
                }
                catch (Exception ex) {
                    context.getLogger().w(Warning.CANNOT_CREATE_VERIFICATION_DATABASE, element, DatabaseVerificationErrors.INSTANCE.cannotCreateConnection(ex), new Object[0]);
                    return null;
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

