/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.Database;
import androidx.room.processor.Context;
import androidx.room.processor.DatabaseProcessor;
import androidx.room.processor.MissingTypeException;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SimpleJavaVersion;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.Warning;
import androidx.room.writer.DaoWriter;
import androidx.room.writer.DatabaseWriter;
import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0014J\b\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/room/RoomProcessor;", "Lcom/google/auto/common/BasicAnnotationProcessor;", "()V", "jdkVersionHasBugReported", "", "getSupportedOptions", "", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "initSteps", "", "Lcom/google/auto/common/BasicAnnotationProcessor$ProcessingStep;", "methodParametersVisibleInClassFiles", "DatabaseProcessingStep", "room-compiler"})
public final class RoomProcessor
extends BasicAnnotationProcessor {
    private boolean jdkVersionHasBugReported;

    @Nullable
    protected Iterable<BasicAnnotationProcessor.ProcessingStep> initSteps() {
        Object[] objectArray = new DatabaseProcessingStep[1];
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        objectArray[0] = new DatabaseProcessingStep(processingEnvironment);
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public Set<String> getSupportedOptions() {
        Set supportedOptions = CollectionsKt.toMutableSet((Iterable)Context.Companion.getARG_OPTIONS());
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        if (Context.BooleanProcessorOptions.INCREMENTAL.getValue(processingEnvironment)) {
            if (this.methodParametersVisibleInClassFiles()) {
                supportedOptions.add("org.gradle.annotation.processing.isolating");
            } else if (!this.jdkVersionHasBugReported) {
                ProcessingEnvironment processingEnvironment2 = this.processingEnv;
                Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment2, (String)"processingEnv");
                new Context(processingEnvironment2).getLogger().w(Warning.JDK_VERSION_HAS_BUG, ProcessorErrors.INSTANCE.getJDK_VERSION_HAS_BUG(), new Object[0]);
                this.jdkVersionHasBugReported = true;
            }
        }
        return supportedOptions;
    }

    private final boolean methodParametersVisibleInClassFiles() {
        boolean bl;
        boolean isEmbeddedJdk;
        SimpleJavaVersion simpleJavaVersion = SimpleJavaVersion.Companion.getCurrentVersion();
        if (simpleJavaVersion == null) {
            return false;
        }
        SimpleJavaVersion currentJavaVersion = simpleJavaVersion;
        if (currentJavaVersion.compareTo(SimpleJavaVersion.Companion.getVERSION_11_0_0()) >= 0) {
            return true;
        }
        String string = System.getProperty("java.vendor");
        boolean bl2 = isEmbeddedJdk = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"JetBrains", (boolean)true) : false;
        if (isEmbeddedJdk && currentJavaVersion.compareTo(SimpleJavaVersion.Companion.getVERSION_1_8_0_202()) > 0) {
            bl = true;
        } else if (isEmbeddedJdk && Intrinsics.areEqual((Object)currentJavaVersion, (Object)SimpleJavaVersion.Companion.getVERSION_1_8_0_202())) {
            String string2 = System.getProperty("java.runtime.version");
            if (string2 != null) {
                String string3 = string2;
                boolean bl3 = false;
                boolean bl4 = false;
                String it = string3;
                boolean bl5 = false;
                bl = Intrinsics.areEqual((Object)it, (Object)"1.8.0_202-release-1483-b39-5396753") ^ true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latest()");
        return sourceVersion;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bH\u0016J$\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u001a\u0010\u0014\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00130\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Landroidx/room/RoomProcessor$DatabaseProcessingStep;", "Lcom/google/auto/common/BasicAnnotationProcessor$ProcessingStep;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "annotations", "", "Ljava/lang/Class;", "", "prepareDaosForWriting", "", "databases", "", "Landroidx/room/vo/Database;", "daoMethods", "Landroidx/room/vo/DaoMethod;", "process", "Ljavax/lang/model/element/Element;", "elementsByAnnotation", "Lcom/google/common/collect/SetMultimap;", "room-compiler"})
    public static final class DatabaseProcessingStep
    implements BasicAnnotationProcessor.ProcessingStep {
        @NotNull
        private final ProcessingEnvironment processingEnv;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Set<Element> process(@NotNull SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
            Map daoMethodsMap;
            Map map2;
            Object list$iv$iv;
            List databases;
            List list;
            Iterable<Object> destination$iv$iv;
            Intrinsics.checkParameterIsNotNull(elementsByAnnotation, (String)"elementsByAnnotation");
            Context context = new Context(this.processingEnv);
            boolean bl = false;
            Set rejectedElements = new LinkedHashSet();
            Set set = elementsByAnnotation.get(Database.class);
            if (set != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = set;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    androidx.room.vo.Database database;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Element it = (Element)element$iv$iv;
                    boolean bl3 = false;
                    try {
                        TypeElement typeElement = MoreElements.asType((Element)it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"MoreElements.asType(it)");
                        database = new DatabaseProcessor(context, typeElement).process();
                    }
                    catch (MissingTypeException ex) {
                        Element element = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                        rejectedElements.add(element);
                        database = null;
                    }
                    if (database == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it$iv$iv = object;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List list2 = databases = list;
            if (list2 != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv$iv;
                    boolean bl7 = false;
                    Iterable $this$map$iv = db.getDaoMethods();
                    boolean $i$f$map = false;
                    Iterable bl3 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DaoMethod daoMethod = (DaoMethod)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl8 = false;
                        Pair pair = TuplesKt.to((Object)it, (Object)db);
                        collection.add(pair);
                    }
                    list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            } else {
                map2 = null;
            }
            Map map3 = daoMethodsMap = map2;
            if (map3 != null) {
                Map $this$flatMap$iv = map3;
                boolean $i$f$flatMap = false;
                boolean bl9 = false;
                Map it = $this$flatMap$iv;
                boolean bl10 = false;
                this.prepareDaosForWriting(databases, CollectionsKt.toList((Iterable)it.keySet()));
                Map $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                list$iv$iv = $this$forEach$iv;
                boolean bl7 = false;
                Iterator iterator = list$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry $dstr$daoMethod$db = element$iv = iterator.next();
                    boolean bl11 = false;
                    Map.Entry entry = $dstr$daoMethod$db;
                    boolean bl12 = false;
                    DaoMethod daoMethod = (DaoMethod)entry.getKey();
                    entry = $dstr$daoMethod$db;
                    bl12 = false;
                    androidx.room.vo.Database db = (androidx.room.vo.Database)entry.getValue();
                    new DaoWriter(daoMethod.getDao(), db.getElement(), context.getProcessingEnv()).write(context.getProcessingEnv());
                }
            }
            List list3 = databases;
            if (list3 != null) {
                Iterable $this$forEach$iv = list3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String qName;
                    File dbSchemaFolder;
                    androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv;
                    boolean bl13 = false;
                    new DatabaseWriter(db).write(context.getProcessingEnv());
                    if (!db.getExportSchema()) continue;
                    File schemaOutFolder2 = context.getSchemaOutFolder();
                    if (schemaOutFolder2 == null) {
                        context.getLogger().w(Warning.MISSING_SCHEMA_LOCATION, db.getElement(), ProcessorErrors.INSTANCE.getMISSING_SCHEMA_EXPORT_DIRECTORY(), new Object[0]);
                        continue;
                    }
                    if (!schemaOutFolder2.exists()) {
                        schemaOutFolder2.mkdirs();
                    }
                    if (!(dbSchemaFolder = new File(schemaOutFolder2, qName = db.getElement().getQualifiedName().toString())).exists()) {
                        dbSchemaFolder.mkdirs();
                    }
                    db.exportSchema(new File(dbSchemaFolder, db.getVersion() + ".json"));
                }
            }
            return rejectedElements;
        }

        @NotNull
        public Set<? extends Class<? extends Annotation>> annotations() {
            return SetsKt.mutableSetOf((Object[])new Class[]{Database.class});
        }

        /*
         * WARNING - void declaration
         */
        private final void prepareDaosForWriting(List<androidx.room.vo.Database> databases, List<DaoMethod> daoMethods) {
            void $this$filterTo$iv$iv;
            Object list$iv$iv;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = daoMethods;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object element$iv$iv = iterator.next();
                DaoMethod it = (DaoMethod)element$iv$iv;
                boolean bl = false;
                ClassName key$iv$iv = it.getDao().getTypeName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$filter$iv = destination$iv$iv;
            boolean $i$f$filter = false;
            $this$groupByTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv;
            boolean element$iv$iv = false;
            list$iv$iv = iterator.entrySet().iterator();
            while (list$iv$iv.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry entry = element$iv$iv2 = (Map.Entry)list$iv$iv.next();
                boolean bl4 = false;
                if (!(((List)entry.getValue()).size() > 1)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$groupByTo$iv$iv2;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl3 = false;
                Iterable $this$groupBy$iv2 = (Iterable)entry.getValue();
                boolean $i$f$groupBy2 = false;
                Iterable bl4 = $this$groupBy$iv2;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo2 = false;
                for (Object element$iv$iv3 : $this$groupByTo$iv$iv2) {
                    Object object3;
                    Object element$iv22;
                    block13: {
                        DaoMethod daoMethod = (DaoMethod)element$iv$iv3;
                        boolean bl5 = false;
                        Iterable $this$first$iv = databases;
                        boolean $i$f$first = false;
                        for (Object element$iv22 : $this$first$iv) {
                            androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv22;
                            boolean bl6 = false;
                            if (!db.getDaoMethods().contains(daoMethod)) continue;
                            break block13;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    androidx.room.vo.Database db = (androidx.room.vo.Database)element$iv22;
                    String key$iv$iv = db.getTypeName().simpleName();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl7 = false;
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv;
                    }
                    List list$iv$iv2 = (List)object3;
                    list$iv$iv2.add(element$iv$iv3);
                }
                Map $this$forEach$iv2 = destination$iv$iv2;
                boolean $i$f$forEach2 = false;
                Map map2 = $this$forEach$iv2;
                boolean bl8 = false;
                Iterator iterator3 = map2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv3;
                    Map.Entry $dstr$dbName$methods = element$iv3 = iterator3.next();
                    boolean bl9 = false;
                    Map.Entry bl5 = $dstr$dbName$methods;
                    boolean $this$first$iv = false;
                    String dbName = (String)bl5.getKey();
                    bl5 = $dstr$dbName$methods;
                    $this$first$iv = false;
                    List methods = (List)bl5.getValue();
                    if (methods.size() == 1) {
                        Dao dao = ((DaoMethod)CollectionsKt.first((List)methods)).getDao();
                        String string = dbName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dbName");
                        dao.setSuffix(string);
                        continue;
                    }
                    Iterable $this$forEachIndexed$iv = methods;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void method;
                        int n = index$iv++;
                        boolean bl10 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        int n2 = n;
                        DaoMethod $i$f$getOrPut = (DaoMethod)item$iv;
                        int index = n2;
                        boolean bl11 = false;
                        method.getDao().setSuffix(dbName + '_' + index);
                    }
                }
            }
        }

        @NotNull
        public final ProcessingEnvironment getProcessingEnv() {
            return this.processingEnv;
        }

        public DatabaseProcessingStep(@NotNull ProcessingEnvironment processingEnv) {
            Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
            this.processingEnv = processingEnv;
        }
    }
}

