/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.RawQuery;
import androidx.room.Transaction;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XDeclaredType;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XVariableElement;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.ext.Xelement_extKt;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.SqlParser;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.Pojo;
import androidx.room.vo.RawQueryMethod;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/room/processor/RawQueryMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XDeclaredType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XDeclaredType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XDeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "findRuntimeQueryParameter", "Landroidx/room/vo/RawQueryMethod$RuntimeQueryParameter;", "extractParams", "", "Landroidx/room/compiler/processing/XVariableElement;", "process", "Landroidx/room/vo/RawQueryMethod;", "processObservedTables", "", "", "room-compiler"})
public final class RawQueryMethodProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XDeclaredType containing;
    @NotNull
    private final XMethodElement executableElement;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final RawQueryMethod process() {
        MethodProcessorDelegate delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        XType returnType = delegate.extractReturnType();
        this.context.getChecker().check(this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(RawQuery.class)), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getMISSING_RAWQUERY_ANNOTATION(), new Object[0]);
        TypeName returnTypeName = returnType.getTypeName();
        this.context.getChecker().notUnbound(returnTypeName, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        Set<String> observedTableNames = this.processObservedTables();
        ParsedQuery query2 = SqlParser.Companion.rawQueryForTables(observedTableNames);
        QueryResultBinder resultBinder = delegate.findResultBinder(returnType, query2);
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParam = this.findRuntimeQueryParameter(delegate.extractParams());
        boolean inTransaction = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Transaction.class));
        QueryResultBinder queryResultBinder = resultBinder;
        boolean bl = inTransaction;
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParameter = runtimeQueryParam;
        XType xType = returnType;
        Set<String> set = observedTableNames;
        RawQueryMethod rawQueryMethod = new RawQueryMethod(this.executableElement, this.executableElement.getName(), xType, bl, set, runtimeQueryParameter, queryResultBinder);
        this.context.getChecker().check(rawQueryMethod.getReturnsValue(), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_RETURN_TYPE(), new Object[0]);
        return rawQueryMethod;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> processObservedTables() {
        Object object;
        block9: {
            block8: {
                void $this$flatMapTo$iv$iv;
                XTypeElement it;
                Iterable $this$mapTo$iv$iv;
                XAnnotationBox annotation = this.executableElement.toAnnotationBox(Reflection.getOrCreateKotlinClass(RawQuery.class));
                object = annotation;
                if (object == null || (object = object.getAsTypeList("observedEntities")) == null) break block8;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    XType xType = (XType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    XTypeElement xTypeElement = it.asTypeElement();
                    collection.add(xTypeElement);
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List<String> list;
                    it = (XTypeElement)element$iv$iv;
                    boolean bl = false;
                    if (Xelement_extKt.isEntityElement((XElement)it)) {
                        Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, it, null, 4, null).process();
                        list = CollectionsKt.arrayListOf((Object[])new String[]{entity.getTableName()});
                    } else {
                        Pojo pojo = PojoProcessor.Companion.createFor$default(PojoProcessor.Companion, this.context, it, FieldProcessor.BindingScope.READ_FROM_CURSOR, null, null, 16, null).process();
                        List<String> tableNames2 = pojo.accessedTableNames();
                        if (tableNames2.isEmpty()) {
                            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.rawQueryBadEntity(it.getType().getTypeName()), new Object[0]);
                        }
                        list = tableNames2;
                    }
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (object != null) break block9;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final RawQueryMethod.RuntimeQueryParameter findRuntimeQueryParameter(List<? extends XVariableElement> extractParams) {
        if (extractParams.size() == 1 && !this.executableElement.isVarArgs()) {
            XType param = ((XVariableElement)CollectionsKt.first(extractParams)).asMemberOf(this.containing);
            XProcessingEnv processingEnv = this.context.getProcessingEnv();
            XType supportQueryType = processingEnv.requireType((TypeName)SupportDbTypeNames.INSTANCE.getQUERY());
            boolean isSupportSql = supportQueryType.isAssignableFrom(param);
            if (isSupportSql) {
                return new RawQueryMethod.RuntimeQueryParameter(extractParams.get(0).getName(), supportQueryType.getTypeName());
            }
            XType stringType = processingEnv.requireType("java.lang.String");
            boolean isString = stringType.isAssignableFrom(param);
            if (isString) {
                this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_STRING_PARAMETER_REMOVED(), new Object[0]);
                return null;
            }
        }
        this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_PARAMS(), new Object[0]);
        return null;
    }

    @NotNull
    public final XDeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    public RawQueryMethodProcessor(@NotNull Context baseContext, @NotNull XDeclaredType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, 2, null);
    }
}

