/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Xtype_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.ForeignKeyInput;
import androidx.room.processor.IndexInput;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.TableEntityProcessor;
import androidx.room.processor.cache.Cache;
import androidx.room.vo.Constructor;
import androidx.room.vo.EmbeddedField;
import androidx.room.vo.Field;
import androidx.room.vo.Fields;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.ForeignKeyAction;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.Pojo;
import androidx.room.vo.Warning;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\b\u0010$\u001a\u00020%H\u0002J$\u0010&\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00132\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020%H\u0016J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00132\u0006\u00102\u001a\u000203H\u0002J$\u00104\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u00105\u001a\b\u0012\u0004\u0012\u00020(0\u00132\u0006\u00102\u001a\u000203H\u0002R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Landroidx/room/processor/TableEntityProcessor;", "Landroidx/room/processor/EntityProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "checkIndicesForForeignKeys", "", "entityForeignKeys", "", "Landroidx/room/vo/ForeignKey;", "primaryKey", "Landroidx/room/vo/PrimaryKey;", "indices", "Landroidx/room/vo/Index;", "choosePrimaryKey", "candidates", "typeElement", "collectPrimaryKeysFromEmbeddedFields", "embeddedFields", "Landroidx/room/vo/EmbeddedField;", "collectPrimaryKeysFromEntityAnnotations", "availableFields", "Landroidx/room/vo/Field;", "collectPrimaryKeysFromPrimaryKeyAnnotations", "fields", "doProcess", "Landroidx/room/vo/Entity;", "findAndValidatePrimaryKey", "loadSuperIndices", "Landroidx/room/processor/IndexInput;", "typeMirror", "Landroidx/room/compiler/processing/XType;", "tableName", "inherit", "", "process", "validateAndCreateForeignKeyReferences", "foreignKeyInputs", "Landroidx/room/processor/ForeignKeyInput;", "pojo", "Landroidx/room/vo/Pojo;", "validateAndCreateIndices", "inputs", "room-compiler"})
public final class TableEntityProcessor
implements EntityProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XTypeElement element;
    private final LinkedHashSet<String> referenceStack;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.Entity process() {
        return this.context.getCache().getEntities().get(new Cache.EntityKey((XElement)this.element), (Function0<androidx.room.vo.Entity>)((Function0)new Function0<androidx.room.vo.Entity>(this){
            final /* synthetic */ TableEntityProcessor this$0;

            @NotNull
            public final androidx.room.vo.Entity invoke() {
                return TableEntityProcessor.access$doProcess(this.this$0);
            }
            {
                this.this$0 = tableEntityProcessor;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.Entity doProcess() {
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), ProcessorErrors.INSTANCE.getENTITY_MUST_BE_ANNOTATED_WITH_ENTITY(), new Object[0]);
        XAnnotationBox annotationBox = this.element.toAnnotationBox(Reflection.getOrCreateKotlinClass(Entity.class));
        String tableName = null;
        List<IndexInput> entityIndices = null;
        List<ForeignKeyInput> foreignKeyInputs = null;
        boolean inheritSuperIndices = false;
        if (annotationBox != null) {
            tableName = EntityProcessor.Companion.extractTableName(this.element, (Entity)annotationBox.getValue());
            entityIndices = EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)annotationBox, tableName);
            inheritSuperIndices = ((Entity)annotationBox.getValue()).inheritSuperIndices();
            foreignKeyInputs = EntityProcessor.Companion.extractForeignKeys((XAnnotationBox<Entity>)annotationBox);
        } else {
            tableName = this.element.getName();
            foreignKeyInputs = CollectionsKt.emptyList();
            entityIndices = CollectionsKt.emptyList();
            inheritSuperIndices = false;
        }
        this.context.getChecker().notBlank(tableName, (XElement)this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)tableName, (String)"sqlite_", (boolean)true), (XElement)this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_START_WITH_SQLITE(), new Object[0]);
        Pojo pojo = PojoProcessor.Companion.createFor(this.context, this.element, FieldProcessor.BindingScope.TWO_WAY, null, this.referenceStack).process();
        this.context.getChecker().check(pojo.getRelations().isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getRELATION_IN_ENTITY(), new Object[0]);
        Iterable $this$filter$iv = pojo.getFields();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Field)element$iv$iv;
            boolean bl = false;
            if (!((Field)it).getIndexed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            IndexInput indexInput;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Field it2 = (Field)element$iv$iv;
            boolean bl2 = false;
            if (it2.getParent() != null) {
                it2.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_FIELD_IS_DROPPED, (XElement)it2.getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedFieldIndex(it2.getPath(), this.element.getQualifiedName()), new Object[0]);
                indexInput = null;
            } else if (Intrinsics.areEqual((Object)it2.getElement().getEnclosingTypeElement(), (Object)this.element) ^ true && !inheritSuperIndices) {
                it2.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_PARENT_FIELD_IS_DROPPED, ProcessorErrors.INSTANCE.droppedSuperClassFieldIndex(it2.getColumnName(), this.element.toString(), it2.getElement().getEnclosingTypeElement().toString()), new Object[0]);
                indexInput = null;
            } else {
                indexInput = new IndexInput(EntityProcessor.Companion.createIndexName(CollectionsKt.listOf((Object)it2.getColumnName()), tableName), false, CollectionsKt.listOf((Object)it2.getColumnName()));
            }
            if (indexInput == null) continue;
            IndexInput indexInput2 = indexInput;
            boolean bl3 = false;
            boolean bl4 = false;
            IndexInput it$iv$iv = indexInput2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fieldIndices = (List)destination$iv$iv;
        List<IndexInput> superIndices = this.loadSuperIndices(this.element.getSuperType(), tableName, inheritSuperIndices);
        List indexInputs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)entityIndices, (Iterable)fieldIndices), (Iterable)superIndices);
        List<Index> indices = this.validateAndCreateIndices(indexInputs, pojo);
        androidx.room.vo.PrimaryKey primaryKey2 = this.findAndValidatePrimaryKey(pojo.getFields(), pojo.getEmbeddedFields());
        Object object = (Field)CollectionsKt.firstOrNull((List)primaryKey2.getFields());
        if (object == null || (object = object.getAffinity()) == null) {
            object = SQLTypeAffinity.TEXT;
        }
        Object affinity = object;
        Checks checks = this.context.getChecker();
        boolean bl = !primaryKey2.getAutoGenerateId() || affinity == SQLTypeAffinity.INTEGER;
        Field field = (Field)CollectionsKt.firstOrNull((List)primaryKey2.getFields());
        if (field == null || (field = field.getElement()) == null) {
            field = this.element;
        }
        checks.check(bl, (XElement)field, ProcessorErrors.INSTANCE.getAUTO_INCREMENTED_PRIMARY_KEY_IS_NOT_INT(), new Object[0]);
        List<ForeignKey> entityForeignKeys = this.validateAndCreateForeignKeyReferences(foreignKeyInputs, pojo);
        this.checkIndicesForForeignKeys(entityForeignKeys, primaryKey2, indices);
        this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(tableName), (XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_TABLE_NAME(), new Object[0]);
        Iterable $this$forEach$iv = pojo.getFields();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it3 = (Field)element$iv;
            boolean bl6 = false;
            this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(it3.getColumnName()), (XElement)it3.getElement(), ProcessorErrors.INSTANCE.getINVALID_COLUMN_NAME(), new Object[0]);
        }
        String string = null;
        Constructor constructor = pojo.getConstructor();
        List<ForeignKey> list = entityForeignKeys;
        androidx.room.vo.PrimaryKey primaryKey3 = primaryKey2;
        List<Index> list2 = indices;
        androidx.room.vo.Entity entity = new androidx.room.vo.Entity(this.element, tableName, pojo.getType(), pojo.getFields(), pojo.getEmbeddedFields(), primaryKey3, list2, list, constructor, string);
        return entity;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkIndicesForForeignKeys(List<ForeignKey> entityForeignKeys, androidx.room.vo.PrimaryKey primaryKey, List<Index> indices) {
        $fun$covers$1 = checkIndicesForForeignKeys.1.INSTANCE;
        $this$forEach$iv = entityForeignKeys;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block8: {
                fKey = (ForeignKey)element$iv;
                $i$a$-forEach-TableEntityProcessor$checkIndicesForForeignKeys$2 = false;
                $this$map$iv = fKey.getChildFields();
                $i$f$map = false;
                var13_15 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_23 = (Field)item$iv$iv;
                    var19_24 = destination$iv$iv;
                    $i$a$-map-TableEntityProcessor$checkIndicesForForeignKeys$2$columnNames$1 = false;
                    var21_26 = it.getColumnName();
                    var19_24.add(var21_26);
                }
                columnNames = (List)destination$iv$iv;
                if (checkIndicesForForeignKeys.1.INSTANCE.invoke(columnNames, primaryKey.getFields())) ** GOTO lbl-1000
                $this$any$iv = indices;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        index = (Index)element$iv;
                        $i$a$-any-TableEntityProcessor$checkIndicesForForeignKeys$2$exists$1 = false;
                        if (!checkIndicesForForeignKeys.1.INSTANCE.invoke(columnNames, index.getFields())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (exists = v1) continue;
            if (columnNames.size() == 1) {
                this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, (XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumn((String)columnNames.get(0)), new Object[0]);
                continue;
            }
            this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, (XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumns(columnNames), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForeignKey> validateAndCreateForeignKeyReferences(List<ForeignKeyInput> foreignKeyInputs, Pojo pojo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = foreignKeyInputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ForeignKey foreignKey;
            Collection collection;
            block19: {
                void it;
                ForeignKeyInput foreignKeyInput = (ForeignKeyInput)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (it.getOnUpdate() == null) {
                    this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                    foreignKey = null;
                } else if (it.getOnDelete() == null) {
                    this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                    foreignKey = null;
                } else if (it.getChildColumns().isEmpty()) {
                    this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_CHILD_COLUMN_LIST(), new Object[0]);
                    foreignKey = null;
                } else if (it.getParentColumns().isEmpty()) {
                    this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_PARENT_COLUMN_LIST(), new Object[0]);
                    foreignKey = null;
                } else if (it.getChildColumns().size() != it.getParentColumns().size()) {
                    this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyColumnNumberMismatch(it.getChildColumns(), it.getParentColumns()), new Object[0]);
                    foreignKey = null;
                } else {
                    XTypeElement xTypeElement;
                    try {
                        xTypeElement = it.getParent().asTypeElement();
                    }
                    catch (IllegalArgumentException noClass) {
                        this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_CANNOT_FIND_PARENT(), new Object[0]);
                        foreignKey = null;
                        break block19;
                    }
                    XTypeElement parentElement = xTypeElement;
                    XAnnotationBox parentAnnotation = parentElement.toAnnotationBox(Reflection.getOrCreateKotlinClass(Entity.class));
                    if (parentAnnotation == null) {
                        this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyNotAnEntity(parentElement.toString()), new Object[0]);
                        foreignKey = null;
                    } else {
                        void $this$mapNotNullTo$iv$iv;
                        String tableName = EntityProcessor.Companion.extractTableName(parentElement, (Entity)parentAnnotation.getValue());
                        Iterable $this$mapNotNull$iv = it.getChildColumns();
                        boolean $i$f$mapNotNull = false;
                        Object object = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Field field;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl2 = false;
                            String columnName = (String)element$iv$iv;
                            boolean bl3 = false;
                            Field field2 = HasFieldsKt.findFieldByColumnName(pojo, columnName);
                            if (field2 == null) {
                                this.context.getLogger().e((XElement)pojo.getElement(), ProcessorErrors.INSTANCE.foreignKeyChildColumnDoesNotExist(columnName, HasFieldsKt.getColumnNames(pojo)), new Object[0]);
                            }
                            if (field2 == null) continue;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Field it$iv$iv = field;
                            boolean bl6 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List fields = (List)destination$iv$iv2;
                        if (fields.size() != it.getChildColumns().size()) {
                            foreignKey = null;
                        } else {
                            boolean bl7 = it.getDeferred();
                            ForeignKeyAction foreignKeyAction = it.getOnUpdate();
                            object = it.getOnDelete();
                            List<String> list = it.getParentColumns();
                            List list2 = fields;
                            ForeignKey foreignKey2 = new ForeignKey(tableName, list, list2, (ForeignKeyAction)((Object)object), foreignKeyAction, bl7);
                            foreignKey = foreignKey2;
                        }
                    }
                }
            }
            ForeignKey foreignKey3 = foreignKey;
            collection.add(foreignKey3);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey findAndValidatePrimaryKey(List<Field> fields, List<EmbeddedField> embeddedFields) {
        void $this$filterNotTo$iv$iv;
        List candidates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.collectPrimaryKeysFromEntityAnnotations(this.element, fields), (Iterable)this.collectPrimaryKeysFromPrimaryKeyAnnotations(fields)), (Iterable)this.collectPrimaryKeysFromEmbeddedFields(embeddedFields));
        Collection collection = candidates;
        boolean bl = false;
        this.context.getChecker().check(!collection.isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getMISSING_PRIMARY_KEY(), new Object[0]);
        bl = false;
        Set verifiedFields = new LinkedHashSet();
        Iterable $this$filterNot$iv = candidates;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl2 = false;
            if (it.getAutoGenerateId()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            androidx.room.vo.PrimaryKey candidate = (androidx.room.vo.PrimaryKey)element$iv;
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = candidate.getFields();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl4 = false;
                if (candidate.getFields().size() <= 1 && (candidate.getFields().size() != 1 || field.getAffinity() == SQLTypeAffinity.INTEGER)) continue;
                if (!verifiedFields.contains(field)) {
                    this.context.getChecker().check(field.getNonNull(), (XElement)field.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(field.getPath()), new Object[0]);
                    verifiedFields.add(field);
                }
                EmbeddedField parent = field.getParent();
                while (parent != null) {
                    Field parentField = parent.getField();
                    if (!verifiedFields.contains(parentField)) {
                        this.context.getChecker().check(parentField.getNonNull(), (XElement)parentField.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(parentField.getPath()), new Object[0]);
                        verifiedFields.add(parentField);
                    }
                    parent = parentField.getParent();
                }
            }
        }
        if (candidates.size() == 1) {
            return (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)candidates);
        }
        return this.choosePrimaryKey(candidates, this.element);
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromPrimaryKeyAnnotations(List<Field> fields) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = fields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Field field = (Field)element$iv$iv;
            boolean bl2 = false;
            if (field.getElement().toAnnotationBox(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                XAnnotationBox xAnnotationBox;
                boolean bl3 = false;
                boolean bl4 = false;
                XAnnotationBox it = xAnnotationBox;
                boolean bl5 = false;
                if (field.getParent() != null) {
                    XFieldElement grandParentField = field.getParent().getMRootParent().getField().getElement();
                    Context.fork$default(this.context, (XElement)grandParentField, null, 2, null).getLogger().w(Warning.PRIMARY_KEY_FROM_EMBEDDED_IS_DROPPED, (XElement)grandParentField, ProcessorErrors.INSTANCE.embeddedPrimaryKeyIsDropped(this.element.getQualifiedName(), field.getName()), new Object[0]);
                    primaryKey2 = null;
                } else {
                    primaryKey2 = new androidx.room.vo.PrimaryKey((XElement)field.getElement().getEnclosingTypeElement(), new Fields(field), ((PrimaryKey)it.getValue()).autoGenerate());
                }
            } else {
                primaryKey2 = null;
            }
            if (primaryKey2 == null) continue;
            androidx.room.vo.PrimaryKey primaryKey3 = primaryKey2;
            boolean bl6 = false;
            boolean bl7 = false;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey3;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEntityAnnotations(XTypeElement typeElement, List<Field> availableFields) {
        List<androidx.room.vo.PrimaryKey> list;
        Object primaryKeyColumns;
        Object object;
        block14: {
            block13: {
                List list2;
                object = typeElement.toAnnotationBox(Reflection.getOrCreateKotlinClass(Entity.class));
                if (object == null) break block13;
                XAnnotationBox xAnnotationBox = object;
                boolean bl = false;
                boolean bl2 = false;
                XAnnotationBox it = xAnnotationBox;
                boolean bl3 = false;
                String[] stringArray = primaryKeyColumns = ((Entity)it.getValue()).primaryKeys();
                boolean bl4 = false;
                if (stringArray.length == 0) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    Object $this$mapNotNull$iv = primaryKeyColumns;
                    boolean $i$f$mapNotNull = false;
                    Object object2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    void var18_21 = $this$forEach$iv$iv$iv;
                    int n = ((void)var18_21).length;
                    for (int i = 0; i < n; ++i) {
                        Field field;
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object v2;
                        Iterable $this$firstOrNull$iv;
                        void pKeyColumnName;
                        block12: {
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = var18_21[i];
                            boolean bl5 = false;
                            pKeyColumnName = element$iv$iv;
                            boolean bl6 = false;
                            $this$firstOrNull$iv = availableFields;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                Field it2 = (Field)element$iv;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)it2.getColumnName(), (Object)pKeyColumnName)) continue;
                                v2 = element$iv;
                                break block12;
                            }
                            v2 = null;
                        }
                        Field field2 = v2;
                        $this$firstOrNull$iv = availableFields;
                        void var33_38 = pKeyColumnName;
                        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                        XElement xElement = (XElement)typeElement;
                        boolean bl8 = field2 != null;
                        Checks checks = this.context.getChecker();
                        boolean $i$f$map = false;
                        Iterator iterator = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            Field field3 = (Field)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl9 = false;
                            String string = it3.getColumnName();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv2;
                        checks.check(bl8, xElement, processorErrors.primaryKeyColumnDoesNotExist((String)var33_38, (List<String>)collection), new Object[0]);
                        if (field2 == null) continue;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        Field it$iv$iv = field;
                        boolean bl12 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List fields = (List)destination$iv$iv;
                    list2 = CollectionsKt.listOf((Object)new androidx.room.vo.PrimaryKey((XElement)typeElement, new Fields(fields), false));
                }
                object = list2;
                if (list2 != null) break block14;
            }
            object = CollectionsKt.emptyList();
        }
        Object myPkeys = object;
        XType mySuper = typeElement.getSuperType();
        if (mySuper != null && Xtype_extKt.isNotNone(mySuper)) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = availableFields;
            boolean $i$f$filterNot = false;
            primaryKeyColumns = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getElement().getEnclosingTypeElement(), (Object)typeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingFields = (List)destination$iv$iv;
            list = this.collectPrimaryKeysFromEntityAnnotations(mySuper.asTypeElement(), remainingFields);
        } else {
            list = CollectionsKt.emptyList();
        }
        List<androidx.room.vo.PrimaryKey> superPKeys = list;
        return CollectionsKt.plus((Collection)superPKeys, (Iterable)((Iterable)myPkeys));
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEmbeddedFields(List<EmbeddedField> embeddedFields) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = embeddedFields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EmbeddedField embeddedField = (EmbeddedField)element$iv$iv;
            boolean bl2 = false;
            if (embeddedField.getField().getElement().toAnnotationBox(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                XAnnotationBox xAnnotationBox;
                boolean bl3 = false;
                boolean bl4 = false;
                XAnnotationBox it = xAnnotationBox;
                boolean bl5 = false;
                this.context.getChecker().check(!((PrimaryKey)it.getValue()).autoGenerate() || embeddedField.getPojo().getFields().size() == 1, (XElement)embeddedField.getField().getElement(), ProcessorErrors.INSTANCE.getAUTO_INCREMENT_EMBEDDED_HAS_MULTIPLE_FIELDS(), new Object[0]);
                primaryKey2 = new androidx.room.vo.PrimaryKey((XElement)embeddedField.getField().getElement().getEnclosingTypeElement(), embeddedField.getPojo().getFields(), ((PrimaryKey)it.getValue()).autoGenerate());
            } else {
                primaryKey2 = null;
            }
            if (primaryKey2 == null) continue;
            androidx.room.vo.PrimaryKey primaryKey3 = primaryKey2;
            boolean bl6 = false;
            boolean bl7 = false;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey3;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey choosePrimaryKey(List<androidx.room.vo.PrimaryKey> candidates, XTypeElement typeElement) {
        Object mySuper;
        androidx.room.vo.PrimaryKey primaryKey2;
        androidx.room.vo.PrimaryKey candidate;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv = candidates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            candidate = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)candidate.getDeclaredIn(), (Object)typeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List myPKeys = (List)destination$iv$iv;
        if (myPKeys.size() == 1) {
            Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)candidates, (Iterable)myPKeys);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv;
                boolean bl = false;
                this.context.getLogger().d((XElement)this.element, it.toHumanReadableString() + " is" + " overridden by " + ((androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys)).toHumanReadableString(), new Object[0]);
            }
            primaryKey2 = (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys);
        } else if (myPKeys.isEmpty()) {
            mySuper = typeElement.getSuperType();
            if (mySuper != null && Xtype_extKt.isNotNone(mySuper)) {
                return this.choosePrimaryKey(candidates, mySuper.asTypeElement());
            }
            primaryKey2 = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            mySuper = myPKeys;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            XElement xElement = (XElement)this.element;
            RLog rLog = this.context.getLogger();
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                candidate = (androidx.room.vo.PrimaryKey)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = p1.toHumanReadableString();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            rLog.e(xElement, processorErrors.multiplePrimaryKeyAnnotations((List<String>)collection), new Object[0]);
            primaryKey2 = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        }
        return primaryKey2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> validateAndCreateIndices(List<IndexInput> inputs, Pojo pojo) {
        void $this$filterTo$iv$iv;
        Object list$iv$iv;
        Object $this$groupByTo$iv$iv;
        Collection collection;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = inputs;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        XAnnotationBox xAnnotationBox = $this$forEach$iv$iv$iv.iterator();
        while (xAnnotationBox.hasNext()) {
            Index index;
            void $this$mapNotNullTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = xAnnotationBox.next();
            boolean bl = false;
            IndexInput input = (IndexInput)element$iv$iv;
            boolean bl2 = false;
            collection = input.getColumnNames();
            boolean bl3 = false;
            this.context.getChecker().check(!collection.isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.getINDEX_COLUMNS_CANNOT_BE_EMPTY(), new Object[0]);
            Iterable $this$mapNotNull$iv2 = input.getColumnNames();
            boolean $i$f$mapNotNull2 = false;
            Iterable iterable = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Field field;
                Object element$iv$iv$iv2;
                Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                String columnName = (String)element$iv$iv2;
                boolean bl4 = false;
                Field field2 = HasFieldsKt.findFieldByColumnName(pojo, columnName);
                this.context.getChecker().check(field2 != null, (XElement)this.element, ProcessorErrors.INSTANCE.indexColumnDoesNotExist(columnName, HasFieldsKt.getColumnNames(pojo)), new Object[0]);
                if (field2 == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                Field it$iv$iv = field;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List fields = (List)destination$iv$iv2;
            if ((fields.isEmpty() ? null : new Index(input.getName(), input.getUnique(), fields)) == null) continue;
            index = index;
            boolean bl8 = false;
            boolean bl9 = false;
            Index it$iv$iv = index;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List indices = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = indices;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        $this$forEach$iv$iv$iv = $this$groupByTo$iv$iv.iterator();
        while ($this$forEach$iv$iv$iv.hasNext()) {
            Object object;
            Object element$iv$iv = $this$forEach$iv$iv$iv.next();
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl11 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        $this$forEach$iv$iv$iv = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        list$iv$iv = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry it = element$iv$iv3 = (Map.Entry)list$iv$iv.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach3 = false;
        iterator = $this$forEach$iv;
        boolean destination$iv$iv2 = false;
        Iterator $i$f$filterTo22 = iterator.entrySet().iterator();
        while ($i$f$filterTo22.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = $i$f$filterTo22.next();
            boolean bl = false;
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.duplicateIndexInEntity((String)it.getKey()), new Object[0]);
        }
        $this$forEach$iv = pojo.getEmbeddedFields();
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            EmbeddedField embedded = (EmbeddedField)element$iv;
            boolean bl = false;
            XTypeElement embeddedElement = embedded.getPojo().getElement();
            if (embeddedElement.toAnnotationBox(Reflection.getOrCreateKotlinClass(Entity.class)) == null) continue;
            boolean bl12 = false;
            boolean bl13 = false;
            XAnnotationBox it = xAnnotationBox;
            boolean bl14 = false;
            List<IndexInput> subIndices = EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)it, "");
            collection = subIndices;
            boolean bl15 = false;
            if (!(!collection.isEmpty())) continue;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)embedded.getField().getElement();
            String string = embedded.getPojo().getTypeName().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"embedded.pojo.typeName.toString()");
            rLog.w(Warning.INDEX_FROM_EMBEDDED_ENTITY_IS_DROPPED, xElement, ProcessorErrors.INSTANCE.droppedEmbeddedIndex(string, embedded.getField().getPath(), this.element.getQualifiedName()), new Object[0]);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexInput> loadSuperIndices(XType typeMirror, String tableName, boolean inherit) {
        Object object;
        XTypeElement parentElement;
        block10: {
            block9: {
                List list;
                if (typeMirror == null || typeMirror.isNone()) {
                    return CollectionsKt.emptyList();
                }
                parentElement = typeMirror.asTypeElement();
                object = parentElement.toAnnotationBox(Reflection.getOrCreateKotlinClass(Entity.class));
                if (object == null) break block9;
                XAnnotationBox xAnnotationBox = object;
                boolean bl = false;
                boolean bl2 = false;
                XAnnotationBox annotation = xAnnotationBox;
                boolean bl3 = false;
                List<IndexInput> indices = EntityProcessor.Companion.extractIndices((XAnnotationBox<Entity>)annotation, "super");
                if (indices.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else if (inherit) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = indices;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IndexInput indexInput = (IndexInput)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        IndexInput indexInput2 = new IndexInput(EntityProcessor.Companion.createIndexName(it.getColumnNames(), tableName), it.getUnique(), it.getColumnNames());
                        collection.add(indexInput2);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    this.context.getLogger().w(Warning.INDEX_FROM_PARENT_IS_DROPPED, (XElement)parentElement, ProcessorErrors.INSTANCE.droppedSuperClassIndex(this.element.getQualifiedName(), parentElement.getQualifiedName()), new Object[0]);
                    list = CollectionsKt.emptyList();
                }
                object = list;
                if (list != null) break block10;
            }
            object = CollectionsKt.emptyList();
        }
        Object myIndices = object;
        return CollectionsKt.plus((Collection)((Collection)myIndices), (Iterable)this.loadSuperIndices(parentElement.getSuperType(), tableName, inherit));
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    public TableEntityProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }

    public /* synthetic */ TableEntityProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    public static final /* synthetic */ androidx.room.vo.Entity access$doProcess(TableEntityProcessor $this) {
        return $this.doProcess();
    }
}

