/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.solver.CodeGenScope;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/room/writer/ValidationWriter;", "", "()V", "countingScope", "Landroidx/room/writer/ValidationWriter$CountingCodeGenScope;", "statementCount", "", "write", "", "dbParam", "Lcom/squareup/javapoet/ParameterSpec;", "scope", "Landroidx/room/solver/CodeGenScope;", "CodeBlockWrapper", "CountingCodeGenScope", "room-compiler"})
public abstract class ValidationWriter {
    private CountingCodeGenScope countingScope;

    public final void write(@NotNull ParameterSpec dbParam, @NotNull CodeGenScope scope) {
        Intrinsics.checkNotNullParameter((Object)dbParam, (String)"dbParam");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        CountingCodeGenScope countingCodeGenScope = this.countingScope = new CountingCodeGenScope(scope);
        if (countingCodeGenScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingScope");
        }
        this.write(dbParam, countingCodeGenScope);
    }

    protected abstract void write(@NotNull ParameterSpec var1, @NotNull CountingCodeGenScope var2);

    public final int statementCount() {
        CountingCodeGenScope countingCodeGenScope = this.countingScope;
        if (countingCodeGenScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countingScope");
        }
        return countingCodeGenScope.statementCount();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Landroidx/room/writer/ValidationWriter$CountingCodeGenScope;", "", "scope", "Landroidx/room/solver/CodeGenScope;", "(Landroidx/room/solver/CodeGenScope;)V", "builder", "Landroidx/room/writer/ValidationWriter$CodeBlockWrapper;", "getScope", "()Landroidx/room/solver/CodeGenScope;", "getTmpVar", "", "prefix", "statementCount", "", "room-compiler"})
    protected static final class CountingCodeGenScope {
        private CodeBlockWrapper builder;
        @NotNull
        private final CodeGenScope scope;

        @NotNull
        public final String getTmpVar(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return this.scope.getTmpVar(prefix);
        }

        @NotNull
        public final CodeBlockWrapper builder() {
            if (this.builder == null) {
                this.builder = new CodeBlockWrapper(this.scope.builder());
            }
            CodeBlockWrapper codeBlockWrapper = this.builder;
            Intrinsics.checkNotNull((Object)codeBlockWrapper);
            return codeBlockWrapper;
        }

        public final int statementCount() {
            CodeBlockWrapper codeBlockWrapper = this.builder;
            return codeBlockWrapper != null ? codeBlockWrapper.getStatementCount() : 0;
        }

        @NotNull
        public final CodeGenScope getScope() {
            return this.scope;
        }

        public CountingCodeGenScope(@NotNull CodeGenScope scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0010\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0014\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Landroidx/room/writer/ValidationWriter$CodeBlockWrapper;", "", "builder", "Lcom/squareup/javapoet/CodeBlock$Builder;", "(Lcom/squareup/javapoet/CodeBlock$Builder;)V", "getBuilder", "()Lcom/squareup/javapoet/CodeBlock$Builder;", "<set-?>", "", "statementCount", "getStatementCount", "()I", "addStatement", "format", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Landroidx/room/writer/ValidationWriter$CodeBlockWrapper;", "beginControlFlow", "controlFlow", "endControlFlow", "room-compiler"})
    protected static final class CodeBlockWrapper {
        private int statementCount;
        @NotNull
        private final CodeBlock.Builder builder;

        public final int getStatementCount() {
            return this.statementCount;
        }

        @NotNull
        public final CodeBlockWrapper addStatement(@NotNull String format, Object ... args2) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
            int n = this.statementCount;
            this.statementCount = n + 1;
            this.builder.addStatement(format, Arrays.copyOf(args2, args2.length));
            return this;
        }

        @NotNull
        public final CodeBlockWrapper beginControlFlow(@NotNull String controlFlow, Object ... args2) {
            Intrinsics.checkNotNullParameter((Object)controlFlow, (String)"controlFlow");
            Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
            int n = this.statementCount;
            this.statementCount = n + 1;
            this.builder.beginControlFlow(controlFlow, Arrays.copyOf(args2, args2.length));
            return this;
        }

        @NotNull
        public final CodeBlockWrapper endControlFlow() {
            this.builder.endControlFlow();
            return this;
        }

        @NotNull
        public final CodeBlock.Builder getBuilder() {
            return this.builder;
        }

        public CodeBlockWrapper(@NotNull CodeBlock.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.builder = builder;
        }
    }
}

